/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTTurnOverConvert;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;

public class QTDepartUtils {
    private static final String OUT_PRE_KEY = "out_";
    private static final int SACLE = 6;

    public static void getQTThurnOverConvert(QTCalRule qtCalRule, QuotaContextStd context, QTTurnOverConvert qtTurnOverConvet, Map<String, BigDecimal> convertMap, Map<String, Boolean> isConvertMap) {
        Date endDate = context.getCircleRestVo().getEndDate();
        Date startDate = context.getCircleRestVo().getStartDate();
        Date sysEndDate = QuotaContextUtil.getDepartDate(context);
        BigDecimal thurnFactor = BigDecimal.ONE;
        Boolean thurnOverConvertTag = Boolean.FALSE;
        String key = OUT_PRE_KEY + qtCalRule.getId();
        if (sysEndDate != null) {
            String endDayStr = WTCDateUtils.date2Str((Date)sysEndDate, (String)"yyyy-MM-dd");
            String endPeriodDayStr = WTCDateUtils.date2Str((Date)endDate, (String)"yyyy-MM-dd");
            if (qtTurnOverConvet != null && !endDayStr.equals(endPeriodDayStr) && sysEndDate.compareTo(endDate) <= 0 && sysEndDate.compareTo(startDate) >= 0) {
                thurnFactor = QTDepartUtils.getOffDutyFactor(qtTurnOverConvet, startDate, endDate, sysEndDate);
                convertMap.put(key, thurnFactor);
                thurnOverConvertTag = Boolean.TRUE;
            }
        }
        isConvertMap.put(key, thurnOverConvertTag);
    }

    private static BigDecimal getOffDutyFactor(QTTurnOverConvert qtTurnOverConvet, Date startDate, Date endDate, Date outEndDate) {
        BigDecimal factor = null;
        BigDecimal periodDay = BigDecimal.valueOf(WTCDateUtils.daysBetween((Date)startDate, (Date)endDate) + 1);
        switch (qtTurnOverConvet.getConvertMethod()) {
            case CONVERT_ALL: {
                factor = BigDecimal.ONE;
                break;
            }
            case CONVERT_LAST_WORK_DAY: {
                factor = BigDecimal.ZERO;
                break;
            }
            case CONVERT_OTHER_DAY: {
                Date endDay = qtTurnOverConvet.getConvertDate();
                if (!endDay.after(startDate)) break;
                BigDecimal otherDay = BigDecimal.valueOf(WTCDateUtils.daysBetween((Date)startDate, (Date)endDay) + 1);
                factor = otherDay.divide(periodDay, 6, RoundingMode.HALF_UP);
                break;
            }
            case CONVERT_LEAVE_DAY: {
                BigDecimal lastWk = BigDecimal.valueOf(WTCDateUtils.daysBetween((Date)startDate, (Date)outEndDate) + 1);
                factor = lastWk.divide(periodDay, 6, RoundingMode.HALF_UP);
            }
        }
        return factor;
    }
}

