/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbd.business.retrieval.service.RetrievalRuleMatchDimension;
import kd.wtc.wtbd.business.retrieval.service.RetrievalRuleMatchService;
import kd.wtc.wtbd.business.retrieval.service.RetrievalRuleMatchType;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.business.model.attfile.AttFileScheduleEntity;
import kd.wtc.wtbs.business.rulecondition.RuleConditionValues;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.retrieval.RetrievalTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.access.ConditionDto;
import kd.wtc.wtes.business.model.quotacal.retrieval.QuotaRetrievalDimensionResult;
import kd.wtc.wtes.business.model.quotacal.retrieval.QuotaRetrievalResult;
import kd.wtc.wtes.business.model.rlqt.AttRecordDetailHolder;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTRule;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.model.QuotaCycInfo;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.std.QuotaMessageStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;

public class QTTieRetrievalUtil {
    private static final Log LOG = LogFactory.getLog(QTTieRetrievalUtil.class);
    private AttFileCabinet attFileCabinet;
    private Map<String, List<RetrievalRuleMatchDimension>> matchDimensionsMap = Maps.newHashMapWithExpectedSize((int)16);
    private Set<String> qtItemUniqueCodes = Sets.newHashSetWithExpectedSize((int)16);
    Set<Long> qtRuleIds = Sets.newHashSetWithExpectedSize((int)16);
    private QuotaRetrievalResult qtRetrievalResult = new QuotaRetrievalResult(null);

    public static Set<QuotaRetrievalDimensionResult> getQTRetrievalResultOfDate(QuotaContextStd context, QTRule ruleConfig, LocalDate chainDate) {
        if (context.getInitParam("QTRETRIEVEL") instanceof QuotaMessageStd) {
            QuotaMessageStd messageStd = (QuotaMessageStd)context.getInitParam("QTRETRIEVEL");
            throw new KDBizException(messageStd.getMsg());
        }
        QuotaRetrievalResult retrievalResult = (QuotaRetrievalResult)context.getInitParam("QTRETRIEVEL");
        Set<Object> result = Sets.newHashSetWithExpectedSize((int)16);
        long attPersonId = context.getAttPersonId();
        if (ruleConfig != null) {
            boolean containsRuleId = false;
            if (retrievalResult != null) {
                long ruleId = ruleConfig.getTimeSeqInfo().getVid();
                containsRuleId = retrievalResult.containsQtRuleId(ruleId);
            }
            if (containsRuleId) {
                result = retrievalResult.getByPersonAndDate(attPersonId, chainDate);
            } else {
                List<QTCalRule> qtCalRules = ruleConfig.getQtRules();
                if (WTCCollections.isNotEmpty(qtCalRules)) {
                    List qtGenConfigs = qtCalRules.stream().filter(qtCalRule -> context.getQuotaTypeId().longValue() == ((QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(chainDate)).getQtType().getId()).map(qtCalRule -> (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(chainDate)).collect(Collectors.toList());
                    QTTieRetrievalUtil qtTieRetrievalUtil = new QTTieRetrievalUtil();
                    AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context, chainDate);
                    for (QTGenConfig qtGenConfig : qtGenConfigs) {
                        if (qtGenConfig.getQtGenConfigEntries() == null) continue;
                        for (QTGenConfigEntry qtGenConfigEntrie : qtGenConfig.getQtGenConfigEntries()) {
                            qtTieRetrievalUtil.qtItemUniqueCodes.addAll(qtTieRetrievalUtil.getConfigRetrievalItemCode(qtGenConfigEntrie.getReplaceCondition()));
                        }
                    }
                    if (WTCCollections.isNotEmpty(qtTieRetrievalUtil.qtItemUniqueCodes) && attFileModel != null) {
                        HashSet qtRetrievalResults = Sets.newHashSetWithExpectedSize((int)16);
                        qtTieRetrievalUtil.initQtRetrievalDimension(context.getQuotaTypeId(), attFileModel, WTCDateUtils.toDate((LocalDate)chainDate), context.getCircleRestVo());
                        Map<String, RetrievalRuleMatchDimension> matchDimensionMap = qtTieRetrievalUtil.beginRetrieval();
                        String dimensionKey = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)context.getQuotaTypeId(), (long)context.getCircleRestVo().getCycSetId(), (long)context.getCircleRestVo().getIndex().intValue());
                        QuotaRetrievalDimensionResult dimensionResults = qtTieRetrievalUtil.buildRetrievalDimensionResult(matchDimensionMap, dimensionKey);
                        if (dimensionResults != null) {
                            qtRetrievalResults.add(dimensionResults);
                        }
                        if (retrievalResult == null) {
                            retrievalResult = new QuotaRetrievalResult(null);
                        }
                        retrievalResult.addQTRetrievalResult(qtRetrievalResults);
                        result = retrievalResult.getByPersonAndDate(attPersonId, chainDate);
                    }
                }
            }
        }
        return result;
    }

    public QTTieRetrievalUtil() {
    }

    public QTTieRetrievalUtil(QuotaInitParamRequest initRequest) {
        List<Long> regQtTypeIds;
        LOG.info("QTTieRetrievalUtil.init begin");
        Map<String, Object> initParams = initRequest.getInitParams();
        this.attFileCabinet = (AttFileCabinet)initParams.get("ATT_FILE");
        if (this.attFileCabinet == null) {
            return;
        }
        Map<Long, List<TimeSeqBo<AttFileModel>>> attFileTimeSeqBoMap = this.attFileCabinet.getAttFileTimeSeqBoMap();
        if (attFileTimeSeqBoMap == null) {
            return;
        }
        ArrayList qtTypeIds = Lists.newArrayListWithExpectedSize((int)16);
        List<Long> dyQtTypeIds = initRequest.getRequest().getDyQtTypeIds();
        if (!CollectionUtils.isEmpty(dyQtTypeIds)) {
            qtTypeIds.addAll(dyQtTypeIds);
        }
        if (!CollectionUtils.isEmpty(regQtTypeIds = initRequest.getRequest().getRegQtTypeIds())) {
            qtTypeIds.addAll(regQtTypeIds);
        }
        Set<QTRule> qtRules = this.getQTRules(initParams, attFileTimeSeqBoMap);
        this.qtRuleIds = qtRules.stream().map(AbstractTimeSeqVersion::getId).collect(Collectors.toSet());
        this.initAllItemUniqueCodes(qtRules, qtTypeIds);
        Set<QuotaRetrievalDimensionResult> dimensionResults = this.quotaBatchRetrieval(initRequest, qtTypeIds, attFileTimeSeqBoMap);
        HashMap quotaRetrievalResultsMap = Maps.newHashMapWithExpectedSize((int)4);
        quotaRetrievalResultsMap.put("wtp_qtgenconfig", dimensionResults);
        this.qtRetrievalResult = new QuotaRetrievalResult(quotaRetrievalResultsMap);
        this.qtRetrievalResult.setQtRuleIds(this.qtRuleIds);
        LOG.info("QTTieRetrievalUtil.init end");
    }

    private Set<QTRule> getQTRules(Map<String, Object> initParams, Map<Long, List<TimeSeqBo<AttFileModel>>> attFileTimeSeqBoMap) {
        HashSet qtRuleSet = Sets.newHashSetWithExpectedSize((int)16);
        RuleEngineMetaData ruleEngineMetaData = (RuleEngineMetaData)initParams.get("RULE_ENGINE");
        List rules = ruleEngineMetaData.getBusinessRuleMap().values().stream().filter(obj -> obj instanceof TimeSeqAvailableBo).map(obj -> ((TimeSeqAvailableBo)obj).getVersions()).flatMap(Collection::stream).filter(obj -> obj instanceof QTRule).map(obj -> (QTRule)obj).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(rules)) {
            qtRuleSet.addAll(rules);
        }
        for (List<TimeSeqBo<AttFileModel>> value : attFileTimeSeqBoMap.values()) {
            value.forEach(timeSeqBo -> timeSeqBo.getVersions().stream().filter(Objects::nonNull).forEach(attFileModel -> attFileModel.getAttQtPackageList().stream().filter(Objects::nonNull).map(AttFileScheduleEntity::getEntity).filter(Objects::nonNull).map(TimeSeqBo::getVersions).filter(Objects::nonNull).flatMap(Collection::stream).forEach(qtScheme -> {
                TimeSeqAvailableBo<QTRule> rule = qtScheme.getQtRule();
                if (rule == null) {
                    return;
                }
                List qtRules = rule.getVersions();
                if (WTCCollections.isNotEmpty((Collection)rules)) {
                    qtRuleSet.addAll(qtRules);
                }
            })));
        }
        return qtRuleSet;
    }

    private void initAllItemUniqueCodes(Set<QTRule> qtRules, List<Long> qtTypeIds) {
        if (WTCCollections.isEmpty(qtRules)) {
            return;
        }
        Set<Object> qtGenConfigs = Sets.newHashSetWithExpectedSize((int)16);
        for (QTRule qtRule : qtRules) {
            List<QTCalRule> qtCalRules = qtRule.getQtRules();
            if (WTCCollections.isEmpty(qtCalRules)) continue;
            for (QTCalRule qtCalRule : qtCalRules) {
                List genConfigs;
                TimeSeqAvailableBo<QTGenConfig> qtGenConfigTimeSeqAvailableBo = qtCalRule.getGenConfig();
                if (qtGenConfigTimeSeqAvailableBo == null || !WTCCollections.isNotEmpty((Collection)(genConfigs = qtGenConfigTimeSeqAvailableBo.getVersions()))) continue;
                qtGenConfigs.addAll(genConfigs);
            }
        }
        qtGenConfigs = qtGenConfigs.stream().filter(qtGenConfig -> qtTypeIds.contains(qtGenConfig.getQtType().getId())).collect(Collectors.toSet());
        this.initQtRuleAllItemUniqueCodes((Set<QTGenConfig>)qtGenConfigs);
    }

    private void initQtRuleAllItemUniqueCodes(Set<QTGenConfig> qtGenConfigs) {
        if (WTCCollections.isNotEmpty(qtGenConfigs)) {
            for (QTGenConfig genConfig : qtGenConfigs) {
                List<QTGenConfigEntry> qtGenConfigEntries = genConfig.getQtGenConfigEntries();
                if (WTCCollections.isEmpty(qtGenConfigEntries)) continue;
                for (QTGenConfigEntry genConfigEntry : qtGenConfigEntries) {
                    String condition = genConfigEntry.getReplaceCondition();
                    this.qtItemUniqueCodes.addAll(this.getConfigRetrievalItemCode(condition));
                }
            }
        }
        LOG.info("QTTieRetrievalUtil.initOtRuleAllItemUniqueCodes,allOtCalItemUniqueCodes.size:{},", (Object)this.qtItemUniqueCodes.size());
    }

    private Set<String> getConfigRetrievalItemCode(String ruleCondition) {
        AccessDto dateConditionAccessDto = this.getRuleConditionInfo(ruleCondition);
        return this.getConfigRetrievalItemCode(dateConditionAccessDto);
    }

    private Set<String> getConfigRetrievalItemCode(AccessDto accessDto) {
        HashSet itemUniqueCodes = Sets.newHashSetWithExpectedSize((int)16);
        if (accessDto != null && WTCCollections.isNotEmpty(accessDto.getConditionList())) {
            for (ConditionDto conditionDto : accessDto.getConditionList()) {
                String retrievalWay = conditionDto.getRetrievalWay();
                if (!HRStringUtils.isNotEmpty((String)retrievalWay) || !RetrievalTypeEnum.CONFIG.getValue().equals(retrievalWay)) continue;
                itemUniqueCodes.add(conditionDto.getUniqueCode());
            }
        }
        return itemUniqueCodes;
    }

    public QuotaRetrievalResult getQTRetrievalResult() {
        return this.qtRetrievalResult;
    }

    private Set<QuotaRetrievalDimensionResult> quotaBatchRetrieval(QuotaInitParamRequest initRequest, List<Long> qtTypeIds, Map<Long, List<TimeSeqBo<AttFileModel>>> attFileTimeSeqBoMap) {
        if (WTCCollections.isEmpty(this.qtItemUniqueCodes)) {
            return new HashSet<QuotaRetrievalDimensionResult>(0);
        }
        AttRecordDetailHolder holder = (AttRecordDetailHolder)initRequest.getInitParams().get("QT_ATT_RECORD_DETAIL");
        Map<String, QuotaCycInfo> holderMap = holder.getCycSetMap();
        for (Map.Entry<Long, List<TimeSeqBo<AttFileModel>>> entry : attFileTimeSeqBoMap.entrySet()) {
            List<TimeSeqBo<AttFileModel>> attFileModels = entry.getValue();
            for (TimeSeqBo<AttFileModel> attFileModelTimeSeqBo : attFileModels) {
                Long fileBoid = attFileModelTimeSeqBo.getBid();
                for (Long quotaId : qtTypeIds) {
                    QuotaCycInfo quotaCycInfo = holderMap.get(fileBoid + "_" + quotaId);
                    if (quotaCycInfo == null) continue;
                    List<CircleRestVo> circleRestVos = quotaCycInfo.getRestVos();
                    for (CircleRestVo circleRestVo : circleRestVos) {
                        List attFileModelList;
                        Date endDate = circleRestVo.getEndDate();
                        Date startDate = circleRestVo.getStartDate();
                        AttFileModel attFileModel = (AttFileModel)attFileModelTimeSeqBo.getVersionByDate(WTCDateUtils.toLocalDate((Date)endDate));
                        if (attFileModel == null && WTCCollections.isNotEmpty((Collection)(attFileModelList = attFileModelTimeSeqBo.getVersionsBetweenDate(WTCDateUtils.toLocalDate((Date)startDate), WTCDateUtils.toLocalDate((Date)endDate))))) {
                            attFileModelList.sort(Comparator.comparing(AttFileModel::getEndDate));
                            attFileModel = (AttFileModel)((Object)attFileModelList.get(attFileModelList.size() - 1));
                        }
                        if (attFileModel == null) continue;
                        endDate = attFileModel.getEndDateTime();
                        this.initQtRetrievalDimension(quotaId, attFileModel, endDate, circleRestVo);
                    }
                }
            }
        }
        Map<String, RetrievalRuleMatchDimension> retrievalRuleMatchDimensionMap = this.beginRetrieval();
        Set<QuotaRetrievalDimensionResult> qtRetrievalResults = this.handleQtRetrievalResult(retrievalRuleMatchDimensionMap, initRequest, qtTypeIds, attFileTimeSeqBoMap);
        return qtRetrievalResults;
    }

    private void initQtRetrievalDimension(Long quotaId, AttFileModel attFileModel, Date endDate, CircleRestVo circleRestVo) {
        RetrievalRuleMatchDimension matchDimension = new RetrievalRuleMatchDimension();
        matchDimension.setAttPersonId(attFileModel.getAttPersonId());
        matchDimension.setAttFileId(attFileModel.getId());
        matchDimension.setAttFileBoId(attFileModel.getBid());
        matchDimension.setPersonBoId(attFileModel.getPersonBoid().longValue());
        matchDimension.setEmployeeBoId(attFileModel.getEmployeeId().longValue());
        matchDimension.setDepempBoId(attFileModel.getDepempBoid().longValue());
        Date ownDate = endDate.before(circleRestVo.getEndDate()) ? endDate : circleRestVo.getEndDate();
        matchDimension.setOwnDate(ownDate);
        matchDimension.setType(RetrievalRuleMatchType.entry);
        matchDimension.setEntryKey("wtp_qtgenconfig");
        matchDimension.setIndex(circleRestVo.getIndex().intValue());
        String dimensionKey = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)quotaId, (long)circleRestVo.getCycSetId(), (long)circleRestVo.getIndex().intValue());
        matchDimension.setDimensionKey(dimensionKey);
        List matchDimensions = this.matchDimensionsMap.computeIfAbsent("wtp_qtgenconfig", item -> new ArrayList(16));
        matchDimensions.add(matchDimension);
    }

    private Map<String, RetrievalRuleMatchDimension> beginRetrieval() {
        try {
            HashSet allMatchDimension = Sets.newHashSetWithExpectedSize((int)16);
            HashSet allItemUniqueCodes = Sets.newHashSetWithExpectedSize((int)16);
            this.matchDimensionsMap.values().forEach(allMatchDimension::addAll);
            allItemUniqueCodes.addAll(this.qtItemUniqueCodes);
            LOG.info("QTTieRetrievalUtil.beginRetrieval,allItemUniqueCodes.size:{},allMatchDimension.size:{}", (Object)allItemUniqueCodes.size(), (Object)allMatchDimension.size());
            if (WTCCollections.isNotEmpty((Collection)allMatchDimension) && WTCCollections.isNotEmpty((Collection)allItemUniqueCodes)) {
                RetrievalRuleMatchService retrievalService = new RetrievalRuleMatchService();
                retrievalService.addRetrievalUnicode((Set)allItemUniqueCodes);
                retrievalService.addRetrievalDimension((List)Lists.newArrayList((Iterable)allMatchDimension));
                retrievalService.retrievalData();
                return allMatchDimension.stream().collect(Collectors.toMap(RetrievalRuleMatchDimension::getDimensionKey, Function.identity(), (o1, o2) -> o1));
            }
        }
        catch (KDBizException exception) {
            throw new WtesBizException(exception.getMessage());
        }
        catch (Exception exception) {
            LOG.warn("QTTieRetrievalUtil.beginRetrieval exception", (Throwable)exception);
            String msg = ResManager.loadKDString((String)"\u5b9a\u989d\u751f\u6210\u89c4\u5219\u53d6\u6570\u5f02\u5e38\u3002", (String)"QTTieRetrievalUtil_0", (String)"wtc-wtes-business", (Object[])new Object[0]);
            throw new WtesBizException(msg);
        }
        return Collections.emptyMap();
    }

    private Set<QuotaRetrievalDimensionResult> handleQtRetrievalResult(Map<String, RetrievalRuleMatchDimension> retrievalRuleMatchDimensionMap, QuotaInitParamRequest initRequest, List<Long> qtTypeIds, Map<Long, List<TimeSeqBo<AttFileModel>>> attFileTimeSeqBoMap) {
        HashSet qtRetrievalResults = Sets.newHashSetWithExpectedSize((int)16);
        if (WTCCollections.isEmpty(retrievalRuleMatchDimensionMap)) {
            return qtRetrievalResults;
        }
        AttRecordDetailHolder holder = (AttRecordDetailHolder)initRequest.getInitParams().get("QT_ATT_RECORD_DETAIL");
        Map<String, QuotaCycInfo> holderMap = holder.getCycSetMap();
        for (Map.Entry<Long, List<TimeSeqBo<AttFileModel>>> entry : attFileTimeSeqBoMap.entrySet()) {
            List<TimeSeqBo<AttFileModel>> attFileModels = entry.getValue();
            for (TimeSeqBo<AttFileModel> attFileModelTimeSeqBo : attFileModels) {
                Long fileBoid = attFileModelTimeSeqBo.getBid();
                for (Long quotaId : qtTypeIds) {
                    QuotaCycInfo quotaCycInfo = holderMap.get(fileBoid + "_" + quotaId);
                    if (quotaCycInfo == null) continue;
                    List<CircleRestVo> circleRestVos = quotaCycInfo.getRestVos();
                    for (CircleRestVo circleRestVo : circleRestVos) {
                        String dimensionKey;
                        QuotaRetrievalDimensionResult dimensionResults;
                        List attFileModelList;
                        Date endDate = circleRestVo.getEndDate();
                        Date startDate = circleRestVo.getStartDate();
                        AttFileModel attFileModel = (AttFileModel)attFileModelTimeSeqBo.getVersionByDate(WTCDateUtils.toLocalDate((Date)endDate));
                        if (attFileModel == null && WTCCollections.isNotEmpty((Collection)(attFileModelList = attFileModelTimeSeqBo.getVersionsBetweenDate(WTCDateUtils.toLocalDate((Date)startDate), WTCDateUtils.toLocalDate((Date)endDate))))) {
                            attFileModelList.sort(Comparator.comparing(AttFileModel::getEndDate));
                            attFileModel = (AttFileModel)((Object)attFileModelList.get(attFileModelList.size() - 1));
                        }
                        if (attFileModel == null || (dimensionResults = this.buildRetrievalDimensionResult(retrievalRuleMatchDimensionMap, dimensionKey = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)quotaId, (long)circleRestVo.getCycSetId(), (long)circleRestVo.getIndex().intValue()))) == null) continue;
                        qtRetrievalResults.add(dimensionResults);
                    }
                }
            }
        }
        return qtRetrievalResults;
    }

    private QuotaRetrievalDimensionResult buildRetrievalDimensionResult(Map<String, RetrievalRuleMatchDimension> retrievalRuleMatchDimensionMap, String dimensionKey) {
        RetrievalRuleMatchDimension entryMatchDimensions = retrievalRuleMatchDimensionMap.get(dimensionKey);
        if (entryMatchDimensions == null) {
            return null;
        }
        QuotaRetrievalDimensionResult qtRetrievalDimensionResult = new QuotaRetrievalDimensionResult();
        qtRetrievalDimensionResult.setDimensionKey(dimensionKey);
        qtRetrievalDimensionResult.setAttPersonId(entryMatchDimensions.getAttPersonId());
        qtRetrievalDimensionResult.setRosterDate(WTCDateUtils.toLocalDate((Date)entryMatchDimensions.getOwnDate()));
        qtRetrievalDimensionResult.setRetrievalDimension((RuleConditionValues)entryMatchDimensions);
        return qtRetrievalDimensionResult;
    }

    private AccessDto getRuleConditionInfo(String condition) {
        try {
            if (HRStringUtils.isEmpty((String)condition)) {
                return new AccessDto();
            }
            return (AccessDto)SerializationUtils.fromJsonString((String)condition, AccessDto.class);
        }
        catch (Exception exception) {
            LOG.warn("QTTieRetrievalUtil.getRuleConditionInfo exception", (Throwable)exception);
            return new AccessDto();
        }
    }
}

