/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTUseConfig;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTDateConfigTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTFloatUnitEnum;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.business.quota.util.RefDateUtils;

public class QTUseDateGenUtils {
    public static Map<String, Date> getUseDate(Date genStartDate, Date genEndDate, QuotaContextStd contextStd, QTCalRule qtCalRule) {
        int dateUnit;
        QTFloatUnitEnum qtStartFloatUnitEnum;
        Calendar calendar;
        Date useEndDate;
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        LocalDate localDate = contextStd.getChainDate();
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        Date periodEnd = contextStd.getCircleRestVo().getEndDate();
        QTUseConfig qtUseConfig = (QTUseConfig)qtCalRule.getUseConfig().getVersionByDate(localDate);
        QTDateConfigTypeEnum qtDateConfigTypeEnum = qtUseConfig.getUseStartDate();
        Date useStartDate = QTDateConfigTypeEnum.QT_DATE_START == qtDateConfigTypeEnum ? genStartDate : genEndDate;
        QTDateConfigTypeEnum qtEndDateConfigTypeEnum = qtUseConfig.getUseEndDate();
        Date date = useEndDate = QTDateConfigTypeEnum.QT_DATE_START == qtEndDateConfigTypeEnum ? genStartDate : genEndDate;
        if (qtUseConfig.getStartDelay().booleanValue() && qtUseConfig.getsDelay() != 0) {
            calendar = Calendar.getInstance();
            calendar.setTime(useStartDate);
            qtStartFloatUnitEnum = qtUseConfig.getStartFloatUnit();
            dateUnit = QTFloatUnitEnum.NATURAL_DAY == qtStartFloatUnitEnum ? 5 : 2;
            calendar.add(dateUnit, qtUseConfig.getsDelay());
            useStartDate = calendar.getTime();
        }
        if (qtUseConfig.getEndDelay().booleanValue() && qtUseConfig.geteDelay() != 0) {
            calendar = Calendar.getInstance();
            calendar.setTime(useEndDate);
            qtStartFloatUnitEnum = qtUseConfig.getEndFloatUnit();
            dateUnit = QTFloatUnitEnum.NATURAL_DAY == qtStartFloatUnitEnum ? 5 : 2;
            calendar.add(dateUnit, qtUseConfig.geteDelay());
            useEndDate = calendar.getTime();
        }
        List<Long> expectRefDateIdList = Stream.of(qtUseConfig.getStartLimit(), qtUseConfig.getEndLimit()).filter(ele -> ele != 0L).collect(Collectors.toList());
        LocalDate personChain = WTCDateUtils.toLocalDate((Date)periodEnd);
        AttendPersonModel byBidAndDate = QuotaContextUtil.getAttendPersonData(contextStd, personChain);
        Map<Long, Date> refDateMap = RefDateUtils.getRefDateMap(byBidAndDate, attFileModel, contextStd.getAttPersonId(), expectRefDateIdList, localDate, contextStd.getInitParams());
        Date startSpeDate = refDateMap.get(qtUseConfig.getStartLimit());
        useStartDate = startSpeDate != null && startSpeDate.after(useStartDate) ? startSpeDate : useStartDate;
        map.put("startDate", useStartDate);
        Date endSpeDate = refDateMap.get(qtUseConfig.getEndLimit());
        useEndDate = endSpeDate != null && endSpeDate.before(useEndDate) ? endSpeDate : useEndDate;
        map.put("endDate", useEndDate);
        return map;
    }
}

