/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.sdk.wtc.wtes.business.qte.executor.AfterQteGenQTEvent;
import kd.sdk.wtc.wtes.business.qte.executor.QteGenQTExtPlugin;
import kd.sdk.wtc.wtes.business.qte.executor.QuotaDetail;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.common.enums.AttitemUnitEnum;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTCarryDown;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTOverDraw;
import kd.wtc.wtes.business.model.rlqt.QTRule;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTUnitEnum;
import kd.wtc.wtes.business.quota.datanode.QuotaAttItemValue;
import kd.wtc.wtes.business.quota.datanode.QuotaDataNode;
import kd.wtc.wtes.business.quota.model.QuotaAttItemInstance;
import kd.wtc.wtes.business.quota.model.QuotaAttItemType;
import kd.wtc.wtes.business.quota.model.QuotaDetailType;
import kd.wtc.wtes.business.quota.model.QuotaExtPluginHolder;
import kd.wtc.wtes.business.quota.model.QuotaRunTimeCache;
import kd.wtc.wtes.business.quota.model.VestTypeEnum;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.quota.util.QuotaContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.cumulate.trading.QTRuntime;
import kd.wtc.wtp.business.cumulate.trading.model.DetailLogicKey;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetail;
import org.apache.commons.lang3.StringUtils;

public class QteGenExtPluginUtils {
    private static final Log log = WTCLogFactory.getLog(QteGenExtPluginUtils.class);
    private static final String BUSINESS_KEY = "businessCache";
    private static final String CUS_ADD_TAG = "custom";

    public static void afterDoEvalua(QuotaContextStd context, List<QuotaAttItemValue> quotaAttItemValues, String stepName, BiFunction<QTLineDetail, Date, QuotaDetail> biFunction) {
        QTRule qtRule;
        List<QTCalRule> qtCalRules;
        QTCalRule qtCalRule;
        if (CollectionUtils.isEmpty(quotaAttItemValues) && !"carrydown".equals(stepName)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("QteGenExtPluginUtils.afterDoEvalua  quotaAttItemValues = {},stepName = {}", (Object)JSON.toJSONString(quotaAttItemValues), (Object)stepName);
        }
        AttFileCabinet attFileCabinet = context.getInitParamMust("ATT_FILE", AttFileCabinet.class);
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(context);
        String key = DetailLogicKey.getIndexKey((long)attFileModel.getBid(), (long)context.getQuotaTypeId(), (long)context.getCircleRestVo().getCycSetId(), (long)context.getCircleRestVo().getIndex().intValue());
        List qtDetails = (List)context.getVariable(key, VScope.LINE);
        if (CollectionUtils.isEmpty((Collection)qtDetails)) {
            return;
        }
        Map<String, Object> initParams = context.getInitParams();
        Object initDataExt = initParams.get("QT_EXT_PARAM");
        ArrayList quotaDetails = new ArrayList(quotaAttItemValues.size());
        List<Object> needDoAttItemValues = new ArrayList(quotaAttItemValues.size());
        needDoAttItemValues = "carrydown".equals(stepName) ? quotaAttItemValues.stream().filter(qt -> QteGenExtPluginUtils.isCarryAttItem(qt.getAttItemInstance())).collect(Collectors.toList()) : quotaAttItemValues;
        HashSet qtLineDetailIds = new HashSet();
        Map<Long, List<QuotaAttItemValue>> detailMap = needDoAttItemValues.stream().collect(Collectors.groupingBy(dt -> dt.getAttItemInstance().getQtDetailId()));
        HashSet<QTLineDetail> qtLineDetails = new HashSet<QTLineDetail>();
        HashMap matchRuleMap = new HashMap();
        needDoAttItemValues.forEach(dt -> {
            QuotaAttItemInstance attItemInstance = dt.getAttItemInstance();
            if (!CollectionUtils.isEmpty((Collection)qtDetails) && !qtLineDetailIds.contains(attItemInstance.getQtDetailId())) {
                qtDetails.forEach(qtLineDetail -> {
                    if (qtLineDetail.getBid() == attItemInstance.getQtDetailId().longValue()) {
                        matchRuleMap.put(qtLineDetail.getAttFileVid(), dt.getMatchedRule());
                        QuotaDetail quotaDetail = (QuotaDetail)biFunction.apply((QTLineDetail)qtLineDetail, attItemInstance.getChangeSatrt());
                        qtLineDetailIds.add(attItemInstance.getQtDetailId());
                        qtLineDetails.add((QTLineDetail)qtLineDetail);
                        quotaDetails.add(quotaDetail);
                    }
                });
            }
        });
        long attPersonId = context.getAttPersonId();
        LocalDate chainDate = context.getChainDate();
        HashMap map = (HashMap)context.getVariable(BUSINESS_KEY, VScope.LINE);
        if (map == null) {
            map = new HashMap();
            context.setVariable(BUSINESS_KEY, map, VScope.LINE);
        }
        AfterQteGenQTEvent param = new AfterQteGenQTEvent(attPersonId, chainDate, matchRuleMap, attFileModel.getBid(), quotaDetails, initDataExt, initParams, map);
        QuotaExtPluginHolder pluginHolder = (QuotaExtPluginHolder)initParams.get("QT_EXT_PLUGIN");
        WTCPluginProxy instance = (WTCPluginProxy)pluginHolder.getPlugin(QteGenQTExtPlugin.class.getName());
        QteGenExtPluginUtils.invokeReplace((WTCPluginProxy<QteGenQTExtPlugin>)instance, param, stepName);
        if (log.isDebugEnabled()) {
            log.debug("after QteGenQTExtPlugin  quotaAttItemValues = {},stepName = {}", (Object)JSON.toJSONString(quotaAttItemValues), (Object)stepName);
        }
        if (CollectionUtils.isNotEmpty(quotaAttItemValues)) {
            QteGenExtPluginUtils.updateVale(stepName, detailMap, param, qtLineDetails, context, quotaAttItemValues);
        }
        if ((qtCalRule = QteGenExtPluginUtils.getQTCalRule(qtCalRules = (qtRule = QteGenExtPluginUtils.getMatchRule(context, attFileModel.getId())).getQtRules(), context, chainDate)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u5339\u914d\u201c\u5b9a\u989d\u89c4\u5219\u201d\u4e0b\u7684\u8ba1\u7b97\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u201c\u8003\u52e4\u6863\u6848\u201d\u4e0b\u201c\u5b9a\u989d\u65b9\u6848\u201d\u5185\u7684\u201c\u5b9a\u989d\u89c4\u5219\u201d\u7684\u914d\u7f6e\u9879\u3002", (String)"QTStandardDurationEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        QTGenConfig qtGenConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(chainDate);
        QTGenConfigEntry qtGenConfigEntry = qtGenConfig.getQtGenCfEntryByDetail(((QTLineDetail)qtDetails.get(0)).getBid());
        quotaAttItemValues.addAll(QteGenExtPluginUtils.doNewDetail(stepName, param, qtLineDetails, context, qtCalRule, qtGenConfigEntry, qtGenConfig));
    }

    private static QTCalRule getQTCalRule(List<QTCalRule> qtCalRules, QuotaContextStd contextstd, LocalDate endDate) {
        if (CollectionUtils.isEmpty(qtCalRules)) {
            return null;
        }
        for (QTCalRule qtCalRule : qtCalRules) {
            QTGenConfig genConfig = (QTGenConfig)qtCalRule.getGenConfig().getVersionByDate(endDate);
            if (!contextstd.getQuotaTypeId().equals(genConfig.getQtType().getId())) continue;
            return qtCalRule;
        }
        return null;
    }

    private static void invokeReplace(WTCPluginProxy<QteGenQTExtPlugin> instance, AfterQteGenQTEvent param, String stepName) {
        if (StringUtils.isEmpty((CharSequence)stepName)) {
            return;
        }
        switch (stepName) {
            case "standardgen": {
                instance.invokeReplace(plugin -> plugin.afterStandardGen(param));
                break;
            }
            case "usegen": {
                instance.invokeReplace(plugin -> plugin.afterUseGen(param));
                break;
            }
            case "in_out": {
                instance.invokeReplace(plugin -> plugin.afterInOutGen(param));
                break;
            }
            case "standardql": {
                instance.invokeReplace(plugin -> plugin.afterQualificationGen(param));
                break;
            }
            case "useql": {
                instance.invokeReplace(plugin -> plugin.afterUseQlGen(param));
                break;
            }
            case "over": {
                instance.invokeReplace(plugin -> plugin.afterOverdrawGen(param));
                break;
            }
            case "overql": {
                instance.invokeReplace(plugin -> plugin.afterOverdrawQlGen(param));
                break;
            }
            case "carrydown": {
                instance.invokeReplace(plugin -> plugin.afterCarryDwonQlGen(param));
            }
        }
    }

    private static void updateVale(String stepName, Map<Long, List<QuotaAttItemValue>> detailMap, AfterQteGenQTEvent param, Set<QTLineDetail> qtLineDetails, QuotaContextStd contextStd, List<QuotaAttItemValue> quotaAttItemValues) {
        if (StringUtils.isEmpty((CharSequence)stepName)) {
            return;
        }
        List qtDetails = param.getQuotaDetails();
        Map<Long, List<QTLineDetail>> qtLineDetailMap = qtLineDetails.stream().collect(Collectors.groupingBy(QTLineDetail::getBid));
        qtDetails.forEach(detail -> {
            Long id = detail.getId();
            List qTLineDetailList = (List)qtLineDetailMap.get(id);
            if (CollectionUtils.isEmpty((Collection)qTLineDetailList)) {
                return;
            }
            boolean isModify = detail.isModify();
            if (!isModify) {
                return;
            }
            List attItemValues = (List)detailMap.get(id);
            QteGenExtPluginUtils.updateOnePropValue(stepName, attItemValues, detail, (QTLineDetail)qTLineDetailList.get(0), contextStd, quotaAttItemValues);
        });
    }

    private static void updateOnePropValue(String stepName, List<QuotaAttItemValue> attItemValues, QuotaDetail detail, QTLineDetail qtLineDetail, QuotaContextStd contextStd, List<QuotaAttItemValue> quotaAttItemValues) {
        switch (stepName) {
            case "standardgen": {
                attItemValues.forEach(attItemValue -> {
                    QuotaAttItemInstance attItemInstance = attItemValue.getAttItemInstance();
                    attItemInstance.setDesc(detail.getDesc());
                    attItemInstance.setItemValue(detail.getGenValue());
                    attItemInstance.setGenStartDate(detail.getGenStartDate());
                    attItemInstance.setGenEndDate(detail.getGenEndDate());
                });
                qtLineDetail.setGenValue(detail.getGenValue());
                qtLineDetail.setGenStartDate(detail.getGenStartDate());
                qtLineDetail.setGenEndDate(detail.getGenEndDate());
                break;
            }
            case "usegen": {
                attItemValues.forEach(attItemValue -> {
                    QuotaAttItemInstance attItemInstance = attItemValue.getAttItemInstance();
                    attItemInstance.setDesc(detail.getDesc());
                    attItemInstance.setUseStartDate(detail.getUseStartDate());
                    attItemInstance.setUseEndDate(detail.getUseEndDate());
                });
                qtLineDetail.setUseStartDate(detail.getUseStartDate());
                qtLineDetail.setUseEndDate(detail.getUseEndDate());
                break;
            }
            case "in_out": 
            case "standardql": 
            case "useql": {
                List<QuotaAttItemValue> enjoys = attItemValues.stream().filter(attItemValue -> attItemValue.getAttItemInstance().getQuotaAttItemType() == QuotaAttItemType.DURATION_ENJOYMENT).collect(Collectors.toList());
                enjoys.forEach(attItemValue -> {
                    QuotaAttItemInstance attItemInstance = attItemValue.getAttItemInstance();
                    attItemInstance.setDesc(detail.getDesc());
                    attItemInstance.setItemValue(detail.getOwnValue());
                });
                qtLineDetail.setOwnValue(detail.getOwnValue());
                break;
            }
            case "over": 
            case "overql": {
                List<QuotaAttItemValue> enjoyOvers = attItemValues.stream().filter(attItemValue -> attItemValue.getAttItemInstance().getQuotaAttItemType() == QuotaAttItemType.OVERDRAW_STANDARD).collect(Collectors.toList());
                enjoyOvers.forEach(attItemValue -> {
                    QuotaAttItemInstance attItemInstance = attItemValue.getAttItemInstance();
                    attItemInstance.setDesc(detail.getDesc());
                    attItemInstance.setItemValue(detail.getOwnOdValue());
                });
                List<QuotaAttItemValue> overs = attItemValues.stream().filter(attItemValue -> attItemValue.getAttItemInstance().getQuotaAttItemType() == QuotaAttItemType.OVERDRAW_AVAILABLE).collect(Collectors.toList());
                overs.forEach(attItemValue -> {
                    QuotaAttItemInstance attItemInstance = attItemValue.getAttItemInstance();
                    attItemInstance.setDesc(detail.getDesc());
                    attItemInstance.setItemValue(detail.getCanBeOdValue());
                });
                qtLineDetail.setOwnOdValue(detail.getOwnOdValue());
                qtLineDetail.setCanBeOdValue(detail.getCanBeOdValue());
            }
            case "carrydown": {
                if (!CollectionUtils.isNotEmpty(attItemValues)) break;
                QTCalRule qtCalRule = (QTCalRule)attItemValues.get(0).getMatchedRule();
                quotaAttItemValues.addAll(QteGenExtPluginUtils.carryDownStep(qtCalRule, attItemValues, detail, qtLineDetail, contextStd));
                List carryDwonItemValues = attItemValues.stream().filter(attItemValue -> attItemValue.getAttItemInstance().getQuotaAttItemType() == QuotaAttItemType.CARRYDOWN_DURATION || attItemValue.getAttItemInstance().getQuotaAttItemType() == QuotaAttItemType.QUIT_DEPART).collect(Collectors.toList());
                if (carryDwonItemValues.size() <= 1) break;
                ArrayList delItmes = Lists.newArrayListWithExpectedSize((int)carryDwonItemValues.size());
                for (int index = 0; index < carryDwonItemValues.size(); ++index) {
                    QuotaAttItemValue attItemValue2 = (QuotaAttItemValue)carryDwonItemValues.get(index);
                    int size = carryDwonItemValues.size();
                    if (BigDecimal.ZERO.compareTo(attItemValue2.getAttItemInstance().getItemValue()) != 0 || delItmes.size() >= size - 1) continue;
                    delItmes.add(attItemValue2);
                }
                quotaAttItemValues.removeAll(delItmes);
            }
        }
    }

    private static List<QuotaAttItemValue> carryDownStep(QTCalRule qtCalRule, List<QuotaAttItemValue> attItemValues, QuotaDetail detail, QTLineDetail qtLineDetail, QuotaContextStd contextStd) {
        List<QuotaAttItemValue> businessItemValues;
        List<QuotaAttItemValue> departItemValues;
        QuotaAttItemInstance quotaAttItemInstance5;
        List<QuotaAttItemValue> settleItemValues;
        ArrayList carryAttItemInstances = Lists.newArrayListWithCapacity((int)16);
        ArrayList updateAddAttItemInstances = Lists.newArrayListWithCapacity((int)16);
        BigDecimal carryDwonValue = detail.getCarryDownedValue();
        BigDecimal settlementValue = detail.getSettlementValue();
        BigDecimal invalidValue = detail.getInvalidValue() == null ? BigDecimal.ZERO : detail.getInvalidValue();
        BigDecimal departCarryValue = detail.getDepartCarryValue();
        BigDecimal carryToBusinessValue = detail.getCarryToBusinessValue();
        QteGenExtPluginUtils.getMatchRule(contextStd, qtLineDetail.getAttFileVid());
        QTCarryDown carryDown = (QTCarryDown)qtCalRule.getCarryDown().getVersionByDate(contextStd.getChainDate());
        AttItemSpecData attItemSpecData = contextStd.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(carryDown.getDepartCarryDown().getDepartAttItem(), contextStd.getChainDate());
        QTUnitEnum qtUnitEnum = AttitemUnitEnum.DAY == AttitemUnitEnum.of((String)attItemSpec.getUnit()) ? QTUnitEnum.DAY : QTUnitEnum.HOUR;
        List<QuotaAttItemValue> carryDwonItemValues = attItemValues.stream().filter(attItemValue -> attItemValue.getAttItemInstance().getQuotaAttItemType() == QuotaAttItemType.CARRYDOWN_DURATION && !VestTypeEnum.BUSINESS_AREA.getCode().equals(attItemValue.getAttItemInstance().getVestType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(carryDwonItemValues) && carryDwonValue != null && BigDecimal.ZERO.compareTo(carryDwonValue) != 0) {
            Long carryItem = carryDown.getCdDuration() == 0L ? QuotaContextUtil.getQTDefaultItem(qtUnitEnum).longValue() : carryDown.getCdDuration();
            QuotaAttItemInstance quotaAttItemInstance2 = QteGenExtPluginUtils.buildNewAttitem(detail, contextStd, carryDwonValue, QuotaAttItemType.CARRYDOWN_DURATION, carryItem, qtLineDetail.getAttFileBoId(), qtLineDetail.getAttFileVid(), qtLineDetail.getBid());
            Map<String, Date> useDateMap = QuotaContextUtil.getCdUseDate(carryDown, quotaAttItemInstance2);
            Date useStartDate = useDateMap.get("start");
            Date useEndDate = useDateMap.get("end");
            if (useEndDate.before(useStartDate)) {
                AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5b9a\u989d\u7ed3\u8f6c\u914d\u7f6e\u4e2d\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u7ed3\u675f\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u201c\u8003\u52e4\u6863\u6848\u201d\u4e0b\u201c\u5b9a\u989d\u65b9\u6848\u201d\u5185\u7684\u201c\u5b9a\u989d\u7ed3\u8f6c\u914d\u7f6e\u201d\u3002", (String)"QTCarryOverEvaluator_1", (String)"wtc-wtes-business", (Object[])new Object[0]), attFileModel.getNumber()));
            }
            quotaAttItemInstance2.setUseStartDate(useStartDate);
            quotaAttItemInstance2.setUseEndDate(useEndDate);
            carryAttItemInstances.add(quotaAttItemInstance2);
        } else {
            carryDwonItemValues.forEach(attItemValue -> {
                QuotaAttItemInstance attItemInstance = attItemValue.getAttItemInstance();
                attItemInstance.setDesc(detail.getDesc());
                BigDecimal cdValue = carryDwonValue == null ? BigDecimal.ZERO : carryDwonValue;
                attItemInstance.setItemValue(cdValue);
            });
        }
        if (carryDwonValue != null && BigDecimal.ZERO.compareTo(carryDwonValue) != 0) {
            qtLineDetail.setCarryDownedValue(carryDwonValue);
            qtLineDetail.setVestType("");
        }
        if (CollectionUtils.isEmpty(settleItemValues = attItemValues.stream().filter(attItemValue -> attItemValue.getAttItemInstance().getQuotaAttItemType() == QuotaAttItemType.QUIT_SETTLEMENT).collect(Collectors.toList())) && settlementValue != null && BigDecimal.ZERO.compareTo(settlementValue) != 0) {
            Long slmentItem = carryDown.getSlmentAttItem();
            QuotaAttItemInstance quotaAttItemInstance3 = QteGenExtPluginUtils.buildNewAttitem(detail, contextStd, settlementValue, QuotaAttItemType.QUIT_SETTLEMENT, slmentItem, qtLineDetail.getAttFileBoId(), qtLineDetail.getAttFileVid(), qtLineDetail.getBid());
            quotaAttItemInstance3.setVestType(VestTypeEnum.SETTLEMENT.getCode());
            qtLineDetail.setSettlement(Boolean.TRUE.booleanValue());
            qtLineDetail.setVestType(VestTypeEnum.SETTLEMENT.getCode());
            carryAttItemInstances.add(quotaAttItemInstance3);
        } else {
            settleItemValues.forEach(attItemValue -> {
                QuotaAttItemInstance attItemInstance = attItemValue.getAttItemInstance();
                attItemInstance.setDesc(detail.getDesc());
                attItemInstance.setItemValue(settlementValue);
            });
        }
        if (invalidValue != null) {
            List<QuotaAttItemValue> invalidItemValues = attItemValues.stream().filter(attItemValue -> attItemValue.getAttItemInstance().getQuotaAttItemType() == QuotaAttItemType.CARRYDOWN_EXPIRE).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(invalidItemValues) && BigDecimal.ZERO.compareTo(invalidValue) != 0) {
                long carryItem = carryDown.getPassDurationAttItem() == 0L ? QuotaContextUtil.getQTDefaultItem(qtUnitEnum).longValue() : carryDown.getPassDurationAttItem();
                carryItem = carryItem == 0L ? carryDown.getSlmentAttItem() : carryItem;
                quotaAttItemInstance5 = QteGenExtPluginUtils.buildNewAttitem(detail, contextStd, invalidValue, QuotaAttItemType.CARRYDOWN_EXPIRE, carryItem, qtLineDetail.getAttFileBoId(), qtLineDetail.getAttFileVid(), qtLineDetail.getBid());
                carryAttItemInstances.add(quotaAttItemInstance5);
            } else {
                invalidItemValues.forEach(attItemValue -> {
                    QuotaAttItemInstance attItemInstance = attItemValue.getAttItemInstance();
                    attItemInstance.setDesc(detail.getDesc());
                    attItemInstance.setItemValue(invalidValue);
                });
            }
        }
        if (CollectionUtils.isEmpty(departItemValues = attItemValues.stream().filter(attItemValue -> attItemValue.getAttItemInstance().getQuotaAttItemType() == QuotaAttItemType.QUIT_DEPART).collect(Collectors.toList())) && departCarryValue != null && BigDecimal.ZERO.compareTo(departCarryValue) != 0) {
            Long departItem = carryDown.getDepartCarryDown().getDepartAttItem();
            QuotaAttItemInstance quotaAttItemInstance4 = QteGenExtPluginUtils.buildNewAttitem(detail, contextStd, departCarryValue, QuotaAttItemType.QUIT_DEPART, departItem, qtLineDetail.getAttFileBoId(), qtLineDetail.getAttFileVid(), qtLineDetail.getBid());
            Date day = QuotaContextUtil.getDepartVestDay(carryDown, contextStd);
            quotaAttItemInstance4.setVestDay(WTCDateUtils.getZeroDate((Date)day));
            quotaAttItemInstance4.setVestType(VestTypeEnum.DEPART.getCode());
            carryAttItemInstances.add(quotaAttItemInstance4);
        } else {
            departItemValues.forEach(attItemValue -> {
                QuotaAttItemInstance attItemInstance = attItemValue.getAttItemInstance();
                attItemInstance.setDesc(detail.getDesc());
                BigDecimal depValue = departCarryValue == null ? BigDecimal.ZERO : departCarryValue;
                attItemInstance.setItemValue(depValue);
            });
        }
        if (departCarryValue != null && BigDecimal.ZERO.compareTo(departCarryValue) != 0) {
            qtLineDetail.setCarryDownedValue(departCarryValue);
            qtLineDetail.setDepartValue(departCarryValue);
            qtLineDetail.setVestType(VestTypeEnum.DEPART.getCode());
        }
        if (CollectionUtils.isEmpty(businessItemValues = attItemValues.stream().filter(attItemValue -> attItemValue.getAttItemInstance().getQuotaAttItemType() == QuotaAttItemType.CARRYDOWN_DURATION && VestTypeEnum.BUSINESS_AREA.getCode().equals(attItemValue.getAttItemInstance().getVestType())).collect(Collectors.toList())) && carryToBusinessValue != null && BigDecimal.ZERO.compareTo(carryToBusinessValue) != 0) {
            Long carryItem = carryDown.getCdDuration() == 0L ? QuotaContextUtil.getQTDefaultItem(qtUnitEnum).longValue() : carryDown.getCdDuration();
            quotaAttItemInstance5 = QteGenExtPluginUtils.buildNewAttitem(detail, contextStd, carryToBusinessValue, QuotaAttItemType.CARRYDOWN_DURATION, carryItem, qtLineDetail.getAttFileBoId(), qtLineDetail.getAttFileVid(), qtLineDetail.getBid());
            Date vestDay = QuotaContextUtil.getBusinessVestDay(qtLineDetail.getUseEndDate(), carryDown);
            quotaAttItemInstance5.setVestDay(WTCDateUtils.getZeroDate((Date)vestDay));
            quotaAttItemInstance5.setVestType(VestTypeEnum.BUSINESS_AREA.getCode());
            carryAttItemInstances.add(quotaAttItemInstance5);
        } else {
            businessItemValues.forEach(attItemValue -> {
                QuotaAttItemInstance attItemInstance = attItemValue.getAttItemInstance();
                attItemInstance.setDesc(detail.getDesc());
                BigDecimal busValue = carryToBusinessValue == null ? BigDecimal.ZERO : carryToBusinessValue;
                attItemInstance.setItemValue(busValue);
            });
        }
        if (carryToBusinessValue != null && BigDecimal.ZERO.compareTo(carryToBusinessValue) != 0) {
            qtLineDetail.setCarryDownedValue(carryToBusinessValue);
            qtLineDetail.setVestType(VestTypeEnum.BUSINESS_AREA.getCode());
        }
        if (QteGenExtPluginUtils.carryValueisZero(carryDwonValue, carryToBusinessValue, departCarryValue)) {
            qtLineDetail.setCarryDownedValue(BigDecimal.ZERO);
        }
        qtLineDetail.setInvalidValue(invalidValue);
        if (CollectionUtils.isNotEmpty((Collection)carryAttItemInstances)) {
            for (QuotaAttItemInstance quotaAttItemInstance5 : carryAttItemInstances) {
                QuotaAttItemValue quotaAttItemValue = QteGenExtPluginUtils.bulidItemValue(qtCalRule, carryDown.getId(), "wtp_qtcarrydown", quotaAttItemInstance5);
                attItemValues.add(quotaAttItemValue);
                updateAddAttItemInstances.add(quotaAttItemValue);
            }
        }
        return updateAddAttItemInstances;
    }

    private static boolean carryValueisZero(BigDecimal carryDwonValue, BigDecimal carryToBusinessValue, BigDecimal departCarryValue) {
        return !(carryDwonValue != null && BigDecimal.ZERO.compareTo(carryDwonValue) != 0 || carryToBusinessValue != null && BigDecimal.ZERO.compareTo(carryToBusinessValue) != 0 || departCarryValue != null && BigDecimal.ZERO.compareTo(departCarryValue) != 0);
    }

    private static boolean isCarryAttItem(QuotaAttItemInstance quotaAttItemInstance) {
        return quotaAttItemInstance.getQuotaAttItemType() == QuotaAttItemType.CARRYDOWN_DURATION || quotaAttItemInstance.getQuotaAttItemType() == QuotaAttItemType.QUIT_DEPART || quotaAttItemInstance.getQuotaAttItemType() == QuotaAttItemType.CARRYDOWN_EXPIRE || quotaAttItemInstance.getQuotaAttItemType() == QuotaAttItemType.QUIT_SETTLEMENT;
    }

    private static QTRule getMatchRule(QuotaContextStd context, Long attFielVid) {
        String ruleKey = "matchRuleLineVar" + attFielVid;
        return (QTRule)context.getVariable(ruleKey, VScope.LINE);
    }

    private static QuotaAttItemInstance buildNewAttitem(QuotaDetail detail, QuotaContextStd context, BigDecimal attItemVale, QuotaAttItemType itemType, Long attItemId, Long attFileBoid, Long attFileVId, Long qtDetailId) {
        AttItemSpecData attItemSpecData = context.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
        AttItemSpec attItemSpec = attItemSpecData.getByBidAndDate(attItemId, context.getChainDate());
        QuotaAttItemInstance quotaAttItemInstance = new QuotaAttItemInstance(qtDetailId, attItemSpec, attItemVale, AttitemUnitEnum.of((String)attItemSpec.getUnit()), itemType, QuotaDetailType.of(detail.getSource()), detail.getQtTypeId(), detail.getpCycleId(), detail.getPeriodNum(), context.getCircleRestVo().getAssignDate());
        quotaAttItemInstance.setGenStartDate(detail.getGenStartDate());
        quotaAttItemInstance.setGenEndDate(detail.getGenEndDate());
        quotaAttItemInstance.setUseStartDate(detail.getUseStartDate());
        quotaAttItemInstance.setUseEndDate(detail.getUseEndDate());
        quotaAttItemInstance.setOrgEndDay(context.getChainDate());
        quotaAttItemInstance.setAttFileBoId(attFileBoid);
        quotaAttItemInstance.setAttFileVId(attFileVId);
        return quotaAttItemInstance;
    }

    private static QuotaAttItemValue bulidItemValue(QTCalRule qtCalRule, Long evaluationRuleId, String evaluationRuleType, QuotaAttItemInstance quotaAttItemInstance) {
        QuotaAttItemValue quotaSdtAttItemValue = (QuotaAttItemValue)((QuotaAttItemValue.Builder)((QuotaAttItemValue.Builder)((QuotaDataNode.Builder)QuotaAttItemValue.builder().attItemInstance(quotaAttItemInstance)).matchedRule(qtCalRule)).evaluationRule(EvaluationRuleModel.of(evaluationRuleId, evaluationRuleType))).build();
        return quotaSdtAttItemValue;
    }

    private static List<QuotaAttItemValue> doNewDetail(String step, AfterQteGenQTEvent param, Set<QTLineDetail> qtLineDetails, QuotaContextStd contextStd, QTCalRule qtCalRule, QTGenConfigEntry entry, QTGenConfig genConfig) {
        ArrayList attItemValues = Lists.newArrayListWithExpectedSize((int)16);
        List<QTLineDetail> lineqtDetails = QuotaContextUtil.getLineDetail(contextStd);
        if (CollectionUtils.isEmpty(lineqtDetails)) {
            return attItemValues;
        }
        AttFileModel attFileModel = QuotaContextUtil.getAttFileModle(contextStd);
        QuotaRunTimeCache quotaRunTimeCache = (QuotaRunTimeCache)contextStd.getInitParam("QT_RUN_TIME_CACHE");
        QTRuntime qtRuntime = quotaRunTimeCache.getRunTimeByAttFileBoId(attFileModel.getBid());
        List qtDetails = param.getQuotaDetails();
        ArrayList needSaveDetails = Lists.newArrayListWithExpectedSize((int)16);
        Map<Long, List<QTLineDetail>> qtLineDetailMap = qtLineDetails.stream().collect(Collectors.groupingBy(QTLineDetail::getBid));
        qtDetails.forEach(detail -> {
            List qTLineDetailList;
            Long id = detail.getId();
            if (id == null || id == 0L) {
                id = IDService.get().genLongId();
            }
            if (CollectionUtils.isEmpty((Collection)(qTLineDetailList = (List)qtLineDetailMap.get(id)))) {
                QTLineDetail qtLineDetail = new QTLineDetail();
                qtLineDetail.setId(id.longValue());
                qtLineDetail.setAttFileVid(detail.getAttFileVid());
                qtLineDetail.setAttFileBoId(param.getAttFileBid());
                qtLineDetail.setOrgId(detail.getOrgId());
                qtLineDetail.setSource(detail.getSource());
                qtLineDetail.setQtTypeId(detail.getQtTypeId());
                qtLineDetail.setpCycleId(detail.getpCycleId());
                qtLineDetail.setPeriodNum(detail.getPeriodNum());
                qtLineDetail.setUseEndDate(detail.getUseEndDate());
                qtLineDetail.setUseStartDate(detail.getUseStartDate());
                qtLineDetail.setGenStartDate(detail.getGenStartDate());
                qtLineDetail.setGenEndDate(detail.getGenEndDate());
                qtLineDetail.setGenValue(detail.getGenValue());
                qtLineDetail.setOwnValue(detail.getOwnValue());
                qtLineDetail.setUsableValue(detail.getUsableValue());
                qtLineDetail.setOwnOdValue(detail.getOwnOdValue());
                qtLineDetail.setCanBeOdValue(detail.getCanBeOdValue());
                qtLineDetail.setGenConditionStr(CUS_ADD_TAG);
                lineqtDetails.add(qtLineDetail);
                genConfig.putQtGenCfEntryByDetail(qtLineDetail.getBid(), entry);
                QuotaAttItemInstance starItem = QteGenExtPluginUtils.buildNewAttitem(detail, contextStd, detail.getGenValue(), QuotaAttItemType.STANDARD, entry.getResultAttItem(), qtLineDetail.getAttFileBoId(), qtLineDetail.getAttFileVid(), qtLineDetail.getBid());
                QuotaAttItemValue starAttItemValue = QteGenExtPluginUtils.bulidItemValue(qtCalRule, genConfig.getId(), "wtp_qtgenconfig", starItem);
                starAttItemValue.setEvaluationRule(EvaluationRuleModel.of(genConfig.getCycSet(), "wtbd_cycset"));
                attItemValues.add(starAttItemValue);
                QuotaAttItemInstance enjoyItem = QteGenExtPluginUtils.buildNewAttitem(detail, contextStd, detail.getOwnValue(), QuotaAttItemType.DURATION_ENJOYMENT, entry.getEnjoyAttItem(), qtLineDetail.getAttFileBoId(), qtLineDetail.getAttFileVid(), qtLineDetail.getBid());
                QuotaAttItemValue enjoyAttItemValue = QteGenExtPluginUtils.bulidItemValue(qtCalRule, genConfig.getId(), "wtp_qtgenconfig", enjoyItem);
                attItemValues.add(enjoyAttItemValue);
                if (detail.getOwnOdValue() != null && BigDecimal.ZERO.compareTo(detail.getOwnOdValue()) != 0 && qtCalRule.getOverDraw() != null && qtCalRule.getOverDraw().getVersionByDate(contextStd.getChainDate()) != null) {
                    QTOverDraw qtOverDraw = (QTOverDraw)qtCalRule.getOverDraw().getVersionByDate(contextStd.getChainDate());
                    QuotaAttItemInstance overItem = QteGenExtPluginUtils.buildNewAttitem(detail, contextStd, detail.getGenValue(), QuotaAttItemType.OVERDRAW_STANDARD, qtOverDraw.getOriOverAttItem(), qtLineDetail.getAttFileBoId(), qtLineDetail.getAttFileVid(), qtLineDetail.getBid());
                    QuotaAttItemValue overAttItemValue = QteGenExtPluginUtils.bulidItemValue(qtCalRule, qtOverDraw.getId(), "wtp_qtoverdraw", overItem);
                    attItemValues.add(overAttItemValue);
                    if (detail.getCanBeOdValue() != null && BigDecimal.ZERO.compareTo(detail.getCanBeOdValue()) != 0) {
                        QuotaAttItemInstance canBeOdItem = QteGenExtPluginUtils.buildNewAttitem(detail, contextStd, detail.getCanBeOdValue(), QuotaAttItemType.OVERDRAW_AVAILABLE, qtOverDraw.getCanOdValue(), qtLineDetail.getAttFileBoId(), qtLineDetail.getAttFileVid(), qtLineDetail.getBid());
                        QuotaAttItemValue canBeOdAttItemValue = QteGenExtPluginUtils.bulidItemValue(qtCalRule, qtOverDraw.getId(), "wtp_qtoverdraw", canBeOdItem);
                        attItemValues.add(canBeOdAttItemValue);
                    }
                }
                if ("carrydown".equals(step)) {
                    needSaveDetails.add(qtLineDetail);
                    QteGenExtPluginUtils.carryDownStep(qtCalRule, attItemValues, detail, qtLineDetail, contextStd);
                }
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)needSaveDetails)) {
            qtRuntime.plusPoolAndMarkDirty((Collection)needSaveDetails);
        }
        return attItemValues;
    }
}

