/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.util;

import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtes.business.model.RuleEngineEnum;
import kd.wtc.wtes.business.model.rlqt.QTRule;
import kd.wtc.wtes.business.model.rlqt.QTScheme;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.business.ruleengine.RuleEngineService;
import kd.wtc.wtes.business.ruleengine.RuleParam;
import kd.wtc.wtes.common.util.CollectionUtils;

public class QuotaRuleConfigUtils {
    private static final Log logger = LogFactory.getLog(QuotaRuleConfigUtils.class);

    public static QTRule getRuleConfig(QuotaContextStd context, QTScheme qtScheme, LocalDate localDate) {
        if (qtScheme.isRuleEngine()) {
            RuleParam ruleParam = new RuleParam(RuleEngineEnum.qt.getSceneNumber(), RuleEngineEnum.qt.getBizApp(), qtScheme.getId());
            List<PolicyResult> policyResults = RuleEngineService.callQtRuleEngine(ruleParam, context, localDate, null);
            logger.debug("\u5339\u914d\u7684\u89c4\u5219\u5f15\u64ce\u7ed3\u679c{}", policyResults);
            String qtRuleTag = "wtp_qtrule";
            Set<Long> ids = RuleEngineService.getRuleIdsByTag(policyResults, qtRuleTag);
            RuleEngineMetaData ruleEngineMetaData = (RuleEngineMetaData)context.getInitParam("RULE_ENGINE");
            if (CollectionUtils.isEmpty(ids)) {
                logger.info("qtrule is empty");
                return null;
            }
            List collect = ids.stream().map(id -> (QTRule)((TimeSeqBo)ruleEngineMetaData.getBizRuleById((Long)id)).getVersionByDate(localDate)).filter(Objects::nonNull).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                logger.info("qtrulepackage is empty");
                throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u65f6\u95f4\u8303\u56f4\u5185\uff0c\u8003\u52e4\u6863\u6848\u4e2d\u7684\u5b9a\u989d\u65b9\u6848\u4e0b\u89c4\u5219\u5f15\u64ce\u7684\u89c4\u5219\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u5b9a\u989d\u65b9\u6848\u4e2d\u89c4\u5219\u5f15\u64ce\u76f8\u5173\u914d\u7f6e\u3002", (String)"QuotaRuleConfigUtils_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            if (collect.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b9a\u989d\u65b9\u6848\u91cc\u7684\u89c4\u5219\u5f15\u64ce\u53ea\u80fd\u914d\u7f6e\u4e00\u4e2a\u89c4\u5219\u8fd4\u56de\u3002", (String)"QTStandardDurationEvaluator_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
            }
            return (QTRule)collect.get(0);
        }
        if (null == qtScheme.getQtRule()) {
            logger.info("qtScheme_rule is empty,qtScheme_number={}", (Object)qtScheme.getNumber());
            return null;
        }
        return (QTRule)qtScheme.getQtRule().getVersionByDate(localDate);
    }
}

