/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.validator;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.quota.model.QuotaCycInfo;
import kd.wtc.wtes.business.quota.validator.AbstractQuotaLineValidator;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttQuotaTypeCircleValidator
extends AbstractQuotaLineValidator {
    private final Log log = LogFactory.getLog(AttQuotaTypeCircleValidator.class);

    @Override
    public void validate() {
        List hasCircleAttFileInfoList = this.attSubject.getAttFileInfoList().stream().filter(attFileInfo -> Boolean.TRUE.equals(attFileInfo.getLegal())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(hasCircleAttFileInfoList)) {
            return;
        }
        if (QTAccountModeHelper.isDeductChain((String)this.getQuotaRequest().getAccountMode())) {
            return;
        }
        for (AttFileInfo attFileInfo2 : hasCircleAttFileInfoList) {
            Date startDate = attFileInfo2.getStartDate();
            Date endDate = attFileInfo2.getEndDate();
            if (CollectionUtils.isEmpty(attFileInfo2.getTypeCircleMap())) {
                attFileInfo2.setLegal(Boolean.FALSE);
                attFileInfo2.setMessage(ResManager.loadKDString((String)"\u751f\u6210\u6709\u6548\u671f\u95f4\u4e0d\u5728\u6b64\u6b21\u6838\u7b97\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6838\u7b97\u65f6\u95f4\u6267\u884c\u5b9a\u989d\u6838\u7b97\u3002", (String)"AttQuotaTypeCircleValidator_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
                continue;
            }
            boolean boEmptyFlag = false;
            String errorMsg = "";
            for (Map.Entry<Long, QuotaCycInfo> mapEntry : attFileInfo2.getTypeCircleMap().entrySet()) {
                if (null == mapEntry.getValue() || CollectionUtils.isEmpty(mapEntry.getValue().getRestVos()) || StringUtils.isNotEmpty((CharSequence)mapEntry.getValue().getErrorMsg())) {
                    boEmptyFlag = true;
                    errorMsg = mapEntry.getValue().getErrorMsg();
                    continue;
                }
                List effectCircleRestVos = mapEntry.getValue().getRestVos().stream().filter(vo -> vo.getStartDate().compareTo(endDate) <= 0 && vo.getEndDate().compareTo(startDate) >= 0).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(effectCircleRestVos)) {
                    boEmptyFlag = true;
                    continue;
                }
                boEmptyFlag = false;
                break;
            }
            if (!boEmptyFlag) continue;
            attFileInfo2.setLegal(Boolean.FALSE);
            String errMsg = StringUtils.isNotEmpty((CharSequence)errorMsg) ? errorMsg : ResManager.loadKDString((String)"\u751f\u6210\u6709\u6548\u671f\u95f4\u5747\u4e0d\u5728\u6b64\u6b21\u6838\u7b97\u8303\u56f4\u5185\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6838\u7b97\u65f6\u95f4\u6267\u884c\u5b9a\u989d\u6838\u7b97\u3002", (String)"AttQuotaTypeCircleValidator_1", (String)"wtc-wtes-business", (Object[])new Object[0]);
            attFileInfo2.setMessage(errMsg);
        }
    }
}

