/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.quota.validator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.business.quota.validator.AbstractQuotaValidator;

public class QuotaValidatorExecutor {
    protected final Log log = LogFactory.getLog(QuotaValidatorExecutor.class);

    public void validateParams(QuotaRequest request, Map<String, Object> engineVariable, Map<String, Object> initParams) {
        this.doValidate(request, engineVariable, initParams, null, null, this.getParaValidators());
    }

    public void validateLine(QuotaRequest request, Map<String, Object> engineVariable, Map<String, Object> initParams, AttPersonRange attSubject, Map<String, Object> lineVariable) {
        this.doValidate(request, engineVariable, initParams, attSubject, lineVariable, this.getLineValidators());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidate(QuotaRequest request, Map<String, Object> engineVariable, Map<String, Object> initParams, AttPersonRange attSubject, Map<String, Object> lineVariable, List<AbstractQuotaValidator> validators) {
        for (AbstractQuotaValidator validator : validators) {
            validator.initValidator(request, engineVariable, initParams, attSubject, lineVariable);
            long startTime = System.nanoTime();
            try {
                validator.validate();
            }
            finally {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("#TIE# [validatorName {}] [Elapsed {}] #TIE#", (Object)validator.getClass().getName(), (Object)(System.nanoTime() - startTime));
            }
        }
    }

    private List<AbstractQuotaValidator> getParaValidators() {
        List<String> quotaParamBeanNames = this.getQuotaParamBeanNames("quota.init.paraValidators");
        return this.getValidators(quotaParamBeanNames, AbstractQuotaValidator.class);
    }

    private List<AbstractQuotaValidator> getLineValidators() {
        List<String> quotaParamBeanNames = this.getQuotaParamBeanNames("quota.init.lineValidators");
        return this.getValidators(quotaParamBeanNames, AbstractQuotaValidator.class);
    }

    private List<String> getQuotaParamBeanNames(String spQuotaInitInitialises) {
        Object initialises = WTCAppContextHelper.getProjectParams().get(spQuotaInitInitialises);
        if (initialises == null) {
            return Collections.emptyList();
        }
        return (List)initialises;
    }

    private List<AbstractQuotaValidator> getValidators(List<String> initialises, Class<AbstractQuotaValidator> quotaValidatorClass) {
        return initialises.stream().map(initializerBeanName -> (AbstractQuotaValidator)WTCAppContextHelper.getBean((String)initializerBeanName, (Class)quotaValidatorClass)).collect(Collectors.toList());
    }
}

