/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.ruleengine;

import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.hr.hbp.common.model.ruleengine.RuleEngineResponseUtils;
import kd.hr.hbp.common.model.ruleengine.RuleResult;
import kd.hr.hbp.common.model.ruleengine.SceneResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.common.enums.WTCRuleEngineSceneEnum;
import kd.sdk.wtc.wtes.business.qte.QteContextExt;
import kd.sdk.wtc.wtp.business.ruleengine.OnGenRuleEngineInputParamEvent;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.model.attendperson.EmpPosOrgRel;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.common.constants.ruleengine.RuleEngineConstants;
import kd.wtc.wtbs.common.lang.WTCBizException;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.attperiod.chain.TieAttPeriodContext;
import kd.wtc.wtes.business.core.VScope;
import kd.wtc.wtes.business.ext.core.chain.QteContextExtImpl;
import kd.wtc.wtes.business.ext.utils.ContextExtUtil;
import kd.wtc.wtes.business.ext.utils.TiePeriodContextExtUtil;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.RuleEngineEnum;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.access.ConditionDto;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.quota.model.QuotaExtPluginHolder;
import kd.wtc.wtes.business.quota.std.QuotaContextStd;
import kd.wtc.wtes.business.ruleengine.ArgumentWrapper;
import kd.wtc.wtes.business.ruleengine.RuleEngineConf;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.business.ruleengine.RuleParam;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.business.util.ValiteKDStringUtil;
import kd.wtc.wtes.common.lang.WtesBizException;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.CollectionUtils;

public class RuleEngineService {
    private static final Log logger = LogFactory.getLog(RuleEngineService.class);
    private static final String BIZ_APP = "bizApp";
    private static final String SCENE_NUMBER = "sceneNumber";
    private static final String BU_NUMBER = "buNumber";
    private static final String EXECUTE_POLICY_IDS = "executePolicyIds";
    private static final String INPUT_PARAMS = "inputParams";
    private static final String RESPONSE_CODE_SUCCESS = "200";
    private static final String RESULT_MAP = "RESULT_MAP";
    private static final String WTP_ATTFILE = "wtp_attfilebase";
    private static final String WTP_ATTPERSON = "wtp_attendperson";
    private static final String WTP_DEPEMPJOB = "wtp_depempjob";
    private static final Map<String, String> modelNameMap = Maps.newHashMapWithExpectedSize((int)10);
    private static final Map<String, Map<String, Function<Object, Object>>> map = Maps.newHashMapWithExpectedSize((int)10);
    private static final Map<String, Function<Object, Object>> attfileMap = Maps.newHashMapWithExpectedSize((int)10);
    private static final Map<String, Function<Object, Object>> attpersonMap = Maps.newHashMapWithExpectedSize((int)10);
    private static final Map<String, Function<Object, Object>> empJobMap = Maps.newHashMapWithExpectedSize((int)10);

    private RuleEngineService() {
    }

    private static EmpPosOrgRel getDepemp(ArgumentWrapper ele) {
        return ele.attendPersonModel.getEmpPosOrgRel();
    }

    private static DynamicObject getDynamicObject(Long id, String modelName) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)modelName));
        dynamicObject.set("id", (Object)id);
        return dynamicObject;
    }

    public static List<PolicyResult> callRuleEngine(RuleParam ruleParam, TieContextStd context) {
        SceneResult sceneResult;
        logger.debug("callRuleEngine start");
        RuleEngineConf ruleEngineConf = RuleEngineService.getConfig(ruleParam, context);
        if (null == ruleEngineConf) {
            if (!HRStringUtils.isEmpty((String)ruleParam.getScenePlanName())) {
                throw new WtesException(ValiteKDStringUtil.noRuleEngine(ruleParam.getScenePlanName()));
            }
            throw new WtesException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u65b9\u6848\u7248\u672cid[{0}]\u5bf9\u5e94\u7684\u89c4\u5219\u5f15\u64ce\u914d\u7f6e\u3002", (String)"RuleEngineService_0", (String)"wtc-wtes-business", (Object[])new Object[]{ruleParam.getPlanVersionId()}));
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put(BIZ_APP, ruleParam.getBizApp());
        requestMap.put(SCENE_NUMBER, ruleParam.getSceneNumber());
        ruleParam.setInputParaMap(RuleEngineService.getInputParaMap(ruleEngineConf, context, ruleParam));
        requestMap.put(BU_NUMBER, ruleEngineConf.getBuNumber());
        requestMap.put(EXECUTE_POLICY_IDS, Collections.singletonList(ruleEngineConf.getStrategyId()));
        requestMap.put(INPUT_PARAMS, ruleParam.getInputParaMap());
        List resultList = RuleEngineService.getRuleIdFromCache(ruleParam, context);
        if (resultList != null) {
            logger.debug("ruleParam = {}", requestMap);
            logger.debug("resultList = {}", resultList);
            return resultList;
        }
        logger.debug("ruleParam = {}", requestMap);
        try {
            Map responseMap = (Map)WTCServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{requestMap});
            sceneResult = RuleEngineResponseUtils.transferToSceneResult((Map)responseMap);
        }
        catch (Exception ex) {
            logger.warn("callRuleEngine error ", (Throwable)ex);
            throw new WtesException((Throwable)ex);
        }
        logger.debug("sceneResult = {}", (Object)sceneResult);
        if (!RESPONSE_CODE_SUCCESS.equals(sceneResult.getResponseCode())) {
            throw new WtesException(sceneResult.getErrorMsg());
        }
        resultList = sceneResult.getPolicyResults();
        RuleEngineService.cacheResult(context, ruleParam, (List<PolicyResult>)resultList);
        logger.debug("callRuleEngine end");
        return resultList;
    }

    public static List<PolicyResult> callQtRuleEngine(RuleParam ruleParam, QuotaContextStd context, LocalDate chainDate, Long fileBoId) {
        SceneResult sceneResult;
        logger.debug("callRuleEngine start");
        RuleEngineMetaData ruleEngineMetaData = null;
        if (context != null) {
            ruleEngineMetaData = (RuleEngineMetaData)context.getInitParam("RULE_ENGINE");
        } else {
            Map<String, Object> initParams = ruleParam.getInitParams();
            if (initParams != null) {
                ruleEngineMetaData = (RuleEngineMetaData)initParams.get("RULE_ENGINE");
            }
        }
        if (ruleEngineMetaData == null) {
            logger.warn("ruleEngineMetaData is null");
            return Collections.emptyList();
        }
        RuleEngineConf ruleEngineConf = ruleEngineMetaData.getRuleEngineConfByPlanId(ruleParam.getPlanVersionId());
        if (null == ruleEngineConf) {
            if (!HRStringUtils.isEmpty((String)ruleParam.getScenePlanName())) {
                throw new WtesException(ValiteKDStringUtil.noRuleEngine(ruleParam.getScenePlanName()));
            }
            throw new WTCBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u65b9\u6848\u7248\u672cid[{0}]\u5bf9\u5e94\u7684\u89c4\u5219\u5f15\u64ce\u914d\u7f6e\u3002", (String)"RuleEngineService_0", (String)"wtc-wtes-business", (Object[])new Object[]{ruleParam.getPlanVersionId()}));
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put(BIZ_APP, ruleParam.getBizApp());
        requestMap.put(SCENE_NUMBER, ruleParam.getSceneNumber());
        ruleParam.setInputParaMap(RuleEngineService.getInputParaMap(ruleEngineConf, context, ruleParam, chainDate, fileBoId));
        requestMap.put(BU_NUMBER, ruleEngineConf.getBuNumber());
        requestMap.put(EXECUTE_POLICY_IDS, Collections.singletonList(ruleEngineConf.getStrategyId()));
        requestMap.put(INPUT_PARAMS, ruleParam.getInputParaMap());
        Map cacheMap = null;
        if (context != null) {
            cacheMap = (Map)context.getVariable(RESULT_MAP, VScope.ENGINE);
        }
        ArrayList<PolicyResult> resultList = new ArrayList(16);
        if (cacheMap != null && (resultList = (List)cacheMap.get(ruleParam)) != null) {
            logger.debug("ruleParam = {}", requestMap);
            logger.debug("resultList = {}", resultList);
            return resultList;
        }
        logger.debug("ruleParam = {}", requestMap);
        try {
            Map responseMap = (Map)WTCServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{requestMap});
            sceneResult = RuleEngineResponseUtils.transferToSceneResult((Map)responseMap);
        }
        catch (Exception ex) {
            logger.warn("callRuleEngine error ", (Throwable)ex);
            throw new WtesException((Throwable)ex);
        }
        logger.debug("sceneResult = {}", (Object)sceneResult);
        if (!RESPONSE_CODE_SUCCESS.equals(sceneResult.getResponseCode())) {
            throw new WtesException(sceneResult.getErrorMsg());
        }
        resultList = sceneResult.getPolicyResults();
        RuleEngineService.cacheResult(context, ruleParam, resultList);
        logger.debug("callRuleEngine end");
        return resultList;
    }

    private static RuleEngineConf getConfig(RuleParam ruleParam, TieContextStd context) {
        RuleEngineConf ruleEngineConf = null;
        if (context != null) {
            RuleEngineMetaData ruleEngineMetaData = ContextUtil.getRuleEngineMetaData(context);
            ruleEngineConf = ruleEngineMetaData.getRuleEngineConfByPlanId(ruleParam.getPlanVersionId());
        } else {
            Map<String, Object> initParams = ruleParam.getInitParams();
            if (initParams != null) {
                RuleEngineMetaData ruleEngineMetaData = (RuleEngineMetaData)initParams.get("RULE_ENGINE");
                ruleEngineConf = ruleEngineMetaData.getRuleEngineConfByPlanId(ruleParam.getPlanVersionId());
            } else {
                logger.warn("initParams is null");
            }
        }
        return ruleEngineConf;
    }

    public static List<PolicyResult> callRuleEngine(RuleParam ruleParam, TieAttPeriodContext tieAttPeriodContext, PerAttPeriod perAttPeriod) {
        SceneResult sceneResult;
        logger.debug("callRuleEngine start");
        RuleEngineMetaData ruleEngineMetaData = tieAttPeriodContext.getRuleEngineMetaData();
        RuleEngineConf ruleEngineConf = ruleEngineMetaData.getRuleEngineConfByPlanId(ruleParam.getPlanVersionId());
        if (null == ruleEngineConf) {
            throw new WTCBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u65b9\u6848\u7248\u672cid[{0}]\u5bf9\u5e94\u7684\u89c4\u5219\u5f15\u64ce\u914d\u7f6e\u3002", (String)"RuleEngineService_0", (String)"wtc-wtes-business", (Object[])new Object[]{ruleParam.getPlanVersionId()}));
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put(BIZ_APP, ruleParam.getBizApp());
        requestMap.put(SCENE_NUMBER, ruleParam.getSceneNumber());
        ruleParam.setInputParaMap(RuleEngineService.getInputParaMap(ruleEngineConf, ruleParam, tieAttPeriodContext, perAttPeriod));
        requestMap.put(BU_NUMBER, ruleEngineConf.getBuNumber());
        requestMap.put(EXECUTE_POLICY_IDS, Collections.singletonList(ruleEngineConf.getStrategyId()));
        requestMap.put(INPUT_PARAMS, ruleParam.getInputParaMap());
        logger.debug("ruleParam = {}", requestMap);
        try {
            Map responseMap = (Map)WTCServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{requestMap});
            sceneResult = RuleEngineResponseUtils.transferToSceneResult((Map)responseMap);
        }
        catch (Exception ex) {
            logger.warn("callRuleEngine error ", (Throwable)ex);
            throw new WtesException((Throwable)ex);
        }
        logger.debug("sceneResult = {}", (Object)sceneResult);
        if (!RESPONSE_CODE_SUCCESS.equals(sceneResult.getResponseCode())) {
            throw new WtesException(sceneResult.getErrorMsg());
        }
        List resultList = sceneResult.getPolicyResults();
        logger.debug("callRuleEngine end");
        return resultList;
    }

    private static Map<String, Object> getInputParaMap(RuleEngineConf ruleEngineConf, TieContextStd context, RuleParam ruleParam) {
        HashMap<String, Object> inputParaMap = new HashMap<String, Object>(16);
        List<AccessDto> filterConditionDtoList = ruleEngineConf.getFilterConditionDtoList();
        HashMap dynamicObjectMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap hashCodeMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet<String> extendKeys = new HashSet<String>(4);
        boolean extendFlag = false;
        for (AccessDto filterCondition : filterConditionDtoList) {
            List<ConditionDto> conditionList = filterCondition.getConditionList();
            RuleEngineService.checkConditionList(ruleParam, conditionList);
            for (ConditionDto conditionDto : conditionList) {
                Function<Object, Object> field;
                String param = conditionDto.getParam();
                String paramType = conditionDto.getParamType();
                String[] split = param.split("\\.");
                if (split.length < 3 && null == WTCRuleEngineSceneEnum.getPlanEnumByNumber((String)ruleParam.getSceneNumber())) {
                    throw new WtesBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\u3002", (String)"RuleEngineService_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
                }
                if (split.length < 3 && null != WTCRuleEngineSceneEnum.getPlanEnumByNumber((String)ruleParam.getSceneNumber())) {
                    extendFlag = true;
                    extendKeys.add(split[0]);
                    continue;
                }
                String identify = split[0];
                if (!RuleEngineConstants.INPUT_PARAM_IDENTIFY_SET.contains(identify)) {
                    extendFlag = true;
                    extendKeys.add(split.length < 3 ? split[0] : split[0] + "." + split[2]);
                    continue;
                }
                String modelName = split[1];
                String fieldName = split[2];
                Map<String, Function<Object, Object>> functionMap = map.get(modelName);
                DynamicObject mainDynamicObject = (DynamicObject)dynamicObjectMap.get(identify);
                if (null == mainDynamicObject) {
                    mainDynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)modelName));
                    dynamicObjectMap.put(identify, mainDynamicObject);
                }
                if (HRObjectUtils.isEmpty(field = functionMap.get(fieldName))) {
                    extendFlag = true;
                    extendKeys.add(split[0] + "." + split[2]);
                    continue;
                }
                Object value = functionMap.get(fieldName).apply(RuleEngineService.getModelByName(context, modelName, ruleParam));
                if ("dynamicObject".equals(paramType)) {
                    mainDynamicObject.set(fieldName, (Object)RuleEngineService.getDynamicObject((Long)value, modelNameMap.get(fieldName)));
                } else {
                    mainDynamicObject.set(fieldName, value);
                }
                hashCodeMap.put(identify + fieldName, String.valueOf(value));
                inputParaMap.put(identify, mainDynamicObject);
            }
        }
        if (extendFlag) {
            RuleEngineService.genInputParamExtend(inputParaMap, hashCodeMap, ruleParam, context, extendKeys);
        }
        ruleParam.setInputParaMapHashCode(hashCodeMap.hashCode());
        return inputParaMap;
    }

    private static void checkConditionList(RuleParam ruleParam, List<ConditionDto> conditionList) {
        if (conditionList == null || conditionList.isEmpty()) {
            if (!HRStringUtils.isEmpty((String)ruleParam.getScenePlanName())) {
                throw new WtesException(ResManager.loadKDString((String)"\u8be5\u8003\u52e4\u6863\u6848\u4e0b\u89c4\u5219\u5f15\u64ce\u4e3a\u201c{0}\u201d\u4e2d\u7684\u89c4\u5219\u7f3a\u5931\u6216\u4e0d\u5b8c\u5584\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"RuleEngineService_5", (String)"wtc-wtes-business", (Object[])new Object[]{ruleParam.getScenePlanName()}));
            }
            throw new WtesException(ResManager.loadKDString((String)"\u8be5\u8003\u52e4\u6863\u6848\u4e0b\u89c4\u5219\u65b9\u6848\u7248\u672cID\u4e3a\u201c{0}\u201d\u7684\u89c4\u5219\u5f15\u64ce\u4e0b\u7684\u89c4\u5219\u7f3a\u5931\u6216\u4e0d\u5b8c\u5584\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"RuleEngineService_4", (String)"wtc-wtes-business", (Object[])new Object[]{ruleParam.getPlanVersionId()}));
        }
    }

    private static void genInputParamExtend(Map<String, Object> inputParaMap, Map<String, String> hashCodeMap, RuleParam ruleParam, TieContextStd context, Set<String> extendKeys) {
        if (null == context) {
            return;
        }
        if (null == WTCRuleEngineSceneEnum.getPlanEnumByNumber((String)ruleParam.getSceneNumber())) {
            return;
        }
        WTCPluginProxy inputParamExtPlugin = (WTCPluginProxy)ContextExtUtil.getExtPlugin(context, "kd.sdk.wtc.wtp.business.ruleengine.RuleEngineInputParamExtPlugin");
        if (inputParamExtPlugin == null || !inputParamExtPlugin.hasPlugin()) {
            if (logger.isWarnEnabled()) {
                logger.warn("RuleEngineInputParamExtPlugin,\u672a\u5b9e\u73b0\u6269\u5c55\u7c7b\u3002");
            }
            return;
        }
        RuleEngineService.genInputParamFullProperties(inputParaMap, context, ruleParam);
        HashMap<String, Object> extendMap = new HashMap<String, Object>(extendKeys.size());
        for (String extendKey : extendKeys) {
            extendMap.put(extendKey, null);
        }
        OnGenRuleEngineInputParamEvent param = new OnGenRuleEngineInputParamEvent(WTCDateUtils.toDate((LocalDate)context.getChainDate()), ruleParam.getSceneNumber(), ruleParam.getPlanVersionId().longValue(), inputParaMap, extendKeys, extendMap, ContextExtUtil.getTieContextExt(context));
        inputParamExtPlugin.invokeReplace(extPlugin -> {
            if (logger.isDebugEnabled()) {
                logger.debug("RuleEngineInputParamExtPlugin,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)extPlugin.getClass().getName());
            }
            extPlugin.onGenInputParam(param);
        });
        for (Map.Entry entry : param.getExtendMap().entrySet()) {
            if (extendKeys.contains(entry.getKey())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6269\u5c55\u5165\u53c2\u5b57\u6bb5\u201c{0}\u201d\u8d85\u51fa\u89c4\u5219\u5f15\u64ce\u6269\u5c55\u5b57\u6bb5\u9650\u5236\u3002", (String)"RuleEngineService_1", (String)"wtc-wtes-business", (Object[])new Object[]{entry.getKey()}));
        }
        for (Map.Entry entry : param.getExtendMap().entrySet()) {
            hashCodeMap.put((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
    }

    private static void genInputParamFullProperties(Map<String, Object> inputParaMap, TieContextStd context, RuleParam ruleParam) {
        DynamicObject attFileDy = (DynamicObject)inputParaMap.get(WTP_ATTFILE);
        if (null == attFileDy) {
            attFileDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)WTP_ATTFILE));
            inputParaMap.put(WTP_ATTFILE, attFileDy);
        }
        ArgumentWrapper attFileWrapper = (ArgumentWrapper)RuleEngineService.getModelByName(context, WTP_ATTFILE, ruleParam);
        Map<String, Function<Object, Object>> attFileFunctionMap = map.get(WTP_ATTFILE);
        for (String fieldName : RuleEngineConstants.INPUT_PARAM_ATTFILE_SET) {
            Object value = attFileFunctionMap.get(fieldName).apply(attFileWrapper);
            if (HRObjectUtils.isEmpty((Object)modelNameMap.get(fieldName))) {
                attFileDy.set(fieldName, value);
                continue;
            }
            attFileDy.set(fieldName, (Object)RuleEngineService.getDynamicObject((Long)value, modelNameMap.get(fieldName)));
        }
        DynamicObject attPersonDy = (DynamicObject)inputParaMap.get(WTP_ATTPERSON);
        if (null == attPersonDy) {
            attPersonDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)WTP_ATTPERSON));
            inputParaMap.put(WTP_ATTPERSON, attPersonDy);
        }
        AttendPersonModel personModel = (AttendPersonModel)RuleEngineService.getModelByName(context, WTP_ATTPERSON, ruleParam);
        Map<String, Function<Object, Object>> personFunctionMap = map.get(WTP_ATTPERSON);
        for (String fieldName : RuleEngineConstants.INPUT_PARAM_ATTERSON_SET) {
            Object value = personFunctionMap.get(fieldName).apply(personModel);
            if (HRObjectUtils.isEmpty((Object)modelNameMap.get(fieldName))) {
                attPersonDy.set(fieldName, value);
                continue;
            }
            attPersonDy.set(fieldName, (Object)RuleEngineService.getDynamicObject((Long)value, modelNameMap.get(fieldName)));
        }
        DynamicObject depEmpDy = (DynamicObject)inputParaMap.get(WTP_DEPEMPJOB);
        if (null == depEmpDy) {
            depEmpDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)WTP_DEPEMPJOB));
            inputParaMap.put(WTP_DEPEMPJOB, depEmpDy);
        }
        ArgumentWrapper depEmpWrapper = (ArgumentWrapper)RuleEngineService.getModelByName(context, WTP_DEPEMPJOB, ruleParam);
        Map<String, Function<Object, Object>> depEmpFunctionMap = map.get(WTP_DEPEMPJOB);
        for (String fieldName : RuleEngineConstants.INPUT_PARAM_EMPJOB_SET) {
            Object value = depEmpFunctionMap.get(fieldName).apply(depEmpWrapper);
            if (HRObjectUtils.isEmpty((Object)modelNameMap.get(fieldName))) {
                depEmpDy.set(fieldName, value);
                continue;
            }
            depEmpDy.set(fieldName, (Object)RuleEngineService.getDynamicObject((Long)value, modelNameMap.get(fieldName)));
        }
    }

    private static void genInputParamFullProperties(Map<String, Object> inputParaMap, TieAttPeriodContext periodContext, PerAttPeriod perAttPeriod) {
        DynamicObject attFileDy = (DynamicObject)inputParaMap.get(WTP_ATTFILE);
        if (null == attFileDy) {
            attFileDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)WTP_ATTFILE));
            inputParaMap.put(WTP_ATTFILE, attFileDy);
        }
        ArgumentWrapper attFileWrapper = (ArgumentWrapper)RuleEngineService.getModelByName(periodContext, WTP_ATTFILE, perAttPeriod);
        Map<String, Function<Object, Object>> attFileFunctionMap = map.get(WTP_ATTFILE);
        for (String fieldName : RuleEngineConstants.INPUT_PARAM_ATTFILE_SET) {
            Object value = attFileFunctionMap.get(fieldName).apply(attFileWrapper);
            if (HRObjectUtils.isEmpty((Object)modelNameMap.get(fieldName))) {
                attFileDy.set(fieldName, value);
                continue;
            }
            attFileDy.set(fieldName, (Object)RuleEngineService.getDynamicObject((Long)value, modelNameMap.get(fieldName)));
        }
        DynamicObject attPersonDy = (DynamicObject)inputParaMap.get(WTP_ATTPERSON);
        if (null == attPersonDy) {
            attPersonDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)WTP_ATTPERSON));
            inputParaMap.put(WTP_ATTPERSON, attPersonDy);
        }
        AttendPersonModel personModel = (AttendPersonModel)RuleEngineService.getModelByName(periodContext, WTP_ATTPERSON, perAttPeriod);
        Map<String, Function<Object, Object>> personFunctionMap = map.get(WTP_ATTPERSON);
        for (String fieldName : RuleEngineConstants.INPUT_PARAM_ATTERSON_SET) {
            Object value = personFunctionMap.get(fieldName).apply(personModel);
            if (HRObjectUtils.isEmpty((Object)modelNameMap.get(fieldName))) {
                attPersonDy.set(fieldName, value);
                continue;
            }
            attPersonDy.set(fieldName, (Object)RuleEngineService.getDynamicObject((Long)value, modelNameMap.get(fieldName)));
        }
        DynamicObject depEmpDy = (DynamicObject)inputParaMap.get(WTP_DEPEMPJOB);
        if (null == depEmpDy) {
            depEmpDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)WTP_DEPEMPJOB));
            inputParaMap.put(WTP_DEPEMPJOB, depEmpDy);
        }
        ArgumentWrapper depEmpWrapper = (ArgumentWrapper)RuleEngineService.getModelByName(periodContext, WTP_DEPEMPJOB, perAttPeriod);
        Map<String, Function<Object, Object>> depEmpFunctionMap = map.get(WTP_DEPEMPJOB);
        for (String fieldName : RuleEngineConstants.INPUT_PARAM_EMPJOB_SET) {
            Object value = depEmpFunctionMap.get(fieldName).apply(depEmpWrapper);
            if (HRObjectUtils.isEmpty((Object)modelNameMap.get(fieldName))) {
                depEmpDy.set(fieldName, value);
                continue;
            }
            depEmpDy.set(fieldName, (Object)RuleEngineService.getDynamicObject((Long)value, modelNameMap.get(fieldName)));
        }
    }

    private static void genInputParamExtend(Map<String, Object> inputParaMap, Map<String, String> hashCodeMap, RuleParam ruleParam, QuotaContextStd context, Set<String> extendKeys, Long fileBoId) {
        if (!RuleEngineEnum.qt.getSceneNumber().equals(ruleParam.getSceneNumber())) {
            return;
        }
        QuotaExtPluginHolder extPluginMap = context == null ? (QuotaExtPluginHolder)ruleParam.getInitParams().get("QT_EXT_PLUGIN") : (QuotaExtPluginHolder)context.getInitParam("QT_EXT_PLUGIN");
        WTCPluginProxy inputParamExtPlugin = (WTCPluginProxy)extPluginMap.getPlugin("kd.sdk.wtc.wtp.business.ruleengine.RuleEngineInputParamExtPlugin");
        if (inputParamExtPlugin == null || !inputParamExtPlugin.hasPlugin()) {
            if (logger.isWarnEnabled()) {
                logger.warn("RuleEngineInputParamExtPlugin,\u672a\u5b9e\u73b0\u6269\u5c55\u7c7b\u3002");
            }
            return;
        }
        RuleEngineService.genInputParamFullProperties(inputParaMap, context, ruleParam);
        HashMap<String, Object> extendMap = new HashMap<String, Object>(extendKeys.size());
        for (String extendKey : extendKeys) {
            extendMap.put(extendKey, null);
        }
        QteContextExtImpl quotaContextStd = new QteContextExtImpl(context, ruleParam, fileBoId);
        LocalDate chainDate = context != null ? context.getChainDate() : ruleParam.getChainDate();
        OnGenRuleEngineInputParamEvent param = new OnGenRuleEngineInputParamEvent(WTCDateUtils.toDate((LocalDate)chainDate), ruleParam.getSceneNumber(), ruleParam.getPlanVersionId().longValue(), inputParaMap, extendKeys, extendMap, (QteContextExt)quotaContextStd);
        inputParamExtPlugin.invokeReplace(extPlugin -> {
            if (logger.isDebugEnabled()) {
                logger.debug("RuleEngineInputParamExtPlugin,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)extPlugin.getClass().getName());
            }
            extPlugin.onGenInputParam(param);
        });
        for (Map.Entry entry : param.getExtendMap().entrySet()) {
            if (extendKeys.contains(entry.getKey())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6269\u5c55\u5165\u53c2\u5b57\u6bb5\u201c{0}\u201d\u8d85\u51fa\u89c4\u5219\u5f15\u64ce\u6269\u5c55\u5b57\u6bb5\u9650\u5236\u3002", (String)"RuleEngineService_1", (String)"wtc-wtes-business", (Object[])new Object[]{entry.getKey()}));
        }
        for (Map.Entry entry : param.getExtendMap().entrySet()) {
            hashCodeMap.put((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
    }

    private static void genInputParamFullProperties(Map<String, Object> inputParaMap, QuotaContextStd context, RuleParam ruleParam) {
        Object attJobObj;
        DynamicObject depEmpDy;
        Object attPersonObj;
        DynamicObject attPersonDy;
        LocalDate chainDate;
        Object attFileObj;
        DynamicObject attFileDy = (DynamicObject)inputParaMap.get(WTP_ATTFILE);
        if (null == attFileDy) {
            attFileDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)WTP_ATTFILE));
            inputParaMap.put(WTP_ATTFILE, attFileDy);
        }
        if ((attFileObj = RuleEngineService.getModelByName(context, WTP_ATTFILE, chainDate = context != null ? context.getChainDate() : ruleParam.getChainDate(), ruleParam)) != null) {
            ArgumentWrapper attFileWrapper = (ArgumentWrapper)attFileObj;
            Map<String, Function<Object, Object>> attFileFunctionMap = map.get(WTP_ATTFILE);
            for (String fieldName : RuleEngineConstants.INPUT_PARAM_ATTFILE_SET) {
                Object value = null;
                try {
                    value = attFileFunctionMap.get(fieldName).apply(attFileWrapper);
                }
                catch (Exception ex) {
                    logger.warn("genInputParamFullProperties get attFileBase={}  filed={} value error ", new Object[]{attFileWrapper.attFileModel.getNumber(), fieldName, ex});
                }
                if (HRObjectUtils.isEmpty((Object)modelNameMap.get(fieldName))) {
                    attFileDy.set(fieldName, value);
                    continue;
                }
                attFileDy.set(fieldName, (Object)RuleEngineService.getDynamicObject((Long)value, modelNameMap.get(fieldName)));
            }
        }
        if (null == (attPersonDy = (DynamicObject)inputParaMap.get(WTP_ATTPERSON))) {
            attPersonDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)WTP_ATTPERSON));
            inputParaMap.put(WTP_ATTPERSON, attPersonDy);
        }
        if ((attPersonObj = RuleEngineService.getModelByName(context, WTP_ATTPERSON, chainDate, ruleParam)) != null) {
            AttendPersonModel personModel = (AttendPersonModel)attPersonObj;
            Map<String, Function<Object, Object>> personFunctionMap = map.get(WTP_ATTPERSON);
            for (String fieldName : RuleEngineConstants.INPUT_PARAM_ATTERSON_SET) {
                Object value = null;
                try {
                    value = personFunctionMap.get(fieldName).apply(personModel);
                }
                catch (Exception ex) {
                    logger.warn("genInputParamFullProperties get peronModel={} filed={} value error ", new Object[]{personModel.getPerson().getNumber(), fieldName, ex});
                }
                if (HRObjectUtils.isEmpty((Object)modelNameMap.get(fieldName))) {
                    attPersonDy.set(fieldName, value);
                    continue;
                }
                attPersonDy.set(fieldName, (Object)RuleEngineService.getDynamicObject((Long)value, modelNameMap.get(fieldName)));
            }
        }
        if (null == (depEmpDy = (DynamicObject)inputParaMap.get(WTP_DEPEMPJOB))) {
            depEmpDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)WTP_DEPEMPJOB));
            inputParaMap.put(WTP_DEPEMPJOB, depEmpDy);
        }
        if ((attJobObj = RuleEngineService.getModelByName(context, WTP_DEPEMPJOB, chainDate, ruleParam)) != null) {
            ArgumentWrapper depEmpWrapper = (ArgumentWrapper)attJobObj;
            Map<String, Function<Object, Object>> depEmpFunctionMap = map.get(WTP_DEPEMPJOB);
            for (String fieldName : RuleEngineConstants.INPUT_PARAM_EMPJOB_SET) {
                Object value = null;
                try {
                    value = depEmpFunctionMap.get(fieldName).apply(depEmpWrapper);
                }
                catch (Exception ex) {
                    logger.warn("genInputParamFullProperties depEmp filed={} value error ", (Object)fieldName, (Object)ex);
                }
                if (HRObjectUtils.isEmpty((Object)modelNameMap.get(fieldName))) {
                    depEmpDy.set(fieldName, value);
                    continue;
                }
                depEmpDy.set(fieldName, (Object)RuleEngineService.getDynamicObject((Long)value, modelNameMap.get(fieldName)));
            }
        }
    }

    private static Map<String, Object> getInputParaMap(RuleEngineConf ruleEngineConf, QuotaContextStd context, RuleParam ruleParam, LocalDate chainDate, Long fileBoId) {
        HashMap<String, Object> inputParaMap = new HashMap<String, Object>(16);
        List<AccessDto> filterConditionDtoList = ruleEngineConf.getFilterConditionDtoList();
        HashMap dynamicObjectMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap hashCodeMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet<String> extendKeys = new HashSet<String>(4);
        boolean extendFlag = false;
        for (AccessDto filterCondition : filterConditionDtoList) {
            List<ConditionDto> conditionList = filterCondition.getConditionList();
            RuleEngineService.checkConditionList(ruleParam, conditionList);
            for (ConditionDto conditionDto : conditionList) {
                Function<Object, Object> field;
                String param = conditionDto.getParam();
                String paramType = conditionDto.getParamType();
                String[] split = param.split("\\.");
                if (split.length < 3 && !RuleEngineEnum.qt.getSceneNumber().equals(ruleParam.getSceneNumber())) {
                    throw new WtesBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\u3002", (String)"RuleEngineService_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
                }
                if (split.length < 3 && RuleEngineEnum.qt.getSceneNumber().equals(ruleParam.getSceneNumber())) {
                    extendFlag = true;
                    extendKeys.add(split[0]);
                    continue;
                }
                String identify = split[0];
                if (!RuleEngineConstants.INPUT_PARAM_IDENTIFY_SET.contains(identify)) {
                    extendFlag = true;
                    extendKeys.add(split.length < 3 ? split[0] : split[0] + "." + split[2]);
                    continue;
                }
                String modelName = split[1];
                String fieldName = split[2];
                Map<String, Function<Object, Object>> functionMap = map.get(modelName);
                DynamicObject mainDynamicObject = (DynamicObject)dynamicObjectMap.get(identify);
                if (null == mainDynamicObject) {
                    mainDynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)modelName));
                    dynamicObjectMap.put(identify, mainDynamicObject);
                }
                if (HRObjectUtils.isEmpty(field = functionMap.get(fieldName))) {
                    extendFlag = true;
                    extendKeys.add(split[0] + "." + split[2]);
                    continue;
                }
                Object value = functionMap.get(fieldName).apply(RuleEngineService.getModelByName(context, modelName, chainDate, ruleParam));
                if ("dynamicObject".equals(paramType)) {
                    mainDynamicObject.set(fieldName, (Object)RuleEngineService.getDynamicObject((Long)value, modelNameMap.get(fieldName)));
                } else {
                    mainDynamicObject.set(fieldName, value);
                }
                hashCodeMap.put(identify + fieldName, String.valueOf(value));
                inputParaMap.put(identify, mainDynamicObject);
            }
        }
        if (extendFlag) {
            RuleEngineService.genInputParamExtend(inputParaMap, hashCodeMap, ruleParam, context, extendKeys, fileBoId);
        }
        ruleParam.setInputParaMapHashCode(hashCodeMap.hashCode());
        return inputParaMap;
    }

    private static Map<String, Object> getInputParaMap(RuleEngineConf ruleEngineConf, RuleParam ruleParam, TieAttPeriodContext tieAttPeriodContext, PerAttPeriod perAttPeriod) {
        HashMap hashCodeMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet<String> extendKeys = new HashSet<String>(4);
        boolean extendFlag = false;
        HashMap<String, Object> inputParaMap = new HashMap<String, Object>(16);
        List<AccessDto> filterConditionDtoList = ruleEngineConf.getFilterConditionDtoList();
        HashMap dynamicObjectMap = Maps.newHashMapWithExpectedSize((int)16);
        for (AccessDto filterCondition : filterConditionDtoList) {
            List<ConditionDto> conditionList = filterCondition.getConditionList();
            RuleEngineService.checkConditionList(ruleParam, conditionList);
            for (ConditionDto conditionDto : conditionList) {
                Function<Object, Object> field;
                String param = conditionDto.getParam();
                String paramType = conditionDto.getParamType();
                String[] split = param.split("\\.");
                if (split.length < 3 && null == WTCRuleEngineSceneEnum.getPlanEnumByNumber((String)ruleParam.getSceneNumber())) {
                    throw new WtesBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u683c\u5f0f\u9519\u8bef\u3002", (String)"RuleEngineService_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
                }
                if (split.length < 3 && null != WTCRuleEngineSceneEnum.getPlanEnumByNumber((String)ruleParam.getSceneNumber())) {
                    extendFlag = true;
                    extendKeys.add(split[0]);
                    continue;
                }
                String identify = split[0];
                if (!RuleEngineConstants.INPUT_PARAM_IDENTIFY_SET.contains(identify)) {
                    extendFlag = true;
                    extendKeys.add(split.length < 3 ? split[0] : split[0] + "." + split[2]);
                    continue;
                }
                String modelName = split[1];
                String fieldName = split[2];
                Map<String, Function<Object, Object>> functionMap = map.get(modelName);
                DynamicObject mainDynamicObject = (DynamicObject)dynamicObjectMap.get(identify);
                if (null == mainDynamicObject) {
                    mainDynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)modelName));
                    dynamicObjectMap.put(identify, mainDynamicObject);
                }
                if (HRObjectUtils.isEmpty(field = functionMap.get(fieldName))) {
                    extendFlag = true;
                    extendKeys.add(split[0] + "." + split[2]);
                    continue;
                }
                Object value = functionMap.get(fieldName).apply(RuleEngineService.getModelByName(tieAttPeriodContext, modelName, perAttPeriod));
                if ("dynamicObject".equals(paramType)) {
                    mainDynamicObject.set(fieldName, (Object)RuleEngineService.getDynamicObject((Long)value, modelNameMap.get(fieldName)));
                } else {
                    mainDynamicObject.set(fieldName, value);
                }
                hashCodeMap.put(identify + fieldName, String.valueOf(value));
                inputParaMap.put(identify, mainDynamicObject);
            }
            if (!extendFlag) continue;
            RuleEngineService.genPeriodInputParamExtend(inputParaMap, hashCodeMap, ruleParam, tieAttPeriodContext, extendKeys, perAttPeriod);
        }
        return inputParaMap;
    }

    private static Object getModelByName(TieContextStd context, String modelName, RuleParam ruleParam) {
        AttendPersonData attendPersonData = context != null ? (AttendPersonData)((Object)context.getInitParam("ATT_PERINFO")) : (AttendPersonData)((Object)ruleParam.getInitParams().get("ATT_PERINFO"));
        long attPersonId = context != null ? context.getAttPersonId() : ruleParam.getPersonId().longValue();
        LocalDate chainDate = context != null ? context.getChainDate() : ruleParam.getChainDate();
        AttFileCabinet attFileCabinet = context != null ? (AttFileCabinet)context.getInitParam("ATT_FILE") : (AttFileCabinet)ruleParam.getInitParams().get("ATT_FILE");
        return RuleEngineService.getModelByName(attFileCabinet, attendPersonData, attPersonId, chainDate, modelName);
    }

    private static Object getModelByName(TieAttPeriodContext context, String modelName, PerAttPeriod perAttPeriod) {
        AttendPersonData attendPersonData = context.getAttendPersonData();
        if (null == attendPersonData) {
            return null;
        }
        long attPersonId = perAttPeriod.getPersonId();
        AttFileModel attFileModel = context.getAttFileModelById(attPersonId, perAttPeriod.getFileId());
        if (null == attFileModel) {
            return null;
        }
        LocalDate chainDate = context.getPeriodData(perAttPeriod, attFileModel);
        AttFileCabinet attFileCabinet = context.getAttFileCabinet();
        return RuleEngineService.getModelByName(attFileCabinet, attendPersonData, attPersonId, chainDate, modelName);
    }

    private static Object getModelByName(QuotaContextStd context, String modelName, LocalDate chainDate, RuleParam ruleParam) {
        AttFileCabinet attFileCabinet;
        long attPersonId;
        AttendPersonData attendPersonData;
        if (context != null) {
            attendPersonData = (AttendPersonData)((Object)context.getInitParam("ATT_PERINFO"));
            attPersonId = context.getAttPersonId();
            attFileCabinet = (AttFileCabinet)context.getInitParam("ATT_FILE");
        } else {
            attPersonId = ruleParam.getPersonId();
            attendPersonData = (AttendPersonData)((Object)ruleParam.getInitParams().get("ATT_PERINFO"));
            attFileCabinet = (AttFileCabinet)ruleParam.getInitParams().get("ATT_FILE");
        }
        return RuleEngineService.getModelByName(attFileCabinet, attendPersonData, attPersonId, chainDate, modelName);
    }

    private static Object getModelByName(AttFileCabinet attFileCabinet, AttendPersonData attendPersonData, long attPersonId, LocalDate chainDate, String modelName) {
        Object result = null;
        switch (modelName) {
            case "wtp_attfilebase": {
                AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(attPersonId, chainDate);
                result = new ArgumentWrapper(attFileModel, chainDate);
                logger.debug("wtp_attfilebaseData = {}", result);
                break;
            }
            case "wtp_attendperson": {
                AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(attPersonId, chainDate);
                result = attendPersonData.getByBidAndDate(attFileModel, chainDate);
                logger.debug("attendPersonData = {}", result);
                break;
            }
            case "wtp_depempjob": {
                AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(attPersonId, chainDate);
                result = new ArgumentWrapper(attFileModel, attendPersonData.getByBidAndDate(attFileModel, chainDate), chainDate);
                logger.debug("wtp_depempjobData = {}", result);
                break;
            }
        }
        return result;
    }

    private static List<PolicyResult> getRuleIdFromCache(RuleParam ruleParam, TieContextStd context) {
        if (context == null) {
            return null;
        }
        Map cacheMap = (Map)context.getVariable(RESULT_MAP, VScope.ENGINE);
        if (cacheMap == null) {
            return null;
        }
        return (List)cacheMap.get(ruleParam);
    }

    private static void cacheResult(TieContextStd context, RuleParam ruleParam, List<PolicyResult> resultList) {
        if (context == null) {
            return;
        }
        HashMap<RuleParam, List<PolicyResult>> cacheMap = (HashMap<RuleParam, List<PolicyResult>>)context.getVariable(RESULT_MAP, VScope.ENGINE);
        if (cacheMap == null) {
            cacheMap = new HashMap<RuleParam, List<PolicyResult>>(16);
        }
        cacheMap.put(ruleParam, resultList);
        context.setVariable(RESULT_MAP, cacheMap, VScope.ENGINE);
    }

    private static void cacheResult(QuotaContextStd context, RuleParam ruleParam, List<PolicyResult> resultList) {
        if (context == null) {
            return;
        }
        HashMap<RuleParam, List<PolicyResult>> cacheMap = (HashMap<RuleParam, List<PolicyResult>>)context.getVariable(RESULT_MAP, VScope.ENGINE);
        if (cacheMap == null) {
            cacheMap = new HashMap<RuleParam, List<PolicyResult>>(16);
        }
        cacheMap.put(ruleParam, resultList);
        context.setVariable(RESULT_MAP, cacheMap, VScope.ENGINE);
    }

    public static Map<String, Set<Long>> getRuleIds(List<PolicyResult> policyResults, List<String> ruleTags) {
        HashMap<String, Set<Long>> ruleIdMap = new HashMap<String, Set<Long>>(16);
        if (CollectionUtils.isEmpty(policyResults) || CollectionUtils.isEmpty(ruleTags)) {
            return ruleIdMap;
        }
        policyResults.forEach(policyResult -> {
            for (String ruleTag : ruleTags) {
                HashSet ids = new HashSet(16);
                policyResult.getRuleResults().forEach(ruleResult -> RuleEngineService.getRuleId(ruleResult, ruleTag, ids));
                ruleIdMap.put(ruleTag, ids);
            }
        });
        return ruleIdMap;
    }

    public static Set<Long> getRuleIdsByTag(List<PolicyResult> policyResults, String ruleTag) {
        HashSet ids = Sets.newHashSetWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(policyResults) || WTCStringUtils.isEmpty((String)ruleTag)) {
            return ids;
        }
        for (PolicyResult policyResult : policyResults) {
            if (policyResult.getRuleResults().isEmpty()) {
                Object obj = policyResult.getDefaultResults().get(ruleTag);
                ids.addAll(RuleEngineService.parseResultObj(obj));
                continue;
            }
            for (RuleResult ruleResult : policyResult.getRuleResults()) {
                RuleEngineService.getRuleId(ruleResult, ruleTag, ids);
            }
        }
        return ids;
    }

    public static Set<Object> getEnumsByTag(List<PolicyResult> policyResults, String tag) {
        HashSet ids = Sets.newHashSetWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(policyResults) || WTCStringUtils.isEmpty((String)tag)) {
            return ids;
        }
        for (PolicyResult policyResult : policyResults) {
            if (policyResult.getRuleResults().isEmpty()) {
                ids.add(policyResult.getDefaultResults().get(tag));
                continue;
            }
            for (RuleResult ruleResult : policyResult.getRuleResults()) {
                ids.add(ruleResult.getMatchResults().get(tag));
            }
        }
        return ids;
    }

    public static Set<Long> getRuleIds(List<PolicyResult> policyResults) {
        HashSet<Long> ids = new HashSet<Long>(16);
        if (CollectionUtils.isEmpty(policyResults)) {
            return ids;
        }
        policyResults.forEach(policyResult -> policyResult.getRuleResults().forEach(ruleResult -> ids.add(RuleEngineService.getRuleId(ruleResult))));
        return ids;
    }

    private static Long getRuleId(RuleResult ruleResult) {
        Object rule = ruleResult.getMatchResults().get("rule");
        Long res = null;
        if (rule == null) {
            return null;
        }
        if (rule instanceof DynamicObject) {
            res = (Long)((DynamicObject)rule).get("id");
        } else if (rule instanceof DynamicObject[]) {
            res = ((DynamicObject[])rule)[0].getLong("id");
        } else {
            throw new KDBizException(new ErrorCode("EX_006", MessageFormat.format(ResManager.loadKDString((String)"\u7f16\u7801:{0}\u7684\u89c4\u5219\u5f15\u64ce\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u9519\u8bef\u3002", (String)"RuleEngineService_3", (String)"wtc-wtes-business", (Object[])new Object[0]), ruleResult.getRuleNumber())), new Object[0]);
        }
        return res;
    }

    private static void getRuleId(RuleResult ruleResult, String ruleTag, Set<Long> ids) {
        Object rule = ruleResult.getMatchResults().get(ruleTag);
        if (rule == null) {
            return;
        }
        if (rule instanceof DynamicObject) {
            ids.add((Long)((DynamicObject)rule).get("id"));
        } else if (rule instanceof DynamicObject[]) {
            ids.add(((DynamicObject[])rule)[0].getLong("id"));
        } else {
            throw new KDBizException(new ErrorCode("EX_006", MessageFormat.format(ResManager.loadKDString((String)"\u7f16\u7801:{0}\u7684\u89c4\u5219\u5f15\u64ce\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u9519\u8bef\u3002", (String)"RuleEngineService_3", (String)"wtc-wtes-business", (Object[])new Object[0]), ruleResult.getRuleNumber())), new Object[0]);
        }
    }

    private static Set<Long> parseResultObj(Object obj) {
        HashSet<Long> ids = new HashSet<Long>();
        if (obj instanceof DynamicObject) {
            ids.add(((DynamicObject)obj).getLong("id"));
        } else if (obj instanceof DynamicObjectCollection) {
            ids.addAll(((DynamicObjectCollection)obj).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        } else if (obj instanceof DynamicObject[]) {
            ids.addAll(Arrays.stream((DynamicObject[])obj).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        }
        return ids;
    }

    private static void genPeriodInputParamExtend(Map<String, Object> inputParaMap, Map<String, String> hashCodeMap, RuleParam ruleParam, TieAttPeriodContext context, Set<String> extendKeys, PerAttPeriod attPeriod) {
        if (null == context) {
            return;
        }
        if (null == WTCRuleEngineSceneEnum.getPlanEnumByNumber((String)ruleParam.getSceneNumber())) {
            return;
        }
        WTCPluginProxy inputParamExtPlugin = (WTCPluginProxy)ContextExtUtil.getPeriodExtPlugin(context, "kd.sdk.wtc.wtp.business.ruleengine.RuleEngineInputParamExtPlugin");
        if (inputParamExtPlugin == null || !inputParamExtPlugin.hasPlugin()) {
            if (logger.isWarnEnabled()) {
                logger.warn("RuleEngineInputParamExtPlugin,\u672a\u5b9e\u73b0\u6269\u5c55\u7c7b\u3002");
            }
            return;
        }
        RuleEngineService.genInputParamFullProperties(inputParaMap, context, attPeriod);
        HashMap<String, Object> extendMap = new HashMap<String, Object>(extendKeys.size());
        for (String extendKey : extendKeys) {
            extendMap.put(extendKey, null);
        }
        Long planVersionId = ruleParam.getPlanVersionId();
        OnGenRuleEngineInputParamEvent param = new OnGenRuleEngineInputParamEvent(ruleParam.getSceneNumber(), planVersionId.longValue(), inputParaMap, extendKeys, extendMap, TiePeriodContextExtUtil.getTieAttPeriodContextExt(context), TiePeriodContextExtUtil.getTieAttPeriodContextExt(attPeriod));
        inputParamExtPlugin.invokeReplace(extPlugin -> {
            if (logger.isDebugEnabled()) {
                logger.debug("RuleEngineInputParamExtPlugin,\u8c03\u7528\u6269\u5c55\u7c7b\uff1a{}", (Object)extPlugin.getClass().getName());
            }
            extPlugin.onGenInputParam(param);
        });
        for (Map.Entry entry : param.getExtendMap().entrySet()) {
            if (extendKeys.contains(entry.getKey())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6269\u5c55\u5165\u53c2\u5b57\u6bb5\u201c{0}\u201d\u8d85\u51fa\u89c4\u5219\u5f15\u64ce\u6269\u5c55\u5b57\u6bb5\u9650\u5236\u3002", (String)"RuleEngineService_1", (String)"wtc-wtes-business", (Object[])new Object[]{entry.getKey()}));
        }
        for (Map.Entry entry : param.getExtendMap().entrySet()) {
            hashCodeMap.put((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
    }

    static {
        attfileMap.put("number", ele -> ((ArgumentWrapper)ele).attFileModel.getNumber());
        attfileMap.put("mode", ele -> ((ArgumentWrapper)ele).attFileModel.getAttMode(((ArgumentWrapper)ele).localDate).getCode());
        attfileMap.put("adminorg", ele -> ((ArgumentWrapper)ele).attFileModel.getAdminOrgId());
        modelNameMap.put("adminorg", "haos_adminorghr");
        attfileMap.put("org", ele -> ((ArgumentWrapper)ele).attFileModel.getOrgId());
        modelNameMap.put("org", "bos_org");
        attfileMap.put("affiliateadminorg", ele -> ((ArgumentWrapper)ele).attFileModel.getAffiliateAdminOrgBid());
        modelNameMap.put("affiliateadminorg", "haos_adminorghr");
        attfileMap.put("ismanaged", ele -> ((ArgumentWrapper)ele).attFileModel.isManaged());
        attfileMap.put("dependency", ele -> ((ArgumentWrapper)ele).attFileModel.getDependencyId());
        modelNameMap.put("dependency", "bd_country");
        attfileMap.put("dependencytype", ele -> ((ArgumentWrapper)ele).attFileModel.getDependencyType());
        modelNameMap.put("dependencytype", "hbss_depcytype");
        attfileMap.put("empgroup", ele -> ((ArgumentWrapper)ele).attFileModel.getEmpGroup());
        modelNameMap.put("empgroup", "hbss_empgroup");
        attfileMap.put("atttag", ele -> ((ArgumentWrapper)ele).attFileModel.getAttTagId());
        modelNameMap.put("atttag", "wtbd_attendtag");
        attfileMap.put("workplace", ele -> ((ArgumentWrapper)ele).attFileModel.getWorkplace());
        modelNameMap.put("workplace", "hbss_workplace");
        attpersonMap.put("nationality", ele -> ((AttendPersonModel)ele).getPerNonTsProp() == null ? null : ((AttendPersonModel)ele).getPerNonTsProp().getNationality());
        modelNameMap.put("nationality", "hbss_nationality");
        attpersonMap.put("marriagestatus", ele -> ((AttendPersonModel)ele).getPerTsProp() == null ? null : ((AttendPersonModel)ele).getPerTsProp().getMarriageStatus());
        modelNameMap.put("marriagestatus", "hbss_marriagestatus");
        attpersonMap.put("laborreltype", ele -> ((AttendPersonModel)ele).getEmployee() == null ? null : ((AttendPersonModel)ele).getEmployee().getLaborRelType());
        modelNameMap.put("laborreltype", "hbss_laborreltype");
        attpersonMap.put("laborrelstatus", ele -> ((AttendPersonModel)ele).getEmployee() == null ? null : ((AttendPersonModel)ele).getEmployee().getLaborRelStatus());
        modelNameMap.put("laborrelstatus", "hbss_laborrelstatus");
        attpersonMap.put("joblevel", ele -> ((AttendPersonModel)ele).getEmpJobRel() == null ? null : ((AttendPersonModel)ele).getEmpJobRel().getJobLevel());
        modelNameMap.put("joblevel", "hbjm_joblevelhr");
        attpersonMap.put("jobgrade", ele -> ((AttendPersonModel)ele).getEmpJobRel() == null ? null : ((AttendPersonModel)ele).getEmpJobRel().getJobGrade());
        modelNameMap.put("jobgrade", "hbjm_jobgradehr");
        attpersonMap.put("number", ele -> ((AttendPersonModel)ele).getEmployee() == null ? null : ((AttendPersonModel)ele).getEmployee().getEmpNumber());
        attpersonMap.put("gender", ele -> ((AttendPersonModel)ele).getPerNonTsProp() == null ? null : ((AttendPersonModel)ele).getPerNonTsProp().getGender());
        modelNameMap.put("gender", "hbss_sex");
        empJobMap.put("posstatus", ele -> RuleEngineService.getDepemp((ArgumentWrapper)ele) == null ? null : RuleEngineService.getDepemp((ArgumentWrapper)ele).getPosStatus());
        modelNameMap.put("posstatus", "hbss_poststate");
        empJobMap.put("postype", ele -> RuleEngineService.getDepemp((ArgumentWrapper)ele) == null ? null : RuleEngineService.getDepemp((ArgumentWrapper)ele).getPosType());
        modelNameMap.put("postype", "hbss_postype");
        empJobMap.put("isprimary", ele -> RuleEngineService.getDepemp((ArgumentWrapper)ele) == null ? null : RuleEngineService.getDepemp((ArgumentWrapper)ele).getIsPrimary());
        empJobMap.put("position", ele -> ((ArgumentWrapper)ele).attFileModel == null ? null : ((ArgumentWrapper)ele).attFileModel.getPositionId());
        modelNameMap.put("position", "hbpm_positionhr");
        empJobMap.put("company", ele -> ((ArgumentWrapper)ele).attFileModel == null ? null : ((ArgumentWrapper)ele).attFileModel.getCompanyId());
        modelNameMap.put("company", "haos_adminorghr");
        empJobMap.put("job", ele -> ((ArgumentWrapper)ele).attFileModel == null ? null : ((ArgumentWrapper)ele).attFileModel.getJobId());
        modelNameMap.put("job", "hbjm_jobhr");
        map.put(WTP_ATTFILE, attfileMap);
        map.put(WTP_ATTPERSON, attpersonMap);
        map.put(WTP_DEPEMPJOB, empJobMap);
    }
}

