/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.ruleengine.init;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.model.rlad.AdRulePackage;
import kd.wtc.wtes.business.model.util.AdEntityUtils;
import kd.wtc.wtes.business.ruleengine.init.IRuleInitializer;

public class AdRuleInitializer
implements IRuleInitializer {
    public Map<Long, TimeSeqAvailableBo<AdRulePackage>> initRule(Set<Long> ruleIds, InitParam initRequest) {
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        HashMap adRuleMap = Maps.newHashMapWithExpectedSize((int)ruleIds.size());
        DynamicObject[] adRuleHisList = InitHelper.getHisDyArr("wtp_supplerule", ruleIds, startDate, endDate);
        Map<Long, List<DynamicObject>> adRuleHisMap = Arrays.stream(adRuleHisList).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        for (Long ruleId : ruleIds) {
            adRuleMap.put(ruleId, AdEntityUtils.getRule(ruleId, adRuleHisMap));
        }
        return adRuleMap;
    }
}

