/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.ruleengine.init;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.business.timeseq.AbstractTimeSeqVersion;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.executor.rlex.ExCalHelper;
import kd.wtc.wtes.business.ruleengine.init.IRuleInitializer;

public class ExRuleInitializer
implements IRuleInitializer {
    @Override
    public Map<Long, ? extends TimeSeqBo<? extends AbstractTimeSeqVersion>> initRule(Set<Long> ruleIds, InitParam initParamRequest) {
        HashMap businessRuleMap = Maps.newHashMapWithExpectedSize((int)ruleIds.size());
        LocalDate startDate = initParamRequest.getStartDate();
        LocalDate endDate = initParamRequest.getEndDate();
        DynamicObject[] bizRuleHisArr = ExCalHelper.getHisDyArr("wtp_exrule", ruleIds, startDate, endDate);
        Map<Long, List<DynamicObject>> bizRuleHisMap = Arrays.stream(bizRuleHisArr).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        Map<Long, List<DynamicObject>> exConfMap = ExCalHelper.getExConfMap(startDate, endDate, bizRuleHisArr);
        for (Long ruleId : ruleIds) {
            businessRuleMap.put(ruleId, ExCalHelper.getExRule(ruleId, bizRuleHisMap, exConfMap));
        }
        return businessRuleMap;
    }
}

