/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.executor.rlex.ExCalHelper;
import kd.wtc.wtes.business.init.IAttFilePlan;
import kd.wtc.wtes.business.model.ExAttPackage;

public class AttFileExPlanImpl
implements IAttFilePlan {
    public Map<Long, TimeSeqAvailableBo<ExAttPackage>> getAttFilePlanSeq(Set<Long> fileEntryIds, InitParam initRequest) {
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileEntryIds.size());
        DynamicObject[] exSchemeHisArr = ExCalHelper.getHisDyArr(AttFilePlanEnum.EXS.getEntityNumber(), fileEntryIds, startDate, endDate);
        Map<Long, List<DynamicObject>> schemeHisMap = Arrays.stream(exSchemeHisArr).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        Set<Long> ruleIdHisSet = this.getRuleIdList(exSchemeHisArr);
        DynamicObject[] exRuleHisArr = ExCalHelper.getHisDyArr("wtp_exrule", ruleIdHisSet, startDate, endDate);
        Map<Long, List<DynamicObject>> ruleHisMap = Arrays.stream(exRuleHisArr).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        Map<Long, List<DynamicObject>> configHisMap = ExCalHelper.getExConfMap(startDate, endDate, exRuleHisArr);
        for (Long schemeId : fileEntryIds) {
            List<DynamicObject> dynamicObjectList = schemeHisMap.get(schemeId);
            if (null == dynamicObjectList) continue;
            resultMap.put(schemeId, new TimeSeqAvailableBo(ExCalHelper.getExSchemeHisList(schemeHisMap.get(schemeId), ruleHisMap, configHisMap)));
        }
        return resultMap;
    }

    private Set<Long> getRuleIdList(DynamicObject[] exSchemeHisList) {
        HashSet ruleIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject exSchemeHis : exSchemeHisList) {
            ruleIdSet.add(exSchemeHis.getLong("rule.id"));
        }
        return ruleIdSet;
    }
}

