/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqVersion;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.init.IAttFilePlan;
import kd.wtc.wtes.business.model.rlqt.QTCalRule;
import kd.wtc.wtes.business.model.rlqt.QTCarryDown;
import kd.wtc.wtes.business.model.rlqt.QTContext;
import kd.wtc.wtes.business.model.rlqt.QTDepartCarryDown;
import kd.wtc.wtes.business.model.rlqt.QTGenConfig;
import kd.wtc.wtes.business.model.rlqt.QTGenConfigEntry;
import kd.wtc.wtes.business.model.rlqt.QTInConvert;
import kd.wtc.wtes.business.model.rlqt.QTInConvertEntry;
import kd.wtc.wtes.business.model.rlqt.QTOverDraw;
import kd.wtc.wtes.business.model.rlqt.QTQualification;
import kd.wtc.wtes.business.model.rlqt.QTRule;
import kd.wtc.wtes.business.model.rlqt.QTScheme;
import kd.wtc.wtes.business.model.rlqt.QTTurnOverConvert;
import kd.wtc.wtes.business.model.rlqt.QTType;
import kd.wtc.wtes.business.model.rlqt.QTUseConfig;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTCarryDownTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTConverTimeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTConvertEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTConvertMethodEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTConvertTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTDateConfigTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTFloatUnitEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTGenTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTOverDrawTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTRoundPriorityEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTUnitEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTVestDayEnum;
import kd.wtc.wtes.business.service.AttFileVaPlanImpl;

public class AttFileQtPlanImpl
implements IAttFilePlan {
    private static final Log log = LogFactory.getLog(AttFileVaPlanImpl.class);
    private static final String QT_TYPE = "qttype";

    public Map<Long, TimeSeqAvailableBo<QTScheme>> getAttFilePlanSeq(Set<Long> fileEntryIds, InitParam initRequest) {
        QTContext context = this.buildQtContext(fileEntryIds, initRequest);
        Map<Long, TimeSeqAvailableBo<QTScheme>> qtPlans = this.buildQtPlans(context);
        log.debug("package QT plan susses\u3002\u3002\u3002\u3002");
        return qtPlans;
    }

    private Map<Long, TimeSeqAvailableBo<QTScheme>> buildQtPlans(QTContext context) {
        Map<Long, List<DynamicObject>> planMap = context.getPlanMap();
        if (null == planMap) {
            return Collections.emptyMap();
        }
        HashMap<Long, TimeSeqAvailableBo<QTScheme>> qtSchemes = new HashMap<Long, TimeSeqAvailableBo<QTScheme>>(planMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : planMap.entrySet()) {
            List<DynamicObject> planList = entry.getValue();
            if (planList.isEmpty()) continue;
            ArrayList<QTScheme> qtSchemesHis = new ArrayList<QTScheme>(planList.size());
            for (DynamicObject plan : planList) {
                QTScheme qtScheme = new QTScheme((TimeSeqInfo)InitHelper.getTimeSeqEntity(plan));
                if ("2".equals(plan.getString("srw"))) {
                    qtScheme.setRuleEngine(true);
                } else {
                    qtScheme.setQtRule(this.buildQtRule(plan, context));
                }
                qtSchemesHis.add(qtScheme);
            }
            qtSchemes.put(entry.getKey(), (TimeSeqAvailableBo<QTScheme>)new TimeSeqAvailableBo(qtSchemesHis));
        }
        return qtSchemes;
    }

    private TimeSeqAvailableBo<QTRule> buildQtRule(DynamicObject plan, QTContext context) {
        DynamicObject ruleDy = plan.getDynamicObject("rule");
        if (ruleDy == null) {
            return null;
        }
        return this.buildQtRuleByRuleId(ruleDy.getLong("id"), context);
    }

    public TimeSeqAvailableBo<QTRule> buildQtRuleByRuleId(long ruleId, QTContext context) {
        List<DynamicObject> ruleLists = context.getRuleHisListMap().get(ruleId);
        if (ruleLists == null || ruleLists.isEmpty()) {
            return null;
        }
        ArrayList<QTRule> rules = new ArrayList<QTRule>(ruleLists.size());
        for (DynamicObject ruleDy : ruleLists) {
            QTRule rule = new QTRule((TimeSeqInfo)InitHelper.getTimeSeqEntity(ruleDy));
            DynamicObjectCollection ruleEntryCollection = ruleDy.getDynamicObjectCollection("entryentity");
            if (ruleEntryCollection == null || ruleEntryCollection.isEmpty()) {
                log.debug("why qtRuleEntry is empty? qtRuleId is {}", (Object)rule.getId());
                return new TimeSeqAvailableBo((TimeSeqVersion)rule);
            }
            ArrayList<QTCalRule> calRules = new ArrayList<QTCalRule>(ruleEntryCollection.size());
            for (DynamicObject ruleEntryRow : ruleEntryCollection) {
                QTCalRule calRule = new QTCalRule();
                DynamicObject target = ruleEntryRow.getDynamicObject(QT_TYPE);
                if (target != null) {
                    calRule.setQtType(this.buildQtType(target.getLong("id"), context));
                }
                calRule.setGenConfig(this.buildQtGenConfig(ruleEntryRow.getDynamicObject("qtgenconfig"), context));
                calRule.setGenQualification(this.buildQTQualification(ruleEntryRow.getDynamicObject("genqc"), context));
                calRule.setUseConfig(this.buildQtUseConfig(ruleEntryRow.getDynamicObject("qtuseconfig"), context));
                calRule.setUseQualification(this.buildQTQualification(ruleEntryRow.getDynamicObject("useqc"), context));
                calRule.setOverDraw(this.buildOverDraw(ruleEntryRow.getDynamicObject("qtoverdraw"), context));
                calRule.setOverQualification(this.buildQTQualification(ruleEntryRow.getDynamicObject("overqc"), context));
                calRule.setCarryDown(this.buildCarryDown(ruleEntryRow.getDynamicObject("qtcarrydown"), context));
                calRule.setCarryQualification(this.buildQTQualification(ruleEntryRow.getDynamicObject("carryqc"), context));
                calRule.setInconVersion(this.buildQTInConvert(ruleEntryRow.getDynamicObject("inconvert"), context));
                calRule.setTurnOverConversion(this.buildTurnOverConversion(ruleEntryRow.getDynamicObject("toconvert"), context));
                calRules.add(calRule);
            }
            rule.setQtRules(calRules);
            rules.add(rule);
        }
        return new TimeSeqAvailableBo(rules);
    }

    private QTTurnOverConvert buildTurnOverConversion(DynamicObject toConvert, QTContext context) {
        if (toConvert == null) {
            return null;
        }
        Map<Long, List<DynamicObject>> toConcertMap = context.getToConvert();
        List<DynamicObject> toConvertDys = toConcertMap.get(toConvert.getLong("id"));
        if (toConvertDys == null || toConvertDys.isEmpty()) {
            return null;
        }
        DynamicObject toConvertDy = toConvertDys.get(0);
        QTTurnOverConvert overConversion = new QTTurnOverConvert(toConvertDy.getLong("id"), toConvertDy.getString("number"));
        overConversion.setConvertMethod(QTConvertMethodEnum.getByType(toConvertDy.getString("conversionmethod")));
        overConversion.setConvertDate(toConvertDy.getDate("convertdate"));
        overConversion.setSafActor(toConvertDy.getBigDecimal("conversionfator"));
        DynamicObject attItem = toConvertDy.getDynamicObject("settlementitem");
        if (attItem != null) {
            overConversion.setSettlementItem(attItem.getLong("id"));
        }
        return overConversion;
    }

    private QTInConvert buildQTInConvert(DynamicObject inConvert, QTContext context) {
        if (inConvert == null) {
            return null;
        }
        Map<Long, List<DynamicObject>> inConvertMap = context.getInConvert();
        List<DynamicObject> inConvertDys = inConvertMap.get(inConvert.getLong("id"));
        if (inConvertDys == null || inConvertDys.isEmpty()) {
            return null;
        }
        DynamicObject inConvertDy = inConvertDys.get(0);
        QTInConvert qtInConvert = new QTInConvert(inConvertDy.getLong("id"), inConvertDy.getString("number"));
        qtInConvert.setConvertMethod(QTConvertMethodEnum.getByType(inConvertDy.getString("convermethod")));
        qtInConvert.setConvertType(QTConvertTypeEnum.getByType(inConvertDy.getString("convertype")));
        qtInConvert.setConvertFactor(inConvertDy.getBigDecimal("converfator"));
        qtInConvert.setInConvertEntries(this.buildQTInConvertEntry(inConvertDy.getDynamicObjectCollection("qtinconverentry")));
        return qtInConvert;
    }

    private List<QTInConvertEntry> buildQTInConvertEntry(DynamicObjectCollection qtInConvertEntry) {
        if (qtInConvertEntry == null || qtInConvertEntry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QTInConvertEntry> qtInConvertEntries = new ArrayList<QTInConvertEntry>(qtInConvertEntry.size());
        for (DynamicObject row : qtInConvertEntry) {
            QTInConvertEntry entry = new QTInConvertEntry();
            entry.setStartDate(row.getString("begintime"));
            entry.setEndDate(row.getString("endtime"));
            entry.setProportion(row.getBigDecimal("proportion"));
            qtInConvertEntries.add(entry);
        }
        return qtInConvertEntries;
    }

    private TimeSeqAvailableBo<QTCarryDown> buildCarryDown(DynamicObject qtCarryDown, QTContext context) {
        if (qtCarryDown == null) {
            return null;
        }
        List<DynamicObject> qtCarryDownDys = context.getQtCarryDownConfigs().get(qtCarryDown.getLong("id"));
        if (qtCarryDownDys == null || qtCarryDownDys.isEmpty()) {
            return null;
        }
        ArrayList<QTCarryDown> qtCarryDowns = new ArrayList<QTCarryDown>(qtCarryDownDys.size());
        for (DynamicObject qtCarryDownDy : qtCarryDownDys) {
            DynamicObject slmentAttItem;
            QTCarryDown carryDown = new QTCarryDown((TimeSeqInfo)InitHelper.getTimeSeqEntity(qtCarryDownDy));
            carryDown.setCarryDownMethod(QTCarryDownTypeEnum.getByType(qtCarryDownDy.getString("cdmode")));
            DynamicObject passDuration = qtCarryDownDy.getDynamicObject("pastduration");
            if (passDuration != null) {
                carryDown.setPassDurationAttItem(passDuration.getLong("id"));
            }
            carryDown.setCarryStartDate(QTDateConfigTypeEnum.getByType(qtCarryDownDy.getString("cdstartdate")));
            carryDown.setStartDelay(qtCarryDownDy.getBoolean("cdsdelay"));
            carryDown.setsDelay(qtCarryDownDy.getInt("cdsdelayvalue"));
            carryDown.setStartFloatUnit(QTFloatUnitEnum.getByType(qtCarryDownDy.getString("cdsdelayunit")));
            carryDown.setCarryEndDate(QTDateConfigTypeEnum.getByType(qtCarryDownDy.getString("cdenddate")));
            carryDown.setEndDelay(qtCarryDownDy.getBoolean("cdedelay"));
            carryDown.seteDelay(qtCarryDownDy.getInt("cdedelayvalue"));
            carryDown.setEndFloatUnit(QTFloatUnitEnum.getByType(qtCarryDownDy.getString("cdedelayunit")));
            carryDown.setCarryType(QTOverDrawTypeEnum.getByType(qtCarryDownDy.getString("cdtype")));
            carryDown.setFixValue(qtCarryDownDy.getBigDecimal("cdvalue"));
            carryDown.setPercentValue(qtCarryDownDy.getBigDecimal("cdpercent"));
            carryDown.setVDDelay(qtCarryDownDy.getBoolean("cdvdelay"));
            carryDown.setVestDay(QTVestDayEnum.getByType(qtCarryDownDy.getString("cdvestday")));
            carryDown.setVestDayDelay(qtCarryDownDy.getInt("cdvdelayvalue"));
            carryDown.setVestDayFloatUnit(QTFloatUnitEnum.getByType(qtCarryDownDy.getString("cdvdelayunit")));
            carryDown.setDepartCarryDown(this.buildQTDepartCarryDown(qtCarryDownDy));
            carryDown.setOffsetMethod(qtCarryDownDy.getString("offsetmode"));
            carryDown.setOffsetSeq(qtCarryDownDy.getString("offsetseq"));
            DynamicObject cdDurationAttItem = qtCarryDownDy.getDynamicObject("cdduration");
            if (cdDurationAttItem != null) {
                carryDown.setCdDuration(cdDurationAttItem.getLong("id"));
            }
            carryDown.setCdPastPercent(qtCarryDownDy.getBigDecimal("cdpastpercent"));
            DynamicObject cdPassDuration = qtCarryDownDy.getDynamicObject("cdpastduration");
            if (cdPassDuration != null) {
                carryDown.setCarryDownAttItem(cdPassDuration.getLong("id"));
            }
            if ((slmentAttItem = qtCarryDownDy.getDynamicObject("slmentattitem")) != null) {
                carryDown.setSlmentAttItem(slmentAttItem.getLong("id"));
            }
            qtCarryDowns.add(carryDown);
        }
        return new TimeSeqAvailableBo(qtCarryDowns);
    }

    private QTDepartCarryDown buildQTDepartCarryDown(DynamicObject qtCarryDownDy) {
        QTDepartCarryDown qtDepartCarryDown = new QTDepartCarryDown();
        DynamicObject departDurationAttItem = qtCarryDownDy.getDynamicObject("departduration");
        if (departDurationAttItem != null) {
            qtDepartCarryDown.setDepartAttItem(departDurationAttItem.getLong("id"));
        }
        qtDepartCarryDown.setDepartCDDelay(qtCarryDownDy.getInt("dpvdelayvalue"));
        qtDepartCarryDown.setDPDelay(qtCarryDownDy.getBoolean("dpvdelay"));
        qtDepartCarryDown.setVestDayMethod(qtCarryDownDy.getString("dpvestday"));
        qtDepartCarryDown.setVestDayFloatUnit(QTFloatUnitEnum.getByType(qtCarryDownDy.getString("dpvdelayunit")));
        return qtDepartCarryDown;
    }

    private TimeSeqAvailableBo<QTOverDraw> buildOverDraw(DynamicObject qtOverDraw, QTContext context) {
        if (qtOverDraw == null) {
            return null;
        }
        List<DynamicObject> qtOverDrawDys = context.getQtOverConfigs().get(qtOverDraw.getLong("id"));
        if (qtOverDrawDys == null || qtOverDrawDys.isEmpty()) {
            return null;
        }
        ArrayList<QTOverDraw> qtOverDraws = new ArrayList<QTOverDraw>(qtOverDrawDys.size());
        for (DynamicObject qtOverDrawDy : qtOverDrawDys) {
            DynamicObject canodvalue;
            DynamicObject odvalue;
            DynamicObject oriAttItem;
            QTOverDraw overDraw = new QTOverDraw((TimeSeqInfo)InitHelper.getTimeSeqEntity(qtOverDrawDy));
            overDraw.setOverDrawType(QTOverDrawTypeEnum.getByType(qtOverDrawDy.getString("overdrawtype")));
            overDraw.setFixValue(qtOverDrawDy.getBigDecimal("value"));
            overDraw.setPercentValue(qtOverDrawDy.getBigDecimal("percent"));
            DynamicObject roundRule = qtOverDrawDy.getDynamicObject("roundrule");
            if (roundRule != null) {
                overDraw.setRoundRule(roundRule.getLong("id"));
            }
            if ((oriAttItem = qtOverDrawDy.getDynamicObject("rawodvalue")) != null) {
                overDraw.setOriOverAttItem(oriAttItem.getLong("id"));
            }
            if ((odvalue = qtOverDrawDy.getDynamicObject("odvalue")) != null) {
                overDraw.setOverTimeAttItem(odvalue.getLong("id"));
            }
            if ((canodvalue = qtOverDrawDy.getDynamicObject("canodvalue")) != null) {
                overDraw.setCanOdValue(canodvalue.getLong("id"));
            }
            qtOverDraws.add(overDraw);
        }
        return new TimeSeqAvailableBo(qtOverDraws);
    }

    private TimeSeqAvailableBo<QTUseConfig> buildQtUseConfig(DynamicObject useConfig, QTContext context) {
        if (useConfig == null) {
            return null;
        }
        long useConfigId = useConfig.getLong("id");
        List<DynamicObject> useConfigDys = context.getQtUseConfigs().get(useConfigId);
        if (useConfigDys == null || useConfigDys.isEmpty()) {
            return null;
        }
        ArrayList<QTUseConfig> qtUseConfigs = new ArrayList<QTUseConfig>(useConfigDys.size());
        for (DynamicObject useConfigDy : useConfigDys) {
            DynamicObject freeze;
            DynamicObject useDuration;
            DynamicObject endLimitDy;
            QTUseConfig qtUseConfig = new QTUseConfig((TimeSeqInfo)InitHelper.getTimeSeqEntity(useConfigDy));
            qtUseConfig.setUseStartDate(QTDateConfigTypeEnum.getByType(useConfigDy.getString("usestartdate")));
            qtUseConfig.setStartDelay(useConfigDy.getBoolean("sdelay"));
            qtUseConfig.setsDelay(useConfigDy.getInt("startdelay"));
            qtUseConfig.setStartFloatUnit(QTFloatUnitEnum.getByType(useConfigDy.getString("startdelayunit")));
            qtUseConfig.setUseEndDate(QTDateConfigTypeEnum.getByType(useConfigDy.getString("useenddate")));
            qtUseConfig.setEndDelay(useConfigDy.getBoolean("edelay"));
            qtUseConfig.seteDelay(useConfigDy.getInt("enddelay"));
            qtUseConfig.setEndFloatUnit(QTFloatUnitEnum.getByType(useConfigDy.getString("enddelayunit")));
            DynamicObject startLimitDy = useConfigDy.getDynamicObject("startlimit");
            if (startLimitDy != null) {
                qtUseConfig.setStartLimit(startLimitDy.getLong("id"));
            }
            if ((endLimitDy = useConfigDy.getDynamicObject("endlimit")) != null) {
                qtUseConfig.setEndLimit(endLimitDy.getLong("id"));
            }
            if ((useDuration = useConfigDy.getDynamicObject("useduration")) != null) {
                qtUseConfig.setUseDuration(useDuration.getLong("id"));
            }
            if ((freeze = useConfigDy.getDynamicObject("freeze")) != null) {
                qtUseConfig.setFreeze(freeze.getLong("id"));
            }
            qtUseConfigs.add(qtUseConfig);
        }
        return new TimeSeqAvailableBo(qtUseConfigs);
    }

    private TimeSeqAvailableBo<QTQualification> buildQTQualification(DynamicObject qualification, QTContext context) {
        if (qualification == null) {
            return null;
        }
        long limitId = qualification.getLong("id");
        List<DynamicObject> qualificationDys = context.getLimitConditions().get(limitId);
        if (qualificationDys == null || qualificationDys.isEmpty()) {
            return null;
        }
        ArrayList<QTQualification> qtQualifications = new ArrayList<QTQualification>(qualificationDys.size());
        for (DynamicObject qualificationDy : qualificationDys) {
            QTQualification qualify = new QTQualification((TimeSeqInfo)InitHelper.getTimeSeqEntity(qualificationDy));
            qualify.setConditionStr(qualificationDy.getString("conditionstr"));
            qualify.setInspectRang(qualificationDy.getString("inspectrangm"));
            qualify.setLimitMethod(qualificationDy.getString("limitmethodm"));
            qualify.setLimitPercent(qualificationDy.getBigDecimal("limitprecentgm"));
            qualify.setLimitQuatity(qualificationDy.getBigDecimal("limitquatitym"));
            qualify.setQualityType(qualificationDy.getString("qualitytypem"));
            qtQualifications.add(qualify);
        }
        return new TimeSeqAvailableBo(qtQualifications);
    }

    private TimeSeqAvailableBo<QTGenConfig> buildQtGenConfig(DynamicObject genConfig, QTContext context) {
        if (genConfig == null) {
            return null;
        }
        Map<Long, List<DynamicObject>> qtGenConfigs = context.getQtGenConfigs();
        List<DynamicObject> qtGenConfigDys = qtGenConfigs.get(genConfig.getLong("id"));
        if (qtGenConfigDys == null || qtGenConfigDys.isEmpty()) {
            return null;
        }
        ArrayList<QTGenConfig> qtGenConfigList = new ArrayList<QTGenConfig>(qtGenConfigDys.size());
        for (DynamicObject qtGenConfigDy : qtGenConfigDys) {
            DynamicObject cycSet;
            QTGenConfig qtGenConfig = new QTGenConfig((TimeSeqInfo)InitHelper.getTimeSeqEntity(qtGenConfigDy));
            qtGenConfig.setConvertByCondition(QTConvertEnum.getByType(qtGenConfigDy.getString("conditionconvert")));
            DynamicObject qtType = qtGenConfigDy.getDynamicObject(QT_TYPE);
            if (qtType != null) {
                long qtTypeId = qtType.getLong("id");
                qtGenConfig.setQtType(this.buildQtType(qtTypeId, context));
            }
            if ((cycSet = qtGenConfigDy.getDynamicObject("cycset")) != null) {
                long cycSetId = cycSet.getLong("id");
                qtGenConfig.setCycSet(cycSetId);
                qtGenConfig.setCycDateSet(cycSet.getLong("cycrefdate.id"));
            }
            qtGenConfig.setTransferOrg(qtGenConfigDy.getBoolean("transferorg"));
            qtGenConfig.setCrossMangOrg(qtGenConfigDy.getString("transfermangorg"));
            qtGenConfig.setConvertByOrg(QTConvertEnum.getByType(qtGenConfigDy.getString("convert")));
            qtGenConfig.setConverTime(QTConverTimeEnum.getByType(qtGenConfigDy.getString("convertime")));
            qtGenConfig.setGenCondition(qtGenConfigDy.getBoolean("gencondition"));
            qtGenConfig.setConvertByCondition(QTConvertEnum.getByType(qtGenConfigDy.getString("conditionconvert")));
            qtGenConfig.setQtGenConfigEntries(this.buildGenConfigEntry(qtGenConfigDy, context));
            qtGenConfig.setGenDetails(qtGenConfigDy.getBoolean("isgendetails"));
            qtGenConfig.setNoGenBeforeDate(qtGenConfigDy.getString("nogenbeforedate"));
            qtGenConfigList.add(qtGenConfig);
        }
        return new TimeSeqAvailableBo(qtGenConfigList);
    }

    private List<QTGenConfigEntry> buildGenConfigEntry(DynamicObject qtGenConfigDy, QTContext context) {
        DynamicObjectCollection genConfigEntryDy = qtGenConfigDy.getDynamicObjectCollection("entryentity");
        if (genConfigEntryDy == null || genConfigEntryDy.isEmpty()) {
            log.debug("why qtGenConfigEntry is empty? qtRuleId is {}", (Object)qtGenConfigDy.getLong("id"));
            return Collections.emptyList();
        }
        ArrayList<QTGenConfigEntry> configEntries = new ArrayList<QTGenConfigEntry>(genConfigEntryDy.size());
        for (DynamicObject row : genConfigEntryDy) {
            QTGenConfigEntry configEntry = new QTGenConfigEntry();
            DynamicObject target = row.getDynamicObject("attitem");
            if (target != null) {
                configEntry.setAttItem(target.getLong("id"));
            }
            configEntry.setEntryBoId(row.getLong("entryboid"));
            configEntry.setConditionFilter(row.getString("conditionfilter"));
            BigDecimal value = row.getBigDecimal("itemvalue") != null ? row.getBigDecimal("itemvalue") : row.getBigDecimal("value");
            configEntry.setValue(value);
            target = row.getDynamicObject("roundrule");
            if (target != null) {
                configEntry.setRoundRule(target.getLong("id"));
            }
            if ((target = row.getDynamicObject("maxattitem")) != null) {
                configEntry.setMaxAttItem(target.getLong("id"));
            }
            if ((target = row.getDynamicObject("resultattitem")) != null) {
                configEntry.setResultAttItem(target.getLong("id"));
            }
            if ((target = row.getDynamicObject("enjoyattitem")) != null) {
                configEntry.setEnjoyAttItem(target.getLong("id"));
            }
            if ((target = row.getDynamicObject("usableattitem")) != null) {
                configEntry.setUsableAttItem(target.getLong("id"));
            }
            if ((target = row.getDynamicObject("qualification")) != null) {
                configEntry.setQtQualification(this.buildQTQualification(target, context));
            }
            configEntry.setPercent(row.getBigDecimal("percent"));
            configEntry.setRoundPriority(QTRoundPriorityEnum.getByType(row.getString("roundpriority")));
            configEntries.add(configEntry);
        }
        return configEntries;
    }

    private QTType buildQtType(long qtTypeId, QTContext context) {
        List<DynamicObject> qtTypes = context.getQtTypes().get(qtTypeId);
        if (qtTypes == null || qtTypes.isEmpty()) {
            return null;
        }
        DynamicObject qtTypeDy = qtTypes.get(0);
        QTType qtType = new QTType(qtTypeDy.getLong("id"), qtTypeDy.getString("number"));
        qtType.setName(qtTypeDy.getString("name"));
        qtType.setQtMethod(QTTypeEnum.getByType(qtTypeDy.getString("category")));
        qtType.setUnit(QTUnitEnum.getByType(qtTypeDy.getString("unit")));
        qtType.setqTGenTypeEnum(QTGenTypeEnum.getByType(qtTypeDy.getString("gentype")));
        return qtType;
    }

    public void buildQtContextByRule(Set<Long> ruleIdList, InitParam initRequest, QTContext context) {
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        context.setStartDate(WTCDateUtils.toDate((LocalDate)startDate));
        context.setEndDate(WTCDateUtils.toDate((LocalDate)endDate));
        DynamicObject[] vaRuleHisList = InitHelper.getHisDyArr("wtp_qtrule", ruleIdList, startDate, endDate);
        Map<Long, List<DynamicObject>> ruleHisListMap = Arrays.stream(vaRuleHisList).collect(Collectors.groupingBy(info -> info.getLong("boid")));
        context.setRuleHisListMap(ruleHisListMap);
        HashSet<Long> qtTypes = new HashSet<Long>(16);
        HashSet<Long> qtGenConfigs = new HashSet<Long>(16);
        HashSet<Long> limitConditions = new HashSet<Long>(16);
        HashSet<Long> qtUseConfigs = new HashSet<Long>(16);
        HashSet<Long> qtOverConfigs = new HashSet<Long>(16);
        HashSet<Long> qtCarryDownConfigs = new HashSet<Long>(16);
        HashSet<Long> inConvert = new HashSet<Long>(16);
        HashSet<Long> toConvert = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : vaRuleHisList) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            if (dynamicObjectCollection == null) continue;
            for (DynamicObject dy2 : dynamicObjectCollection) {
                DynamicObject value = dy2.getDynamicObject(QT_TYPE);
                if (value != null) {
                    qtTypes.add(value.getLong("id"));
                }
                if ((value = dy2.getDynamicObject("qtgenconfig")) != null) {
                    qtGenConfigs.add(value.getLong("id"));
                    qtTypes.add(value.getLong("qttype.id"));
                }
                if ((value = dy2.getDynamicObject("genqc")) != null) {
                    limitConditions.add(value.getLong("id"));
                }
                if ((value = dy2.getDynamicObject("qtuseconfig")) != null) {
                    qtUseConfigs.add(value.getLong("id"));
                }
                if ((value = dy2.getDynamicObject("useqc")) != null) {
                    limitConditions.add(value.getLong("id"));
                }
                if ((value = dy2.getDynamicObject("qtoverdraw")) != null) {
                    qtOverConfigs.add(value.getLong("id"));
                }
                if ((value = dy2.getDynamicObject("overqc")) != null) {
                    limitConditions.add(value.getLong("id"));
                }
                if ((value = dy2.getDynamicObject("qtcarrydown")) != null) {
                    qtCarryDownConfigs.add(value.getLong("id"));
                }
                if ((value = dy2.getDynamicObject("carryqc")) != null) {
                    limitConditions.add(value.getLong("id"));
                }
                if ((value = dy2.getDynamicObject("inconvert")) != null) {
                    inConvert.add(value.getLong("id"));
                }
                if ((value = dy2.getDynamicObject("toconvert")) == null) continue;
                toConvert.add(value.getLong("id"));
            }
        }
        if (!qtTypes.isEmpty()) {
            DynamicObject[] qtTypeArr = new HRBaseServiceHelper("wtp_qttype").loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", qtTypes)});
            context.setQtTypes(Arrays.stream(qtTypeArr).collect(Collectors.groupingBy(info -> info.getLong("id"))));
        }
        if (!qtGenConfigs.isEmpty()) {
            DynamicObject[] genConfigArr = InitHelper.getHisDyArr("wtp_qtgenconfig", qtGenConfigs, startDate, endDate);
            context.setQtGenConfigs(Arrays.stream(genConfigArr).collect(Collectors.groupingBy(info -> info.getLong("boid"))));
            if (genConfigArr != null) {
                for (int index = 0; index < genConfigArr.length; ++index) {
                    DynamicObject dynamicObject = genConfigArr[index];
                    Set qualificationIds = dynamicObject.getDynamicObjectCollection("entryentity").stream().filter(dy -> dy.getDynamicObject("qualification") != null).map(dy -> dy.getDynamicObject("qualification").getLong("id")).collect(Collectors.toSet());
                    limitConditions.addAll(qualificationIds);
                }
            }
        }
        if (!limitConditions.isEmpty()) {
            DynamicObject[] limitConditionArr = InitHelper.getHisDyArr("wtp_qtqualification", limitConditions, startDate, endDate);
            context.setLimitConditions(Arrays.stream(limitConditionArr).collect(Collectors.groupingBy(info -> info.getLong("boid"))));
        }
        if (!qtUseConfigs.isEmpty()) {
            DynamicObject[] qtUseConfigArr = InitHelper.getHisDyArr("wtp_qtuseconfig", qtUseConfigs, startDate, endDate);
            context.setQtUseConfigs(Arrays.stream(qtUseConfigArr).collect(Collectors.groupingBy(info -> info.getLong("boid"))));
        }
        if (!qtOverConfigs.isEmpty()) {
            DynamicObject[] qtOverConfigArr = InitHelper.getHisDyArr("wtp_qtoverdraw", qtOverConfigs, startDate, endDate);
            context.setQtOverConfigs(Arrays.stream(qtOverConfigArr).collect(Collectors.groupingBy(info -> info.getLong("boid"))));
        }
        if (!qtCarryDownConfigs.isEmpty()) {
            DynamicObject[] qtCarryDownConfigArr = InitHelper.getHisDyArr("wtp_qtcarrydown", qtCarryDownConfigs, startDate, endDate);
            context.setQtCarryDownConfigs(Arrays.stream(qtCarryDownConfigArr).collect(Collectors.groupingBy(info -> info.getLong("boid"))));
        }
        if (!inConvert.isEmpty()) {
            DynamicObject[] inConvertArr = new HRBaseServiceHelper("wtp_qtinconversion").loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", inConvert)});
            context.setInConvert(Arrays.stream(inConvertArr).collect(Collectors.groupingBy(info -> info.getLong("id"))));
        }
        if (!toConvert.isEmpty()) {
            DynamicObject[] toConvertArr = new HRBaseServiceHelper("wtp_qtturnoverconver").loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", toConvert)});
            context.setToConvert(Arrays.stream(toConvertArr).collect(Collectors.groupingBy(info -> info.getLong("id"))));
        }
    }

    private QTContext buildQtContext(Set<Long> fileEntryIds, InitParam initRequest) {
        Set<Long> ruleIdList;
        LocalDate endDate;
        QTContext context = new QTContext();
        LocalDate startDate = initRequest.getStartDate();
        DynamicObject[] qtPlanList = InitHelper.getHisDyArr("wtp_qtscheme", fileEntryIds, startDate, endDate = initRequest.getEndDate());
        if (qtPlanList.length != 0) {
            Map<Long, List<DynamicObject>> planMap = Arrays.stream(qtPlanList).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
            context.setPlanMap(planMap);
        }
        if (!(ruleIdList = this.getRuleIdList(qtPlanList)).isEmpty()) {
            this.buildQtContextByRule(ruleIdList, initRequest, context);
        }
        return context;
    }

    private Set<Long> getRuleIdList(DynamicObject[] qtPlanHisList) {
        HashSet ruleIdList = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject qtPlanHis : qtPlanHisList) {
            DynamicObject qtRule = qtPlanHis.getDynamicObject("rule");
            if (!Objects.nonNull(qtRule)) continue;
            ruleIdList.add(qtRule.getLong("id"));
        }
        return ruleIdList;
    }
}

