/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.ruleengine.RuleEngineQueryServiceImpl;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.executor.rlva.VaCalHelper;
import kd.wtc.wtes.business.init.IAttFilePlan;
import kd.wtc.wtes.business.model.VaAttPackage;

public class AttFileVaPlanImpl
implements IAttFilePlan {
    private static final Log log = LogFactory.getLog(AttFileVaPlanImpl.class);

    public Map<Long, TimeSeqAvailableBo<VaAttPackage>> getAttFilePlanSeq(Set<Long> fileEntryIds, InitParam initRequest) {
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        log.debug("\u4f11\u5047\u8ba1\u7b97\u914d\u7f6e\u8be6\u60c5\u5305\u914d\u7f6e\u903b\u8f91\u5f00\u59cb\u3002\u3002\u3002");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileEntryIds.size());
        DynamicObject[] vaPlanHisList = VaCalHelper.getHisDyArr(AttFilePlanEnum.VP.getEntityNumber(), fileEntryIds, startDate, endDate);
        Map<Long, List<DynamicObject>> planMap = Arrays.stream(vaPlanHisList).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        List planVersionIds = Arrays.stream(vaPlanHisList).map(hisPlan -> hisPlan.getLong("id")).collect(Collectors.toList());
        Map ruleSetMap = RuleEngineQueryServiceImpl.getInstance().queryRuleEngineAssociation(planVersionIds);
        Set<Long> ruleIdList = this.getRuleIdList(vaPlanHisList);
        DynamicObject[] vaRuleHisList = VaCalHelper.getHisDyArr("wtp_varule", ruleIdList, startDate, endDate);
        Map<Long, List<DynamicObject>> ruleHisListMap = Arrays.stream(vaRuleHisList).collect(Collectors.groupingBy(info -> info.getLong("boid")));
        Map<String, Set<Long>> f7IdMaps = VaCalHelper.getF7IdMaps(vaRuleHisList);
        Set<Long> vaBaseSetIds = f7IdMaps.get("vabasesetid");
        DynamicObject[] vaBaseSetHisList = VaCalHelper.getHisDyArr("wtp_vabaseset", vaBaseSetIds, startDate, endDate);
        Map<Long, List<DynamicObject>> baseSetHisListMap = Arrays.stream(vaBaseSetHisList).collect(Collectors.groupingBy(info -> info.getLong("boid")));
        Map<Object, Object> deductRuleHisMap = Maps.newHashMapWithExpectedSize((int)16);
        Set<Long> deductionRuleIds = f7IdMaps.get("deductrule");
        if (WTCCollections.isNotEmpty(deductionRuleIds)) {
            DynamicObject[] deductRuleHisList = VaCalHelper.getHisDyArr("wtp_qtdeducrule", deductionRuleIds, startDate, endDate);
            deductRuleHisMap = Arrays.stream(deductRuleHisList).collect(Collectors.groupingBy(info -> info.getLong("boid")));
        }
        HashMap<String, Map<Long, List<DynamicObject>>> f7Maps = new HashMap<String, Map<Long, List<DynamicObject>>>();
        f7Maps.put("vabasesetid", baseSetHisListMap);
        f7Maps.put("deductrule", deductRuleHisMap);
        for (Long planId : fileEntryIds) {
            List<DynamicObject> dynamicObjectList = planMap.get(planId);
            if (null == dynamicObjectList) continue;
            resultMap.put(planId, new TimeSeqAvailableBo(VaCalHelper.getPlanHisList(dynamicObjectList, ruleHisListMap, ruleSetMap, f7Maps)));
        }
        log.debug("\u4f11\u5047\u8ba1\u7b97\u914d\u7f6e\u8be6\u60c5\u5305\u914d\u7f6e\u903b\u8f91\u7ed3\u675f\u3002\u3002\u3002\u3002");
        return resultMap;
    }

    private Set<Long> getRuleIdList(DynamicObject[] vaPlanHisList) {
        HashSet ruleIdList = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject vaPlanHis : vaPlanHisList) {
            DynamicObject vaRule = vaPlanHis.getDynamicObject("varule");
            if (!Objects.nonNull(vaRule)) continue;
            ruleIdList.add(vaRule.getLong("id"));
        }
        return ruleIdList;
    }
}

