/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtes.business.tie.model.init.TieRequestExt;
import kd.sdk.wtc.wtes.business.tie.persistent.clean.AfterCleanExDataEvent;
import kd.sdk.wtc.wtes.business.tie.persistent.clean.TieCleanExDataExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.init.TieRequestExtImpl;
import kd.wtc.wtes.business.ext.model.attstate.AttStateExtImpl;
import kd.wtc.wtes.business.service.IDataPackageStoreService;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;

public class ClearAttHisDataService {
    private static final Log logger = LogFactory.getLog(ClearAttHisDataService.class);
    private static final ClearAttHisDataService instance = (ClearAttHisDataService)WTCAppContextHelper.getBean(ClearAttHisDataService.class);
    private static final HRBaseServiceHelper attPeriodSummaryService = WtesHRBaseTimeWatchUtil.create(ClearAttHisDataService.class.getName() + "." + "wtctd_atttotalbase", "wtctd_atttotalbase");
    private static final HRBaseServiceHelper attPeriodDetailSummaryService = WtesHRBaseTimeWatchUtil.create(ClearAttHisDataService.class.getName() + "." + "wtdtd_attrecorddetail", "wtctd_atttotaldetail");
    private static final String ISINFOEXC = "isinfoexc";
    private List<IDataPackageStoreService> serviceList;

    public static ClearAttHisDataService getInstance() {
        return instance;
    }

    public Map<Long, String> cleanHisData(TieRequest tieRequest) {
        List<Long> attFileBoIds = tieRequest.getAttFileBoids();
        AttStateInfoService instance = AttStateInfoService.getInstance();
        List attStateInfoBOS = instance.queryAttStateInfoByBoid(attFileBoIds);
        HashMap exBoIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (AttStateInfoBO attStateInfoBO : attStateInfoBOS) {
            if (attStateInfoBO.getInfoExc() != null && !attStateInfoBO.getInfoExc().booleanValue()) continue;
            Date lockToDate = attStateInfoBO.getLockTo();
            Date exStartDate = attStateInfoBO.getExcStartDate();
            Date exEndDate = attStateInfoBO.getExcEndDate();
            Long fileBoid = attStateInfoBO.getFileBoid();
            if (lockToDate != null && lockToDate.getTime() >= exStartDate.getTime()) {
                exBoIdMap.put(fileBoid, ResManager.loadKDString((String)"\u8be5\u8003\u52e4\u6863\u6848\u5728{0}\u81f3{1}\u5df2\u505c\u6b62\u8003\u52e4\uff0c\u9700\u66f4\u65b0\u8003\u52e4\u7ed3\u679c\uff0c\u4f46\u8003\u52e4\u7ed3\u679c\u5df2\u9501\u5b9a\u81f3{2}\uff0c\u8bf7\u89e3\u9501\u6216\u89e3\u5c01\u540e\u91cd\u7b97\u66f4\u65b0\u3002", (String)"ClearAttHisDataService_0", (String)"wtc-wtes-business", (Object[])new Object[]{WTCDateUtils.toLocalDate((Date)exStartDate), WTCDateUtils.toLocalDate((Date)exEndDate), WTCDateUtils.toLocalDate((Date)lockToDate)}));
                continue;
            }
            try {
                this.doClearByAttFileBoId(fileBoid, exStartDate);
                this.updateWtteInfo(fileBoid, exStartDate);
            }
            catch (Exception ex) {
                exBoIdMap.put(fileBoid, ResManager.loadKDString((String)"\u8be5\u8003\u52e4\u6863\u6848\u5728{0}\u81f3{1}\u5df2\u505c\u6b62\u8003\u52e4\uff0c\u9700\u66f4\u65b0\u8003\u52e4\u7ed3\u679c\uff0c\u4f46\u672a\u66f4\u65b0\u6210\u529f\uff0c\u8bf7\u91cd\u7b97\u66f4\u65b0\u3002", (String)"ClearAttHisDataService_1", (String)"wtc-wtes-business", (Object[])new Object[]{WTCDateUtils.toLocalDate((Date)exStartDate), WTCDateUtils.toLocalDate((Date)exEndDate)}));
                logger.warn("cleanHisData error", (Throwable)ex);
            }
        }
        this.afterCleanExData(tieRequest, attStateInfoBOS);
        return exBoIdMap;
    }

    public void afterCleanExData(TieRequest tieRequest, List<AttStateInfoBO> attStateInfoBos) {
        WTCPluginProxyFactory.create(TieCleanExDataExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.persistent.clean.TieCleanExDataExtPlugin").invokeReplace(extPlugin -> {
            List attStateExtList = attStateInfoBos.stream().map(AttStateExtImpl::new).collect(Collectors.toList());
            AfterCleanExDataEvent afterCleanExDataEvent = new AfterCleanExDataEvent(attStateExtList, (TieRequestExt)new TieRequestExtImpl(tieRequest));
            extPlugin.afterCleanExData(afterCleanExDataEvent);
        });
    }

    private void updateWtteInfo(Long attFileBoId, Date exStartDate) {
        HashMap fileBoIdWtteDyMap = Maps.newHashMapWithExpectedSize((int)1);
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        map.put(ISINFOEXC, Boolean.FALSE);
        map.put("accountto", WTCDateUtils.addDays((Date)exStartDate, (int)-1));
        fileBoIdWtteDyMap.put(attFileBoId, map);
        AttStateInfoService.getInstance().updateExcInfoAndAccountTo((Map)fileBoIdWtteDyMap, Collections.singletonList(attFileBoId));
    }

    private void doClearByAttFileBoId(Long attFileBoId, Date startDate) {
        logger.debug("doClear attFileBoId->{},startDate->{}", (Object)attFileBoId, (Object)startDate);
        List<IDataPackageStoreService> storeServices = this.getStoreServices();
        for (IDataPackageStoreService service : storeServices) {
            service.deleteRecordByAttFileBoIdAfterErrorDate(attFileBoId, startDate);
        }
        QFilter qFilter1 = new QFilter("perperiodbegindate", ">=", (Object)startDate);
        QFilter qFilter2 = new QFilter("attfileid", "=", (Object)attFileBoId);
        Object[] periodTotal = attPeriodSummaryService.queryOriginalArray("id", new QFilter[]{qFilter1, qFilter2});
        attPeriodSummaryService.delete(periodTotal);
        List attMainIdList = Arrays.stream(periodTotal).map(ob -> ob.getLong("id")).collect(Collectors.toList());
        attPeriodDetailSummaryService.deleteByFilter(new QFilter[]{new QFilter("attmain", "in", attMainIdList)});
    }

    private List<IDataPackageStoreService> getStoreServices() {
        Object initialises;
        if (CollectionUtils.isEmpty(this.serviceList) && (initialises = WTCAppContextHelper.getProjectParams().get("tie.init.dataPackageStoreList")) != null) {
            List initializerList = (List)initialises;
            this.serviceList = initializerList.stream().map(initializerBeanName -> (IDataPackageStoreService)WTCAppContextHelper.getBean((String)initializerBeanName, IDataPackageStoreService.class)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(this.serviceList)) {
                return Collections.EMPTY_LIST;
            }
            return this.serviceList;
        }
        return this.serviceList;
    }
}

