/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtes.business.tie.init.logiccard.OnQueryInitParamOfLogicCardEvent;
import kd.sdk.wtc.wtes.business.tie.init.logiccard.TieInitEffectiveCardExtPlugin;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtes.business.service.ILogicCardQueryService;

public class LogicCardQueryServiceImpl
implements ILogicCardQueryService {
    private static final String SHIFTDATE = "shiftdate";
    private static final String QUERY_FIELD_MUTI = "attperson.id, shiftdate shiftbelongdate, entryentity.effectivepoint specifictime, entryentity.mustpoint worktime,entryentity.timezone timezone,entryentity.timezone.timedif timedif,entryentity.applyreason applyreason,entryentity.source source,entryentity.accesstag accesstag,entryentity.seq seq,shift";
    private static final String QUERY_FIELD_ONCE = "attperson.id, shiftdate shiftbelongdate, oncepoint specifictime, -1 worktime,timezone,timezone.timedif timedif,applyreason,source";
    private static final String QUERY_FIELD_EFFECTIVEPOINT = "entryentity.effectivepoint";
    private static final String QUERY_FIELD_ONCEPOINT = "oncepoint";
    private static final HRBaseServiceHelper MUTI_SEVICEHELPER = new HRBaseServiceHelper("wtpm_multicard");
    private static final HRBaseServiceHelper ONCE_SEVICEHELPER = new HRBaseServiceHelper("wtpm_oncecard");

    @Override
    public DynamicObject[] queryEffectiveMutiCard(List<Long> attPersonIds, Date checkBeginDate, Date checkEndDate, Set<String> extKeys) {
        QFilter universalQFilter = this.getUniversalQFilter(attPersonIds, checkBeginDate, checkEndDate);
        Set<String> selectProperties = Arrays.stream(WTCStringUtils.split((String)QUERY_FIELD_MUTI, (String)",")).map(WTCStringUtils::trim).collect(Collectors.toSet());
        this.invokeLogicCardInitExtPlugin(universalQFilter, selectProperties, extKeys, 2);
        DynamicObject[] mutiCardDys = MUTI_SEVICEHELPER.queryOriginalArray(WTCStringUtils.join(new ArrayList<String>(selectProperties), (String)","), new QFilter[]{universalQFilter});
        return mutiCardDys;
    }

    @Override
    public DynamicObject[] queryEffectiveOnceCard(List<Long> attPersonIds, Date checkBeginDate, Date checkEndDate, Set<String> extKeys) {
        QFilter universalQFilter = this.getUniversalQFilter(attPersonIds, checkBeginDate, checkEndDate);
        Set<String> selectProperties = Arrays.stream(WTCStringUtils.split((String)QUERY_FIELD_ONCE, (String)",")).map(WTCStringUtils::trim).collect(Collectors.toSet());
        this.invokeLogicCardInitExtPlugin(universalQFilter, selectProperties, extKeys, 1);
        DynamicObject[] onceCardDys = ONCE_SEVICEHELPER.queryOriginalArray(WTCStringUtils.join(new ArrayList<String>(selectProperties), (String)","), new QFilter[]{universalQFilter});
        return onceCardDys;
    }

    private QFilter getUniversalQFilter(List<Long> attPersonIds, Date checkBeginDate, Date checkEndDate) {
        QFilter attPersonQFilter = null != attPersonIds && attPersonIds.size() == 1 ? new QFilter("attperson", "=", (Object)attPersonIds.get(0)) : new QFilter("attperson", "in", attPersonIds);
        QFilter shiftDateQFilter = checkBeginDate.compareTo(checkEndDate) == 0 ? new QFilter(SHIFTDATE, "=", (Object)checkBeginDate) : new QFilter(SHIFTDATE, ">=", (Object)checkBeginDate).and(new QFilter(SHIFTDATE, "<=", (Object)checkEndDate));
        return shiftDateQFilter.and(attPersonQFilter);
    }

    private void invokeLogicCardInitExtPlugin(QFilter qFilter, Set<String> propertiesSet, Set<String> extKeys, int cardFlag) {
        WTCPluginProxy tieInitParamExtPluginProxy = WTCPluginProxyFactory.create(TieInitEffectiveCardExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.init.logiccard.TieInitEffectiveCardExtPlugin");
        tieInitParamExtPluginProxy.invokeReplace(plugin -> {
            OnQueryInitParamOfLogicCardEvent event = new OnQueryInitParamOfLogicCardEvent(qFilter);
            if (1 == cardFlag) {
                plugin.onQueryOnceEffectiveCard(event);
            } else if (2 == cardFlag) {
                plugin.onQueryMultiEffectiveCard(event);
            }
            if (WTCCollections.isNotEmpty((Collection)event.getExtKeys())) {
                extKeys.addAll(event.getExtKeys());
                propertiesSet.addAll(extKeys);
            }
        });
    }
}

