/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.wtc.wtbs.common.model.evaluation.Round;
import kd.wtc.wtbs.common.model.evaluation.RoundWrapper;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.init.cache.TieInitializerCache;
import kd.wtc.wtes.business.service.IRoundService;

public class RoundServiceImpl
implements IRoundService {
    private static String ROUND_HASH_KEY = "roundHashKey";
    private static String ROUND_MAP_KEY = "roundMapKey";

    @Override
    public Map<Long, RoundWrapper> queryAllRoundRule() {
        Map roundDyMap = BusinessDataServiceHelper.loadFromCache((String)"wtbd_roundrule", (QFilter[])new QFilter[0]);
        int dyHashCode = roundDyMap.hashCode();
        Object odHashCode = TieInitializerCache.ROUNDMAP.get(ROUND_HASH_KEY);
        if (odHashCode != null && dyHashCode == (Integer)odHashCode) {
            return (Map)TieInitializerCache.ROUNDMAP.get(ROUND_MAP_KEY);
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)roundDyMap.size());
        for (Map.Entry entry : roundDyMap.entrySet()) {
            DynamicObject roundDy = (DynamicObject)entry.getValue();
            RoundWrapper roundWrapper = new RoundWrapper();
            DynamicObjectCollection entryDys = roundDy.getDynamicObjectCollection("entryentity");
            ArrayList roundList = Lists.newArrayListWithCapacity((int)entryDys.size());
            for (DynamicObject entryDy : entryDys) {
                Round round = new Round();
                round.setLowerLimitValue(entryDy.getBigDecimal("lowerlimitvalue"));
                round.setContainLower(entryDy.getBoolean("containlower"));
                round.setUpperLimitValue(entryDy.getBigDecimal("upperlimitvalue"));
                round.setContainUpper(entryDy.getBoolean("containupper"));
                round.setOriginValue(entryDy.getBoolean("isoriginvalue"));
                round.setTargetValue(entryDy.getBigDecimal("targetvalue"));
                round.setCirculate(entryDy.getBoolean("circulate"));
                roundList.add(round);
            }
            roundWrapper.setId(Long.valueOf(roundDy.getLong("id")));
            roundWrapper.setRoundList((List)roundList);
            roundWrapper.setSettingMode(roundDy.getString("settingmode"));
            roundWrapper.setFunctionMode(roundDy.getString("function"));
            roundWrapper.setAccuracy(Integer.valueOf(roundDy.getInt("accuracy")));
            map.put(roundDy.getLong("id"), roundWrapper);
        }
        TieInitializerCache.ROUNDMAP.put(ROUND_HASH_KEY, dyHashCode);
        TieInitializerCache.ROUNDMAP.put(ROUND_MAP_KEY, map);
        return map;
    }
}

