/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service.impl;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.wtc.wtbs.business.timeseq.TimeSeqAvailableBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.executor.common.InitHelper;
import kd.wtc.wtes.business.init.IAttFilePlan;
import kd.wtc.wtes.business.model.rlad.AdPlanPackage;
import kd.wtc.wtes.business.model.rlad.AdRulePackage;
import kd.wtc.wtes.business.model.util.AdEntityUtils;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttFileAdPlanImpl
implements IAttFilePlan {
    private static final Log LOG = LogFactory.getLog(AttFileAdPlanImpl.class);

    public Map<Long, TimeSeqBo<AdPlanPackage>> getAttFilePlanSeq(Set<Long> fileEntryIds, InitParam initRequest) {
        LocalDate startDate = initRequest.getStartDate();
        LocalDate endDate = initRequest.getEndDate();
        LOG.debug("AttFileAdPlanImpl.getAttFilePlanSeq begin");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)fileEntryIds.size());
        DynamicObject[] adPlanArr = InitHelper.getHisDyArr(AttFilePlanEnum.AD.getEntityNumber(), fileEntryIds, startDate, endDate);
        Map<Long, List<DynamicObject>> planMap = Arrays.stream(adPlanArr).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        Set<Long> ruleIdList = this.getAdRuleIdList(adPlanArr);
        DynamicObject[] adRuleHisArr = InitHelper.getHisDyArr("wtp_supplerule", ruleIdList, startDate, endDate);
        Map<Long, List<DynamicObject>> ruleHisMap = Arrays.stream(adRuleHisArr).collect(Collectors.groupingBy(info -> info.getLong("boid")));
        for (Long planId : fileEntryIds) {
            List<DynamicObject> adPlanList = planMap.get(planId);
            if (!CollectionUtils.isNotEmpty(adPlanList)) continue;
            List<AdPlanPackage> attFilePlanPackageList = this.getPlanList(adPlanList, ruleHisMap);
            resultMap.put(planId, new TimeSeqAvailableBo(attFilePlanPackageList));
        }
        return resultMap;
    }

    private List<AdPlanPackage> getPlanList(List<DynamicObject> adPlanList, Map<Long, List<DynamicObject>> ruleHisMap) {
        ArrayList planHis = Lists.newArrayListWithExpectedSize((int)adPlanList.size());
        for (DynamicObject planDy : adPlanList) {
            boolean isDirectRule = this.isDirectRule(planDy);
            TimeSeqAvailableBo<AdRulePackage> ruleBoVersionList = null;
            if (isDirectRule) {
                Long ruleBoId = HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)planDy, (String)"rule");
                ruleBoVersionList = AdEntityUtils.getRule(ruleBoId, ruleHisMap);
            }
            TimeSeqInfoImpl timeSeqEntity = TimeSeqEntityGenerateUtils.getTimeSeqEntity(planDy);
            long planId = planDy.getLong("id");
            String number = planDy.getString("number");
            AdPlanPackage adPlanPackage = new AdPlanPackage(planId, number, (TimeSeqInfo)timeSeqEntity, ruleBoVersionList, isDirectRule);
            planHis.add(adPlanPackage);
        }
        return planHis;
    }

    private Set<Long> getAdRuleIdList(DynamicObject[] adPlanArr) {
        if (adPlanArr == null || adPlanArr.length == 0) {
            return new HashSet<Long>(0);
        }
        HashSet ruleIdSet = Sets.newHashSetWithExpectedSize((int)adPlanArr.length);
        for (DynamicObject planDy : adPlanArr) {
            if (!this.isDirectRule(planDy)) continue;
            ruleIdSet.add(HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)planDy, (String)"rule"));
        }
        return ruleIdSet;
    }

    private boolean isDirectRule(DynamicObject planDy) {
        return "1".equals(planDy.getString("ruletype"));
    }
}

