/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.service.impl;

import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.wtc.wtbs.common.access.ConditionDtoExt;
import kd.sdk.wtc.wtbs.common.enums.RefDateType;
import kd.sdk.wtc.wtbs.common.enums.WTCDateRangeSource;
import kd.sdk.wtc.wtes.business.timecut.OnTimeCutMatchEvent;
import kd.sdk.wtc.wtes.business.timecut.TimeCutMatchExtPlugin;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.rulecondition.RuleConditionValues;
import kd.wtc.wtbs.business.rulecondition.bill.RuleConditionCommonService;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.ext.utils.ContextExtUtil;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTable;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.access.ConditionDtoExtBridge;
import kd.wtc.wtes.business.service.impl.DateRangeServiceImpl;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.util.BillTieRetrievalUtil;

public class DateRangeEnhancedServiceImpl
extends DateRangeServiceImpl {
    private static final Log logger = LogFactory.getLog(DateRangeEnhancedServiceImpl.class);
    private static final Set<String> SUPPORTED_SCENE = Sets.newHashSet((Object[])new String[]{"dateattribute", "datetype"});

    public boolean matchShiftCondition(WTCDateRangeSource wtcDateRangeSource, AccessDto accessDto, TieContextStd context, RefDateType refDateType) {
        return this.matchShiftCondition(wtcDateRangeSource, accessDto, context, refDateType, null);
    }

    public boolean matchShiftCondition(WTCDateRangeSource wtcDateRangeSource, AccessDto accessDto, TieContextStd context, RefDateType refDateType, RuleConditionValues retrievalDimension) {
        if (accessDto == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5339\u914d\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DateRangeEnhancedServiceImpl_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        if (context == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587\u5bf9\u8c61\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\u3002", (String)"DateRangeEnhancedServiceImpl_1", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        ShiftTable shiftTable = context.getInitParamMust("ROSTER", ShiftTable.class);
        if (shiftTable == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587\u5bf9\u8c61context\u7f3a\u5931\u6392\u73ed\u6570\u636e\u3002", (String)"DateRangeEnhancedServiceImpl_2", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        ShiftTableSingle shiftTableSingle = shiftTable.getByAttPersonId(context.getAttPersonId());
        if (shiftTableSingle == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587\u5bf9\u8c61context\u7f3a\u5931\u6392\u73ed\u6570\u636e\u3002", (String)"DateRangeEnhancedServiceImpl_3", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        LocalDate calDate = null;
        LocalDate chainDate = context.getChainDate();
        if (refDateType == RefDateType.TODAY) {
            calDate = chainDate;
        } else if (refDateType == RefDateType.NEXT_DAY) {
            calDate = chainDate.plusDays(1L);
        } else if (refDateType == RefDateType.PREV_DAY) {
            calDate = chainDate.plusDays(-1L);
        }
        if (calDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5904\u7406\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DateRangeEnhancedServiceImpl_4", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        List<kd.wtc.wtes.business.model.access.ConditionDto> conditionList = accessDto.getConditionList();
        if (CollectionUtils.isEmpty(conditionList)) {
            return true;
        }
        HashMap<String, Boolean> matchResult = new HashMap<String, Boolean>(16);
        WTCPluginProxy plugin = WTCPluginProxyFactory.create(TimeCutMatchExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.timecut.TimeCutMatchExtPlugin");
        for (kd.wtc.wtes.business.model.access.ConditionDto dto : conditionList) {
            String matchKey;
            String retrievalWay = dto.getRetrievalWay();
            if (HRStringUtils.isNotEmpty((String)retrievalWay) && "1".equals(retrievalWay)) {
                ConditionDto conditionDto = BillTieRetrievalUtil.wtesDtoToWtbsDto(dto);
                RuleConditionCommonService.configItemRetrieval((ConditionDto)conditionDto, matchResult, (RuleConditionValues)retrievalDimension);
                continue;
            }
            String param = dto.getParam();
            String paramType = dto.getParamType();
            if (HRStringUtils.equals((String)paramType, (String)"dynamicObject")) {
                param = param.replace(".id", "");
            }
            if (SUPPORTED_SCENE.contains(matchKey = param.substring(param.lastIndexOf(46) + 1))) {
                String shiftMatchInfo = this.getShiftMatchInfo(matchKey, shiftTableSingle, calDate);
                DateRangeEnhancedServiceImpl.putMap(dto, shiftMatchInfo, matchResult);
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)plugin.getPlugins())) {
                OnTimeCutMatchEvent onTimeCutMatchEvent = new OnTimeCutMatchEvent(ContextExtUtil.getTieContextExt(context), refDateType, (ConditionDtoExt)new ConditionDtoExtBridge(dto), wtcDateRangeSource);
                plugin.invokeReplace(service -> service.onTimeCutMatch(onTimeCutMatchEvent));
                if (onTimeCutMatchEvent.getResult() == null) continue;
                matchResult.put(dto.getName(), onTimeCutMatchEvent.getResult());
                continue;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u65f6\u6bb5\u5207\u5206\u4e0d\u652f\u6301\u7684\u573a\u666f\u3002", (String)"DateRangeEnhancedServiceImpl_5", (String)"wtc-wtes-business", (Object[])new Object[0]));
        }
        String conditionExpressStr = accessDto.getConditionExpressStr();
        return DateRangeEnhancedServiceImpl.getResult(conditionExpressStr, matchResult);
    }

    private String getShiftMatchInfo(String matchKey, ShiftTableSingle shiftTableSingle, LocalDate date) {
        ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(date);
        switch (matchKey) {
            case "dateattribute": {
                DateAttribute dateAttribute = shiftTableSingle.getDateAttribute(date);
                if (dateAttribute == null) {
                    logger.warn("DateRangeEnhancedServiceImpl_dateattribute \u65e0\u6392\u73ed\u7684dateattribute");
                    return "";
                }
                return dateAttribute.getCode();
            }
            case "datetype": {
                DateType dateType = shiftTableSingle.getDateType(date);
                if (dateType == null) {
                    logger.warn("DateRangeEnhancedServiceImpl_datetype \u65e0\u6392\u73ed\u7684datetype");
                    return "";
                }
                return String.valueOf(dateType.getId());
            }
        }
        return "";
    }
}

