/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.std;

import java.time.LocalDate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.core.exporter.ITieExporter;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.TieEngineState;
import kd.wtc.wtes.business.model.TieLineState;

public abstract class AbstractTieExporter
implements ITieExporter {
    private long firstStartTime = 0L;
    private long elapsedInNano;
    private long stateChangedElapsedInNano;
    private Map<Long, AttSubject> attSubjectMap;
    private Map<String, Object> initParams;
    private Set<Long> epRelDiscardAttFileBoIds;

    @Override
    public void finishOneLine(AttSubject attSubject) {
        if (this.firstStartTime == 0L) {
            this.firstStartTime = System.currentTimeMillis();
        }
        long sTime = System.nanoTime();
        this.finishOneSubject(attSubject);
        this.elapsedInNano += System.nanoTime() - sTime;
    }

    protected abstract void finishOneSubject(AttSubject var1);

    @Override
    public void errorOneLine(AttSubject attSubject) {
        if (this.firstStartTime == 0L) {
            this.firstStartTime = System.currentTimeMillis();
        }
        long sTime = System.nanoTime();
        this.errorOneSubject(attSubject);
        this.elapsedInNano += System.nanoTime() - sTime;
    }

    protected abstract void errorOneSubject(AttSubject var1);

    @Override
    public void stateChanged(TieState oldState, TieState newState) {
        if (this.firstStartTime == 0L) {
            this.firstStartTime = System.currentTimeMillis();
        }
        long sTime = System.nanoTime();
        this.afterStateChanged(oldState, newState);
        this.stateChangedElapsedInNano += System.nanoTime() - sTime;
    }

    protected abstract void afterStateChanged(TieState var1, TieState var2);

    public abstract void pushSubjectErrorMsg(Long var1, String var2);

    public abstract TieEngineState getEngineState();

    public abstract void addCacheLine(TieLineState var1, TieState var2);

    @Override
    public void setAttSubjects(List<AttSubject> attSubjects) {
        this.attSubjectMap = WTCCollections.isEmpty(attSubjects) ? Collections.emptyMap() : attSubjects.stream().collect(Collectors.toMap(AttSubject::getAttPersonId, Function.identity()));
    }

    @Override
    public void setInitMap(Map<String, Object> initParams) {
        this.initParams = initParams;
        this.epRelDiscardAttFileBoIds = this.initDiscardEpRelBoIds();
    }

    private Set<Long> initDiscardEpRelBoIds() {
        HashSet attFileBoIds = Sets.newHashSetWithExpectedSize((int)10);
        AttFileCabinet attFileCabinet = (AttFileCabinet)this.initParams.get("ATT_FILE");
        Map<Long, List<TimeSeqBo<AttFileModel>>> attFileTimeSeqBoMap = attFileCabinet.getAttFileTimeSeqBoMap();
        for (List<TimeSeqBo<AttFileModel>> value : attFileTimeSeqBoMap.values()) {
            for (TimeSeqBo<AttFileModel> attFileSeq : value) {
                for (AttFileModel attFileModel : attFileSeq.getVersions()) {
                    if (!attFileModel.epRelStatusDiscard() || !this.isOverlap(attFileModel)) continue;
                    attFileBoIds.add(attFileModel.getTimeSeqInfo().getBid());
                }
            }
        }
        return attFileBoIds;
    }

    protected Set<Long> getEpRelDiscardAttFileBoIds() {
        return this.epRelDiscardAttFileBoIds;
    }

    private boolean isOverlap(AttFileModel attFileModel) {
        AttSubject attSubject = this.attSubjectMap.get(attFileModel.getAttPersonId());
        if (null == attSubject) {
            return false;
        }
        LocalDate bsed = attFileModel.getTimeSeqInfo().getBsed();
        LocalDate blsed = attFileModel.getTimeSeqInfo().getBlsed();
        LocalDate startDate = attSubject.getStartDate();
        LocalDate endDate = attSubject.getEndDate();
        return !blsed.isBefore(startDate) && !endDate.isBefore(bsed);
    }
}

