/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.std.datanode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kd.wtc.wtbs.business.IEntity;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.model.EvaluationRuleModel;
import kd.wtc.wtes.business.std.datanode.ITieDataNodeExt;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.common.lang.TypeCloneable;
import kd.wtc.wtes.common.lang.WtesException;
import kd.wtc.wtes.common.util.Assert;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.LabelSet;

public abstract class TieDataNode
implements ITieDataNodeExt<TieDataNodeStd>,
TypeCloneable<TieDataNode> {
    private List<TieDataNodeStd> parentDataNodes = new LinkedList<TieDataNodeStd>();
    private EvaluationRuleModel evaluationRule;
    private LabelSet<ILabel> labelSet = new LabelSet();
    private IEntity matchedRule;

    protected TieDataNode() {
    }

    @Override
    public EvaluationRuleModel getEvaluationRule() {
        return this.evaluationRule;
    }

    public void setEvaluationRule(EvaluationRuleModel evaluationRule) {
        this.evaluationRule = evaluationRule;
    }

    @Override
    public List<TieDataNodeStd> parentDataNodes() {
        return this.parentDataNodes;
    }

    public void setParentDataNodes(List<TieDataNodeStd> parentDataNodes) {
        this.parentDataNodes = parentDataNodes;
    }

    @Override
    public LabelSet<ILabel> getLabelSet() {
        return this.labelSet;
    }

    public void setLabelSet(LabelSet<ILabel> labelSet) {
        this.labelSet = labelSet;
    }

    @Override
    public IEntity getMatchedRule() {
        return this.matchedRule;
    }

    public void setMatchedRule(IEntity matchedRule) {
        this.matchedRule = matchedRule;
    }

    public String toString() {
        return "TieDataNode{parentDataNodeIds=" + Arrays.toString(this.getParentIds()) + ", evaluationRule=" + this.evaluationRule + ", labelSet=" + this.labelSet + '}';
    }

    public TieDataNode clone() {
        try {
            return (TieDataNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new WtesException((Throwable)e);
        }
    }

    protected static <T> List<T> copy(Collection<T> tCollection) {
        if (tCollection == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(tCollection);
    }

    protected static abstract class Builder<E extends TieDataNode, B extends Builder<E, B>>
    extends CleanableBuilder<E, B> {
        protected TieDataNode dataNode;

        protected Builder(E dataNode) {
            Assert.nonNull(dataNode, (String)"dataNode");
            this.dataNode = dataNode;
        }

        public B appendParentDataNode(TieDataNodeStd parentDataNode) {
            this.dataNode.parentDataNodes.add(parentDataNode);
            return (B)((Builder)this.self());
        }

        public B appendAllParentDataNodes(Collection<TieDataNodeStd> parentDataNodes) {
            this.dataNode.parentDataNodes.addAll(parentDataNodes);
            return (B)((Builder)this.self());
        }

        public B parentDataNodes(Collection<TieDataNodeStd> parentDataNodes) {
            this.dataNode.parentDataNodes = new ArrayList<TieDataNodeStd>(parentDataNodes);
            return (B)((Builder)this.self());
        }

        public B clearParentDataNodes() {
            this.dataNode.parentDataNodes.clear();
            return (B)((Builder)this.self());
        }

        public B evaluationRule(EvaluationRuleModel evaluationRule) {
            this.dataNode.evaluationRule = evaluationRule;
            return (B)((Builder)this.self());
        }

        public B addLabel(ILabel label) {
            this.dataNode.labelSet.add(label);
            return (B)((Builder)this.self());
        }

        public B addAllLabels(Collection<? extends ILabel> labels) {
            this.dataNode.labelSet.addAll(labels);
            return (B)((Builder)this.self());
        }

        public B matchedRule(IEntity matchedRule) {
            this.dataNode.matchedRule = matchedRule;
            return (B)((Builder)this.self());
        }

        @Override
        protected void clear() {
            this.dataNode = null;
        }
    }
}

