/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.std.datanode;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtes.business.model.AbsenceBillState;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.TravelBillState;
import kd.wtc.wtes.business.model.rlra.AttendanceBillTag;
import kd.wtc.wtes.business.model.rlra.CardExceptionTypeEnum;
import kd.wtc.wtes.business.model.rlra.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtes.business.model.rlra.TimeBucketPositionEnum;
import kd.wtc.wtes.business.model.rlra.TimeBucketPunchCardRelationEnum;
import kd.wtc.wtes.business.std.datanode.ITimeBucket;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.common.pairtime.SourceCode;
import kd.wtc.wtes.common.pairtime.TimePointSource;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.LabelSet;

public class TimeBucket
extends TieDataNode
implements ITimeBucket {
    private LocalDate originalDate;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private List<AttItemInstance> attItemInstances = Collections.emptyList();
    private int timeIntervalInSeconds;
    private Long shiftTimeBucketSeqId;
    private SourceCode startTimePointSource;
    private SourceCode endTimePointSource;
    private AttendanceBillTag attendanceBillTag;
    private ShiftTimeBucketPropertyEnum shiftTimeBucketProperty;
    private TimeBucketPositionEnum timeBucketPosition;
    private TimeBucketPunchCardRelationEnum timeBucketPunchCardRelation;
    private List<String> attendanceStatusList;
    private List<String> timeBucketLabelList;
    private String punchCardTag;
    private DateType dateType;
    private DateAttribute dateAttribute;
    private Roster roster;
    private String absenceBillState;
    private String travelBillState;
    private String attMode;
    private CardExceptionTypeEnum cardExceptionType;
    private Long shouldPunchCardSeqId;

    public Builder<?, ?> toBuilder() {
        return new TimeBucketBuilder(this);
    }

    public static Builder<?, ?> builder() {
        return new TimeBucketBuilder(new TimeBucket());
    }

    @Override
    public TimeBucket clone() {
        TimeBucket clone = (TimeBucket)super.clone();
        clone.attendanceStatusList = TimeBucket.copy(this.attendanceStatusList);
        clone.attItemInstances = TimeBucket.copy(this.attItemInstances);
        clone.timeBucketLabelList = TimeBucket.copy(this.timeBucketLabelList);
        clone.setLabelSet((LabelSet<ILabel>)new LabelSet(this.getLabelSet()));
        clone.setParentDataNodes(new ArrayList<TieDataNodeStd>(1));
        return clone;
    }

    @Override
    public Roster getRoster() {
        return this.roster;
    }

    public void setRoster(Roster roster) {
        this.roster = roster;
    }

    @Override
    public LocalDate getOriginalDate() {
        return this.originalDate;
    }

    @Override
    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    @Override
    public List<AttItemInstance> getAttItemInstances() {
        return this.attItemInstances;
    }

    @Override
    public String getDataNodeCategory() {
        return "tb";
    }

    @Override
    public int getTimeIntervalInSeconds() {
        return this.timeIntervalInSeconds;
    }

    @Override
    public Long getShiftTimeBucketSeqId() {
        return this.shiftTimeBucketSeqId;
    }

    @Override
    public Long getShouldPunchCardSeqId() {
        return this.shouldPunchCardSeqId;
    }

    @Override
    public SourceCode getStartTimePointSource() {
        return this.startTimePointSource;
    }

    @Override
    public SourceCode getEndTimePointSource() {
        return this.endTimePointSource;
    }

    @Override
    public AttendanceBillTag getAttendanceBillTag() {
        return this.attendanceBillTag;
    }

    @Override
    public ShiftTimeBucketPropertyEnum getShiftTimeBucketProperty() {
        return this.shiftTimeBucketProperty;
    }

    @Override
    public TimeBucketPositionEnum getTimeBucketPosition() {
        return this.timeBucketPosition;
    }

    @Override
    public TimeBucketPunchCardRelationEnum getTimeBucketPunchCardRelation() {
        return this.timeBucketPunchCardRelation;
    }

    @Override
    public List<String> getAttendanceStatuses() {
        return this.attendanceStatusList;
    }

    @Override
    public List<String> getTimeBucketLabels() {
        return this.timeBucketLabelList;
    }

    @Override
    public String getPunchCardTag() {
        return this.punchCardTag;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public void setAttItemInstances(List<AttItemInstance> attItemInstances) {
        this.attItemInstances = attItemInstances;
    }

    public void setTimeIntervalInSeconds(int timeIntervalInSeconds) {
        this.timeIntervalInSeconds = timeIntervalInSeconds;
    }

    public void setStartTimePointSource(SourceCode startTimePointSource) {
        this.startTimePointSource = startTimePointSource;
    }

    public void setEndTimePointSource(SourceCode endTimePointSource) {
        this.endTimePointSource = endTimePointSource;
    }

    public void setAttendanceBillTag(AttendanceBillTag attendanceBillTag) {
        this.attendanceBillTag = attendanceBillTag;
    }

    public void setShiftTimeBucketProperty(ShiftTimeBucketPropertyEnum shiftTimeBucketProperty) {
        this.shiftTimeBucketProperty = shiftTimeBucketProperty;
    }

    public void setTimeBucketPosition(TimeBucketPositionEnum timeBucketPosition) {
        this.timeBucketPosition = timeBucketPosition;
    }

    public void setTimeBucketPunchCardRelation(TimeBucketPunchCardRelationEnum timeBucketPunchCardRelation) {
        this.timeBucketPunchCardRelation = timeBucketPunchCardRelation;
    }

    public void setAttendanceStatusList(List<String> attendanceStatusList) {
        this.attendanceStatusList = attendanceStatusList;
    }

    public void setTimeBucketLabelList(List<String> timeBucketLabelList) {
        this.timeBucketLabelList = timeBucketLabelList;
    }

    public void setPunchCardTag(String punchCardTag) {
        this.punchCardTag = punchCardTag;
    }

    public void setDateType(DateType dateType) {
        this.dateType = dateType;
    }

    public void setDateAttribute(DateAttribute dateAttribute) {
        this.dateAttribute = dateAttribute;
    }

    @Override
    public DateType getDateType() {
        return this.dateType;
    }

    @Override
    public DateAttribute getDateAttribute() {
        return this.dateAttribute;
    }

    @Override
    public List<String> getAttendanceStatusList() {
        return this.attendanceStatusList;
    }

    @Override
    public List<String> getTimeBucketLabelList() {
        return this.timeBucketLabelList;
    }

    @Override
    public String getAbsenceBillState() {
        return this.absenceBillState;
    }

    @Override
    public String getTravelBillState() {
        return this.travelBillState;
    }

    @Override
    public String getAttMode() {
        return this.attMode;
    }

    @Override
    public CardExceptionTypeEnum getCardExceptionType() {
        return this.cardExceptionType;
    }

    public void setAbsenceBillState(String absenceBillState) {
        this.absenceBillState = absenceBillState;
    }

    public void setTravelBillState(String travelBillState) {
        this.travelBillState = travelBillState;
    }

    public void setAttMode(String attMode) {
        this.attMode = attMode;
    }

    public void setCardExceptionType(CardExceptionTypeEnum cardExceptionType) {
        this.cardExceptionType = cardExceptionType;
    }

    @Override
    public String toString() {
        return "TimeBucket{startTime=" + this.startTime + ", endTime=" + this.endTime + ", attItemInstances=" + this.attItemInstances + ", timeIntervalInSeconds=" + this.timeIntervalInSeconds + ", startTimePointSource=" + this.startTimePointSource + ", endTimePointSource=" + this.endTimePointSource + ", attendanceBillTag=" + this.attendanceBillTag + ", shiftTimeBucketProperty=" + (Object)((Object)this.shiftTimeBucketProperty) + ", timeBucketPosition=" + (Object)((Object)this.timeBucketPosition) + ", timeBucketPunchCardRelation=" + (Object)((Object)this.timeBucketPunchCardRelation) + ", attendanceStatusList=" + this.attendanceStatusList + ", timeBucketLabelList=" + this.timeBucketLabelList + ", punchCardTag='" + this.punchCardTag + '\'' + ", dateType=" + this.dateType + ", dateAttribute=" + this.dateAttribute + ", roster=" + this.roster + ", absenceBillState='" + this.absenceBillState + '\'' + ", travelBillState='" + this.travelBillState + '\'' + ", attMode='" + this.attMode + '\'' + ", originalDate='" + this.originalDate + '\'' + ", cardExceptionType='" + (Object)((Object)this.cardExceptionType) + '\'' + '}';
    }

    @Override
    public LocalDate getShiftDate() {
        return this.getRoster().getRosterDate();
    }

    @Override
    public ShiftSpec getShiftSpec() {
        return this.getRoster().getShiftSpec();
    }

    @Override
    public boolean isNonTime() {
        return this.startTime == null || this.endTime == null;
    }

    public int getDurationOfSecond() {
        if (this.isNonTime()) {
            return this.timeIntervalInSeconds;
        }
        Duration between = Duration.between(this.startTime, this.endTime);
        this.timeIntervalInSeconds = (int)between.getSeconds();
        return this.timeIntervalInSeconds;
    }

    public BigDecimal getDurationOfDay() {
        if (this.getShiftSpec() == null) {
            return BigDecimal.ZERO;
        }
        return this.getShiftSpec().secondsToDays(this.getDurationOfSecond());
    }

    private static class TimeBucketBuilder
    extends Builder<TimeBucket, TimeBucketBuilder> {
        protected TimeBucketBuilder(TimeBucket dataNode) {
            super(dataNode);
        }

        @Override
        protected TimeBucketBuilder self() {
            return this;
        }

        @Override
        protected TimeBucket building() {
            return this.timeBucket;
        }

        @Override
        protected void clear() {
            super.clear();
            this.timeBucket = null;
        }
    }

    public static abstract class Builder<E extends TimeBucket, B extends Builder<E, B>>
    extends TieDataNode.Builder<E, B> {
        protected TimeBucket timeBucket;
        protected TimePointSource startTimePointSource;
        protected TimePointSource endTimePointSource;
        protected AbsenceBillState absenceBillState;
        protected TravelBillState travelBillState;

        protected Builder(E dataNode) {
            super(dataNode);
            this.timeBucket = dataNode;
        }

        public TimeBucket buildForRaw() {
            TimeBucket build = (TimeBucket)super.build();
            build.startTimePointSource = this.startTimePointSource.getSourceCode();
            build.endTimePointSource = this.endTimePointSource.getSourceCode();
            build.absenceBillState = this.absenceBillState.getBillState();
            build.travelBillState = this.travelBillState.getBillState();
            return build;
        }

        public B originalDate(LocalDate originalDate) {
            this.timeBucket.originalDate = originalDate;
            return (B)((Builder)this.self());
        }

        public B startTime(LocalDateTime startTime) {
            this.timeBucket.startTime = startTime;
            return (B)((Builder)this.self());
        }

        public B endTime(LocalDateTime endTime) {
            this.timeBucket.endTime = endTime;
            return (B)((Builder)this.self());
        }

        public B attItemInstances(List<AttItemInstance> attItemInstances) {
            this.timeBucket.attItemInstances = attItemInstances;
            return (B)((Builder)this.self());
        }

        public B clearItemInstances() {
            this.timeBucket.attItemInstances = null;
            return (B)((Builder)this.self());
        }

        public B timeIntervalInSeconds(int timeIntervalInSeconds) {
            this.timeBucket.timeIntervalInSeconds = timeIntervalInSeconds;
            return (B)((Builder)this.self());
        }

        public B shiftTimeBucketSeqId(Long timeSeqId) {
            this.timeBucket.shiftTimeBucketSeqId = timeSeqId;
            return (B)((Builder)this.self());
        }

        public B shouldPunchCardSeqId(Long shouldPunchCardSeqId) {
            this.timeBucket.shouldPunchCardSeqId = shouldPunchCardSeqId;
            return (B)((Builder)this.self());
        }

        public B startTimePointSource(SourceCode startTimePointSource) {
            this.timeBucket.startTimePointSource = startTimePointSource;
            return (B)((Builder)this.self());
        }

        public B startTimePointSourceToBuilder(TimePointSource startTimePointSource) {
            ((Builder)this.self()).startTimePointSource = startTimePointSource;
            return (B)((Builder)this.self());
        }

        public B endTimePointSource(SourceCode endTimePointSource) {
            this.timeBucket.endTimePointSource = endTimePointSource;
            return (B)((Builder)this.self());
        }

        public B endTimePointSourceToBuilder(TimePointSource endTimePointSource) {
            ((Builder)this.self()).endTimePointSource = endTimePointSource;
            return (B)((Builder)this.self());
        }

        public B attendanceBillTag(AttendanceBillTag attendanceBillTag) {
            this.timeBucket.attendanceBillTag = attendanceBillTag;
            return (B)((Builder)this.self());
        }

        public B shiftTimeBucketProperty(ShiftTimeBucketPropertyEnum shiftTimeBucketProperty) {
            this.timeBucket.shiftTimeBucketProperty = shiftTimeBucketProperty;
            return (B)((Builder)this.self());
        }

        public B timeBucketPosition(TimeBucketPositionEnum timeBucketPosition) {
            this.timeBucket.timeBucketPosition = timeBucketPosition;
            return (B)((Builder)this.self());
        }

        public B timeBucketPunchCardRelation(TimeBucketPunchCardRelationEnum timeBucketPunchCardRelation) {
            this.timeBucket.timeBucketPunchCardRelation = timeBucketPunchCardRelation;
            return (B)((Builder)this.self());
        }

        public B attendanceStatusList(List<String> attendanceStatusList) {
            this.timeBucket.attendanceStatusList = attendanceStatusList;
            return (B)((Builder)this.self());
        }

        public B timeBucketLabelList(List<String> timeBucketLabelList) {
            this.timeBucket.timeBucketLabelList = timeBucketLabelList;
            return (B)((Builder)this.self());
        }

        public B punchCardTag(String punchCardTag) {
            this.timeBucket.punchCardTag = punchCardTag;
            return (B)((Builder)this.self());
        }

        public B dateType(DateType dateType) {
            this.timeBucket.dateType = dateType;
            return (B)((Builder)this.self());
        }

        public B dateAttribute(DateAttribute dateAttribute) {
            this.timeBucket.dateAttribute = dateAttribute;
            return (B)((Builder)this.self());
        }

        public B roster(Roster roster) {
            this.timeBucket.roster = roster;
            return (B)((Builder)this.self());
        }

        public B absenceBillStateToBuilder(AbsenceBillState absenceBillState) {
            ((Builder)this.self()).absenceBillState = absenceBillState;
            return (B)((Builder)this.self());
        }

        public B travelBillStateToBuilder(TravelBillState travelBillState) {
            ((Builder)this.self()).travelBillState = travelBillState;
            return (B)((Builder)this.self());
        }

        public B attMode(String attMode) {
            this.timeBucket.attMode = attMode;
            return (B)((Builder)this.self());
        }

        public B cardExceptionType(CardExceptionTypeEnum cardExceptionType) {
            this.timeBucket.cardExceptionType = cardExceptionType;
            return (B)((Builder)this.self());
        }

        public TimeBucketPositionEnum getTimeBucketPosition() {
            return this.timeBucket.timeBucketPosition;
        }

        public AttendanceBillTag getAttendanceBillTag() {
            return this.timeBucket.attendanceBillTag;
        }

        public ShiftTimeBucketPropertyEnum getShiftTimeBucketProperty() {
            return this.timeBucket.shiftTimeBucketProperty;
        }

        public CardExceptionTypeEnum getCardExceptionType() {
            return this.timeBucket.cardExceptionType;
        }

        public TimeBucketPunchCardRelationEnum getTimeBucketPunchCardRelation() {
            return this.timeBucket.timeBucketPunchCardRelation;
        }
    }
}

