/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.std.engine;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.wtc.wtbs.business.report.TieReportKDStrings;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.task.concurrencyctrl.TaskConcurrencyCtrlHelper;
import kd.wtc.wtbs.business.task.enums.TaskCategoryEnum;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.common.log.WTCLogFactory;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.core.engine.TieEngineCallbackEvent;
import kd.wtc.wtes.business.core.engine.TieEngineCompletedCallback;
import kd.wtc.wtes.business.storage.countmsg.CountMsgObject;
import kd.wtc.wtes.business.storage.countmsg.CountMsgProducer;

public class EngineCallbackExecutor
implements TieEngineCompletedCallback {
    private List<TieEngineCompletedCallback> terminatedCallbackList;
    private static final Log log = WTCLogFactory.getLog(EngineCallbackExecutor.class);

    public EngineCallbackExecutor() {
    }

    public List<TieEngineCompletedCallback> getTerminatedCallbackList() {
        return this.terminatedCallbackList;
    }

    public void setTerminatedCallbackList(List<TieEngineCompletedCallback> terminatedCallbackList) {
        this.terminatedCallbackList = terminatedCallbackList;
    }

    public EngineCallbackExecutor(List<TieEngineCompletedCallback> terminatedCallbackList) {
        this.terminatedCallbackList = terminatedCallbackList;
    }

    @Override
    public void completedCallback(TieEngineCallbackEvent callbackEvent) {
        boolean isCallbackExecuteFlag;
        log.debug("TieEngine callback, status={}, traceId={}", (Object)callbackEvent.getState(), (Object)RequestContext.get().getTraceId());
        boolean bl = isCallbackExecuteFlag = callbackEvent.getState() != TieState.ERROR;
        if (isCallbackExecuteFlag) {
            log.debug("TieEngine callback Lists {}", this.terminatedCallbackList.stream().map(dy -> dy.getClass().getName()).collect(Collectors.toList()));
            if (WTCCollections.isNotEmpty(this.terminatedCallbackList)) {
                try (Span callbackSpan = TaskTracer.newSpan((String)TieReportKDStrings.ENGINE_CALLBACK.loadKDString());){
                    for (TieEngineCompletedCallback terminatedCallback : this.terminatedCallbackList) {
                        String callbackTag = terminatedCallback.getClass().getName();
                        log.debug("TieEngine callback try to call {}", (Object)callbackTag);
                        try {
                            Span callbackTagSpan = TaskTracer.newSpan((String)callbackTag);
                            Throwable throwable = null;
                            try {
                                terminatedCallback.completedCallback(callbackEvent);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (callbackTagSpan == null) continue;
                                if (throwable != null) {
                                    try {
                                        callbackTagSpan.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                callbackTagSpan.close();
                            }
                        }
                        catch (Exception e) {
                            log.warn("TieEngine callback[{}] error", (Object)callbackTag, (Object)e);
                        }
                    }
                }
            }
        }
        this.sendMsgToDealCountMsg(callbackEvent);
        TaskConcurrencyCtrlHelper.getInstance().deleteBySubTaskIds(TaskCategoryEnum.WTTE_TIE.getCode(), Collections.singletonList(callbackEvent.getSubTaskId()));
    }

    private void sendMsgToDealCountMsg(TieEngineCallbackEvent callbackEvent) {
        try {
            if (callbackEvent.getState() != TieState.SUCCESS) {
                return;
            }
            CountMsgObject msgObject = new CountMsgObject();
            msgObject.setTaskId(callbackEvent.getTaskId());
            msgObject.setSubTaskId(callbackEvent.getSubTaskId());
            msgObject.setVersionId(callbackEvent.getRequest().getVersion());
            Tuple<LocalDate, LocalDate> attSubjectMaxRange = this.getAttSubjectMaxRange(callbackEvent.getEngine().getAttSubjects());
            msgObject.setStartDate(WTCDateUtils.toDate((LocalDate)((LocalDate)attSubjectMaxRange.getKey())));
            msgObject.setEndDate(WTCDateUtils.toDate((LocalDate)((LocalDate)attSubjectMaxRange.getValue())));
            CountMsgProducer.publish(msgObject);
        }
        catch (Exception ex) {
            log.warn("sendMsgToDealCountMsg error", (Throwable)ex);
        }
    }

    private Tuple<LocalDate, LocalDate> getAttSubjectMaxRange(List<AttSubject> attSubjects) {
        LocalDate earliestStartDate = attSubjects.get(0).getStartDate();
        LocalDate latestEndDate = attSubjects.get(0).getEndDate();
        for (AttSubject attSubject : attSubjects) {
            LocalDate startDate = attSubject.getStartDate();
            earliestStartDate = startDate.isBefore(earliestStartDate) ? startDate : earliestStartDate;
            LocalDate endDate = attSubject.getEndDate();
            latestEndDate = endDate.isAfter(latestEndDate) ? endDate : latestEndDate;
        }
        return new Tuple((Object)earliestStartDate, (Object)latestEndDate);
    }
}

