/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.storage;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.model.AttRecordModel;
import kd.wtc.wtes.business.model.DataPackageInfo;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjust;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimResult;
import kd.wtc.wtes.business.service.IDataPackageStoreService;
import kd.wtc.wtes.business.storage.RecordAndPackageWrapper;
import kd.wtc.wtes.business.storage.StorageUtil;
import kd.wtc.wtes.business.util.AttRecordTrimUtil;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttRecordTrimDaySaveServiceImpl
implements IDataPackageStoreService {
    private static HRBaseServiceHelper adjustRecordService = WtesHRBaseTimeWatchUtil.create(AttRecordTrimDaySaveServiceImpl.class.getName() + "." + "wtte_daymovedetail", "wtte_daymovedetail");
    public static MainEntityType adjustRecord = MetadataServiceHelper.getDataEntityType((String)"wtte_daymovedetail");

    private void setData(List<AttRecordModel> list, DynamicObjectCollection adjustCollection, Long attPersonId, Date ownDate) {
        for (AttRecordModel model : list) {
            List<AttRecordTrimResult> attRecordTrimResultList = model.getAttRecordTrimResultList();
            if (CollectionUtils.isEmpty(attRecordTrimResultList)) continue;
            attRecordTrimResultList.forEach(attRecordTrimResult -> {
                if (attRecordTrimResult != null) {
                    DynamicObject adjustDyn = new DynamicObject((DynamicObjectType)adjustRecord);
                    AttRecordAdjust attRecordAdjust = attRecordTrimResult.getAttRecordAdjust();
                    if (attRecordAdjust != null) {
                        adjustDyn.set("revisiondate", (Object)ownDate);
                        AttRecordTrimUtil.builtTrimDy(adjustDyn, attRecordTrimResult);
                        adjustCollection.add((Object)adjustDyn);
                    }
                }
            });
        }
    }

    private void saveAdjustRecord(DynamicObjectCollection collection) {
        adjustRecordService.save(collection);
    }

    @Override
    public void storeBatch(List<RecordAndPackageWrapper> recordAndPackageWrapperList) {
        if (recordAndPackageWrapperList.isEmpty()) {
            return;
        }
        DynamicObjectCollection adjustCollection = new DynamicObjectCollection();
        for (RecordAndPackageWrapper recordAndPackageWrapper : recordAndPackageWrapperList) {
            DataPackageInfo packageInfo = recordAndPackageWrapper.getPackageInfo();
            Long attPersonId = packageInfo.getAttPersonId();
            Date ownDate = packageInfo.getOwnDate();
            this.setData(recordAndPackageWrapper.getList(), adjustCollection, attPersonId, ownDate);
        }
        this.saveAdjustRecord(adjustCollection);
    }

    @Override
    @Deprecated
    public void deleteRecoredAfterErrorDate(Long attPersionId, Date errorDate) {
        QFilter qFilter = StorageUtil.generalErrorDateSql(attPersionId, errorDate, "attfilebase.attperson", "revisiondate");
        if (qFilter != null) {
            qFilter.and(new QFilter("revisionhisid.datastatus", "=", (Object)"1"));
            adjustRecordService.deleteByFilter(new QFilter[]{qFilter});
        }
    }

    @Override
    public void deleteRecordByAttFileBoIdAfterErrorDate(Long attFileBoId, Date errorDate) {
        QFilter qFilter = StorageUtil.generalErrorDateSql(attFileBoId, errorDate, "attfilebase", "revisiondate");
        if (qFilter != null) {
            qFilter.and(new QFilter("revisionhisid.datastatus", "=", (Object)"1"));
            adjustRecordService.deleteByFilter(new QFilter[]{qFilter});
        }
    }

    @Override
    public String getServiceReportNodeName() {
        return CalcReportConstants.ATTRECORDADJUST_STORE_TIME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCalDataClean(List<AttSubject> attSubjects, String version) {
        QFilter[] filters = StorageUtil.transferClearQFilter(version, attSubjects, "attfilebase", "revisiondate", null);
        if (filters != null) {
            try (TXHandle tx = TX.required();){
                for (QFilter filter : filters) {
                    filter.and(new QFilter("revisionhisid.datastatus", "=", (Object)"1"));
                    adjustRecordService.deleteByFilter(new QFilter[]{filter});
                }
            }
        }
    }
}

