/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.storage;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.sdk.wtc.wtes.business.tie.core.chain.TieContentPersistentExt;
import kd.sdk.wtc.wtes.business.tie.persistent.daily.BeforeSaveDailyDataResultEvent;
import kd.sdk.wtc.wtes.business.tie.persistent.daily.TieSaveDailyDataExtPlugin;
import kd.sdk.wtc.wtes.business.tie.persistent.utils.TieDataResultExt;
import kd.sdk.wtc.wtes.business.tie.persistent.utils.TieDataResultRelExt;
import kd.sdk.wtc.wtes.business.tie.persistent.utils.TieDataResultUtils;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.ext.model.daily.TieContentPersistentExtImpl;
import kd.wtc.wtes.business.model.AttRecordModel;
import kd.wtc.wtes.business.model.DataPackageInfo;
import kd.wtc.wtes.business.model.RecordDbEntity;
import kd.wtc.wtes.business.service.IDataPackageStoreService;
import kd.wtc.wtes.business.storage.RecordAndPackageWrapper;
import kd.wtc.wtes.business.storage.StorageUtil;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttSpliteRecordSaveServiceImpl
implements IDataPackageStoreService {
    private static HRBaseServiceHelper attMainRecordService = WtesHRBaseTimeWatchUtil.create(AttSpliteRecordSaveServiceImpl.class.getName() + "." + "wtdtd_attrecordbase", "wtdtd_attrecordbase");
    private static HRBaseServiceHelper attDetailRecordService = WtesHRBaseTimeWatchUtil.create(AttSpliteRecordSaveServiceImpl.class.getName() + "." + "wtdtd_attrecorddetail", "wtdtd_attrecorddetail");
    private static HRBaseServiceHelper attMainRecordHisService = WtesHRBaseTimeWatchUtil.create(AttSpliteRecordSaveServiceImpl.class.getName() + "." + "wtdtd_attrecordbasehis", "wtdtd_attrecordbasehis");
    private static HRBaseServiceHelper attDetailRecordHisService = WtesHRBaseTimeWatchUtil.create(AttSpliteRecordSaveServiceImpl.class.getName() + "." + "wtdtd_attrecorddetailhis", "wtdtd_attrecorddetailhis");

    private static Boolean isSaveHis() {
        return (Boolean)SystemParamQueryUtil.getValueByAppNumAndKey((String)"wtte", (String)"checkboxfield");
    }

    public void saveRecored(DynamicObjectCollection mainObjList, DynamicObjectCollection deatailObjList) {
        if (CollectionUtils.isNotEmpty((Collection)mainObjList)) {
            attMainRecordService.save(mainObjList);
        }
        if (CollectionUtils.isNotEmpty((Collection)deatailObjList)) {
            attDetailRecordService.save(deatailObjList);
        }
    }

    public void saveRecoredHis(DynamicObjectCollection mainObjHisList, DynamicObjectCollection detailObjHisList) {
        attMainRecordHisService.save(mainObjHisList);
        attDetailRecordHisService.save(detailObjHisList);
    }

    @Override
    public void storeBatch(List<RecordAndPackageWrapper> recordAndPackageWrapperList) {
        if (recordAndPackageWrapperList.isEmpty()) {
            return;
        }
        DynamicObjectCollection mainObjList = new DynamicObjectCollection();
        DynamicObjectCollection detailObjList = new DynamicObjectCollection();
        DynamicObjectCollection mainObjHisList = new DynamicObjectCollection();
        DynamicObjectCollection detailObjHisList = new DynamicObjectCollection();
        for (RecordAndPackageWrapper recordAndPackageWrapper : recordAndPackageWrapperList) {
            DynamicObjectCollection dynamicObjectCollection;
            RecordDbEntity recordDbEntity = this.builteRecordDbEntity(recordAndPackageWrapper.getList(), recordAndPackageWrapper.getPackageInfo());
            if (recordDbEntity == null) continue;
            DynamicObject dynamicObject = recordDbEntity.getMainObj();
            if (dynamicObject != null) {
                mainObjList.add((Object)dynamicObject);
                mainObjHisList.add((Object)recordDbEntity.getMainObjHis());
            }
            if (!CollectionUtils.isNotEmpty((Collection)(dynamicObjectCollection = recordDbEntity.getDetailObj()))) continue;
            detailObjList.addAll((Collection)dynamicObjectCollection);
            detailObjHisList.addAll((Collection)recordDbEntity.getDetailObjHis());
        }
        this.beforeSaveDailyDataResult(mainObjList, detailObjList, recordAndPackageWrapperList.get(0).getPackageInfo());
        this.saveRecored(mainObjList, detailObjList);
        if (AttSpliteRecordSaveServiceImpl.isSaveHis().booleanValue()) {
            this.saveRecoredHis(mainObjHisList, detailObjHisList);
        }
    }

    private void beforeSaveDailyDataResult(DynamicObjectCollection mainObjList, DynamicObjectCollection detailObjList, DataPackageInfo packageInfo) {
        WTCPluginProxyFactory.create(TieSaveDailyDataExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.persistent.daily.TieSaveDailyDataExtPlugin").invokeReplace(instance -> {
            ArrayList tieDataResultRelExtList = new ArrayList(mainObjList.size());
            Map<Object, List<DynamicObject>> detailObjectListMap = detailObjList.stream().collect(Collectors.groupingBy(ob -> ob.getLong("attmain")));
            mainObjList.forEach(mainObject -> {
                TieDataResultExt tieDataResultExt = new TieDataResultExt(TieDataResultUtils.dayMainBlackList, mainObject);
                List dynamicObjects = detailObjectListMap.getOrDefault(mainObject.getLong("id"), Collections.emptyList());
                List tieDataResultExtList = dynamicObjects.stream().map(item -> new TieDataResultExt(TieDataResultUtils.dayDetailBlackList, item)).collect(Collectors.toList());
                TieDataResultRelExt tieDataResultRelExt = new TieDataResultRelExt(tieDataResultExt, tieDataResultExtList);
                tieDataResultRelExtList.add(tieDataResultRelExt);
            });
            TieContentPersistentExtImpl tieContentPersistentExt = new TieContentPersistentExtImpl(packageInfo.getInitParams());
            BeforeSaveDailyDataResultEvent beforeSaveDailyDataResultEvent = new BeforeSaveDailyDataResultEvent(tieDataResultRelExtList, (TieContentPersistentExt)tieContentPersistentExt);
            instance.beforeSaveDailyDataResult(beforeSaveDailyDataResultEvent);
        });
    }

    @Override
    @Deprecated
    public void deleteRecoredAfterErrorDate(Long attPersionId, Date errorDate) {
        List<Object> pKIdList;
        QFilter qFilter = StorageUtil.generalErrorDateSql(attPersionId, errorDate, "personid", "owndate");
        if (qFilter != null && CollectionUtils.isNotEmpty(pKIdList = this.getMainDeleteObj(qFilter))) {
            attMainRecordService.deleteByFilter(new QFilter[]{new QFilter("id", "in", pKIdList)});
            attDetailRecordService.deleteByFilter(new QFilter[]{new QFilter("attmain", "in", pKIdList).and("owndate", ">=", (Object)errorDate)});
        }
    }

    @Override
    public void deleteRecordByAttFileBoIdAfterErrorDate(Long attFileBoId, Date errorDate) {
        List<Object> pKIdList;
        QFilter qFilter = StorageUtil.generalErrorDateSql(attFileBoId, errorDate, "attfileid", "owndate");
        if (qFilter != null && CollectionUtils.isNotEmpty(pKIdList = this.getMainDeleteObj(qFilter))) {
            attMainRecordService.deleteByFilter(new QFilter[]{new QFilter("id", "in", pKIdList)});
            attDetailRecordService.deleteByFilter(new QFilter[]{new QFilter("attmain", "in", pKIdList).and("owndate", ">=", (Object)errorDate)});
        }
    }

    private List<Object> getMainDeleteObj(QFilter qFilter) {
        DynamicObject[] dynamicObjects = attMainRecordService.query("id", new QFilter[]{qFilter});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            return Arrays.asList(dynamicObjects).stream().map(ob -> ob.get("id")).collect(Collectors.toList());
        }
        return new ArrayList<Object>(0);
    }

    private RecordDbEntity builteRecordDbEntity(List<AttRecordModel> attRecordModelList, DataPackageInfo packageInfo) {
        if (CollectionUtils.isEmpty(attRecordModelList)) {
            return null;
        }
        RecordDbEntity recordDbEntity = new RecordDbEntity();
        DynamicObject mainDynamicObject = this.getBaseRecordData(attRecordModelList.get(0), packageInfo);
        recordDbEntity.setMainObj(mainDynamicObject);
        DynamicObject mainHis = BusinessDataServiceHelper.newDynamicObject((String)"wtdtd_attrecordbasehis");
        HRDynamicObjectUtils.copy((DynamicObject)mainDynamicObject, (DynamicObject)mainHis);
        mainHis.set("id", (Object)DB.genLongId((String)"wtdtd_attrecordbasehis"));
        recordDbEntity.setMainObjHis(mainHis);
        DynamicObjectCollection detailHis = new DynamicObjectCollection();
        DynamicObjectCollection dynamicObjectCollection = this.getDeatilRecordData(mainDynamicObject.getLong("id"), mainHis.getLong("id"), attRecordModelList, packageInfo, detailHis);
        recordDbEntity.setDetailObj(dynamicObjectCollection);
        recordDbEntity.setDetailObjHis(detailHis);
        return recordDbEntity;
    }

    private DynamicObject getBaseRecordData(AttRecordModel attRecordModel, DataPackageInfo packageInfo) {
        Long attPersonId = packageInfo.getAttPersonId();
        Date ownDate = packageInfo.getOwnDate();
        DynamicObject base = BusinessDataServiceHelper.newDynamicObject((String)"wtdtd_attrecordbase");
        Long org = packageInfo.getOrg();
        Long shiftId = packageInfo.getShiftId();
        String mode = packageInfo.getMode();
        String version = packageInfo.getVersion();
        Long attFileid = packageInfo.getAttFileid();
        Long attFileVid = packageInfo.getAttFileVid();
        Date calculateDate = packageInfo.getCalculateDate();
        Long calculatorId = packageInfo.getCalculatorId();
        Long attPeriodId = packageInfo.getAttPeriodId();
        String perAttPeriodId = packageInfo.getPerAttPeriodId();
        Long perAttPeriodPK = packageInfo.getPerAttPeriodPK();
        Date perAttBeginDate = packageInfo.getPerAttBeginDate();
        Date perAttEndDate = packageInfo.getPerAttEndDate();
        base.set("id", (Object)DB.genLongId((String)"wtdtd_attrecordbase"));
        long departmentVid = packageInfo.getDepartmentVid();
        long companyVid = packageInfo.getCompanyVid();
        long positionVid = packageInfo.getPositionVid();
        long jobVid = packageInfo.getJobVid();
        long shiftFid = packageInfo.getShiftFid();
        long managescopeVid = packageInfo.getManagescopevid();
        long affiliateadminorgvid = packageInfo.getAffiliateadminorgvid();
        base.set("personid", (Object)attPersonId);
        base.set("orgid", (Object)org);
        base.set("owndate", (Object)ownDate);
        base.set("datetype", (Object)attRecordModel.getDateType());
        base.set("dateattr", (Object)attRecordModel.getDateAttributeId());
        base.set("shiftid", (Object)shiftId);
        base.set("mode", (Object)mode);
        base.set("versionid", (Object)version);
        base.set("attfileid", (Object)attFileid);
        base.set("attfilevid", (Object)attFileVid);
        base.set("calculatedate", (Object)calculateDate);
        base.set("perattperiodid", (Object)attPeriodId);
        base.set("attperattperiodid", (Object)perAttPeriodId);
        base.set("attperattperiodpk", (Object)perAttPeriodPK);
        base.set("perperiodbegindate", (Object)perAttBeginDate);
        base.set("perperiodenddate", (Object)perAttEndDate);
        base.set("companyvid", (Object)companyVid);
        base.set("departmentvid", (Object)departmentVid);
        base.set("jobvid", (Object)jobVid);
        base.set("positionvid", (Object)positionVid);
        base.set("shiftvid", (Object)shiftFid);
        base.set("managescopevid", (Object)managescopeVid);
        base.set("affiliateadminorgvid", (Object)affiliateadminorgvid);
        base.set("reckoner", (Object)calculatorId);
        base.set("createtime", (Object)attRecordModel.getCalDate());
        return base;
    }

    private DynamicObjectCollection getDeatilRecordData(Long attMainId, Long attMainHisId, List<AttRecordModel> attRecordModelList, DataPackageInfo packageInfo, DynamicObjectCollection deatilHis) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        Date ownDate = packageInfo.getOwnDate();
        for (AttRecordModel model : attRecordModelList) {
            DynamicObject detail = BusinessDataServiceHelper.newDynamicObject((String)"wtdtd_attrecorddetail");
            Boolean originalItem = model.getOriginalItem();
            Long attItemId = model.getAttItemId();
            BigDecimal value = model.getValue();
            BigDecimal valueSecond = model.getValueSecondDecimal();
            String valueString = model.getValueString();
            Long timeBuckId = model.getTimeBuckId();
            long attItemFid = model.getAttItemFid();
            detail.set("owndate", (Object)ownDate);
            detail.set("attitemtype", (Object)(originalItem != false ? "0" : "1"));
            detail.set("attitemid", (Object)attItemId);
            detail.set("value", (Object)value);
            detail.set("valuesecond", (Object)valueSecond);
            detail.set("valuestring", (Object)valueString);
            detail.set("valuelong", (Object)(WTCStringUtils.isEmpty((String)valueString) ? Integer.valueOf(0) : new BigDecimal(valueString)));
            detail.set("sourceattitemids", (Object)timeBuckId);
            detail.set("attitemvid", (Object)attItemFid);
            detail.set("attmain", (Object)attMainId);
            dynamicObjectCollection.add((Object)detail);
            DynamicObject detailHis = BusinessDataServiceHelper.newDynamicObject((String)"wtdtd_attrecorddetailhis");
            HRDynamicObjectUtils.copy((DynamicObject)detail, (DynamicObject)detailHis);
            detailHis.set("attmain", (Object)attMainHisId);
            deatilHis.add((Object)detailHis);
        }
        return dynamicObjectCollection;
    }

    @Override
    public String getServiceReportNodeName() {
        return CalcReportConstants.ATTRECORD_STORE_TIME;
    }

    @Override
    public void doCalDataClean(List<AttSubject> attSubjects, String version) {
        QFilter[] filters = StorageUtil.transferClearQFilter(version, attSubjects, "attfileid", "owndate", "versionid");
        if (filters != null) {
            QFilter dateQFilter = this.generalDetailFilterByAttSubject(attSubjects);
            DynamicObject[][] dytdarr = new DynamicObject[filters.length][];
            for (int i = 0; i < filters.length; ++i) {
                QFilter filter = filters[i];
                dytdarr[i] = attMainRecordService.query("id", new QFilter[]{filter});
            }
            DynamicObject[] dynamicObjects = (DynamicObject[])Arrays.stream(dytdarr).flatMap(Arrays::stream).toArray(DynamicObject[]::new);
            List mainIdList = Arrays.stream(dynamicObjects).map(ob -> ob.get("id")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(mainIdList)) {
                attMainRecordService.deleteByFilter(new QFilter[]{new QFilter("id", "in", mainIdList), dateQFilter});
                attDetailRecordService.deleteByFilter(new QFilter[]{new QFilter("attmain", "in", mainIdList), dateQFilter});
            }
        }
    }

    private QFilter generalDetailFilterByAttSubject(List<AttSubject> attSubjects) {
        if (!CollectionUtils.isEmpty(attSubjects)) {
            LocalDate minOwnDate = attSubjects.get(0).getStartDate();
            LocalDate maxOwnDate = attSubjects.get(0).getEndDate();
            for (AttSubject attSubject : attSubjects) {
                if (minOwnDate.compareTo(attSubject.getStartDate()) > 0) {
                    minOwnDate = attSubject.getStartDate();
                }
                if (maxOwnDate.compareTo(attSubject.getEndDate()) >= 0) continue;
                maxOwnDate = attSubject.getEndDate();
            }
            return new QFilter("owndate", ">=", (Object)WTCDateUtils.toDate((LocalDate)minOwnDate)).and(new QFilter("owndate", "<=", (Object)WTCDateUtils.toDate((LocalDate)maxOwnDate)));
        }
        return null;
    }
}

