/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.storage;

import java.util.Date;
import java.util.List;
import kd.bos.ai.util.JsonUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.model.jsondto.AccountPlanJsonDto;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.service.IDataPackageStoreService;
import kd.wtc.wtes.business.storage.RecordAndPackageWrapper;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;

public class CalculateDetailSaveServiceImpl
implements IDataPackageStoreService {
    private static final HRBaseServiceHelper dataJsonService = WtesHRBaseTimeWatchUtil.create("wtte_datajson", "wtte_datajson");
    private static final MainEntityType dataJson = MetadataServiceHelper.getDataEntityType((String)"wtte_datajson");
    private static final String UP_VERSION = "V1.1";

    @Override
    public void storeBatch(List<RecordAndPackageWrapper> recordAndPackageWrapperList) {
        DynamicObjectCollection dynamicObjects = this.makeData(recordAndPackageWrapperList);
        dataJsonService.save(dynamicObjects);
    }

    private DynamicObjectCollection makeData(List<RecordAndPackageWrapper> recordAndPackageWrapperList) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (RecordAndPackageWrapper recordAndPackageWrapper : recordAndPackageWrapperList) {
            AccountPlanJsonDto accountPlanJsonDto = recordAndPackageWrapper.getAccountPlanJsonDto();
            if (null == accountPlanJsonDto) continue;
            DynamicObject dynamicObject = this.toDataJons(accountPlanJsonDto, recordAndPackageWrapper.getPackageInfo().getAttPersonId(), recordAndPackageWrapper.getPackageInfo().getOwnDate(), recordAndPackageWrapper.getPackageInfo().getVersion(), recordAndPackageWrapper.getPackageInfo().getAttFileid(), recordAndPackageWrapper.getPackageInfo().getAttFileVid());
            dynamicObjectCollection.add((Object)dynamicObject);
        }
        return dynamicObjectCollection;
    }

    private DynamicObject toDataJons(AccountPlanJsonDto phaseJsonDto, long attPersonId, Date ownDate, String version, long attFileId, Long attFileVid) {
        String JsonString = JsonUtil.encodeToString((Object)phaseJsonDto);
        DynamicObject dataJsonDyn = new DynamicObject((DynamicObjectType)dataJson);
        dataJsonDyn.set("personid", (Object)attPersonId);
        dataJsonDyn.set("attfileid", (Object)attFileId);
        dataJsonDyn.set("attfilevid", (Object)attFileVid);
        dataJsonDyn.set("owndate", (Object)ownDate);
        dataJsonDyn.set("version", (Object)version);
        dataJsonDyn.set("datajson", (Object)JsonString);
        dataJsonDyn.set("upversion", (Object)UP_VERSION);
        return dataJsonDyn;
    }

    @Override
    @Deprecated
    public void deleteRecoredAfterErrorDate(Long attPersionId, Date errorDate) {
    }

    @Override
    public void deleteRecordByAttFileBoIdAfterErrorDate(Long attFileBoId, Date errorDate) {
    }

    @Override
    public String getServiceReportNodeName() {
        return CalcReportConstants.CALCULATEDETAIL_STORE_TIME;
    }

    @Override
    public void doCalDataClean(List<AttSubject> attSubjects, String version) {
    }
}

