/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.storage;

import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.task.trace.Span;
import kd.wtc.wtbs.business.task.trace.TaskTracer;
import kd.wtc.wtbs.wtes.common.calreport.CalcReportConstants;
import kd.wtc.wtes.business.service.IDataPackageStoreService;
import kd.wtc.wtes.business.storage.DataPackageStoreResult;
import kd.wtc.wtes.business.storage.RecordAndPackageWrapper;

public class DataPackageStoreExecutor
implements Callable<DataPackageStoreResult> {
    private final List<IDataPackageStoreService> storeServices;
    private final RequestContext requestContext;
    private final List<RecordAndPackageWrapper> recordAndPackageWrappers;
    private static Log LOG = LogFactory.getLog(DataPackageStoreExecutor.class);

    public DataPackageStoreExecutor(List<IDataPackageStoreService> storeServices, List<RecordAndPackageWrapper> list, RequestContext requestContext) {
        this.storeServices = storeServices;
        this.recordAndPackageWrappers = list;
        this.requestContext = requestContext;
    }

    @Override
    public DataPackageStoreResult call() throws Exception {
        try {
            RequestContext.copyAndSet((RequestContext)this.requestContext);
            try (Span storeBatchSpan = TaskTracer.newSpan((String)CalcReportConstants.ONCE_STORE_BATCH_TIME);){
                storeBatchSpan.info(CalcReportConstants.STORE_BATCH_NUM, (Object)this.recordAndPackageWrappers.size());
                for (IDataPackageStoreService service : this.storeServices) {
                    long startTime = System.currentTimeMillis();
                    Span singleStoreSpan = TaskTracer.newSpan((String)service.getServiceReportNodeName());
                    Throwable throwable = null;
                    try {
                        LOG.debug("storeServices: {} storeImmediately start ", service.getClass());
                        service.storeBatch(this.recordAndPackageWrappers);
                        LOG.debug("storeServices:{}storeImmediately end ,cost time :{} ", service.getClass(), (Object)(System.currentTimeMillis() - startTime));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (singleStoreSpan == null) continue;
                        if (throwable != null) {
                            try {
                                singleStoreSpan.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        singleStoreSpan.close();
                    }
                }
            }
            return DataPackageStoreResult.success();
        }
        catch (Exception ex) {
            LOG.warn("storeBatch error", (Throwable)ex);
            Set<Long> attPersonId = this.recordAndPackageWrappers.stream().map(en -> en.getPackageInfo().getAttPersonId()).collect(Collectors.toSet());
            return DataPackageStoreResult.fail(ex.getMessage(), attPersonId);
        }
    }
}

