/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.WaitingRejectedHandler;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import org.jetbrains.annotations.NotNull;

public class PriorityExecutorService
implements ExecutorService {
    private static final Log LOGGER = LogFactory.getLog(PriorityExecutorService.class);
    private final ExecutorService delegate;
    private final int maxThreadCount;
    private final String threadNamePrefix;
    private final PriorityBlockingQueue<PriorityCallable<?>> midQueue;
    private final LinkedBlockingQueue<Runnable> serviceQueue;

    public static PriorityExecutorService getStoreInstance() {
        return PriorityExecutorServiceHolder.storeInstance;
    }

    public static PriorityExecutorService getInitInstance() {
        return PriorityExecutorServiceHolder.initInstance;
    }

    private PriorityExecutorService(String name, int coreSize) {
        this.maxThreadCount = coreSize;
        this.threadNamePrefix = name;
        int MAX_FIX_QUEUESIZE = Integer.getInteger("threadpool.fix.maxqueue.size", 100000);
        this.midQueue = new PriorityBlockingQueue<PriorityCallable>(MAX_FIX_QUEUESIZE, Comparator.comparingInt(o -> ((PriorityCallable)o).priority));
        this.serviceQueue = new LocalLinkedBlockingQueue<Runnable>(this::innerTransferTask, MAX_FIX_QUEUESIZE, this.maxThreadCount);
        this.delegate = ThreadLifeCycleManager.wrapExecutorService((ExecutorService)new ThreadPoolExecutor(this.maxThreadCount, this.maxThreadCount, 0L, TimeUnit.MILLISECONDS, this.serviceQueue, new ThreadFactory(){
            private final AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, PriorityExecutorService.this.threadNamePrefix + "-" + this.atomicInteger.incrementAndGet());
            }
        }, (RejectedExecutionHandler)new WaitingRejectedHandler()));
    }

    @Override
    public void shutdown() {
        ArrayList list = new ArrayList(this.midQueue.size() + 1);
        this.midQueue.drainTo(list);
        for (PriorityCallable runner : list) {
            Future fu = this.delegate.submit(runner.callable);
            runner.setFuture(fu);
        }
        this.delegate.shutdown();
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        ArrayList list = new ArrayList(this.midQueue.size() + 1);
        this.midQueue.drainTo(list);
        for (PriorityCallable runner : list) {
            Future fu = this.delegate.submit(runner.callable);
            runner.setFuture(fu);
        }
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> task) {
        throw new UnsupportedOperationException("not support submit");
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable task, T result) {
        throw new UnsupportedOperationException("not support submit");
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        throw new UnsupportedOperationException("not support submit");
    }

    private void transferTask() {
        if (this.serviceQueue.size() <= this.maxThreadCount + 1 && this.midQueue.size() > 0) {
            ArrayList list = new ArrayList(this.maxThreadCount + 1);
            int size = this.midQueue.drainTo(list, this.maxThreadCount + 1);
            LOGGER.info("transferTask name:{}, size: {}, midiQueue size:{}, serviceQueue size:{}", new Object[]{this.threadNamePrefix, size, this.midQueue.size(), this.serviceQueue.size()});
            for (PriorityCallable runner : list) {
                if (runner.cancelFlag) continue;
                Future fu = this.delegate.submit(runner.callable);
                runner.setFuture(fu);
            }
        }
    }

    private void innerTransferTask() {
        if (this.serviceQueue.size() <= this.maxThreadCount + 1 && this.midQueue.size() > 0) {
            ArrayList list = new ArrayList(this.maxThreadCount + 1);
            int size = this.midQueue.drainTo(list, this.maxThreadCount + 1);
            LOGGER.info("innerTransferTask name:{}, size: {}, midiQueue size:{}, serviceQueue size:{}", new Object[]{this.threadNamePrefix, size, this.midQueue.size(), this.serviceQueue.size()});
            for (PriorityCallable runner : list) {
                RequestContext.copyAndSet((RequestContext)runner.context);
                if (runner.cancelFlag) continue;
                Future fu = this.delegate.submit(runner.callable);
                runner.setFuture(fu);
            }
        }
    }

    public <T> Future<T> submit(@NotNull Callable<T> callable, int priority) {
        PriorityCallable<T> wr = new PriorityCallable<T>(callable, priority, RequestContext.get());
        boolean offer = this.midQueue.offer(wr);
        if (offer) {
            this.transferTask();
            return wr;
        }
        return this.delegate.submit(callable);
    }

    public <T> List<Future<T>> submitAll(@NotNull List<Callable<T>> callables, int priority) {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(callables.size());
        for (Callable<T> callable : callables) {
            PriorityCallable<T> wr = new PriorityCallable<T>(callable, priority, RequestContext.get());
            boolean offer = this.midQueue.offer(wr);
            if (offer) {
                futures.add(wr);
                continue;
            }
            futures.add(this.delegate.submit(callable));
        }
        this.transferTask();
        return futures;
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException("not support invokeAll");
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("not support invokeAll");
    }

    @Override
    @NotNull
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("not support invokeAny");
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("not support invokeAny");
    }

    @Override
    public void execute(@NotNull Runnable command) {
        throw new UnsupportedOperationException("not support execute");
    }

    private static class LocalLinkedBlockingQueue<E>
    extends LinkedBlockingQueue<E> {
        private Runnable lessListener;
        private int notifySize;

        public LocalLinkedBlockingQueue(Runnable lessListener, int size, int notifySize) {
            super(size);
            this.lessListener = lessListener;
            this.notifySize = notifySize;
        }

        private void tryNotify() {
            if (this.size() < this.notifySize) {
                this.lessListener.run();
            }
        }

        @Override
        public boolean offer(@NotNull E e) {
            boolean offer = super.offer(e);
            this.tryNotify();
            return offer;
        }

        @Override
        public E poll() {
            Object poll = super.poll();
            this.tryNotify();
            return poll;
        }

        @Override
        public E poll(long timeout, TimeUnit unit) throws InterruptedException {
            Object poll = super.poll(timeout, unit);
            this.tryNotify();
            return poll;
        }

        @Override
        public E remove() {
            Object remove = super.remove();
            this.tryNotify();
            return remove;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean b = super.removeAll(c);
            this.tryNotify();
            return b;
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            boolean b = super.removeIf(filter);
            this.tryNotify();
            return b;
        }

        @Override
        public boolean remove(Object o) {
            boolean remove = super.remove(o);
            this.tryNotify();
            return remove;
        }

        @Override
        public int drainTo(Collection<? super E> c, int maxElements) {
            int i = super.drainTo(c, maxElements);
            this.tryNotify();
            return i;
        }

        @Override
        public E take() throws InterruptedException {
            Object take = super.take();
            this.tryNotify();
            return take;
        }

        @Override
        public E peek() {
            Object peek = super.peek();
            this.tryNotify();
            return peek;
        }

        @Override
        public void clear() {
            super.clear();
            this.tryNotify();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean b = super.retainAll(c);
            this.tryNotify();
            return b;
        }
    }

    private static class PriorityCallable<T>
    implements Future<T> {
        private final Callable<T> callable;
        private final int priority;
        private Future<T> future;
        private RequestContext context;
        private boolean cancelFlag = false;
        private boolean mayInterruptIfRunning;

        public PriorityCallable(Callable<T> callable, int priority, RequestContext context) {
            this.callable = callable;
            this.priority = priority;
            this.context = context;
        }

        private synchronized void setFuture(Future<T> fu) {
            this.future = fu;
            if (this.cancelFlag) {
                this.future.cancel(this.mayInterruptIfRunning);
            }
            this.notifyAll();
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelFlag = true;
            this.mayInterruptIfRunning = mayInterruptIfRunning;
            if (this.future != null) {
                return this.future.cancel(mayInterruptIfRunning);
            }
            return true;
        }

        @Override
        public synchronized boolean isCancelled() {
            return this.cancelFlag;
        }

        @Override
        public synchronized boolean isDone() {
            throw new UnsupportedOperationException("not support isDone");
        }

        @Override
        public synchronized T get() throws InterruptedException, ExecutionException {
            while (this.future == null) {
                this.wait();
            }
            return this.future.get();
        }

        @Override
        public synchronized T get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException("not support get");
        }
    }

    private static class PriorityExecutorServiceHolder {
        private static final PriorityExecutorService storeInstance = new PriorityExecutorService(WTCAppContextHelper.getProjectParams().getString("tie.data.package.pool.name", "WTC-WTES-DataPackagePool"), WTCAppContextHelper.getProjectParams().getIntValue("tie.data.package.pool.size", 2));
        private static final PriorityExecutorService initInstance = new PriorityExecutorService(WTCAppContextHelper.getProjectParams().getString("tie.init.pool.name", "TiInitPool"), WTCAppContextHelper.getProjectParams().getIntValue("tie.init.pool.size", 2));

        private PriorityExecutorServiceHolder() {
        }
    }
}

