/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.storage;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.exporter.ITieEngineStateService;
import kd.wtc.wtes.business.model.TieEngineState;
import kd.wtc.wtes.common.constants.TieExporterConstants;

public class TieEngineStateDAO
implements TieExporterConstants,
ITieEngineStateService {
    private static final HRBaseServiceHelper TIE_ENGING_STATE_HELPER = new HRBaseServiceHelper("wtte_tieengingstate");

    @Override
    public void saveEngineState(TieEngineState engineState) {
        DynamicObject tieEngingStateDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtte_tieengingstate"));
        this.transTieEngingStateToDy(engineState, tieEngingStateDy);
        DynamicObject idDy = (DynamicObject)TIE_ENGING_STATE_HELPER.saveOne(tieEngingStateDy);
        if (!HRObjectUtils.isEmpty((Object)idDy)) {
            engineState.setId(idDy.getLong("id"));
        }
    }

    @Override
    public void updateEngineState(TieEngineState engineState) {
        DynamicObject tieEngingStateDy = TIE_ENGING_STATE_HELPER.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)engineState.getId())});
        tieEngingStateDy.set("status", (Object)engineState.getStatus());
        tieEngingStateDy.set("message", (Object)engineState.getMessage());
        tieEngingStateDy.set("messagelevel", (Object)engineState.getMessageLevel());
        tieEngingStateDy.set("taskstatusrefreshtime", (Object)engineState.getTaskStatusRefreshTime());
        tieEngingStateDy.set("endtime", (Object)engineState.getEndTime());
        tieEngingStateDy.set("linesuccess", (Object)engineState.getLineSuccess());
        tieEngingStateDy.set("linefailed", (Object)engineState.getLineFailed());
        tieEngingStateDy.set("linenotrun", (Object)engineState.getLineNotRun());
        TIE_ENGING_STATE_HELPER.updateOne(tieEngingStateDy);
    }

    private void transTieEngingStateToDy(TieEngineState tieEngineState, DynamicObject tieEngingStateDy) {
        tieEngingStateDy.set("id", (Object)tieEngineState.getId());
        tieEngingStateDy.set("taskid", (Object)tieEngineState.getTaskid());
        tieEngingStateDy.set("version", (Object)tieEngineState.getVersion());
        tieEngingStateDy.set("request", (Object)tieEngineState.getRequest());
        tieEngingStateDy.set("linesum", (Object)tieEngineState.getLineSum());
        tieEngingStateDy.set("linenotrun", (Object)tieEngineState.getLineNotRun());
        tieEngingStateDy.set("status", (Object)TieState.INIT.toString());
        tieEngingStateDy.set("begintime", (Object)tieEngineState.getBeginTime());
    }
}

