/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.storage.countmsg;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.match.WTCMatchingUtils;
import kd.wtc.wtbs.business.personfilter.utils.JudgeResult;
import kd.wtc.wtbs.common.enums.DataStatus;
import kd.wtc.wtbs.common.enums.StoreSystemParamConfigEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.storage.countmsg.AttFileAndItem;
import kd.wtc.wtes.business.storage.countmsg.CountMsgObject;
import kd.wtc.wtes.business.storage.countmsg.ExtendAttr;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class CountMsgService {
    private static final Log log = LogFactory.getLog(CountMsgService.class);
    private static final HRBaseServiceHelper attDetailRecordService = WtesHRBaseTimeWatchUtil.create(CountMsgService.class.getName() + "." + "wtdtd_attrecorddetail", "wtdtd_attrecorddetail");
    private static final HRBaseServiceHelper countMsgRecordService = WtesHRBaseTimeWatchUtil.create(CountMsgService.class.getName() + "." + "wtte_countmsgrecord", "wtte_countmsgrecord");
    private static final HRBaseServiceHelper countMsgRecordHisService = WtesHRBaseTimeWatchUtil.create(CountMsgService.class.getName() + "." + "wtte_countmsgrecordh", "wtte_countmsgrecordh");
    private static final String attRecordSelect = "id,attmain.personid personid,attmain.owndate owndate,valuestring,attitemid.id attitemId, attitemid.name attitemname, attitemvid,attmain.positionvid positionvid,attmain.attfilevid.position position,attmain.jobvid jobvid,attmain.attfilevid.job job,attmain.managescopevid managescopevid,attmain.attfilevid.managingscope managingscope,attmain.companyvid companyvid,attmain.attfilevid.company company,attmain.departmentvid adminorgvid,attmain.attfilevid.adminorg adminorg,attmain.attfilevid.agreedlocation agreedlocation,attmain.orgid orgid,attmain.affiliateadminorgvid affiliateadminorgvid,attmain.attfilevid.affiliateadminorg affiliateadminorg,attmain.attfilevid.empgroup empgroup,attmain.attfilevid.dependency dependency,attmain.attfilevid.dependencytype dependencytype,attmain.attfilevid.workplace workplace,attmain.attfileid attfileid,attmain.attfilevid attfilevid";
    private static final String ATT_RECORD_BASE_PROPS = "id attmain,personid,owndate,attfileid,attfilevid,attfilevid.org,attfilevid.position,attfilevid.job,attfilevid.managingscope,attfilevid.affiliateadminorg,attfilevid.company,attfilevid.adminorg,attfilevid.empgroup,attfilevid.dependency,attfilevid.dependencytype,attfilevid.workplace,attfilevid.agreedlocation";
    private static final String ATT_RECORD_DETAIL_PROPS = "id,valuestring,attitemvid,attitemid.id attitemnumber, attitemid.name attitemname,attmain";
    private static final CountMsgService instance = (CountMsgService)WTCAppContextHelper.getBean(CountMsgService.class);

    public static CountMsgService getInstance() {
        return instance;
    }

    public void saveMsg(CountMsgObject msgObject) {
        DynamicObject[] allRule = this.queryAllRule();
        DynamicObject[] dynamicObjects = this.queryAttRecord(msgObject);
        HashMap extendMap = Maps.newHashMapWithExpectedSize((int)(dynamicObjects.length / 7));
        List<AttFileAndItem> attFileAndItems = this.makeAttFileAndItemList(dynamicObjects, extendMap);
        List<AttFileAndItem> result = this.matchRule(attFileAndItems, allRule);
        DynamicObjectCollection data = new DynamicObjectCollection();
        Boolean storeHis = (Boolean)SystemParamQueryUtil.getValueByAppNumAndKey((String)"wtte", (String)StoreSystemParamConfigEnum.COUNT_MSG.getKey());
        DynamicObjectCollection historyData = Boolean.TRUE.equals(storeHis) ? new DynamicObjectCollection() : null;
        this.makeData(result, extendMap, msgObject, data, historyData);
        countMsgRecordService.save(data);
        countMsgRecordHisService.save(historyData);
    }

    private void makeData(List<AttFileAndItem> attFileAndItems, Map<Long, ExtendAttr> extendMap, CountMsgObject msgObject, DynamicObjectCollection data, DynamicObjectCollection historyData) {
        if (attFileAndItems == null) {
            return;
        }
        MainEntityType countMsgType = MetadataServiceHelper.getDataEntityType((String)"wtte_countmsgrecord");
        MainEntityType countMsgHisType = MetadataServiceHelper.getDataEntityType((String)"wtte_countmsgrecordh");
        long millis = System.currentTimeMillis();
        for (AttFileAndItem attFileAndItem : attFileAndItems) {
            List<String> countMsgList = attFileAndItem.getCountMsgList();
            if (!CollectionUtils.isNotEmpty(countMsgList)) continue;
            for (String msg : countMsgList) {
                DynamicObject attFile = attFileAndItem.getAttFile();
                DynamicObject countMsgDy = new DynamicObject((DynamicObjectType)countMsgType);
                String number = "MSG_C_" + millis++;
                countMsgDy.set("number", (Object)number);
                countMsgDy.set("countnumber", (Object)msgObject.getVersionId());
                countMsgDy.set("attperson", (Object)attFile.getLong("attperson"));
                countMsgDy.set("content", (Object)msg);
                countMsgDy.set("assigndate", (Object)attFileAndItem.getOwnDate());
                countMsgDy.set("org", (Object)attFile.getLong("org"));
                countMsgDy.set("attfilevid", (Object)attFile.getLong("id"));
                countMsgDy.set("attfileid", (Object)attFile.getLong("boid"));
                long attFileId = attFile.getLong("id");
                ExtendAttr extendAttr = extendMap.get(attFileId);
                if (extendAttr != null) {
                    countMsgDy.set("positionvid", (Object)extendAttr.getPositionvid());
                    countMsgDy.set("jobvid", (Object)extendAttr.getJobvid());
                    countMsgDy.set("companyvid", (Object)extendAttr.getCompanyvid());
                    countMsgDy.set("adminorgvid", (Object)extendAttr.getAdminorgvid());
                    countMsgDy.set("affiliateadminorgvid", (Object)extendAttr.getAffiliateadminorgvid());
                }
                data.add((Object)countMsgDy);
                if (historyData == null) continue;
                DynamicObject countMsgHisDy = new DynamicObject((DynamicObjectType)countMsgHisType);
                HRDynamicObjectUtils.copy((DynamicObject)countMsgDy, (DynamicObject)countMsgHisDy);
                historyData.add((Object)countMsgHisDy);
            }
        }
    }

    private List<AttFileAndItem> makeAttFileAndItemList(DynamicObject[] dynamicObjects, Map<Long, ExtendAttr> extendMap) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return Collections.emptyList();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        HashMap attFileMap = Maps.newHashMapWithExpectedSize((int)(dynamicObjects.length / 7));
        HashMap attFileAndItemMap = Maps.newHashMapWithExpectedSize((int)(dynamicObjects.length / 7));
        ArrayList<AttFileAndItem> attFileAndItems = new ArrayList<AttFileAndItem>();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"wtp_attfilebase");
        for (DynamicObject attRecord : dynamicObjects) {
            Date owndate = attRecord.getDate("owndate");
            String format = sdf.format(owndate);
            Long attfilevid = attRecord.getLong("attfilevid");
            Long attfileBoid = attRecord.getLong("attfileid");
            String key = format + attfilevid;
            AttFileAndItem attFileAndItem = (AttFileAndItem)attFileAndItemMap.get(key);
            if (attFileAndItem == null) {
                attFileAndItem = new AttFileAndItem();
                attFileAndItemMap.put(key, attFileAndItem);
                attFileAndItem.setOwnDate(owndate);
                attFileAndItems.add(attFileAndItem);
            }
            long attItemId = attRecord.getLong("attitemnumber");
            attFileAndItem.getAttItemIds().add(attItemId);
            DynamicObject attFile = (DynamicObject)attFileMap.get(attfilevid);
            if (attFile == null) {
                attFile = new DynamicObject((DynamicObjectType)entityType);
                attFile.set("id", (Object)attfilevid);
                attFile.set("boid", (Object)attfileBoid);
                attFile.set("attperson", (Object)attRecord.getLong("personid"));
                attFile.set("org", (Object)attRecord.getLong("attfilevid.org"));
                attFile.set("position", (Object)attRecord.getLong("attfilevid.position"));
                attFile.set("job", (Object)attRecord.getLong("attfilevid.job"));
                attFile.set("managingscope", (Object)attRecord.getLong("attfilevid.managingscope"));
                attFile.set("company", (Object)attRecord.getLong("attfilevid.company"));
                attFile.set("affiliateadminorg", (Object)attRecord.getLong("attfilevid.affiliateadminorg"));
                attFile.set("adminorg", (Object)attRecord.getLong("attfilevid.adminorg"));
                attFile.set("agreedlocation", (Object)attRecord.getLong("attfilevid.agreedlocation"));
                attFile.set("empgroup", (Object)attRecord.getLong("attfilevid.empgroup"));
                attFile.set("dependency", (Object)attRecord.getLong("attfilevid.dependency"));
                attFile.set("dependencytype", (Object)attRecord.getLong("attfilevid.dependencytype"));
                attFile.set("workplace", (Object)attRecord.getLong("attfilevid.workplace"));
                attFileMap.put(attfilevid, attFile);
                extendMap.computeIfAbsent(attfilevid, e -> new ExtendAttr(attRecord.getLong("attfilevid.position"), attRecord.getLong("attfilevid.job"), attRecord.getLong("attfilevid.managingscope"), attRecord.getLong("attfilevid.company"), attRecord.getLong("attfilevid.adminorg"), attRecord.getLong("attfilevid.affiliateadminorg")));
            }
            attFileAndItem.setAttFile(attFile);
        }
        return attFileAndItems;
    }

    public List<AttFileAndItem> matchRule(List<AttFileAndItem> attFileAndItems, DynamicObject[] allRule) {
        if (CollectionUtils.isEmpty(attFileAndItems) || allRule == null || allRule.length == 0) {
            return attFileAndItems;
        }
        List attFileList = attFileAndItems.stream().map(AttFileAndItem::getAttFile).collect(Collectors.toList());
        log.debug("size={},attFileAndItems = {}", (Object)attFileAndItems.size(), attFileAndItems);
        log.debug("length={},countMsgAllRule={}", (Object)allRule.length, (Object)allRule);
        for (DynamicObject ruleDy : allRule) {
            JudgeResult judgeResult;
            List matchedAttFileIdList;
            String conditions = ruleDy.getString("conditions_tag");
            if (StringUtils.isEmpty((String)conditions) || CollectionUtils.isEmpty((Collection)(matchedAttFileIdList = (judgeResult = WTCMatchingUtils.matchDataBySingleCondition(attFileList, (String)conditions)).getAllMatched()))) continue;
            HashSet attFileIdSet = Sets.newHashSet((Iterable)matchedAttFileIdList);
            List matchItemList = attFileAndItems.stream().filter(info -> attFileIdSet.contains(info.getAttFile().getLong("id"))).collect(Collectors.toList());
            String msgContent = ruleDy.getString("msg.content");
            String type = ruleDy.getString("logytype");
            MulBasedataDynamicObjectCollection ruleAttItemList = (MulBasedataDynamicObjectCollection)ruleDy.get("attitem");
            Set<Long> countMsgRuleConfigIdList = ruleAttItemList.stream().map(info -> info.getLong("fbasedataid_id")).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(countMsgRuleConfigIdList)) continue;
            for (AttFileAndItem item : matchItemList) {
                HashSet<Long> attFileMatchItemIdList = new HashSet<Long>(item.getAttItemIds());
                if (countMsgRuleConfigIdList.size() > 1) {
                    if ("1".equals(type)) {
                        if (!this.getAllMatchFlag(countMsgRuleConfigIdList, attFileMatchItemIdList)) continue;
                        item.getCountMsgList().add(msgContent);
                        continue;
                    }
                    if (!"2".equals(type) || !this.getPartMatchFlag(countMsgRuleConfigIdList, attFileMatchItemIdList)) continue;
                    item.getCountMsgList().add(msgContent);
                    continue;
                }
                if (!attFileMatchItemIdList.contains(countMsgRuleConfigIdList.iterator().next())) continue;
                item.getCountMsgList().add(msgContent);
            }
        }
        log.debug("return attFileAndItems={}", (Object)attFileAndItems.size());
        return attFileAndItems;
    }

    private boolean getAllMatchFlag(Set<Long> countMsgRuleConfigIdList, Set<Long> attFileMatchItemIdList) {
        for (Long attItemId : countMsgRuleConfigIdList) {
            if (attFileMatchItemIdList.contains(attItemId)) continue;
            return false;
        }
        return true;
    }

    private boolean getPartMatchFlag(Set<Long> attItemIdSet, Set<Long> attItemIds) {
        for (Long attItemId : attItemIds) {
            if (!attItemIdSet.contains(attItemId)) continue;
            return true;
        }
        return false;
    }

    private DynamicObject[] queryAttRecord(CountMsgObject msgObject) {
        Set<Long> attFileBoIdSet = this.queryAttFileBoId(msgObject);
        Date startDate = msgObject.getStartDate();
        Date endDate = msgObject.getEndDate();
        String versionId = msgObject.getVersionId();
        HRBaseServiceHelper baseHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        QFilter[] baseQFilters = new QFilter[]{new QFilter("versionid", "=", (Object)versionId), new QFilter("attfileid", "in", attFileBoIdSet), new QFilter("owndate", ">=", (Object)startDate), new QFilter("owndate", "<=", (Object)endDate)};
        DynamicObject[] attMainDys = baseHelper.queryOriginalArray(ATT_RECORD_BASE_PROPS, baseQFilters, "id");
        if (attMainDys.length == 0) {
            return new DynamicObject[0];
        }
        List mainIdColl = Arrays.stream(attMainDys).map(dy -> dy.getLong("attmain")).collect(Collectors.toList());
        QFilter[] detailQFilters = new QFilter[]{new QFilter("attmain", "in", mainIdColl), new QFilter("owndate", ">=", (Object)startDate), new QFilter("owndate", "<=", (Object)endDate)};
        DynamicObject[] attDetailDys = detailHelper.queryOriginalArray(ATT_RECORD_DETAIL_PROPS, detailQFilters, "attmain");
        if (attDetailDys.length == 0) {
            return new DynamicObject[0];
        }
        DynamicObjectType mainDyType = attMainDys[0].getDynamicObjectType();
        DynamicObjectType detailDyType = attDetailDys[0].getDynamicObjectType();
        for (IDataEntityProperty property : mainDyType.getProperties()) {
            if ("attmain".equals(property.getName())) continue;
            DynamicSimpleProperty simpleProperty = new DynamicSimpleProperty(property.getName(), property.getPropertyType(), null);
            detailDyType.registerSimpleProperty(simpleProperty);
        }
        Map baseMap = Arrays.stream(attMainDys).collect(Collectors.toMap(base -> base.getLong("attmain"), Function.identity(), (key1, key2) -> key2));
        for (DynamicObject attDetailDy : attDetailDys) {
            DynamicObject attMain = (DynamicObject)baseMap.get(attDetailDy.getLong("attmain"));
            for (IDataEntityProperty property : mainDyType.getProperties()) {
                attDetailDy.set(property.getName(), attMain.get(property.getName()));
            }
        }
        return attDetailDys;
    }

    private DynamicObject[] queryAllRule() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_countmsgconf");
        QFilter qFilter1 = new QFilter("status", "=", (Object)DataStatus.AUDIT.getCode());
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"1");
        return helper.loadDynamicObjectArray(new QFilter[]{qFilter1, qFilter2});
    }

    Set<Long> queryAttFileBoId(CountMsgObject msgObject) {
        List wtcCalTaskDetailEntities = WTCTaskServiceHelper.batchLoadTaskDetailByTaskIdAndSubTaskId((String)"wtte_tie", (long)msgObject.getTaskId(), (long)msgObject.getSubTaskId(), null);
        return wtcCalTaskDetailEntities.stream().map(WTCCalTaskDetailEntity::getAttFileBoId).collect(Collectors.toSet());
    }
}

