/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.wtc.wtes.business.tie.init.bill.OnBuildOTQFilterEvent;
import kd.sdk.wtc.wtes.business.tie.init.bill.OnBuildTPQFilterEvent;
import kd.sdk.wtc.wtes.business.tie.init.bill.OnVaBillTimeBucketSplitEvent;
import kd.sdk.wtc.wtes.business.tie.init.bill.TieInitOTBillExtPlugin;
import kd.sdk.wtc.wtes.business.tie.init.bill.TieInitTPBillExtPlugin;
import kd.sdk.wtc.wtes.business.tie.init.bill.TvlBillTimeBucketSplitEvent;
import kd.sdk.wtc.wtes.business.tie.init.bill.TvlBillTimeBucketSplitExtPlugin;
import kd.sdk.wtc.wtes.business.tie.init.bill.VaBillInitExpService;
import kd.sdk.wtc.wtes.business.tie.init.bill.VaTimeBucketSplitExtPlugin;
import kd.sdk.wtc.wtes.business.tie.model.roster.ShiftTableExt;
import kd.sdk.wtc.wtes.business.tie.model.timebucket.AttBillTimeBucketExt;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxy;
import kd.wtc.wtbs.business.extplugin.WTCPluginProxyFactory;
import kd.wtc.wtbs.common.enums.AttFilePlanEnum;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtes.business.core.init.InitParam;
import kd.wtc.wtes.business.ext.model.roster.ShiftTableExtImpl;
import kd.wtc.wtes.business.ext.model.timebucket.AttBillTimeBucketExtImpl;
import kd.wtc.wtes.business.ext.utils.ContextExtUtil;
import kd.wtc.wtes.business.model.AttBillTimeBucket;
import kd.wtc.wtes.business.model.ShiftTable;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.service.impl.BillTimeBuckSplitEnum;
import kd.wtc.wtes.business.service.impl.BillTimeBuckSplitServiceImpl;
import kd.wtc.wtes.business.util.CompenTypeEnum;
import kd.wtc.wtes.common.enums.BillNonPlanEnum;

public class AttBillTimeBucketUtil {
    private static final Log logger = LogFactory.getLog(AttBillTimeBucketUtil.class);
    public static final Map<String, BiFunction<InitParam, ShiftTable, List<AttBillTimeBucket>>> BILL_TIME_BUCKET_FUN;
    public static final Map<String, BiFunction<InitParam, ShiftTable, List<DynamicObject>>> billEntry;

    private static List<AttBillTimeBucket> tvlBillPluginProxy(List<DynamicObject> billDyLists, List<AttBillTimeBucket> entityList, ShiftTable shiftTable, LocalDate startDate, LocalDate endDate) {
        WTCPluginProxy pluginProxy = WTCPluginProxyFactory.create(TvlBillTimeBucketSplitExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.init.bill.TvlBillTimeBucketSplitExtPlugin");
        if (pluginProxy.hasPlugin()) {
            ArrayList resEntityList = Lists.newArrayListWithCapacity((int)(entityList.size() * 2));
            Map<Long, DynamicObject> dyMap = billDyLists.stream().collect(Collectors.toMap(vaDy -> vaDy.getLong("id"), vaDy -> vaDy));
            List vpTimeBucketExtList = entityList.stream().map(AttBillTimeBucketExtImpl::new).collect(Collectors.toList());
            TvlBillTimeBucketSplitEvent splitEvent = new TvlBillTimeBucketSplitEvent(vpTimeBucketExtList, billDyLists, (ShiftTableExt)new ShiftTableExtImpl(shiftTable), startDate, endDate);
            pluginProxy.invokeReplace(plugin -> plugin.splitVaBillTimeBucket(splitEvent));
            List splitResultList = splitEvent.getAttBillTimeBucketExtList();
            if (WTCCollections.isEmpty((Collection)splitResultList)) {
                logger.debug("\u4e8c\u5f00\u63d2\u4ef6\u62c6\u5206\u540e\u7684\u65f6\u6bb5\u4e3a\u7a7a");
                return resEntityList;
            }
            for (AttBillTimeBucketExt attBillTimeBucketExt : splitResultList) {
                AttBillTimeBucket attBillTimeBucket = ContextExtUtil.convertAttBillTimeBucketExt(attBillTimeBucketExt, dyMap);
                resEntityList.add(attBillTimeBucket);
            }
            return resEntityList;
        }
        return entityList;
    }

    public static List<AttBillTimeBucket> listByAttPersonIdAndRangeDate(InitParam initRequest, ShiftTable shiftTable) {
        ArrayList<AttBillTimeBucket> attBillTimeBuckets;
        block3: {
            block2: {
                attBillTimeBuckets = new ArrayList<AttBillTimeBucket>(16);
                if (!(initRequest instanceof QuotaInitParamRequest)) break block2;
                Object param = WTCAppContextHelper.getProjectParams().get("quota.init.att.bill.param");
                if (param == null) break block3;
                List billInitType = (List)param;
                for (String type : billInitType) {
                    List<AttBillTimeBucket> apply;
                    BiFunction<InitParam, ShiftTable, List<AttBillTimeBucket>> initBillFun = BILL_TIME_BUCKET_FUN.get(type);
                    if (initBillFun == null || (apply = initBillFun.apply(initRequest, shiftTable)) == null || apply.isEmpty()) continue;
                    attBillTimeBuckets.addAll(apply);
                }
                break block3;
            }
            for (BiFunction<InitParam, ShiftTable, List<AttBillTimeBucket>> value : BILL_TIME_BUCKET_FUN.values()) {
                List<AttBillTimeBucket> apply = value.apply(initRequest, shiftTable);
                if (apply == null || apply.isEmpty()) continue;
                attBillTimeBuckets.addAll(apply);
            }
        }
        return attBillTimeBuckets;
    }

    private static List<DynamicObject> getVaBillInfo(Collection<Long> attPersonIds, LocalDate fromDate, LocalDate toDate) {
        QFilter attPersonIdsFilter = new QFilter("personid", "in", attPersonIds);
        QFilter fromDateFilter = new QFilter("entryentity.entrystartdate", "<=", (Object)WTCDateUtils.toDate((LocalDate)toDate));
        QFilter toDateDateFilter = new QFilter("entryentity.entryenddate", ">=", (Object)WTCDateUtils.toDate((LocalDate)fromDate));
        QFilter audit = new QFilter("billstatus", "=", (Object)"C");
        QFilter isNotLeave = new QFilter("isnotleave", "=", (Object)"0");
        ArrayList qFilterList = Lists.newArrayList((Object[])new QFilter[]{attPersonIdsFilter, isNotLeave, fromDateFilter, toDateDateFilter, audit});
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, VaBillInitExpService.class, (String)"kd.sdk.wtc.wtes.business.tie.init.bill.VaBillInitExpService", null);
        List callResult = hrPluginProxy.callReplace(plugin -> {
            plugin.onAddFilters(qFilterList);
            return null;
        });
        logger.debug("AttBillTimeBucketUtil.getVaBillInfo, qFilters:{}", (Object)qFilterList);
        QFilter[] qFilters = new QFilter[qFilterList.size()];
        qFilters = qFilterList.toArray(qFilters);
        String properties = "parentid,personid.id,billno,billstatus,attfilebasef7.id,attfile.id,entryentity.specialvatype,entryentity.entrystartdate,entryentity.entryenddate,entryentity.owndate,entryentity.entrystartmethod,entryentity.entryendmethod,entryentity.specialvamethod,entryentity.specialextjson,entryentity.storageto,entryentity.entryvacationtype,entryentity.specialvatype,entryentity.isdisposable,entryentity.entryunit,entryentity.entryvatimehour";
        HRBaseServiceHelper vaServiceHelper = new HRBaseServiceHelper("wtabm_vaapply");
        DynamicObject[] query = vaServiceHelper.query(properties, qFilters);
        ArrayList entityIds = Lists.newArrayListWithExpectedSize((int)10);
        for (DynamicObject dynamicObject : query) {
            DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                String spVaType = entry.getString("specialvatype");
                if (!StringUtils.equals((CharSequence)"A", (CharSequence)spVaType)) continue;
                long entryId = (Long)entry.getPkValue();
                entityIds.add(entryId);
            }
        }
        ArrayList<DynamicObject> result = new ArrayList(query.length);
        if (CollectionUtils.isNotEmpty((Collection)entityIds)) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"wtabm_vaapply");
            HRBaseServiceHelper vaDetailServiceHelper = new HRBaseServiceHelper("wtabm_vadetail");
            QFilter[] vaDetailFilters = new QFilter[]{new QFilter("entryid", "in", (Object)entityIds)};
            String vaDetailProperties = "vaentrystarttime,vaentryendtime,vaentrydate,entryid";
            DynamicObject[] vaDetailDyns = vaDetailServiceHelper.query(vaDetailProperties, vaDetailFilters);
            Map<Long, List<DynamicObject>> entryVaDetailMap = Arrays.stream(vaDetailDyns).collect(Collectors.groupingBy(vaDetailDyn -> vaDetailDyn.getLong("entryid")));
            for (DynamicObject dynamicObject : query) {
                DynamicObjectCollection entryDyns = dynamicObject.getDynamicObjectCollection("entryentity");
                Map<Long, DynamicObject> entryDynMap = entryDyns.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
                if (CollectionUtils.isEmpty((Collection)CollectionUtils.intersection(entryDynMap.keySet(), (Collection)entityIds))) {
                    result.add(dynamicObject);
                    continue;
                }
                DynamicObject target = AttBillTimeBucketUtil.createVaDyn(dynamicObject, entryVaDetailMap, dataEntityType);
                result.add(target);
            }
        } else {
            result = Arrays.asList(query);
        }
        return result;
    }

    private static DynamicObject createVaDyn(DynamicObject source, Map<Long, List<DynamicObject>> vaDetailDynMap, MainEntityType dataEntityType) {
        DynamicObject target = new DynamicObject((DynamicObjectType)dataEntityType);
        target.set("id", (Object)source.getLong("id"));
        target.set("billno", (Object)source.getString("billno"));
        target.set("billstatus", (Object)source.getString("billstatus"));
        target.set("personid", source.get("personid"));
        target.set("parentid", (Object)source.getLong("parentid"));
        AttBillTimeBucketUtil.createVaEntryDyn(source, target, vaDetailDynMap);
        return target;
    }

    private static void createVaEntryDyn(DynamicObject source, DynamicObject target, Map<Long, List<DynamicObject>> vaDetailDynMap) {
        DynamicObjectCollection sourceEntryList = source.getDynamicObjectCollection("entryentity");
        EntryProp entryProp = (EntryProp)target.getDataEntityType().getProperties().get((Object)"entryentity");
        EntryType entryType = (EntryType)entryProp.getItemType();
        DynamicObjectCollection entries = target.getDynamicObjectCollection("entryentity");
        for (DynamicObject sourceEntry : sourceEntryList) {
            DynamicObject newRow = new DynamicObject((DynamicObjectType)entryType);
            newRow.set("id", (Object)sourceEntry.getLong("id"));
            newRow.set("entryvacationtype", sourceEntry.get("entryvacationtype"));
            newRow.set("owndate", (Object)sourceEntry.getDate("owndate"));
            newRow.set("entrystartdate", (Object)sourceEntry.getDate("entrystartdate"));
            newRow.set("entryenddate", (Object)sourceEntry.getDate("entryenddate"));
            newRow.set("entrystartmethod", (Object)sourceEntry.getString("entrystartmethod"));
            newRow.set("entryendmethod", (Object)sourceEntry.getString("entryendmethod"));
            newRow.set("specialvatype", (Object)sourceEntry.getString("specialvatype"));
            newRow.set("specialextjson", (Object)sourceEntry.getString("specialextjson"));
            newRow.set("specialvamethod", sourceEntry.get("specialvamethod"));
            newRow.set("storageto", sourceEntry.get("storageto"));
            List<DynamicObject> subEntryDyns = vaDetailDynMap.get(sourceEntry.getLong("id"));
            AttBillTimeBucketUtil.createVaSubEntryDyns(newRow, subEntryDyns);
            entries.add((Object)newRow);
        }
    }

    private static void createVaSubEntryDyns(DynamicObject entryDyn, List<DynamicObject> subEntryDyns) {
        if (CollectionUtils.isNotEmpty(subEntryDyns)) {
            SubEntryProp subEntryProp = (SubEntryProp)entryDyn.getDataEntityType().getProperties().get((Object)"vadetailentry");
            SubEntryType itemType = (SubEntryType)subEntryProp.getItemType();
            DynamicObjectCollection subEntryDynList = entryDyn.getDynamicObjectCollection("vadetailentry");
            for (DynamicObject dyn : subEntryDyns) {
                DynamicObject subEntryDyn = new DynamicObject((DynamicObjectType)itemType);
                subEntryDyn.set("id", (Object)dyn.getLong("id"));
                subEntryDyn.set("vaentrystarttime", (Object)dyn.getDate("vaentrystarttime"));
                subEntryDyn.set("vaentryendtime", (Object)dyn.getDate("vaentryendtime"));
                subEntryDyn.set("vaentrydate", (Object)dyn.getDate("vaentrydate"));
                subEntryDynList.add((Object)subEntryDyn);
            }
        }
    }

    private static QFilter[] getTravelQueryCondition(Collection<Long> attPersonIds, LocalDate fromDate, LocalDate toDate) {
        QFilter attPersonIdsFilter = new QFilter("personid", "in", attPersonIds);
        QFilter fromDateFilter = new QFilter("entryentity.startdate", "<", (Object)WTCDateUtils.toDate((LocalDate)toDate));
        QFilter toDateDateFilter = new QFilter("entryentity.enddate", ">=", (Object)WTCDateUtils.toDate((LocalDate)fromDate));
        QFilter isNotLeave = new QFilter("isnottrip", "=", (Object)"0");
        QFilter audit = new QFilter("billstatus", "=", (Object)"C");
        return new QFilter[]{attPersonIdsFilter, fromDateFilter, toDateDateFilter, audit, isNotLeave};
    }

    private static List<AttBillTimeBucket> getWorkEntityList(DynamicObject[] workApplyBills, LocalDate fromDate, LocalDate toDate) {
        ArrayList<AttBillTimeBucket> result = new ArrayList<AttBillTimeBucket>(16);
        if (workApplyBills == null || workApplyBills.length == 0) {
            return result;
        }
        for (DynamicObject workApplyBill : workApplyBills) {
            DynamicObjectCollection sentryEntry = workApplyBill.getDynamicObjectCollection("sdentry");
            result.addAll(AttBillTimeBucketUtil.getWorkEntityList(workApplyBill, fromDate, toDate, sentryEntry));
        }
        return result;
    }

    private static List<AttBillTimeBucket> getWorkEntityList(DynamicObject dynamicObject, LocalDate fromDate, LocalDate toDate, DynamicObjectCollection entry) {
        List<DynamicObject> sentryEntry;
        ArrayList<AttBillTimeBucket> attBillTimeBucketList = new ArrayList<AttBillTimeBucket>();
        Date startDate = WTCDateUtils.toDate((LocalDate)fromDate);
        Date endDate = WTCDateUtils.toDate((LocalDate)toDate);
        String dutyDateStr = "otdutydate";
        if (!CollectionUtils.isEmpty((Collection)entry) && !CollectionUtils.isEmpty(sentryEntry = entry.stream().filter(object -> object.getDate(dutyDateStr) != null && object.getDate(dutyDateStr).compareTo(startDate) >= 0 && object.getDate(dutyDateStr).compareTo(endDate) <= 0).collect(Collectors.toList()))) {
            sentryEntry.forEach(object -> attBillTimeBucketList.add(AttBillTimeBucketUtil.getWorkEntity(dynamicObject, object)));
        }
        return attBillTimeBucketList;
    }

    private static AttBillTimeBucket getWorkEntity(DynamicObject dynamicObject, DynamicObject object) {
        long attPersonId = dynamicObject.getLong("personid.id");
        LocalDateTime otdEndDate = WTCDateUtils.toLocalDateTime((Date)object.getDate("otenddate"));
        LocalDateTime otdStartDate = WTCDateUtils.toLocalDateTime((Date)object.getDate("otstartdate"));
        LocalDate shiftDate = WTCDateUtils.toLocalDate((Date)object.getDate("otdutydate"));
        return AttBillTimeBucket.with().attPersonId(attPersonId).billId(dynamicObject.getLong("id")).compenTypeId(object.getLong("compentyped.id")).billTypeBig("OT").endTime(otdEndDate).id(object.getLong("id")).number(dynamicObject.getString("billno")).rosterDate(shiftDate).startTime(otdStartDate).entryRowDy(object).billType(object.getLong("sdottype.id")).compenType(CompenTypeEnum.form(object.getString("compentyped.number")).getType()).otpBillDyn(dynamicObject).build();
    }

    private static QFilter[] getQueryScentryWorkCondition(Collection<Long> attPersonIds, LocalDate fromDate, LocalDate toDate) {
        QFilter attPersonIdsFilter = new QFilter("personid.id", "in", attPersonIds);
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)toDate).and(new QFilter("enddate", ">=", (Object)fromDate));
        QFilter iscancel = new QFilter("iscancel", "=", (Object)"0");
        QFilter[] qs = new QFilter[]{attPersonIdsFilter, dateFilter, billStatus, iscancel};
        return qs;
    }

    private static QFilter[] getQuerySdentryWorkCondition(Collection<Long> attPersonIds, LocalDate fromDate, LocalDate toDate) {
        QFilter attPersonIdsFilter = new QFilter("personid.id", "in", attPersonIds);
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter dentryDateFilter = new QFilter("sdentry.otdutydate", "<", (Object)WTCDateUtils.toDate((LocalDate)toDate)).and(new QFilter("sdentry.otdutydate", ">=", (Object)WTCDateUtils.toDate((LocalDate)fromDate)));
        return new QFilter[]{attPersonIdsFilter, dentryDateFilter, billStatus};
    }

    private static List<AttBillTimeBucket> getScentWorkEntityList(DynamicObject[] workApplyBills, LocalDate fromDate, LocalDate toDate) {
        ArrayList<AttBillTimeBucket> result = new ArrayList<AttBillTimeBucket>(16);
        if (workApplyBills == null || workApplyBills.length == 0) {
            return result;
        }
        for (DynamicObject workApplyBill : workApplyBills) {
            DynamicObjectCollection scentEntry = workApplyBill.getDynamicObjectCollection("scentry");
            result.addAll(AttBillTimeBucketUtil.getScentWorkEntityList(workApplyBill, fromDate, toDate, scentEntry));
        }
        return result;
    }

    private static List<AttBillTimeBucket> getScentWorkEntityList(DynamicObject dynamicObject, LocalDate fromDate, LocalDate toDate, DynamicObjectCollection entry) {
        List<DynamicObject> dutyEntry;
        ArrayList<AttBillTimeBucket> attBillTimeBucketList = new ArrayList<AttBillTimeBucket>();
        Date startDate = WTCDateUtils.toDate((LocalDate)fromDate);
        Date endDate = WTCDateUtils.toDate((LocalDate)toDate);
        String dutyDateStr = "dutydate";
        if (!CollectionUtils.isEmpty((Collection)entry) && !CollectionUtils.isEmpty(dutyEntry = entry.stream().filter(object -> object.getDate("dutydate") != null && object.getDate(dutyDateStr).compareTo(startDate) >= 0 && object.getDate(dutyDateStr).compareTo(endDate) <= 0).collect(Collectors.toList()))) {
            dutyEntry.forEach(object -> attBillTimeBucketList.add(AttBillTimeBucketUtil.getScentWorkEntity(dynamicObject, object)));
        }
        return attBillTimeBucketList;
    }

    private static AttBillTimeBucket getScentWorkEntity(DynamicObject dynamicObject, DynamicObject object) {
        LocalDate shiftDate = WTCDateUtils.toLocalDate((Date)object.getDate("dutydate"));
        LocalDateTime otdEndDate = WTCDateUtils.toLocalDateTime((Date)object.getDate("otdendtime"));
        LocalDateTime otdStartDate = WTCDateUtils.toLocalDateTime((Date)object.getDate("otdstarttime"));
        if (otdStartDate != null && otdEndDate != null) {
            return AttBillTimeBucketUtil.builderBaseInfo(dynamicObject, object, shiftDate).endTime(otdEndDate).startTime(otdStartDate).build();
        }
        long otTime = object.getLong("otdtime");
        return AttBillTimeBucketUtil.builderBaseInfo(dynamicObject, object, shiftDate).billNonPlanEnum(BillNonPlanEnum.SELF_DURATION).duration(otTime).build();
    }

    private static AttBillTimeBucket.Builder builderBaseInfo(DynamicObject dynamicObject, DynamicObject object, LocalDate shiftDate) {
        long attPersonId = dynamicObject.getLong("personid.id");
        return AttBillTimeBucket.with().attPersonId(attPersonId).billId(dynamicObject.getLong("id")).compenTypeId(object.getLong("compentype.id")).billTypeBig("OT").id(object.getLong("id")).number(dynamicObject.getString("billno")).rosterDate(shiftDate).billType(object.getLong("scottype.id")).compenType(CompenTypeEnum.form(object.getString("compentype.number")).getType()).otpBillDyn(dynamicObject).entryRowDy(object);
    }

    private static QFilter[] onBuildOTQFilterExp(QFilter[] originalFilter) {
        WTCPluginProxy pluginProxy = WTCPluginProxyFactory.create(TieInitOTBillExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.init.bill.TieInitOTBillExtPlugin");
        if (!pluginProxy.hasPlugin()) {
            return originalFilter;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(Arrays.asList(originalFilter));
        pluginProxy.invokeReplace(plugin -> plugin.onBuildQFilter(new OnBuildOTQFilterEvent((List)qFilters)));
        return qFilters.toArray(new QFilter[0]);
    }

    private static QFilter[] onBuildTPQFilterExp(QFilter[] originalFilter) {
        WTCPluginProxy pluginProxy = WTCPluginProxyFactory.create(TieInitTPBillExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.init.bill.TieInitTPBillExtPlugin");
        if (!pluginProxy.hasPlugin()) {
            return originalFilter;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(Arrays.asList(originalFilter));
        pluginProxy.invokeReplace(plugin -> plugin.onBuildQFilter(new OnBuildTPQFilterEvent((List)qFilters)));
        return qFilters.toArray(new QFilter[0]);
    }

    static {
        billEntry = new HashMap<String, BiFunction<InitParam, ShiftTable, List<DynamicObject>>>(16);
        billEntry.put(AttFilePlanEnum.VP.getSign(), (initRequest, shiftTable) -> {
            List<Long> attPersonIds = initRequest.getAttPersonIds();
            LocalDate fromDate = initRequest.getStartDate();
            LocalDate toDate = initRequest.getEndDate();
            List<DynamicObject> vaDyLists = AttBillTimeBucketUtil.getVaBillInfo(attPersonIds, fromDate, toDate);
            return vaDyLists;
        });
        BILL_TIME_BUCKET_FUN = new HashMap<String, BiFunction<InitParam, ShiftTable, List<AttBillTimeBucket>>>(16);
        BILL_TIME_BUCKET_FUN.put(AttFilePlanEnum.OTP.getSign(), (initRequest, shiftTable) -> {
            List<Long> attPersonIds = initRequest.getAttPersonIds();
            LocalDate fromDate = initRequest.getStartDate();
            LocalDate toDate = initRequest.getEndDate();
            HRBaseServiceHelper workServiceHelper = new HRBaseServiceHelper("wtom_overtimeapplybill");
            QFilter[] filters = AttBillTimeBucketUtil.getQueryScentryWorkCondition(attPersonIds, fromDate, toDate);
            QFilter[] newQFilters = AttBillTimeBucketUtil.onBuildOTQFilterExp(filters);
            DynamicObject[] scentryWorkBills = workServiceHelper.loadDynamicObjectArray(newQFilters);
            ArrayList<AttBillTimeBucket> otBillTimeBucket = new ArrayList<AttBillTimeBucket>(AttBillTimeBucketUtil.getScentWorkEntityList(scentryWorkBills, fromDate, toDate));
            otBillTimeBucket.addAll(AttBillTimeBucketUtil.getWorkEntityList(scentryWorkBills, fromDate, toDate));
            return otBillTimeBucket;
        });
        BILL_TIME_BUCKET_FUN.put(AttFilePlanEnum.VP.getSign(), (initRequest, shiftTable) -> {
            List<Long> attPersonIds = initRequest.getAttPersonIds();
            LocalDate fromDate = initRequest.getStartDate();
            LocalDate toDate = initRequest.getEndDate();
            List<Object> vpBillTimeBucket = new ArrayList();
            BillTimeBuckSplitServiceImpl buckSplitService = new BillTimeBuckSplitServiceImpl();
            List<DynamicObject> vaDyLists = AttBillTimeBucketUtil.getVaBillInfo(attPersonIds, fromDate, toDate);
            if (vaDyLists != null && vaDyLists.size() != 0) {
                WTCPluginProxy pluginProxy;
                if (logger.isDebugEnabled()) {
                    logger.debug("\u67e5\u8be2\u51fa\u7684\u4f11\u5047\u5355\u4e2a\u6570{},\u8003\u52e4\u4ebaid{},\u5f00\u59cb\u65f6\u95f4{},\u7ed3\u675f\u65f6\u95f4{}", new Object[]{vaDyLists.size(), JSON.toJSON(attPersonIds), fromDate, toDate});
                }
                vpBillTimeBucket = buckSplitService.splitTimeBucket4Bustrip((ShiftTable)shiftTable, (Iterable<DynamicObject>)vaDyLists, BillTimeBuckSplitEnum.VA_BILL_PRAM);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u62c6\u5206\u540e\u7684\u4f11\u5047\u5355{}", (Object)JSON.toJSONString(vpBillTimeBucket));
                }
                if ((pluginProxy = WTCPluginProxyFactory.create(VaTimeBucketSplitExtPlugin.class, (String)"kd.sdk.wtc.wtes.business.tie.init.bill.VaTimeBucketSplitExtPlugin")).hasPlugin()) {
                    Map<Long, DynamicObject> vaDyMap = vaDyLists.stream().collect(Collectors.toMap(vaDy -> vaDy.getLong("id"), vaDy -> vaDy));
                    List vpTimeBucketExtList = vpBillTimeBucket.stream().map(AttBillTimeBucketExtImpl::new).collect(Collectors.toList());
                    OnVaBillTimeBucketSplitEvent splitEvent = new OnVaBillTimeBucketSplitEvent(vpTimeBucketExtList, vaDyLists);
                    splitEvent.setShiftTableExt((ShiftTableExt)new ShiftTableExtImpl((ShiftTable)shiftTable));
                    pluginProxy.invokeReplace(plugin -> plugin.onSplitVaBillTimeBucket(splitEvent));
                    if (!splitEvent.isCancel()) {
                        List splitResultList = splitEvent.getAttBillTimeBucketExtList();
                        vpBillTimeBucket.clear();
                        if (WTCCollections.isEmpty((Collection)splitResultList)) {
                            logger.debug("\u4e8c\u5f00\u63d2\u4ef6\u62c6\u5206\u540e\u7684\u4f11\u5047\u5355\u65f6\u6bb5\u4e3a\u7a7a");
                            return vpBillTimeBucket;
                        }
                        for (AttBillTimeBucketExt attBillTimeBucketExt : splitResultList) {
                            AttBillTimeBucket attBillTimeBucket = ContextExtUtil.convertAttBillTimeBucketExt(attBillTimeBucketExt, vaDyMap);
                            vpBillTimeBucket.add(attBillTimeBucket);
                        }
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u4e8c\u5f00\u63d2\u4ef6\u62c6\u5206\u540e\u7684\u4f11\u5047\u5355\u65f6\u6bb5{}", (Object)JSON.toJSONString(vpBillTimeBucket));
                }
            }
            return vpBillTimeBucket;
        });
        BILL_TIME_BUCKET_FUN.put(AttFilePlanEnum.TP.getSign(), (initRequest, shiftTable) -> {
            List<Long> attPersonIds = initRequest.getAttPersonIds();
            LocalDate fromDate = initRequest.getStartDate();
            LocalDate toDate = initRequest.getEndDate();
            BillTimeBuckSplitServiceImpl buckSplitService = new BillTimeBuckSplitServiceImpl();
            HRBaseServiceHelper travelServiceHelper = new HRBaseServiceHelper("wtam_busitripbill");
            QFilter[] qFilters = AttBillTimeBucketUtil.getTravelQueryCondition(attPersonIds, fromDate, toDate);
            QFilter[] newQFilters = AttBillTimeBucketUtil.onBuildTPQFilterExp(qFilters);
            DynamicObject[] travelBillSplits = travelServiceHelper.loadDynamicObjectArray(newQFilters);
            ArrayList<DynamicObject> travelBillDyLists = new ArrayList<DynamicObject>(travelBillSplits.length);
            travelBillDyLists.addAll(Arrays.asList(travelBillSplits));
            if (logger.isDebugEnabled()) {
                logger.debug("\u67e5\u8be2\u51fa\u7684\u51fa\u5dee\u5355\u4e2a\u6570{},\u8003\u52e4\u4ebaid{},\u5f00\u59cb\u65f6\u95f4{},\u7ed3\u675f\u65f6\u95f4{}", new Object[]{travelBillSplits.length, attPersonIds, fromDate, toDate});
            }
            List<AttBillTimeBucket> travelEntityList = buckSplitService.splitTimeBucket4Bustrip((ShiftTable)shiftTable, (Iterable<DynamicObject>)travelBillDyLists, BillTimeBuckSplitEnum.TL_BILL_PRAM);
            if (logger.isDebugEnabled()) {
                logger.debug("\u6807\u54c1\u62c6\u5206\u540e\u7684\u51fa\u5dee\u5355{}", travelEntityList);
            }
            travelEntityList = AttBillTimeBucketUtil.tvlBillPluginProxy(travelBillDyLists, travelEntityList, shiftTable, fromDate, toDate);
            if (logger.isDebugEnabled()) {
                logger.debug("\u62c6\u5206\u540e\u7684\u51fa\u5dee\u5355{}", travelEntityList);
            }
            return travelEntityList;
        });
    }
}

