/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtes.business.model.rlra.AttItemLabelConfigEntity;
import kd.wtc.wtes.business.model.rlra.AttItemLabelEntryPackage;
import kd.wtc.wtes.business.util.CardPointUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttItemLabelUtil {
    private static Log logger = LogFactory.getLog(AttItemLabelUtil.class);
    private static String propertiesQuery = null;

    public static List<AttItemLabelConfigEntity> listValidVersionAttItemLabelInRangeDate(LocalDate fromDate, LocalDate toDate) {
        List<AttItemLabelConfigEntity> attItemSpecList = AttItemLabelUtil.listAttItemLabel("wtbd_attitemmap", fromDate, toDate);
        return CollectionUtils.isEmpty(attItemSpecList) ? Collections.emptyList() : attItemSpecList;
    }

    private static AttItemLabelConfigEntity getAttItemLabelEntity(DynamicObject dynamicObject, Boolean isTimeSeq) {
        if (isTimeSeq.booleanValue()) {
            TimeSeqInfoImpl timeSeqEntity = AttItemLabelUtil.getTimeSeqEntity(dynamicObject);
            return AttItemLabelUtil.builtAttItemLabelEntity(dynamicObject, AttItemLabelConfigEntity.withTimeSeq((TimeSeqInfo)timeSeqEntity));
        }
        return AttItemLabelUtil.builtAttItemLabelEntity(dynamicObject, AttItemLabelConfigEntity.withNonTimeSeq());
    }

    private static AttItemLabelConfigEntity builtAttItemLabelEntity(DynamicObject dynamicObject, AttItemLabelConfigEntity.Builder<?, ?> builder) {
        ArrayList<AttItemLabelEntryPackage> itemLabelEntryList = new ArrayList<AttItemLabelEntryPackage>();
        DynamicObjectCollection entryObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryPackageItem : entryObjectCollection) {
            if (entryPackageItem != null) {
                AttItemLabelEntryPackage.AttItemLabelEntryPackageBuilder attLabelBuilder = AttItemLabelEntryPackage.AttItemLabelEntryPackageBuilder.anExConfigEntryPackage().dateType(entryPackageItem.getString("dateattr")).dateAttrIdStr(entryPackageItem.getString("dateattridstr")).timeBucketIdStr(entryPackageItem.getString("timebucketidstr")).shiftTimeBucketProperty(entryPackageItem.getString("shifttbprop"));
                DynamicObject attendanceStatus = entryPackageItem.getDynamicObject("attstsid");
                if (null != attendanceStatus) {
                    attLabelBuilder.attStatus(attendanceStatus.getString("number"));
                }
                DynamicObjectCollection projectCollection = entryPackageItem.getDynamicObjectCollection("projectid");
                String projectList = projectCollection.stream().filter(dy -> null != dy.getDynamicObject("fbasedataid")).map(dy -> dy.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.joining(","));
                attLabelBuilder.attItem(projectList);
                DynamicObject timeLabel = entryPackageItem.getDynamicObject("tblabelid");
                if (null != timeLabel) {
                    attLabelBuilder.pairLabel(timeLabel.getString("number"));
                }
                itemLabelEntryList.add(attLabelBuilder.build());
                continue;
            }
            logger.warn("built_AttItem_Label_Entity_is_null_id: {}", (Object)dynamicObject.getLong("id"));
        }
        DynamicObject countryEntry = dynamicObject.getDynamicObject("countryid");
        if (countryEntry != null) {
            builder.country(countryEntry.getString("number"));
        }
        return (AttItemLabelConfigEntity)((AttItemLabelConfigEntity.Builder)((AttItemLabelConfigEntity.Builder)builder.attItemLabelRelationEntryPackageList(itemLabelEntryList).id(dynamicObject.getLong("id"))).number(dynamicObject.getString("number"))).build();
    }

    private static TimeSeqInfoImpl getTimeSeqEntity(DynamicObject dynamicObject) {
        LocalDate bsled = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("bsled"));
        LocalDate bsed = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("bsed"));
        return (TimeSeqInfoImpl)((TimeSeqInfoImpl.Builder)((TimeSeqInfoImpl.Builder)TimeSeqInfoImpl.with().blsed(bsled).bsed(bsed).bid(dynamicObject.getLong("boid")).id(dynamicObject.getLong("id"))).number(dynamicObject.getString("number"))).build();
    }

    private static List<AttItemLabelConfigEntity> listAttItemLabel(String entityName, LocalDate fromDate, LocalDate toDate) {
        QFilter[] qFilter = CardPointUtil.getQueryCondition(fromDate, toDate);
        Map dynamicObjectsMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)propertiesQuery, (QFilter[])qFilter);
        ArrayList<AttItemLabelConfigEntity> attItemLabelList = new ArrayList<AttItemLabelConfigEntity>();
        if (dynamicObjectsMap != null && dynamicObjectsMap.size() > 0) {
            for (Map.Entry entity : dynamicObjectsMap.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entity.getValue();
                attItemLabelList.add(AttItemLabelUtil.getAttItemLabelEntity(dynamicObject, Boolean.TRUE));
            }
        }
        return attItemLabelList;
    }

    static {
        ArrayList<String> propertiedList = new ArrayList<String>();
        propertiedList.add("entryentity.dateattr");
        propertiedList.add("entryentity.shifttbprop");
        propertiedList.add("entryentity.attstsid");
        propertiedList.add("entryentity.projectid");
        propertiedList.add("entryentity.tblabelid");
        propertiedList.add("entryentity.timebucketidstr");
        propertiedList.add("entryentity.dateattridstr");
        propertiedList.add("countryid");
        propertiedList.add("id");
        propertiedList.add("boid");
        propertiedList.add("number");
        propertiedList.add("bsled");
        propertiedList.add("bsed");
        propertiesQuery = WTCStringUtils.join(propertiedList, (String)",");
    }
}

