/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.enums.HisDataStatus;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjust;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttRecordAdjustUtil {
    private static HRBaseServiceHelper revisionMoveHelper = new HRBaseServiceHelper("wtte_revisionmovehis");

    public static List<AttRecordAdjust> listByAttPersonIdAndRangeDate(Collection<Long> attPersonIds, LocalDate fromDate, LocalDate toDate) {
        ArrayList<AttRecordAdjust> attrecordAdjustList = null;
        DynamicObject[] dynamicObjects = revisionMoveHelper.loadDynamicObjectArray(AttRecordAdjustUtil.getQueryCondition(attPersonIds, fromDate, toDate));
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            attrecordAdjustList = new ArrayList<AttRecordAdjust>(16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                attrecordAdjustList.addAll(AttRecordAdjustUtil.ListAttRecordAdjustEntity(dynamicObject, fromDate, toDate));
            }
        }
        return CollectionUtils.isEmpty(attrecordAdjustList) ? Collections.emptyList() : attrecordAdjustList;
    }

    private static List<AttRecordAdjust> ListAttRecordAdjustEntity(DynamicObject dy, LocalDate fromDate, LocalDate toDate) {
        ArrayList<AttRecordAdjust> attrecordAdjustList = new ArrayList<AttRecordAdjust>(16);
        DynamicObjectCollection dynamicObjectCollection = dy.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return attrecordAdjustList;
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            LocalDate endDate = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("enddate"));
            LocalDate startDate = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("startdate"));
            if (endDate == null || startDate == null) continue;
            LocalDate calculateDate = startDate;
            while (endDate.compareTo(calculateDate) >= 0) {
                if (calculateDate.compareTo(fromDate) >= 0 && calculateDate.compareTo(toDate) <= 0) {
                    attrecordAdjustList.addAll(AttRecordAdjustUtil.getAttRecordAdjustEntityList(dynamicObject, calculateDate, dy));
                }
                calculateDate = calculateDate.plusDays(1L);
            }
        }
        return attrecordAdjustList;
    }

    private static List<AttRecordAdjust> getAttRecordAdjustEntityList(DynamicObject dynamicObject, LocalDate calculateDate, DynamicObject dy) {
        DynamicObject item;
        DynamicObject personDynamic = dynamicObject.getDynamicObject("attperson");
        long attPersonId = 0L;
        if (personDynamic != null) {
            attPersonId = personDynamic.getLong("id");
        }
        long itemId = (item = dynamicObject.getDynamicObject("item")) != null ? item.getLong("id") : 0L;
        DynamicObject bemoveItem = dynamicObject.getDynamicObject("bemoveitem");
        long bemoveItemId = bemoveItem != null ? bemoveItem.getLong("id") : itemId;
        String attfileStr = dynamicObject.getString("attfileids");
        ArrayList<AttRecordAdjust> attRecordAdjustList = new ArrayList<AttRecordAdjust>(16);
        if (WTCStringUtils.isNotEmpty((String)attfileStr)) {
            String[] attfileIds;
            for (String attfileId : attfileIds = attfileStr.split(",")) {
                AttRecordAdjust attRecordAdjust = AttRecordAdjust.with().attPersonId(attPersonId).calculateDate(calculateDate).bemoveItemId(bemoveItemId).adjustTrimId(dynamicObject.getLong("id")).itemId(itemId).trimType(dynamicObject.getString("trimtype")).itemUnit(dynamicObject.getString("itemunit")).value(dynamicObject.getInt("value")).attfileId(WTCStringUtils.isNotEmpty((String)attfileId) ? Long.parseLong(attfileId) : 0L).createTime(dy.getDate("createtime")).modifier(dy.getLong("modifier.id")).modifyTime(dy.getDate("modifytime")).build();
                attRecordAdjustList.add(attRecordAdjust);
            }
        }
        return attRecordAdjustList;
    }

    private static QFilter[] getQueryCondition(Collection<Long> attPersonIds, LocalDate fromDate, LocalDate toDate) {
        QFilter attPersonIdsFilter = new QFilter("entryentity.attperson", "in", attPersonIds);
        QFilter fromDateFilter = new QFilter("entryentity.startdate", "<", (Object)WTCDateUtils.toDate((LocalDate)toDate));
        QFilter toDateDateFilter = new QFilter("entryentity.enddate", ">=", (Object)WTCDateUtils.toDate((LocalDate)fromDate));
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)HisDataStatus.EFFECTIVE.code);
        return new QFilter[]{attPersonIdsFilter, fromDateFilter, toDateDateFilter, statusFilter, new QFilter("enable", "=", (Object)"1")};
    }
}

