/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.model.attendperson.AdminOrg;
import kd.wtc.wtbs.business.model.attendperson.CmpEmp;
import kd.wtc.wtbs.business.model.attendperson.Company;
import kd.wtc.wtbs.business.model.attendperson.Job;
import kd.wtc.wtbs.business.model.attendperson.Position;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.attperiod.chain.TieAttPeriodContext;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.AttPeriodSpliteModel;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjust;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrim;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimData;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimResult;
import kd.wtc.wtes.business.std.TieMessageStd;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.chain.TieDataResultStd;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNode;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.business.util.ContextUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttRecordTrimUtil {
    private static final Log LOGGER = LogFactory.getLog(AttRecordTrimUtil.class);
    private static HRBaseServiceHelper revisionHisHelper = new HRBaseServiceHelper("wtte_revisionhis");
    private static final String SELECT_FIELDS = "startdate,enddate,revisiontype,attfilebase.attperson.id,attitem.id,attitem.name,attitem.unit,attitemto.id,attfilebase.id,id,revisionentryid,adjusttype,value,datastatus,modifier.id";

    public static AttRecordTrim listByAttPersonIdAndRangeDate(Collection<Long> attPersonIds, LocalDate fromDate, LocalDate toDate, AttPeriodTable attPeriodTable) {
        Optional<PerAttPeriod> optionalMin = attPeriodTable.getAccountMinAttPeriodBeginDate();
        Date periodStartDate = optionalMin.isPresent() ? optionalMin.get().getPerAttBeginDate() : WTCDateUtils.toDate((LocalDate)fromDate);
        Optional<PerAttPeriod> optionalMax = attPeriodTable.getAccountMaxAttPeriodEndDate();
        Date periodEndDate = optionalMax.isPresent() ? optionalMax.get().getPerAttEndDate() : WTCDateUtils.toDate((LocalDate)toDate);
        DynamicObject[] dynamicObjects = revisionHisHelper.queryOriginalArray(SELECT_FIELDS, AttRecordTrimUtil.getQueryCondition(attPersonIds, periodStartDate, periodEndDate));
        ArrayList<AttRecordAdjust> attDayRecordAdjustList = new ArrayList<AttRecordAdjust>(16);
        ArrayList<AttRecordAdjust> attPeriodRecordAdjustList = new ArrayList<AttRecordAdjust>(16);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                AttRecordTrimUtil.ListAttRecordAdjustEntity(dynamicObject, fromDate, toDate, attDayRecordAdjustList, attPeriodRecordAdjustList);
            }
        }
        return AttRecordTrim.with().attDayRecordAdjustList(attDayRecordAdjustList).attPeriodRecordAdjustList(attPeriodRecordAdjustList).build();
    }

    private static void ListAttRecordAdjustEntity(DynamicObject dynamicObject, LocalDate fromDate, LocalDate toDate, List<AttRecordAdjust> attDayRecordAdjustList, List<AttRecordAdjust> attPeriodRecordAdjustList) {
        LocalDate endDate = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("enddate"));
        LocalDate startDate = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("startdate"));
        if (endDate == null || startDate == null) {
            return;
        }
        if (HRStringUtils.equals((String)dynamicObject.getString("revisiontype"), (String)"period")) {
            attPeriodRecordAdjustList.add(AttRecordTrimUtil.getAttRecordAdjustEntity(dynamicObject, null));
        } else {
            LocalDate calculateDate = startDate;
            while (endDate.compareTo(calculateDate) >= 0) {
                if (calculateDate.compareTo(fromDate) >= 0 && calculateDate.compareTo(toDate) <= 0) {
                    attDayRecordAdjustList.add(AttRecordTrimUtil.getAttRecordAdjustEntity(dynamicObject, calculateDate));
                }
                calculateDate = calculateDate.plusDays(1L);
            }
        }
    }

    private static AttRecordAdjust getAttRecordAdjustEntity(DynamicObject dynamicObject, LocalDate calculateDate) {
        long attPersonId = dynamicObject.getLong("attfilebase.attperson.id");
        Date now = WTCDateUtils.toDate((LocalDate)LocalDate.now());
        return AttRecordAdjust.with().attPersonId(attPersonId).attfileId(dynamicObject.getLong("attfilebase.id")).calculateDate(calculateDate).bemoveItemId(dynamicObject.getLong("attitemto.id")).revisionType(dynamicObject.getString("revisiontype")).itemId(dynamicObject.getLong("attitem.id")).itemName(dynamicObject.getString("attitem.name")).adjustTrimId(dynamicObject.getLong("id")).adjustDetailId(dynamicObject.getLong("revisionentryid")).trimType(dynamicObject.getString("adjusttype")).itemUnit(dynamicObject.getString("attitem.unit")).valueUpdate(dynamicObject.getBigDecimal("value")).datastatus(dynamicObject.getString("datastatus")).createTime(now).modifier(dynamicObject.getLong("modifier.id")).modifyTime(now).startDate(WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("startdate"))).endDate(WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("enddate"))).build();
    }

    private static QFilter[] getQueryCondition(Collection<Long> attPersonIds, Date fromDate, Date toDate) {
        QFilter attPersonIdsFilter = new QFilter("attfilebase.attperson", "in", attPersonIds);
        QFilter fromDateFilter = new QFilter("startdate", "<=", (Object)toDate);
        QFilter toDateDateFilter = new QFilter("enddate", ">=", (Object)fromDate);
        QFilter statusFilter = new QFilter("datastatus", "=", (Object)"1");
        return new QFilter[]{attPersonIdsFilter, fromDateFilter, toDateDateFilter, statusFilter};
    }

    public static TieDataResultStd vailte(TieContextStd context) {
        LocalDate chainDate = context.getChainDate();
        long attPersonId = context.getAttPersonId();
        ShiftTableSingle shiftTableSingle = ContextUtil.getCurrentShiftTable(context);
        if (shiftTableSingle == null) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, String.format(Locale.ROOT, "There is no attDayRecordTrimEvaluator shiftTableSingle exists for attPersonId=%s", attPersonId)));
        }
        ShiftSpec shiftSpec = shiftTableSingle.getShiftSpec(chainDate);
        if (shiftSpec == null) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, String.format(Locale.ROOT, "There is no attDayRecordTrimEvaluator shiftSpec exists for attPersonId=%s, chainDate=%s", attPersonId, chainDate)));
        }
        AttItemSpecData attItemSpecData = ContextUtil.getAttItemSpecData(context);
        if (attItemSpecData == null) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, "There is no attDayRecordTrimEvaluator AttItemSpecData exists"));
        }
        AttRecordTrimData attRecordTrimData = ContextUtil.getAttRecordTrimtData(context);
        if (attRecordTrimData == null) {
            return TieDataResultStd.exclusion(new TieMessageStd(TieMsgLevel.WARNING, "There is no attDayRecordTrimEvaluator attRecordAdjustData exists"));
        }
        return null;
    }

    public static int getPrecisionTail(String oldPrecisionTail) {
        int precisionTail = 4;
        if (HRStringUtils.equals((String)"2", (String)oldPrecisionTail)) {
            precisionTail = 1;
        } else if (StringUtils.equals((CharSequence)"3", (CharSequence)oldPrecisionTail)) {
            precisionTail = 0;
        }
        return precisionTail;
    }

    public static BigDecimal secondToHour(BigDecimal seconds, int scale, int roundModel) {
        if (seconds == null) {
            return BigDecimal.ZERO;
        }
        return seconds.divide(BigDecimal.valueOf(3600L), scale, roundModel);
    }

    public static BigDecimal secondToMinute(BigDecimal seconds, int scale, int roundModel) {
        if (seconds == null) {
            return BigDecimal.ZERO;
        }
        return seconds.divide(BigDecimal.valueOf(60L), scale, roundModel);
    }

    public static BigDecimal minuteToSecond(BigDecimal minute) {
        if (minute == null) {
            return BigDecimal.ZERO;
        }
        return minute.multiply(BigDecimal.valueOf(60L));
    }

    public static BigDecimal hourToSecond(BigDecimal hour) {
        if (hour == null) {
            return BigDecimal.ZERO;
        }
        return hour.multiply(BigDecimal.valueOf(3600L));
    }

    private static BigDecimal calculateValue(boolean isAdd, BigDecimal valueBefore, BigDecimal adjustValue) {
        return isAdd ? valueBefore.add(adjustValue) : valueBefore.subtract(adjustValue);
    }

    public static AttItemValue builtAttitemValueWithParent(AttItemSpec attItemSpec, AttRecordAdjust attRecordAdjust, BigDecimal valueBefore, AttItemValue curAttItemValue, ShiftSpec shiftSpec, boolean isAdd, boolean isUpNode, AttRecordTrimResult resultAttRecordTrimResult) {
        AttItemInstance attItemInstance;
        List<TieDataNodeStd> parentDataNodes = curAttItemValue == null ? Collections.EMPTY_LIST : curAttItemValue.parentDataNodes();
        if (valueBefore == null) {
            valueBefore = BigDecimal.ZERO;
        }
        int dataAccuracy = attItemSpec.getDataAccuracy();
        int precisionTail = AttRecordTrimUtil.getPrecisionTail(attItemSpec.getPrecisionTail());
        String itemUnit = attRecordAdjust.getItemUnit();
        BigDecimal valueToAfter = null;
        BigDecimal valueToBefore = null;
        if (resultAttRecordTrimResult != null) {
            valueToAfter = resultAttRecordTrimResult.getValueAfter();
            valueToBefore = resultAttRecordTrimResult.getValueBefore();
        }
        ArrayList attRecordMoveTrimResultList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList attRecordTrimResultList = Lists.newArrayListWithExpectedSize((int)16);
        switch (itemUnit) {
            case "time": {
                BigDecimal valueAfter = AttRecordTrimUtil.calculateValue(isAdd, valueBefore, attRecordAdjust.getValueUpdate());
                attItemInstance = new AttItemInstance(attItemSpec, valueAfter, null, BigDecimal.ZERO, attRecordMoveTrimResultList, AttRecordTrimResult.with().attRecordAdjust(attRecordAdjust).valueAfter(valueAfter).valueBefore(valueBefore).valueToBefore(valueToBefore).valueToAfter(valueToAfter).build(), attRecordTrimResultList);
                break;
            }
            case "day": {
                valueBefore = isUpNode ? valueBefore : shiftSpec.secondsToDays(valueBefore);
                BigDecimal valueAfter = AttRecordTrimUtil.calculateValue(isAdd, valueBefore, attRecordAdjust.getValueUpdate());
                attItemInstance = new AttItemInstance(attItemSpec, null, valueAfter, shiftSpec.daysToSecondDecimal(valueAfter), attRecordMoveTrimResultList, AttRecordTrimResult.with().attRecordAdjust(attRecordAdjust).valueAfter(valueAfter).valueBefore(valueBefore).valueToBefore(valueToBefore).valueToAfter(valueToAfter).build(), attRecordTrimResultList);
                break;
            }
            case "hour": {
                valueBefore = isUpNode ? valueBefore : AttRecordTrimUtil.secondToHour(valueBefore, dataAccuracy, precisionTail);
                BigDecimal valueAfter = AttRecordTrimUtil.calculateValue(isAdd, valueBefore, attRecordAdjust.getValueUpdate());
                BigDecimal second = AttRecordTrimUtil.hourToSecond(valueAfter);
                attItemInstance = new AttItemInstance(attItemSpec, null, shiftSpec.secondsToDays(second), second, attRecordMoveTrimResultList, AttRecordTrimResult.with().attRecordAdjust(attRecordAdjust).valueAfter(valueAfter).valueBefore(valueBefore).valueToBefore(valueToBefore).valueToAfter(valueToAfter).build(), attRecordTrimResultList);
                break;
            }
            case "minute": {
                valueBefore = isUpNode ? valueBefore : AttRecordTrimUtil.secondToMinute(valueBefore, dataAccuracy, precisionTail);
                BigDecimal valueAfter = AttRecordTrimUtil.calculateValue(isAdd, valueBefore, attRecordAdjust.getValueUpdate());
                BigDecimal second = AttRecordTrimUtil.minuteToSecond(valueAfter);
                attItemInstance = new AttItemInstance(attItemSpec, null, shiftSpec.secondsToDays(second), second, attRecordMoveTrimResultList, AttRecordTrimResult.with().attRecordAdjust(attRecordAdjust).valueAfter(valueAfter).valueBefore(valueBefore).valueToBefore(valueToBefore).valueToAfter(valueToAfter).build(), attRecordTrimResultList);
                break;
            }
            default: {
                BigDecimal valueAfter;
                BigDecimal second = valueAfter = AttRecordTrimUtil.calculateValue(isAdd, valueBefore, attRecordAdjust.getValueUpdate());
                attItemInstance = new AttItemInstance(attItemSpec, null, shiftSpec.secondsToDays(second), second, attRecordMoveTrimResultList, AttRecordTrimResult.with().attRecordAdjust(attRecordAdjust).valueAfter(valueAfter).valueBefore(valueBefore).valueToBefore(valueToBefore).valueToAfter(valueToAfter).build(), attRecordTrimResultList);
            }
        }
        if (curAttItemValue != null) {
            attItemInstance.getExtraLabels().addAll(curAttItemValue.getAttItemInstance().getExtraLabels());
        }
        AttItemValue newAttItemValue = (AttItemValue)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(attItemInstance)).parentDataNodes(parentDataNodes)).build();
        return newAttItemValue;
    }

    public static AttItemValue builtNewAttitemValueWithOutParent(AttItemSpec attItemSpec) {
        AttItemInstance attItemInstance;
        String itemUnit;
        List parentDataNodes = Collections.EMPTY_LIST;
        BigDecimal valueBefore = BigDecimal.ZERO;
        switch (itemUnit = attItemSpec.getUnit()) {
            case "time": {
                attItemInstance = new AttItemInstance(attItemSpec, valueBefore);
                break;
            }
            default: {
                attItemInstance = new AttItemInstance(attItemSpec, valueBefore, valueBefore);
            }
        }
        AttItemValue newAttItemValue = (AttItemValue)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(attItemInstance)).parentDataNodes(parentDataNodes)).build();
        return newAttItemValue;
    }

    public static AttItemValue getAttItemSpecAttItemValue(AttItemSpec attItemSpec, List<AttItemValue> attItemValueList) {
        List filterList = attItemValueList.stream().filter(attItemValue -> ((Object)((Object)attItemValue.getAttItemInstance().getAttItemSpec())).equals((Object)attItemSpec)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(filterList)) {
            return (AttItemValue)filterList.get(filterList.size() - 1);
        }
        return null;
    }

    public static AttItemValue getCurAttItemInstance(List<TieDataNodeStd> dataNodesInCurPhase, Map<Long, AttItemValue> attItemValueMap, AttItemSpec attItemSpec, boolean isbeMove) {
        List curPhasecollect = dataNodesInCurPhase.stream().filter(dataNode -> dataNode.containsAttItem(attItemSpec)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(curPhasecollect)) {
            if (CollectionUtils.isEmpty(attItemValueMap) || !attItemValueMap.containsKey(attItemSpec.getBid())) {
                return isbeMove ? null : AttRecordTrimUtil.builtNewAttitemValueWithOutParent(attItemSpec);
            }
            return attItemValueMap.get(attItemSpec.getBid());
        }
        TieDataNodeStd nextStepLastNode = (TieDataNodeStd)curPhasecollect.get(curPhasecollect.size() - 1);
        List<AttItemInstance> attItemInstanceList = nextStepLastNode.getAttItemInstances();
        for (AttItemInstance attItemInstance : attItemInstanceList) {
            if (attItemInstance.getAttItemSpec().getBid() != attItemSpec.getBid()) continue;
            return (AttItemValue)((AttItemValue.Builder)((TieDataNode.Builder)AttItemValue.builder().attItemInstance(attItemInstance)).parentDataNodes(attItemValueMap.get(attItemSpec.getBid()).parentDataNodes())).build();
        }
        return null;
    }

    public static void builtTrimDy(DynamicObject adjustDyn, AttRecordTrimResult attRecordTrimResult) {
        AttRecordAdjust attRecordAdjust = attRecordTrimResult.getAttRecordAdjust();
        adjustDyn.set("attitemto", (Object)attRecordAdjust.getBemoveItemId());
        adjustDyn.set("attitem", (Object)attRecordAdjust.getItemId());
        adjustDyn.set("value", (Object)attRecordAdjust.getValueUpdate());
        adjustDyn.set("revisionhisid", (Object)attRecordAdjust.getAdjustTrimId());
        adjustDyn.set("creator", (Object)attRecordAdjust.getModifier());
        adjustDyn.set("modifier", (Object)attRecordAdjust.getModifier());
        adjustDyn.set("createtime", (Object)attRecordAdjust.getCreateTime());
        adjustDyn.set("modifytime", (Object)attRecordAdjust.getModifyTime());
        adjustDyn.set("attfilebase", (Object)attRecordAdjust.getAttfileId());
        adjustDyn.set("valuebefore", (Object)attRecordTrimResult.getValueBefore());
        adjustDyn.set("valueafter", (Object)attRecordTrimResult.getValueAfter());
        adjustDyn.set("valuebeforeto", (Object)attRecordTrimResult.getValueToBefore());
        adjustDyn.set("valueafterto", (Object)attRecordTrimResult.getValueToAfter());
    }

    public static void builtTotalTrim(Long attmainId, DynamicObjectCollection mainDynamicObjectList, DynamicObjectCollection detailDynamicObjectList, List<DynamicObject> mainDynamicObjects, Map<Long, Long> attmainMap, DynamicObject deatilAttTotalDy) {
        Long newAttmainId = attmainMap.get(attmainId);
        if (newAttmainId == null) {
            DynamicObject mainDy = AttRecordTrimUtil.builtMainDynamicObject(attmainId, mainDynamicObjects);
            if (mainDy != null) {
                newAttmainId = mainDy.getLong("id");
                attmainMap.put(attmainId, newAttmainId);
                deatilAttTotalDy.set("attmain", (Object)newAttmainId);
                detailDynamicObjectList.add((Object)deatilAttTotalDy);
                mainDynamicObjectList.add((Object)mainDy);
            }
        } else {
            deatilAttTotalDy.set("attmain", (Object)newAttmainId);
            detailDynamicObjectList.add((Object)deatilAttTotalDy);
        }
    }

    public static AttPeriodSpliteModel getAttPeriodSpliteModel(DynamicObjectCollection mainDynamicObjectList, DynamicObjectCollection detailDynamicObjectList, List<AttRecordTrimResult> attRecordTrimResultList) {
        AttPeriodSpliteModel attPeriodSpliteModel = new AttPeriodSpliteModel(mainDynamicObjectList, detailDynamicObjectList);
        attPeriodSpliteModel.setAttRecordTrimResultList(attRecordTrimResultList);
        return attPeriodSpliteModel;
    }

    private static DynamicObject builtMainDynamicObject(Long attmainId, List<DynamicObject> mainDynamicObjects) {
        DynamicObject mainDy = mainDynamicObjects.stream().filter(ob -> attmainId.equals(ob.getLong("id"))).findFirst().orElse(null);
        if (mainDy != null) {
            DynamicObject baseAttTotalDy = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotalbase");
            HRDynamicObjectUtils.copy((DynamicObject)mainDy, (DynamicObject)baseAttTotalDy);
            baseAttTotalDy.set("id", (Object)DB.genLongId((String)"wtctd_atttotalbase"));
            return baseAttTotalDy;
        }
        return null;
    }

    public static boolean isAdjust(AttRecordAdjust attRecordAdjust, Long attitemId, Long personId, AttPeriodTable attPeriodTable, Long perAttPeriodid) {
        if (attitemId.longValue() != attRecordAdjust.getItemId() || personId.longValue() != attRecordAdjust.getAttPersonId()) {
            return false;
        }
        LocalDate startDate = attRecordAdjust.getStartDate();
        LocalDate endDate = attRecordAdjust.getEndDate();
        if (startDate == null || endDate == null) {
            return false;
        }
        Optional<PerAttPeriod> optional = attPeriodTable.getPerAttPeriod(personId, startDate, endDate, perAttPeriodid);
        return optional.isPresent();
    }

    public static BigDecimal getOrginValue(DynamicObject detailDynamicObject, BigDecimal itemValue) {
        if (itemValue != null) {
            return itemValue;
        }
        if (detailDynamicObject != null) {
            return detailDynamicObject.getBigDecimal("valuelong");
        }
        return null;
    }

    public static Long getPersionId(List<DynamicObject> mainDynamicObjects, Long attmainId) {
        DynamicObject main = mainDynamicObjects.stream().filter(ob -> ob.getLong("id") == attmainId.longValue()).findFirst().orElse(null);
        if (main == null) {
            return null;
        }
        return main.getLong("personid");
    }

    public static void geneAdjustNode(TieAttPeriodContext tieAttPeriodContext, List<DynamicObject> deailDynamicObjects, AttRecordTrimData attRecordTrimData, List<DynamicObject> mainDynamicObjects, String trimType) {
        Map<Long, List<PerAttPeriod>> periodMap = tieAttPeriodContext.getPerAttPeriodMap();
        Map<String, List<AttRecordAdjust>> adjustmap = attRecordTrimData.getPeriodAdjustRecordMap(trimType);
        Map<String, Map<Long, Long>> map = AttRecordTrimUtil.getPerattPeriodMap(mainDynamicObjects, deailDynamicObjects);
        for (Map.Entry<String, List<AttRecordAdjust>> entry : adjustmap.entrySet()) {
            String key = entry.getKey();
            List<AttRecordAdjust> attRecordAdjustList = entry.getValue();
            for (AttRecordAdjust attRecordAdjust : attRecordAdjustList) {
                Long personId = Long.valueOf(key.split("_")[0]);
                List<PerAttPeriod> perAttPeriodList = periodMap.get(personId);
                Optional<PerAttPeriod> optional = perAttPeriodList.stream().filter(ob -> HRStringUtils.equals((String)ob.getId(), (String)key)).findFirst();
                if (!optional.isPresent()) continue;
                Map<Long, Long> tupelMap = map.get(key);
                if (!CollectionUtils.isEmpty(tupelMap)) {
                    Long attMainId = tupelMap.get(attRecordAdjust.getItemId());
                    if (attMainId != null) continue;
                    attMainId = tupelMap.entrySet().iterator().next().getValue();
                    AttRecordTrimUtil.builtWithOutParentNode(tieAttPeriodContext, attRecordAdjust, mainDynamicObjects, deailDynamicObjects, attMainId, optional.get());
                    continue;
                }
                AttRecordTrimUtil.builtWithOutParentNode(tieAttPeriodContext, attRecordAdjust, mainDynamicObjects, deailDynamicObjects, null, optional.get());
            }
        }
    }

    private static void builtWithOutParentNode(TieAttPeriodContext tieAttPeriodContext, AttRecordAdjust attRecordAdjust, List<DynamicObject> mainDynamicObjectList, List<DynamicObject> deailDynamicObjectList, Long attMainId, PerAttPeriod perAttPeriod) {
        if (attMainId == null) {
            attMainId = DB.genLongId((String)"wtctd_atttotalbasehis");
            AttFileModel attFile = tieAttPeriodContext.getAttFileModelById(perAttPeriod.getPersonId(), perAttPeriod.getFileId());
            DynamicObject mainAttTotalDy = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotalbase");
            mainAttTotalDy.set("versionid", (Object)tieAttPeriodContext.getVersion());
            mainAttTotalDy.set("id", (Object)attMainId);
            mainAttTotalDy.set("personid", (Object)perAttPeriod.getPersonId());
            mainAttTotalDy.set("attperattperiodid", (Object)perAttPeriod.getId());
            mainAttTotalDy.set("attperattperiodpk", (Object)perAttPeriod.getPrimaryId());
            mainAttTotalDy.set("perattperiodid", (Object)perAttPeriod.getAttPeriodId());
            LocalDate endDate = tieAttPeriodContext.getPeriodData(perAttPeriod, attFile);
            AttFileCabinet attFileCabinet = tieAttPeriodContext.getAttFileCabinet();
            AttendPersonModel personModel = tieAttPeriodContext.getAttendPersonModel(attFile, endDate);
            if (personModel == null) {
                LOGGER.warn("periodrecord_not_find_personModel_personId={},endDate={}", (Object)perAttPeriod.getPersonId(), (Object)endDate);
                return;
            }
            CmpEmp cmpEmp = personModel.getCmpEmp();
            mainAttTotalDy.set("managescopevid", (Object)(cmpEmp != null ? cmpEmp.getId() : 0L));
            AdminOrg adminOrgByDate = attFileCabinet.getAdminOrgByDate(attFile.getAdminOrgId(), endDate);
            Company companyByDate = attFileCabinet.getCompanyByDate(attFile.getCompanyId(), endDate);
            Position positionByDate = attFileCabinet.getPositionByDate(attFile.getPositionId(), endDate);
            Job jobByDate = attFileCabinet.getJobByDate(attFile.getJobId(), endDate);
            mainAttTotalDy.set("companyvid", (Object)(companyByDate == null ? 0L : companyByDate.getId()));
            mainAttTotalDy.set("departmentvid", (Object)(adminOrgByDate == null ? 0L : adminOrgByDate.getId()));
            mainAttTotalDy.set("positionvid", (Object)(positionByDate == null ? 0L : positionByDate.getId()));
            mainAttTotalDy.set("jobvid", (Object)(jobByDate == null ? 0L : jobByDate.getId()));
            mainAttTotalDy.set("orgid", (Object)attFile.getOrgId());
            mainAttTotalDy.set("affiliateadminorgvid", (Object)attFile.getAffiliateAdminOrgVid(endDate));
            mainAttTotalDy.set("createtime", (Object)WTCDateUtils.toDate((LocalDateTime)tieAttPeriodContext.getRequest().getCreateTime()));
            mainAttTotalDy.set("reckoner", (Object)tieAttPeriodContext.getRequest().getCreateUserId());
            mainAttTotalDy.set("perperiodbegindate", (Object)perAttPeriod.getPerAttBeginDate());
            mainAttTotalDy.set("perperiodenddate", (Object)perAttPeriod.getPerAttEndDate());
            mainAttTotalDy.set("attfileid", (Object)attFile.getTimeSeqInfo().getBid());
            mainAttTotalDy.set("attfilevid", (Object)attFile.getTimeSeqInfo().getVid());
            mainDynamicObjectList.add(mainAttTotalDy);
        }
        Long trimItemId = attRecordAdjust.getItemId();
        AttItemSpecData attItemSpecData = tieAttPeriodContext.getAttItemSpecData();
        DynamicObject deatilMoveToAttTotalDy = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotaldetail");
        deatilMoveToAttTotalDy.set("attmain", (Object)attMainId);
        deatilMoveToAttTotalDy.set("perattperiodid", (Object)perAttPeriod.getAttPeriodId());
        AttItemSpec attItemSpec = (AttItemSpec)attItemSpecData.getByBid(trimItemId).getBoVersion();
        deatilMoveToAttTotalDy.set("attitemtype", (Object)(attItemSpec == null ? null : attItemSpec.getItemType()));
        deatilMoveToAttTotalDy.set("attitemid", (Object)trimItemId);
        deatilMoveToAttTotalDy.set("attitemvid", attItemSpec == null ? null : Long.valueOf(attItemSpec.getId()));
        deatilMoveToAttTotalDy.set("valuelong", (Object)BigDecimal.ZERO);
        deailDynamicObjectList.add(deatilMoveToAttTotalDy);
    }

    private static Map<String, Map<Long, Long>> getPerattPeriodMap(List<DynamicObject> mainDynamicObjects, List<DynamicObject> deailDynamicObjects) {
        Map<Long, List<DynamicObject>> dyMap = mainDynamicObjects.stream().collect(Collectors.groupingBy(ob -> ob.getLong("id")));
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject deailDynamicObject : deailDynamicObjects) {
            Long attitemId = deailDynamicObject.getLong("attitemid");
            Long attMainId = deailDynamicObject.getLong("attmain");
            List<DynamicObject> mainObjectList = dyMap.get(attMainId);
            if (CollectionUtils.isEmpty(mainObjectList)) continue;
            Map attitemMap = map.computeIfAbsent(mainObjectList.get(0).getString("attperattperiodid"), key -> new HashMap(16));
            attitemMap.put(attitemId, attMainId);
        }
        return map;
    }
}

