/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtes.business.model.rlra.AttStatusConfigEntity;
import kd.wtc.wtes.business.model.rlra.AttStatusEntryPackage;
import kd.wtc.wtes.business.util.CardPointUtil;
import kd.wtc.wtes.common.util.CollectionUtils;

public class AttStatusUtil {
    private static Log logger = LogFactory.getLog(AttStatusUtil.class);
    private static String propertiesQuery = null;

    public static List<AttStatusConfigEntity> listValidVersionAttStatusInRangeDate(LocalDate fromDate, LocalDate toDate) {
        List<AttStatusConfigEntity> attItemSpecList = AttStatusUtil.listAttStatus("wtbd_attstsmap", fromDate, toDate);
        return CollectionUtils.isEmpty(attItemSpecList) ? Collections.emptyList() : attItemSpecList;
    }

    private static AttStatusConfigEntity getAttStatusEntity(DynamicObject dynamicObject, Boolean isTimeSeq) {
        if (isTimeSeq.booleanValue()) {
            TimeSeqInfoImpl timeSeqEntity = AttStatusUtil.getTimeSeqEntity(dynamicObject);
            return AttStatusUtil.builtAttStatusEntity(dynamicObject, AttStatusConfigEntity.withTimeSeq((TimeSeqInfo)timeSeqEntity));
        }
        return AttStatusUtil.builtAttStatusEntity(dynamicObject, AttStatusConfigEntity.withNonTimeSeq());
    }

    private static AttStatusConfigEntity builtAttStatusEntity(DynamicObject dynamicObject, AttStatusConfigEntity.Builder<?, ?> builter) {
        ArrayList<AttStatusEntryPackage> attStatusEntryList = new ArrayList<AttStatusEntryPackage>();
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryPackageItem : dynamicObjectCollection) {
            AttStatusEntryPackage.AttStatusEntryPackageBuilder builder = AttStatusEntryPackage.AttStatusEntryPackageBuilder.anExConfigEntryPackage().punchCardTag(entryPackageItem.getString("pctag")).pcTagIdStr(entryPackageItem.getString("pctagidstr")).attBillTagIdStr(entryPackageItem.getString("attbilltagidstr")).attendanceBillTag(entryPackageItem.getString("attbilltag"));
            DynamicObject attendanceStatus = entryPackageItem.getDynamicObject("attstsid");
            if (null != attendanceStatus) {
                builder.attStatus(attendanceStatus.getString("number"));
            }
            attStatusEntryList.add(builder.build());
        }
        DynamicObject countryEntry = dynamicObject.getDynamicObject("countryid");
        if (countryEntry != null) {
            builter.country(countryEntry.getString("number"));
        }
        return (AttStatusConfigEntity)((AttStatusConfigEntity.Builder)((AttStatusConfigEntity.Builder)builter.attStatusRelationEntryPackageList(attStatusEntryList).id(dynamicObject.getLong("id"))).number(dynamicObject.getString("number"))).build();
    }

    private static TimeSeqInfoImpl getTimeSeqEntity(DynamicObject dynamicObject) {
        LocalDate bsled = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("bsled"));
        LocalDate bsed = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("bsed"));
        return (TimeSeqInfoImpl)((TimeSeqInfoImpl.Builder)((TimeSeqInfoImpl.Builder)TimeSeqInfoImpl.with().blsed(bsled).bsed(bsed).bid(dynamicObject.getLong("boid")).id(dynamicObject.getLong("id"))).number(dynamicObject.getString("number"))).build();
    }

    private static List<AttStatusConfigEntity> listAttStatus(String entityName, LocalDate fromDate, LocalDate toDate) {
        ArrayList<AttStatusConfigEntity> attStatusList = new ArrayList<AttStatusConfigEntity>();
        QFilter[] qFilter = CardPointUtil.getQueryCondition(fromDate, toDate);
        Map dynamicObjectsMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)propertiesQuery, (QFilter[])qFilter);
        if (dynamicObjectsMap != null && dynamicObjectsMap.size() > 0) {
            for (Map.Entry entry : dynamicObjectsMap.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                attStatusList.add(AttStatusUtil.getAttStatusEntity(dynamicObject, Boolean.TRUE));
            }
        }
        return attStatusList;
    }

    static {
        ArrayList<String> propertiedList = new ArrayList<String>();
        propertiedList.add("entryentity.pctag");
        propertiedList.add("entryentity.attbilltag");
        propertiedList.add("entryentity.attstsid");
        propertiedList.add("entryentity.pctagidstr");
        propertiedList.add("entryentity.attbilltagidstr");
        propertiedList.add("countryid");
        propertiedList.add("isnewbo");
        propertiedList.add("id");
        propertiedList.add("boid");
        propertiedList.add("number");
        propertiedList.add("bsled");
        propertiedList.add("bsed");
        propertiesQuery = WTCStringUtils.join(propertiedList, (String)",");
    }
}

