/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfo;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtes.business.model.rlra.PunchCardTagEntity;
import kd.wtc.wtes.business.model.rlra.TimeCardRelationEntryPackage;
import kd.wtc.wtes.business.util.TimeSeqEntityGenerateUtils;
import kd.wtc.wtes.common.util.CollectionUtils;

public class CardPointUtil {
    private static String propertiesQuery;

    public static List<PunchCardTagEntity> listValidHisVersionsCardPointInRangeDate(LocalDate fromDate, LocalDate toDate) {
        List<PunchCardTagEntity> attItemSpecList = CardPointUtil.listCardPoint("wtbd_tbpcrelcnf", fromDate, toDate);
        return CollectionUtils.isEmpty(attItemSpecList) ? Collections.emptyList() : attItemSpecList;
    }

    public static QFilter[] getQueryCondition(LocalDate fromDate, LocalDate toDate) {
        return TimeSeqEntityGenerateUtils.getQueryCondition(fromDate, toDate);
    }

    private static PunchCardTagEntity getCardPointEntity(DynamicObject dynamicObject, Boolean isTimeSeq) {
        if (isTimeSeq.booleanValue()) {
            TimeSeqInfoImpl timeSeqEntity = CardPointUtil.getTimeSeqEntity(dynamicObject);
            return CardPointUtil.cardPointEntity(dynamicObject, PunchCardTagEntity.withTimeSeq((TimeSeqInfo)timeSeqEntity));
        }
        return CardPointUtil.cardPointEntity(dynamicObject, PunchCardTagEntity.withNonTimeSeq());
    }

    private static PunchCardTagEntity cardPointEntity(DynamicObject dynamicObject, PunchCardTagEntity.Builder<?, ?> builter) {
        ArrayList<TimeCardRelationEntryPackage> timeCardRelationList = new ArrayList<TimeCardRelationEntryPackage>();
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject cardPointItem : dynamicObjectCollection) {
            DynamicObject cardMark;
            TimeCardRelationEntryPackage.TimeCardRelationEntryPackageBuilder builder = TimeCardRelationEntryPackage.TimeCardRelationEntryPackageBuilder.anExConfigEntryPackage().shiftTimeBucketProperty(cardPointItem.getString("shifttbprop")).timeBucketIdStr(cardPointItem.getString("timebucketidstr"));
            DynamicObject timeCardRelation = cardPointItem.getDynamicObject("tbpcrelid");
            if (null != timeCardRelation) {
                builder.timeCardRelation(timeCardRelation.getString("number"));
            }
            if (null != (cardMark = cardPointItem.getDynamicObject("pctagid"))) {
                builder.punchCardTag(cardMark.getString("number"));
            }
            builder.punchCardExceptionType(cardPointItem.getString("exceptiontype"));
            timeCardRelationList.add(builder.build());
        }
        DynamicObject countryEntry = dynamicObject.getDynamicObject("countryid");
        if (countryEntry != null) {
            builter.country(countryEntry.getString("number"));
        }
        return (PunchCardTagEntity)((PunchCardTagEntity.Builder)((PunchCardTagEntity.Builder)builter.timeCardRelationEntryPackageList(timeCardRelationList).id(dynamicObject.getLong("id"))).number(dynamicObject.getString("number"))).build();
    }

    private static TimeSeqInfoImpl getTimeSeqEntity(DynamicObject dynamicObject) {
        LocalDate bsled = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("bsled"));
        LocalDate bsed = WTCDateUtils.toLocalDate((Date)dynamicObject.getDate("bsed"));
        return (TimeSeqInfoImpl)((TimeSeqInfoImpl.Builder)((TimeSeqInfoImpl.Builder)TimeSeqInfoImpl.with().blsed(bsled).bsed(bsed).bid(dynamicObject.getLong("boid")).number(dynamicObject.getString("number"))).id(dynamicObject.getLong("id"))).build();
    }

    private static List<PunchCardTagEntity> listCardPoint(String entityName, LocalDate fromDate, LocalDate toDate) {
        ArrayList<PunchCardTagEntity> cardPointList = new ArrayList<PunchCardTagEntity>();
        QFilter[] qFilter = CardPointUtil.getQueryCondition(fromDate, toDate);
        Map dynamicObjectsMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)propertiesQuery, (QFilter[])qFilter);
        if (dynamicObjectsMap != null && dynamicObjectsMap.size() > 0) {
            for (Map.Entry entry : dynamicObjectsMap.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                cardPointList.add(CardPointUtil.getCardPointEntity(dynamicObject, Boolean.TRUE));
            }
        }
        return cardPointList;
    }

    static {
        ArrayList<String> propertiedList = new ArrayList<String>();
        propertiedList.add("entryentity");
        propertiedList.add("entryentity.shifttbprop");
        propertiedList.add("entryentity.tbpcrelid");
        propertiedList.add("entryentity.pctagid");
        propertiedList.add("entryentity.timebucketidstr");
        propertiedList.add("countryid");
        propertiedList.add("isnewbo");
        propertiedList.add("id");
        propertiedList.add("boid");
        propertiedList.add("number");
        propertiedList.add("bsled");
        propertiedList.add("bsed");
        propertiedList.add("exceptiontype");
        propertiesQuery = WTCStringUtils.join(propertiedList, (String)",");
    }
}

