/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.wtc.wtbs.business.timeseq.TimeSeqBo;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.enums.DateAttribute;
import kd.wtc.wtbs.common.model.common.DateType;
import kd.wtc.wtbs.common.model.evaluation.RoundWrapper;
import kd.wtc.wtes.business.executor.timeaffiliation.model.Holiday;
import kd.wtc.wtes.business.executor.timeaffiliation.model.TimeAscriptionRule;
import kd.wtc.wtes.business.init.LogicCardData;
import kd.wtc.wtes.business.model.AttBillTimeBucketData;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.ConfigMix;
import kd.wtc.wtes.business.model.DasoConfData;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.ShiftTable;
import kd.wtc.wtes.business.model.ShiftTableSingle;
import kd.wtc.wtes.business.model.access.AccessDto;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.model.attendperson.EffectAttendPersonData;
import kd.wtc.wtes.business.model.attendperson.EffectAttendPersonInfo;
import kd.wtc.wtes.business.model.attrecord.AttRecordDetailTable;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordAdjustData;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimData;
import kd.wtc.wtes.business.model.base.PunchCardPair;
import kd.wtc.wtes.business.model.base.ShiftPeriod;
import kd.wtc.wtes.business.model.base.ShiftTypeEnum;
import kd.wtc.wtes.business.model.rlad.AdCalcData;
import kd.wtc.wtes.business.model.rlad.AdCalcDataModel;
import kd.wtc.wtes.business.model.rlra.AttItemLabelConfigData;
import kd.wtc.wtes.business.model.rlra.AttStatusConfigData;
import kd.wtc.wtes.business.model.rlra.PunchCardTagData;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.common.util.CollectionUtils;

public final class ContextUtil {
    private ContextUtil() {
    }

    public static Long getAttFileId(TieContextStd context, LocalDate shiftDate) {
        AttFileModel attFile = ContextUtil.getAttFile(context, shiftDate);
        return attFile == null ? null : Long.valueOf(attFile.getId());
    }

    public static AttFileModel getAttFile(TieContextStd context, LocalDate shiftDate) {
        return ContextUtil.getAttFileCabinet(context).getByAttPersonIdAndDate(context.getAttPersonId(), shiftDate);
    }

    public static AttFileCabinet getAttFileCabinet(TieContextStd context) {
        return context.getInitParamMust("ATT_FILE", AttFileCabinet.class);
    }

    public static AttRecordDetailTable getAttRecordDetailTable(TieContextStd context) {
        return context.getInitParamMust("ATT_RECORD_DETAIL", AttRecordDetailTable.class);
    }

    public static AttFileModel getCurrentAttFile(TieContextStd context) {
        return ContextUtil.getAttFile(context, context.getChainDate());
    }

    public static AttItemSpecData getAttItemSpecData(TieContextStd context) {
        return context.getInitParamMust("ATT_ITEM_SPEC", AttItemSpecData.class);
    }

    public static DasoConfData getDasoConfData(TieContextStd context) {
        return context.getInitParamMust("DASO_CONF", DasoConfData.class);
    }

    public static ShiftTable getShiftTable(TieContextStd context) {
        return context.getInitParamMust("ROSTER", ShiftTable.class);
    }

    public static ShiftTableSingle getCurrentShiftTable(TieContextStd context) {
        return ContextUtil.getShiftTable(context).getByAttPersonId(context.getAttPersonId());
    }

    public static Map<Long, Holiday> getHolidayMap(TieContextStd context) {
        return (Map)context.getInitParam("HOLIDAY_MAP");
    }

    public static ConfigMix getConfigMix(TieContextStd context) {
        return (ConfigMix)context.getInitParam("CONFIG_MIX");
    }

    public static AttBillTimeBucketData getAttBillTimeBucketData(TieContextStd context) {
        return (AttBillTimeBucketData)context.getInitParam("BILL_TIME_BUCKET");
    }

    public static Map<Long, RoundWrapper> getRoundWrapperMap(TieContextStd context) {
        return (Map)context.getInitParam("ROUND_SPEC");
    }

    public static AttPeriodTable getAttPeriodTable(TieContextStd context) {
        return context.getInitParamMust("ATT_PERIOD", AttPeriodTable.class);
    }

    public static LogicCardData getLogicCardData(TieContextStd context) {
        return (LogicCardData)context.getInitParam("LOGIC_CARD");
    }

    public static AttRecordAdjustData getAttRecordAdjustData(TieContextStd context) {
        return (AttRecordAdjustData)context.getInitParam("ATT_RECORD_ADJUST");
    }

    public static AttRecordTrimData getAttRecordTrimtData(TieContextStd context) {
        return (AttRecordTrimData)context.getInitParam("ATT_RECORD_TRIM");
    }

    public static AttItemLabelConfigData getAttItemLabelConfigData(TieContextStd context) {
        return (AttItemLabelConfigData)context.getInitParam("ATT_LABEL_RELATION");
    }

    public static PunchCardTagData getPunchCardTagData(TieContextStd context) {
        return (PunchCardTagData)context.getInitParam("CHECKPOINT_TAG");
    }

    public static AttStatusConfigData getAttStatusConfigData(TieContextStd context) {
        return (AttStatusConfigData)context.getInitParam("ATT_STATUS_RELATION");
    }

    public static ShiftSpec getShiftSpec(TieContextStd context) {
        ShiftTable shiftTable = ContextUtil.getShiftTable(context);
        ShiftTableSingle byAttPersonId = shiftTable.getByAttPersonId(context.getAttPersonId());
        Roster roster = byAttPersonId.getRoster(context.getChainDate());
        return roster.getShiftSpec();
    }

    public static ShiftSpec getShiftSpec(TieContextStd context, int chainDayDistance) {
        ShiftTable shiftTable = ContextUtil.getShiftTable(context);
        ShiftTableSingle byAttPersonId = shiftTable.getByAttPersonId(context.getAttPersonId());
        LocalDate chainDate = context.getChainDate();
        Roster roster = byAttPersonId.getRoster(chainDate = chainDate.plusDays(chainDayDistance));
        if (roster == null) {
            return null;
        }
        return roster.getShiftSpec();
    }

    public static DateType getCurrentDateType(TieContextStd context) {
        return ContextUtil.getCurrentShiftTable(context).getDateType(context.getChainDate());
    }

    public static DateType getDateType(TieContextStd context, int chainDayDistance) {
        LocalDate chainDate = context.getChainDate();
        chainDate = chainDate.plusDays(chainDayDistance);
        return ContextUtil.getCurrentShiftTable(context).getDateType(chainDate);
    }

    public static DateAttribute getCurrentDateAttribute(TieContextStd context) {
        return ContextUtil.getCurrentShiftTable(context).getDateAttribute(context.getChainDate());
    }

    public static DateAttribute getDateAttribute(TieContextStd context, int chainDayDistance) {
        LocalDate chainDate = context.getChainDate();
        chainDate = chainDate.plusDays(chainDayDistance);
        return ContextUtil.getCurrentShiftTable(context).getDateAttribute(chainDate);
    }

    public static List<PunchCardPair> getPunchCardPairs(TieContextStd context) {
        return (List)context.getInitParam("PUNCH_CARD_PAIR");
    }

    public static long getPunchCardPairId(TieContextStd context, String number) {
        List pairs;
        List punchCardPairs = (List)context.getInitParam("PUNCH_CARD_PAIR");
        if (Objects.nonNull(punchCardPairs) && !(pairs = punchCardPairs.stream().filter(punchCardPair -> number.equals(punchCardPair.getNumber())).collect(Collectors.toList())).isEmpty()) {
            return ((PunchCardPair)pairs.get(0)).getId();
        }
        return 0L;
    }

    public static long getShiftPeriodId(TieContextStd context, String number) {
        List pairs;
        List shiftPeriods = (List)context.getInitParam("SHIFT_PERIOD");
        if (Objects.nonNull(shiftPeriods) && !(pairs = shiftPeriods.stream().filter(shiftPeriod -> number.equals(shiftPeriod.getNumber())).collect(Collectors.toList())).isEmpty()) {
            return ((ShiftPeriod)pairs.get(0)).getId();
        }
        return 0L;
    }

    public static ShiftTypeEnum getShiftTypeById(TieContextStd context, long id) {
        List shiftPeriods = (List)context.getInitParam("SHIFT_PERIOD");
        for (ShiftPeriod shiftPeriod : shiftPeriods) {
            if (shiftPeriod.getId() != id) continue;
            return ShiftTypeEnum.matchByNumber(shiftPeriod.getNumber());
        }
        return null;
    }

    public static List<ShiftPeriod> getShiftPeriodByType(TieContextStd context, ShiftTypeEnum shiftTypeEnum) {
        List shiftPeriods = (List)context.getInitParam("SHIFT_PERIOD");
        List<ShiftPeriod> result = shiftPeriods.stream().filter(shiftPeriod -> shiftPeriod.getNumber().startsWith(shiftTypeEnum.number_prefix)).sorted(Comparator.comparing(ShiftPeriod::getNumber)).collect(Collectors.toList());
        return result;
    }

    public static ShiftTypeEnum getShiftTypeByNumber(TieContextStd context, String number) {
        return ShiftTypeEnum.matchByNumber(number);
    }

    public static RuleEngineMetaData getRuleEngineMetaData(TieContextStd context) {
        return (RuleEngineMetaData)context.getInitParam("RULE_ENGINE");
    }

    public static Map<Long, AccessDto> getDataRangeMap(TieContextStd context) {
        return (Map)context.getInitParam("DATE_RANGE");
    }

    public static Map<Long, AttfileLimitScope> getLimitScopeMap(TieContextStd context) {
        return (Map)context.getInitParam("LIMIT_SCOPE");
    }

    public static AttendPersonModel getAttendPersonData(TieContextStd context, long personId, LocalDate queryDate) {
        AttFileCabinet attFileCabinet = (AttFileCabinet)context.getInitParam("ATT_FILE");
        AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(personId, queryDate);
        if (null == attFileModel) {
            return null;
        }
        AttendPersonData attendPersonData = (AttendPersonData)((Object)context.getInitParam("ATT_PERINFO"));
        if (attendPersonData == null) {
            return null;
        }
        return attendPersonData.getByBidAndDate(attFileModel, queryDate);
    }

    @Deprecated
    public static EffectAttendPersonInfo getEffectAttendPersonData(TieContextStd context, long personId) {
        EffectAttendPersonData effectAttendPersonData = (EffectAttendPersonData)context.getInitParam("EFF_ATT_PERINFO");
        Map<Long, EffectAttendPersonInfo> effectAttendPersonInfoMap = effectAttendPersonData.getEffectAttendPersonInfoMap();
        return effectAttendPersonInfoMap.get(personId);
    }

    @Deprecated
    public static Map<LocalDate, List<AdCalcData>> getPunchCardData(TieContextStd context, long attPersonId) {
        Map<Long, Map<LocalDate, List<AdCalcData>>> adCalcDataMap;
        Map<LocalDate, List<AdCalcData>> byDataCardMap = new HashMap<LocalDate, List<AdCalcData>>(0);
        AdCalcDataModel adCalcDataModel = (AdCalcDataModel)context.getInitParam("PUNCHCARD_DATA");
        if (adCalcDataModel != null && CollectionUtils.isNotEmpty(adCalcDataMap = adCalcDataModel.getAdCalcDataMap())) {
            byDataCardMap = adCalcDataMap.get(attPersonId);
        }
        return byDataCardMap;
    }

    public static TimeAscriptionRule getTimeAscriptionRuleByDate(TieContextStd context, LocalDate chainDate) {
        AttPeriodTable attPeriodTable = ContextUtil.getAttPeriodTable(context);
        long attPersonId = context.getAttPersonId();
        TimeSeqBo<TimeAscriptionRule> timeAscriptionRuleBo = attPeriodTable.getAscriptionBoByAttPersonIdAndDate(attPersonId, chainDate);
        return (TimeAscriptionRule)timeAscriptionRuleBo.getVersionByDate(chainDate);
    }
}

