/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.model.attendperson.AdminOrg;
import kd.wtc.wtbs.business.model.attendperson.CmpEmp;
import kd.wtc.wtbs.business.model.attendperson.Company;
import kd.wtc.wtbs.business.model.attendperson.Job;
import kd.wtc.wtbs.business.model.attendperson.Position;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.attperiod.chain.TieAttPeriodContext;
import kd.wtc.wtes.business.core.TieMessage;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieStatus;
import kd.wtc.wtes.business.core.chain.TiePointer;
import kd.wtc.wtes.business.core.scheme.DecisionConfig;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttPeriodSpliteModel;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.common.enums.TiePhaseRusultEnum;
import kd.wtc.wtes.common.util.CollectionUtils;

public final class PeriodContextUtil {
    public static void dealDetailDynamicObjectList(List<AttPeriodSpliteModel> result, List<DynamicObject> detailDynamicObjectList) {
        HashSet periodAttItemIdSet = Sets.newHashSetWithExpectedSize((int)16);
        List<AttPeriodSpliteModel> reverseNodeList = PeriodContextUtil.reverseNodeList(result);
        LinkedHashMap phaseDataNodes = reverseNodeList.stream().collect(Collectors.groupingBy(ob -> ob.getPhaseProperty().getId(), LinkedHashMap::new, Collectors.toList()));
        phaseDataNodes.forEach((entry, dataNodeList) -> {
            int curindex = ((AttPeriodSpliteModel)dataNodeList.get(0)).getPhaseProperty().getIndex();
            List upNodeList = reverseNodeList.stream().filter(ob -> curindex >= ob.getPhaseProperty().getIndex()).collect(Collectors.toList());
            dataNodeList.forEach(node -> {
                TiePhaseRusultEnum phaseResult = node.getPhaseProperty().getResult();
                PeriodContextUtil.addDetailDys(detailDynamicObjectList, periodAttItemIdSet, node, upNodeList, phaseResult);
            });
        });
    }

    public static List<AttPeriodSpliteModel> copyAttPeriodSpliteModelList(List<AttPeriodSpliteModel> attPeriodSpliteModelList) {
        ArrayList copyAttPeriodSpliteModelList = Lists.newArrayListWithExpectedSize((int)attPeriodSpliteModelList.size());
        for (AttPeriodSpliteModel attPeriodSpliteModel : attPeriodSpliteModelList) {
            copyAttPeriodSpliteModelList.add(PeriodContextUtil.copyAttPeriodSpliteModel(attPeriodSpliteModel));
        }
        return copyAttPeriodSpliteModelList;
    }

    private static AttPeriodSpliteModel copyAttPeriodSpliteModel(AttPeriodSpliteModel attPeriodSpliteModel) {
        DynamicObjectCollection copyDetailDynamicObjects = new DynamicObjectCollection();
        DynamicObjectCollection mainDynamicObjects = attPeriodSpliteModel.getMainDynamicObjects();
        DynamicObjectCollection detailDynamicObjects = attPeriodSpliteModel.getDetailDynamicObjects();
        for (DynamicObject dynamicObject : detailDynamicObjects) {
            DynamicObject deatilAttTotalDy = BusinessDataServiceHelper.newDynamicObject((String)"wtctd_atttotaldetail");
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)deatilAttTotalDy);
            copyDetailDynamicObjects.add((Object)deatilAttTotalDy);
        }
        AttPeriodSpliteModel copyAttPeriodSpliteModel = new AttPeriodSpliteModel(mainDynamicObjects, copyDetailDynamicObjects);
        copyAttPeriodSpliteModel.setPhaseProperty(attPeriodSpliteModel.getPhaseProperty());
        return copyAttPeriodSpliteModel;
    }

    private static List<AttPeriodSpliteModel> reverseNodeList(List<AttPeriodSpliteModel> result) {
        ArrayList tieDataNodeStdList = Lists.newArrayListWithExpectedSize((int)result.size());
        for (int i = result.size() - 1; i >= 0; --i) {
            AttPeriodSpliteModel attPeriodSpliteModel = result.get(i);
            tieDataNodeStdList.add(attPeriodSpliteModel);
            DynamicObjectCollection detailDynamicObjects = attPeriodSpliteModel.getDetailDynamicObjects();
            if (CollectionUtils.isEmpty((Collection)detailDynamicObjects)) continue;
            DynamicObjectCollection newDetailDynamicObjects = new DynamicObjectCollection();
            for (int j = detailDynamicObjects.size() - 1; j >= 0; --j) {
                newDetailDynamicObjects.add(detailDynamicObjects.get(j));
            }
            attPeriodSpliteModel.setDetailDynamicObjects(newDetailDynamicObjects);
        }
        return tieDataNodeStdList;
    }

    private static void addDetailDys(List<DynamicObject> detailDynamicObjectList, Set<String> periodAttItemIdSet, AttPeriodSpliteModel node, List<AttPeriodSpliteModel> upNodeList, TiePhaseRusultEnum phaseResult) {
        DynamicObjectCollection detailDynamicObjects = node.getDetailDynamicObjects();
        for (DynamicObject detail : detailDynamicObjects) {
            String perPeriodId = PeriodContextUtil.getPerPeriodId((List<DynamicObject>)node.getMainDynamicObjects(), detail.getLong("attmain"));
            String periodAttItemId = perPeriodId + "&&" + detail.getLong("attitemid");
            if (!periodAttItemIdSet.add(periodAttItemId)) continue;
            if (phaseResult == TiePhaseRusultEnum.OVERROAD) {
                detailDynamicObjectList.add(detail);
                continue;
            }
            if (phaseResult != TiePhaseRusultEnum.ADDALL) continue;
            List<AttPeriodSpliteModel> allValiteNodeList = PeriodContextUtil.getAllValiteNodes(upNodeList, periodAttItemId);
            BigDecimal sumValue = PeriodContextUtil.getSumValue(allValiteNodeList, periodAttItemId);
            detail.set("valuelong", (Object)sumValue);
            detailDynamicObjectList.add(detail);
        }
    }

    private static String getPerPeriodId(List<DynamicObject> dynamicObjects, Long id) {
        return dynamicObjects.stream().filter(ob -> ob.getLong("id") == id.longValue()).map(ob -> ob.getString("attperattperiodid")).findFirst().orElse(null);
    }

    private static BigDecimal getSumValue(List<AttPeriodSpliteModel> allValiteNodeList, String periodAttItemId) {
        BigDecimal sumValue = BigDecimal.ZERO;
        HashMap respectMap = Maps.newHashMapWithExpectedSize((int)16);
        for (AttPeriodSpliteModel attPeriodSpliteModel : allValiteNodeList) {
            int index = attPeriodSpliteModel.getPhaseProperty().getIndex();
            DynamicObjectCollection detailDynamicObjects = attPeriodSpliteModel.getDetailDynamicObjects();
            for (DynamicObject detail : detailDynamicObjects) {
                String perPeriodId = PeriodContextUtil.getPerPeriodId((List<DynamicObject>)attPeriodSpliteModel.getMainDynamicObjects(), detail.getLong("attmain"));
                String curperiodAttItemId = perPeriodId + "&&" + detail.getLong("attitemid");
                Set oldIndexSet = respectMap.computeIfAbsent(periodAttItemId, ob -> new HashSet(16));
                if (!HRStringUtils.equals((String)periodAttItemId, (String)curperiodAttItemId) || !oldIndexSet.add(index)) continue;
                sumValue = sumValue.add(detail.getBigDecimal("valuelong"));
                respectMap.put(periodAttItemId, oldIndexSet);
            }
        }
        return sumValue;
    }

    private static List<AttPeriodSpliteModel> getAllValiteNodes(List<AttPeriodSpliteModel> upNodeList, String periodattItemId) {
        AttPeriodSpliteModel attPeriodSpliteModel = PeriodContextUtil.getFirstOverLoadByPeriodattItemId(upNodeList, periodattItemId);
        if (attPeriodSpliteModel != null) {
            int index = attPeriodSpliteModel.getPhaseProperty().getIndex();
            return upNodeList.stream().filter(ob -> index <= ob.getPhaseProperty().getIndex()).collect(Collectors.toList());
        }
        return upNodeList;
    }

    private static AttPeriodSpliteModel getFirstOverLoadByPeriodattItemId(List<AttPeriodSpliteModel> upNodeList, String periodattItemId) {
        for (AttPeriodSpliteModel attPeriodSpliteModel : upNodeList) {
            TiePhaseRusultEnum result = attPeriodSpliteModel.getPhaseProperty().getResult();
            if (result != TiePhaseRusultEnum.OVERROAD) continue;
            DynamicObjectCollection detailDynamicObjects = attPeriodSpliteModel.getDetailDynamicObjects();
            for (DynamicObject detail : detailDynamicObjects) {
                String perPeriodId = PeriodContextUtil.getPerPeriodId((List<DynamicObject>)attPeriodSpliteModel.getMainDynamicObjects(), detail.getLong("attmain"));
                String curPeriodattItemId = perPeriodId + "&&" + detail.getLong("attitemid");
                if (!HRStringUtils.equals((String)periodattItemId, (String)curPeriodattItemId)) continue;
                return attPeriodSpliteModel;
            }
        }
        return null;
    }

    public static List<DynamicObject> getMainDysByDetail(List<DynamicObject> detailDynamicObjectList, List<AttPeriodSpliteModel> result) {
        ArrayList mainDynamicObjects = Lists.newArrayListWithExpectedSize((int)16);
        for (AttPeriodSpliteModel attPeriodSpliteModel : result) {
            mainDynamicObjects.addAll(attPeriodSpliteModel.getMainDynamicObjects());
        }
        Set idList = detailDynamicObjectList.stream().map(ob -> ob.getLong("attmain")).collect(Collectors.toSet());
        return mainDynamicObjects.stream().filter(ob -> idList.contains(ob.getLong("id"))).collect(Collectors.toList());
    }

    public static Tuple<Boolean, TieStatus> dealDecision(TiePointer pointer, List<AttPeriodSpliteModel> result, AttPeriodSpliteModel attPeriodSpliteModel, TieAttPeriodContext tieAttPeriodContext, TiePhaseConfig phaseProperty) {
        switch (pointer) {
            case CONTINUE: {
                break;
            }
            case BREAK: {
                return new Tuple((Object)Boolean.FALSE, (Object)TieStatus.SUCCESS);
            }
            case TERMINATE: {
                return new Tuple((Object)Boolean.FALSE, (Object)TieStatus.EXCLUSION);
            }
            case ERROR: {
                List<TieMessage> tieMessages = tieAttPeriodContext.getTieMessages();
                tieMessages.addAll(attPeriodSpliteModel.getTieMessages());
                return new Tuple((Object)Boolean.FALSE, (Object)TieStatus.ERROR);
            }
            default: {
                if (attPeriodSpliteModel == null) break;
                result.add(attPeriodSpliteModel);
                attPeriodSpliteModel.setPhaseProperty(phaseProperty);
            }
        }
        return new Tuple((Object)Boolean.TRUE, (Object)TieStatus.SUCCESS);
    }

    public static String getErrorMsg(List<TieMessage> tieMessages) {
        StringBuilder errMsg = new StringBuilder();
        for (TieMessage tieMessage : tieMessages) {
            if (tieMessage.getMsgLevel() != TieMsgLevel.ERROR) continue;
            errMsg.append(tieMessage.getMsg());
        }
        return errMsg.toString();
    }

    public static TiePointer getDecision(int index, List<DecisionConfig> executorDecision, TieStatus status) {
        if (CollectionUtils.isEmpty(executorDecision) || status != TieStatus.EXCLUSION) {
            return PeriodContextUtil.defalutDecision(status);
        }
        DecisionConfig decisionConfig = executorDecision.get(index);
        if (decisionConfig == null) {
            return PeriodContextUtil.defalutDecision(status);
        }
        return decisionConfig.getTp();
    }

    private static TiePointer defalutDecision(TieStatus status) {
        switch (status) {
            case SUCCESS: {
                return TiePointer.NEXT;
            }
            case EXCLUSION: {
                return TiePointer.CONTINUE;
            }
        }
        return TiePointer.ERROR;
    }

    public static boolean isContinue(Tuple<Boolean, TieStatus> tuple, TiePointer phaseTiePointer) {
        if (tuple != null && !((Boolean)tuple.getKey()).booleanValue()) {
            if (phaseTiePointer == null) {
                return true;
            }
            if (TiePointer.BREAK == phaseTiePointer || TiePointer.TERMINATE == phaseTiePointer || TiePointer.ERROR == phaseTiePointer) {
                return false;
            }
        }
        return true;
    }

    public static TiePointer getPhaseTiePointer(Tuple<Boolean, TieStatus> tuple, TiePointer phaseTiePointer, int phaseIndex, List<DecisionConfig> decisionConfigList) {
        if (tuple != null && !((Boolean)tuple.getKey()).booleanValue()) {
            TieStatus resultTieStatus = (TieStatus)((Object)tuple.getValue());
            return PeriodContextUtil.getDecision(phaseIndex, decisionConfigList, resultTieStatus);
        }
        return phaseTiePointer;
    }

    public static DynamicObject getBaseAttTotalData(TieAttPeriodContext tieAttPeriodContext, PerAttPeriod perAttPeriod, AttendPersonModel personModel, AttFileModel attFileModel, MainEntityType mainEntityType) {
        LocalDate chainDate = tieAttPeriodContext.getPeriodData(perAttPeriod, attFileModel);
        DynamicObject resDyn = new DynamicObject((DynamicObjectType)mainEntityType);
        resDyn.set("versionid", (Object)tieAttPeriodContext.getVersion());
        resDyn.set("personid", (Object)perAttPeriod.getPersonId());
        resDyn.set("attperattperiodid", (Object)perAttPeriod.getId());
        resDyn.set("attperattperiodpk", (Object)perAttPeriod.getPrimaryId());
        resDyn.set("perattperiodid", (Object)perAttPeriod.getAttPeriodId());
        CmpEmp cmpEmp = personModel.getCmpEmp();
        resDyn.set("managescopevid", (Object)(cmpEmp == null ? 0L : cmpEmp.getId()));
        AttFileCabinet attFileCabinet = tieAttPeriodContext.getAttFileCabinet();
        AdminOrg adminOrgByDate = attFileCabinet.getAdminOrgByDate(attFileModel.getAdminOrgId(), chainDate);
        Company companyByDate = attFileCabinet.getCompanyByDate(attFileModel.getCompanyId(), chainDate);
        Position positionByDate = attFileCabinet.getPositionByDate(attFileModel.getPositionId(), chainDate);
        Job jobByDate = attFileCabinet.getJobByDate(attFileModel.getJobId(), chainDate);
        resDyn.set("departmentvid", (Object)(adminOrgByDate == null ? 0L : adminOrgByDate.getId()));
        resDyn.set("companyvid", (Object)(companyByDate == null ? 0L : companyByDate.getId()));
        resDyn.set("positionvid", (Object)(positionByDate == null ? 0L : positionByDate.getId()));
        resDyn.set("jobvid", (Object)(jobByDate == null ? 0L : jobByDate.getId()));
        resDyn.set("orgid", (Object)attFileModel.getOrgId());
        resDyn.set("reckoner", (Object)RequestContext.get().getCurrUserId());
        resDyn.set("affiliateadminorgvid", (Object)attFileModel.getAffiliateAdminOrgVid(chainDate));
        resDyn.set("createtime", (Object)new Date());
        resDyn.set("perperiodbegindate", (Object)perAttPeriod.getPerAttBeginDate());
        resDyn.set("perperiodenddate", (Object)perAttPeriod.getPerAttEndDate());
        resDyn.set("attfileid", (Object)attFileModel.getTimeSeqInfo().getBid());
        resDyn.set("attfilevid", (Object)attFileModel.getTimeSeqInfo().getVid());
        return resDyn;
    }
}

