/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.wtc.wtbs.business.round.RoundCalculateService;
import kd.wtc.wtbs.common.model.evaluation.RoundWrapper;
import kd.wtc.wtbs.common.util.AttItemRoundType;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.ShiftSpec;

public class RoundRuleService {
    private static final String DAY = "day";
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String SECOND = "second";
    private static final String TIME = "time";
    private static final BigDecimal SECONDTOMINUTE = BigDecimal.valueOf(60L);
    private static final BigDecimal INVALID = BigDecimal.valueOf(Long.MAX_VALUE);

    public static BigDecimal roundValue(RoundWrapper roundWrapper, BigDecimal total, AttItemSpec spec, ShiftSpec shiftSpec) {
        BigDecimal round;
        int roundType = AttItemRoundType.getAttItemRoundType((String)spec.getPrecisionTail());
        switch (spec.getUnit()) {
            case "day": {
                total = shiftSpec.secondsToDays(total);
                round = RoundRuleService.doRound(roundWrapper, total);
                round = new BigDecimal(shiftSpec.daysToSeconds(round));
                break;
            }
            case "hour": {
                total = total.divide(SECONDTOMINUTE.multiply(SECONDTOMINUTE), spec.getDataAccuracy(), roundType);
                round = RoundRuleService.doRound(roundWrapper, total);
                round = round.multiply(SECONDTOMINUTE).multiply(SECONDTOMINUTE);
                break;
            }
            case "minute": {
                total = total.divide(SECONDTOMINUTE, spec.getDataAccuracy(), roundType);
                round = RoundRuleService.doRound(roundWrapper, total);
                round = round.multiply(SECONDTOMINUTE);
                break;
            }
            case "second": 
            case "time": {
                round = RoundRuleService.doRound(roundWrapper, total);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + spec.getUnit());
            }
        }
        return round;
    }

    private static BigDecimal doRound(RoundWrapper roundWrapper, BigDecimal total) {
        Map rs = RoundCalculateService.roundCalculate((RoundWrapper)roundWrapper, (BigDecimal)total);
        if (!"".equals(rs.get("resultMsg"))) {
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u5f85\u820d\u5165\u7684\u503c\uff1a{1}\u3002", (String)"RoundRuleService_0", (String)"wtc-wtes-business", (Object[])new Object[]{rs.get("resultMsg"), total}));
        }
        return Optional.ofNullable((BigDecimal)rs.get("resultValue")).orElse(INVALID);
    }
}

