/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtes.business.builder.CleanableBuilder;
import kd.wtc.wtes.business.model.AttItemInstance;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.ShiftSpec;
import kd.wtc.wtes.business.model.attitem.DataType;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimResult;
import kd.wtc.wtes.business.std.datanode.AttItemValue;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;
import kd.wtc.wtes.common.enums.AccountStepEnum;
import kd.wtc.wtes.common.enums.TiePhaseRusultEnum;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.LabelSet;

public final class TieContextUtilForDayDetail {
    private TieContextUtilForDayDetail() {
    }

    public static Map<Long, AttItemValue> getAllHandleResultAttItemValue(List<TieDataNodeStd> dataNodes, ShiftSpec shiftSpec) {
        if (WTCCollections.isEmpty(dataNodes)) {
            return Collections.emptyMap();
        }
        HashMap attItemValueMap = Maps.newHashMapWithExpectedSize((int)16);
        TieContextUtilForDayDetail.setDataNodesHandleFlag(dataNodes);
        List<TieDataNodeStd> tieDataNodeStdList = TieContextUtilForDayDetail.reverseNodeList(dataNodes);
        Optional<TieDataNodeStd> optional = tieDataNodeStdList.stream().filter(ob -> ob.getStepIdentity().getPhaseIdentity().getNumber().equals(AccountStepEnum.DR_1010_S.getPhaseCode()) && ob.getStepIdentity().getNumber().equals(AccountStepEnum.DR_1010_S.getCode())).findFirst();
        Map<Long, List<TieDataNodeStd>> groupByAttitemMap = TieContextUtilForDayDetail.nodeGroupByAttitem(optional, tieDataNodeStdList);
        groupByAttitemMap.forEach((attitemBId, dataNodeList) -> {
            Optional<AttItemSpec> attItemSpecOptional;
            if (!WTCCollections.isEmpty((Collection)dataNodeList) && (attItemSpecOptional = ((TieDataNodeStd)dataNodeList.get(0)).getAttItemInstances().stream().map(ob -> ob.getAttItemSpec()).filter(entry -> attitemBId.equals(entry.getBid())).findFirst()).isPresent()) {
                List<TieDataNodeStd> calNode = TieContextUtilForDayDetail.getCalNode(dataNodeList);
                attItemValueMap.put(attitemBId, TieContextUtilForDayDetail.getAttItemValue(calNode, attItemSpecOptional.get(), shiftSpec));
            }
        });
        return attItemValueMap;
    }

    private static Map<Long, List<TieDataNodeStd>> nodeGroupByAttitem(Optional<TieDataNodeStd> optional, List<TieDataNodeStd> tieDataNodeStdList) {
        if (optional.isPresent()) {
            TieDataNodeStd tieDataNodeStd = optional.get();
            int indexOptional = tieDataNodeStd.getStepIdentity().getPhaseIdentity().getIndex();
            tieDataNodeStdList = tieDataNodeStdList.stream().filter(ob -> ob.getStepIdentity().getPhaseIdentity().getIndex() >= indexOptional).collect(Collectors.toList());
        }
        HashMap groupByAttitemMap = Maps.newHashMapWithExpectedSize((int)16);
        for (TieDataNodeStd tieDataNodeStd : tieDataNodeStdList) {
            List<AttItemInstance> attItemInstanceList = tieDataNodeStd.getAttItemInstances();
            HashSet attitemBIdSet = Sets.newHashSetWithExpectedSize((int)16);
            for (AttItemInstance attItemInstance : attItemInstanceList) {
                List phaseNodeStdList = groupByAttitemMap.computeIfAbsent(attItemInstance.getAttItemSpec().getBid(), key -> new ArrayList());
                Long attitemBid = attItemInstance.getAttItemSpec().getBid();
                if (attitemBIdSet.contains(attitemBid) || attItemInstance.getHandleFlag() == null || !attItemInstance.getHandleFlag().booleanValue()) continue;
                phaseNodeStdList.add(tieDataNodeStd);
                attitemBIdSet.add(attItemInstance.getAttItemSpec().getBid());
            }
        }
        return groupByAttitemMap;
    }

    public static List<TieDataNodeStd> reverseNodeList(List<TieDataNodeStd> dataNodeStdList) {
        ArrayList tieDataNodeStdList = Lists.newArrayListWithExpectedSize((int)dataNodeStdList.size());
        for (int i = dataNodeStdList.size() - 1; i >= 0; --i) {
            tieDataNodeStdList.add(dataNodeStdList.get(i));
        }
        return tieDataNodeStdList;
    }

    private static TieDataNodeStd getFirstHandleFlagNode(List<TieDataNodeStd> dataNodes) {
        for (TieDataNodeStd tieDataNodeStd : dataNodes) {
            if (tieDataNodeStd.getStepIdentity().getPhaseIdentity().getResult() != TiePhaseRusultEnum.OVERROAD) continue;
            return tieDataNodeStd;
        }
        return null;
    }

    public static void setDataNodesHandleFlag(List<TieDataNodeStd> allDataNodes) {
        allDataNodes.stream().filter(TieDataNodeStd::isLeafInPhase).forEach(tieDataNodeStd -> {
            HashSet itemInstanceSet = Sets.newHashSetWithExpectedSize((int)16);
            List<AttItemInstance> attItemInstances = tieDataNodeStd.getAttItemInstances();
            for (AttItemInstance attItemInstance : attItemInstances) {
                attItemInstance.setHandleFlag(Boolean.TRUE);
                itemInstanceSet.add(attItemInstance.getAttItemSpec().getBid());
            }
            Long phaseId = tieDataNodeStd.getStepIdentity().getPhaseIdentity().getId();
            List<TieDataNodeStd> parentNodes = tieDataNodeStd.parentDataNodes();
            for (TieDataNodeStd parentNode : parentNodes) {
                TieContextUtilForDayDetail.setParentNodesHandleFlag(phaseId, parentNode, new HashSet<Long>(itemInstanceSet));
            }
        });
    }

    private static void setParentNodesHandleFlag(Long phaseId, TieDataNodeStd parentDataNode, Set<Long> itemInstanceSet) {
        Long parentId = parentDataNode.getStepIdentity().getPhaseIdentity().getId();
        if (phaseId.equals(parentId)) {
            List<AttItemInstance> attItemInstances = parentDataNode.getAttItemInstances();
            HashSet<Long> tempSet = new HashSet<Long>();
            for (AttItemInstance attItemInstance : attItemInstances) {
                Long specId = attItemInstance.getAttItemSpec().getBid();
                if (itemInstanceSet.contains(specId)) {
                    attItemInstance.setHandleFlag(Boolean.FALSE);
                    continue;
                }
                Boolean flag = attItemInstance.getHandleFlag();
                if (!Objects.isNull(flag)) continue;
                attItemInstance.setHandleFlag(Boolean.TRUE);
                tempSet.add(specId);
            }
            itemInstanceSet.addAll(tempSet);
            List<TieDataNodeStd> tieDataNodes = parentDataNode.parentDataNodes();
            for (TieDataNodeStd tieDataNodeStd : tieDataNodes) {
                TieContextUtilForDayDetail.setParentNodesHandleFlag(parentId, tieDataNodeStd, new HashSet<Long>(itemInstanceSet));
            }
        }
    }

    private static List<TieDataNodeStd> getCalNode(List<TieDataNodeStd> dataNodes) {
        TieDataNodeStd firstTieDataNodeStd = TieContextUtilForDayDetail.getFirstHandleFlagNode(dataNodes);
        if (firstTieDataNodeStd != null) {
            int index = firstTieDataNodeStd.getStepIdentity().getPhaseIdentity().getIndex();
            return dataNodes.stream().filter(ob -> index <= ob.getStepIdentity().getPhaseIdentity().getIndex()).collect(Collectors.toList());
        }
        return dataNodes;
    }

    private static AttItemValue getAttItemValue(List<TieDataNodeStd> attItemDataNodes, AttItemSpec attItemSpec, ShiftSpec shiftSpec) {
        DataType dataType = attItemSpec.getDataType();
        BigDecimal dayValue = BigDecimal.ZERO;
        BigDecimal valueSecond = BigDecimal.ZERO;
        BigDecimal valueTimes = BigDecimal.ZERO;
        HashSet linkParentNodeSet = Sets.newHashSetWithExpectedSize((int)16);
        LabelSet extraLabels = new LabelSet();
        ArrayList attRecordTrimResultList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList attRecordMoveTrimResultList = Lists.newArrayListWithExpectedSize((int)16);
        for (TieDataNodeStd tieDataNodeStd : attItemDataNodes) {
            List<AttItemInstance> attItemInstances = tieDataNodeStd.getAttItemInstances();
            for (AttItemInstance itemInstance : attItemInstances) {
                TieContextUtilForDayDetail.addAttRecordTrimResult(itemInstance, attItemSpec, attRecordTrimResultList, attRecordMoveTrimResultList);
                if (!((Object)((Object)itemInstance.getAttItemSpec())).equals((Object)attItemSpec)) continue;
                switch (dataType) {
                    case DURATION: {
                        dayValue = dayValue.add(itemInstance.getDay());
                        valueSecond = valueSecond.add(itemInstance.getSecondDecimal());
                        break;
                    }
                    case TIMES: {
                        valueTimes = valueTimes.add(itemInstance.getItemValue());
                        break;
                    }
                }
                linkParentNodeSet.add(tieDataNodeStd);
                if (CollectionUtils.isEmpty(itemInstance.getExtraLabels())) continue;
                extraLabels.addAll(itemInstance.getExtraLabels());
            }
        }
        if (null != shiftSpec) {
            dayValue = shiftSpec.secondsToDays(valueSecond);
        }
        AttItemInstance sumItemInstance = new AttItemInstance(attItemSpec, valueTimes, dayValue, valueSecond, attRecordMoveTrimResultList, null, attRecordTrimResultList);
        sumItemInstance.getExtraLabels().addAll((Collection)extraLabels);
        return (AttItemValue)((CleanableBuilder)((AttItemValue.Builder)AttItemValue.builder().parentDataNodes(linkParentNodeSet)).attItemInstance(sumItemInstance)).build();
    }

    private static void addAttRecordTrimResult(AttItemInstance itemInstance, AttItemSpec attItemSpec, List<AttRecordTrimResult> attRecordTrimResultList, List<AttRecordTrimResult> attRecordMoveTrimResultList) {
        if (((Object)((Object)itemInstance.getAttItemSpec())).equals((Object)attItemSpec)) {
            TieContextUtilForDayDetail.addAllAttRecordTrimResultList(attRecordTrimResultList, itemInstance.getAttRecordTrimResultList());
            TieContextUtilForDayDetail.addAllAttRecordTrimResultList(attRecordMoveTrimResultList, itemInstance.getAttRecordMoveTrimResultList());
        }
    }

    public static void addAllAttRecordTrimResultList(List<AttRecordTrimResult> attRecordTrimResultList, List<AttRecordTrimResult> addList) {
        if (!CollectionUtils.isEmpty(addList)) {
            attRecordTrimResultList.addAll(addList);
        }
    }
}

