/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.model.rlotcal.OtSubTimeItem;
import kd.wtc.wtes.business.std.datanode.ITimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.std.datanode.TimeBucketStd;
import kd.wtc.wtes.common.pairtime.SourceCode;

public class TimeBucketUtil {
    private TimeBucketUtil() {
    }

    public static boolean contain(LocalDateTime begin, LocalDateTime end, LocalDateTime shiftStart, LocalDateTime shiftEnd) {
        return !(!end.isBefore(shiftEnd) && !end.isEqual(shiftEnd) || !begin.isAfter(shiftStart) && !begin.isEqual(shiftStart));
    }

    public static boolean hasIntersection(LocalDateTime begin, LocalDateTime end, LocalDateTime shiftStart, LocalDateTime shiftEnd) {
        return !end.isBefore(shiftStart) && !end.isEqual(shiftStart) && !begin.isAfter(shiftEnd) && !begin.isEqual(shiftEnd);
    }

    public static boolean hasIntersection(LocalDateTime begin, LocalDateTime end, ITimeBucket timeBucket) {
        boolean bo;
        boolean bl = bo = begin == null || end == null || timeBucket == null || timeBucket.getStartTime() == null || timeBucket.getEndTime() == null;
        if (bo) {
            return false;
        }
        return !end.isBefore(timeBucket.getStartTime()) && !end.isEqual(timeBucket.getStartTime()) && !begin.isAfter(timeBucket.getEndTime()) && !begin.isEqual(timeBucket.getEndTime());
    }

    public static boolean hasIntersection(LocalTime begin, LocalTime end, ITimeBucket timeBucket) {
        boolean timeBucketStart = TimeBucketUtil.hasIntersection(LocalDateTime.of(timeBucket.getStartTime().toLocalDate(), begin), LocalDateTime.of(timeBucket.getStartTime().toLocalDate(), end), timeBucket);
        boolean timeBucketEnd = TimeBucketUtil.hasIntersection(LocalDateTime.of(timeBucket.getEndTime().toLocalDate(), begin), LocalDateTime.of(timeBucket.getEndTime().toLocalDate(), end), timeBucket);
        return timeBucketStart || timeBucketEnd;
    }

    public static TimeBucket intersection(LocalDateTime begin, LocalDateTime end, TimeBucketStd timeBucket, boolean setPointSource) {
        TimeBucket res = null;
        if (TimeBucketUtil.hasIntersection(begin, end, (ITimeBucket)timeBucket)) {
            res = timeBucket.unwrapAndCopy();
            if (timeBucket.getStartTime().isBefore(begin)) {
                res.setStartTime(begin);
                if (setPointSource) {
                    res.setStartTimePointSource(SourceCode.NONE);
                }
            }
            if (timeBucket.getEndTime().isAfter(end)) {
                res.setEndTime(end);
                if (setPointSource) {
                    res.setEndTimePointSource(SourceCode.NONE);
                }
            }
        }
        return res;
    }

    public static List<TimeBucket> noIntersection(List<OtSubTimeItem> otSubTimeItemList, TimeBucket timeBucket, boolean setPointSource, Map<String, Boolean> map) {
        String key = timeBucket.getStartTime().format(DateTimeFormatter.ISO_DATE_TIME) + timeBucket.getEndTime().format(DateTimeFormatter.ISO_DATE_TIME);
        if (map != null && map.get(key) != null && map.get(key).booleanValue()) {
            return Arrays.asList(new TimeBucket[0]);
        }
        if (map == null) {
            map = new HashMap<String, Boolean>();
        }
        map.put(key, true);
        ArrayList res = Lists.newArrayList();
        otSubTimeItemList = otSubTimeItemList.stream().sorted(Comparator.comparing(item -> item.getBeginTime())).collect(Collectors.toList());
        LocalDate startLocalDate = timeBucket.getStartTime().toLocalDate();
        LocalDate endLocalDate = timeBucket.getEndTime().toLocalDate();
        boolean hasIntersection = false;
        LocalDate i = startLocalDate;
        while (i.compareTo(endLocalDate) <= 0) {
            for (OtSubTimeItem timeItem : otSubTimeItemList) {
                LocalDateTime end;
                LocalDateTime start = LocalDateTime.of(i, LocalTime.ofSecondOfDay(timeItem.getBeginTime()));
                if (!TimeBucketUtil.hasIntersection(start, end = LocalDateTime.of(i, LocalTime.ofSecondOfDay(timeItem.getEndTime())), (ITimeBucket)timeBucket)) continue;
                hasIntersection = true;
                List<TimeBucket> timeBucketList = TimeBucketUtil.noIntersection(start, end, timeBucket, setPointSource);
                for (TimeBucket bucket : timeBucketList) {
                    res.addAll(TimeBucketUtil.noIntersection(otSubTimeItemList, bucket, setPointSource, map));
                }
            }
            i = i.plusDays(1L);
        }
        if (!hasIntersection && timeBucket.getStartTime().compareTo(timeBucket.getEndTime()) != 0) {
            res.add(timeBucket.clone());
        }
        return res.stream().distinct().collect(Collectors.toList());
    }

    public static List<TimeBucket> noIntersection(LocalDateTime begin, LocalDateTime end, TimeBucket timeBucket, boolean setPointSource) {
        ArrayList timeBucketList = Lists.newArrayList();
        TimeBucket res = null;
        if (TimeBucketUtil.hasIntersection(begin, end, (ITimeBucket)timeBucket)) {
            if (TimeBucketUtil.hasInTimeBucket(begin, end, timeBucket)) {
                TimeBucket startTB = timeBucket.clone();
                startTB.setEndTime(begin);
                if (setPointSource) {
                    startTB.setEndTimePointSource(SourceCode.NONE);
                }
                timeBucketList.add(startTB);
                TimeBucket endTB = timeBucket.clone();
                endTB.setStartTime(end);
                if (setPointSource) {
                    endTB.setStartTimePointSource(SourceCode.NONE);
                }
                timeBucketList.add(endTB);
                return timeBucketList;
            }
            TimeBucket tb = new TimeBucket();
            tb.setStartTime(begin);
            tb.setEndTime(end);
            if (TimeBucketUtil.hasInTimeBucket(timeBucket.getStartTime(), timeBucket.getEndTime(), tb)) {
                return Collections.EMPTY_LIST;
            }
            res = timeBucket.clone();
            if (timeBucket.getStartTime().isBefore(begin)) {
                res.setEndTime(begin);
                if (setPointSource) {
                    res.setEndTimePointSource(SourceCode.NONE);
                }
            }
            if (timeBucket.getEndTime().isAfter(end)) {
                res.setStartTime(end);
                if (setPointSource) {
                    res.setStartTimePointSource(SourceCode.NONE);
                }
            }
        } else {
            res = timeBucket.clone();
        }
        return Lists.newArrayList((Object[])new TimeBucket[]{res});
    }

    public static List<TimeBucket> intersectionLocalTime(LocalTime begin, LocalTime end, TimeBucketStd timeBucket, boolean setPointSource) {
        ArrayList intersectionRes = Lists.newArrayList();
        LocalDate startDate = timeBucket.getStartTime().toLocalDate();
        LocalDate endDate = timeBucket.getEndTime().toLocalDate();
        intersectionRes.add(TimeBucketUtil.intersection(LocalDateTime.of(startDate, begin), LocalDateTime.of(startDate, end), timeBucket, setPointSource));
        if (!startDate.equals(endDate)) {
            intersectionRes.add(TimeBucketUtil.intersection(LocalDateTime.of(endDate, begin), LocalDateTime.of(endDate, end), timeBucket, setPointSource));
        }
        intersectionRes.removeIf(Objects::isNull);
        return intersectionRes;
    }

    @Deprecated
    public static List<TimeBucket> intersectionNoMix(LocalDateTime begin, LocalDateTime end, TimeBucket timeBucket, boolean setPointSource) {
        ArrayList<TimeBucket> res = new ArrayList<TimeBucket>();
        ArrayList<TimeBucket> resList = new ArrayList<TimeBucket>();
        if (TimeBucketUtil.hasIntersection(begin, end, (ITimeBucket)timeBucket)) {
            TimeBucket tb;
            if (TimeBucketUtil.hasInTimeBucket(begin, end, timeBucket)) {
                tb = timeBucket.clone();
                tb.setStartTime(end);
                if (setPointSource) {
                    tb.setStartTimePointSource(SourceCode.NONE);
                }
                resList.add(tb);
                TimeBucket tb2 = timeBucket.clone();
                tb2.setEndTime(begin);
                if (setPointSource) {
                    tb2.setEndTimePointSource(SourceCode.NONE);
                }
                resList.add(tb2);
            } else if (TimeBucketUtil.hasInTimeBucket(begin, timeBucket)) {
                tb = timeBucket.clone();
                tb.setEndTime(begin);
                if (setPointSource) {
                    tb.setEndTimePointSource(SourceCode.NONE);
                }
                resList.add(tb);
            } else if (TimeBucketUtil.hasInTimeBucket(end, timeBucket)) {
                tb = timeBucket.clone();
                tb.setStartTime(end);
                if (setPointSource) {
                    tb.setStartTimePointSource(SourceCode.NONE);
                }
                resList.add(tb);
            }
        } else {
            resList.add(timeBucket.clone());
        }
        for (TimeBucket timeBucket2 : resList) {
            if (timeBucket2.getStartTime().isEqual(timeBucket2.getEndTime())) continue;
            res.add(timeBucket2);
        }
        return res;
    }

    public static boolean hasInTimeBucket(LocalDateTime localDateTime, ITimeBucket timeBucket) {
        return !(!timeBucket.getStartTime().isBefore(localDateTime) && !timeBucket.getStartTime().isEqual(localDateTime) || !timeBucket.getEndTime().isAfter(localDateTime) && !timeBucket.getEndTime().isEqual(localDateTime));
    }

    public static boolean hasInTimeBucket(LocalDateTime localDateTime, LocalDateTime startDateTime, LocalDateTime endDateTime) {
        return !(!startDateTime.isBefore(localDateTime) && !startDateTime.isEqual(localDateTime) || !endDateTime.isAfter(localDateTime) && !endDateTime.isEqual(localDateTime));
    }

    public static boolean hasInTimeBucket(LocalDateTime begin, LocalDateTime end, ITimeBucket timeBucket) {
        return TimeBucketUtil.hasInTimeBucket(begin, timeBucket) && TimeBucketUtil.hasInTimeBucket(end, timeBucket);
    }

    public static boolean hasInTime(LocalDateTime begin, LocalDateTime end, ITimeBucket timeBucket) {
        return !(!begin.isBefore(timeBucket.getStartTime()) && !begin.isEqual(timeBucket.getStartTime()) || !end.isAfter(timeBucket.getEndTime()) && !end.isEqual(timeBucket.getEndTime()));
    }

    public static BigDecimal getMinutesFromTimeBucket(ITimeBucket timeBucket) {
        Duration between = Duration.between(timeBucket.getStartTime(), timeBucket.getEndTime());
        return BigDecimal.valueOf(between.toMinutes());
    }

    public static LocalTime getTimeBucketBetween(ITimeBucket timeBucket) {
        Duration between = Duration.between(timeBucket.getStartTime(), timeBucket.getEndTime());
        return WTCDateUtils.secondToTime((long)between.getSeconds());
    }

    @Deprecated
    public static BigDecimal getDay(BigDecimal minutes) {
        if (minutes.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal multiply = new BigDecimal(8).multiply(new BigDecimal(60));
        return minutes.divide(multiply, 2, 4);
    }
}

