/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.timeseq.TimeSeqInfoImpl;
import kd.wtc.wtbs.common.enums.HisDataStatus;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public interface TimeSeqEntityGenerateUtils {
    public static final List<String> usableDataStatusList = Collections.unmodifiableList(Arrays.asList(HisDataStatus.EXPIRATION.code, HisDataStatus.EFFECTIVE.code, HisDataStatus.SCHEDULE_EFFECTIVE.code));
    public static final String BSED = "bsed";
    public static final String BSLED = "bsled";

    public static QFilter[] getQueryCondition(Collection<Long> fIds, LocalDate startDate, LocalDate endDate) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        QFilter qFilter5 = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        qFilters.add(qFilter5);
        if (fIds != null) {
            qFilters.add(WTCHisServiceHelper.validQFilterByBoNoStatus(fIds));
        }
        if (startDate == null || endDate == null) {
            return qFilters.toArray(new QFilter[0]);
        }
        QFilter qFilter1 = new QFilter("boid", "in", fIds);
        QFilter qFilter2 = new QFilter("datastatus", "in", usableDataStatusList);
        QFilter qFilter3 = new QFilter(BSED, "<=", (Object)endDate);
        QFilter qFilter4 = new QFilter(BSLED, ">=", (Object)startDate);
        qFilters.add(qFilter1);
        qFilters.add(qFilter2);
        qFilters.add(qFilter3);
        qFilters.add(qFilter4);
        qFilters.add(qFilter5);
        return qFilters.toArray(new QFilter[0]);
    }

    public static QFilter[] getPresetDataQueryCondition(Collection<Long> fIds) {
        QFilter qFilter1 = new QFilter("id", "in", fIds);
        QFilter qFilter2 = new QFilter("issyspreset", "=", (Object)Character.valueOf('1'));
        return new QFilter[]{qFilter1, qFilter2};
    }

    public static TimeSeqInfoImpl getTimeSeqEntity(DynamicObject hisEntity) {
        if (hisEntity == null) {
            return null;
        }
        long id = hisEntity.getLong("id");
        long bid = hisEntity.getLong("boid");
        String number = hisEntity.getString("number");
        LocalDate bsed = WTCDateUtils.toLocalDate((Date)hisEntity.getDate(BSED));
        LocalDate bsled = WTCDateUtils.toLocalDate((Date)hisEntity.getDate(BSLED));
        return new TimeSeqInfoImpl(id, bid, number, bsed, bsled);
    }

    public static QFilter[] getQueryCondition(LocalDate fromDate, LocalDate toDate) {
        QFilter fromDateFilter = new QFilter(BSED, "<=", (Object)toDate);
        QFilter toDateDateFilter = new QFilter(BSLED, ">=", (Object)fromDate);
        QFilter currentVersion = new QFilter("iscurrentversion", "=", (Object)Boolean.FALSE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", usableDataStatusList);
        return new QFilter[]{statusFilter, dataStatusFilter, fromDateFilter, toDateDateFilter, currentVersion};
    }
}

