/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import kd.wtc.wtes.common.enums.RefDateType;
import kd.wtc.wtes.common.util.Assert;

public interface WTESDateUtils {
    public static Date advanceDateByRefDateType(Date date, RefDateType refDateType) {
        if (date == null) {
            return null;
        }
        int advanceValue = refDateType == RefDateType.NEXTDAY ? 1 : (refDateType == RefDateType.LASTDAY ? -1 : 0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, advanceValue);
        return calendar.getTime();
    }

    public static LocalDate advanceDateByRefDateType(LocalDate localDate, RefDateType refDateType) {
        if (localDate == null) {
            return null;
        }
        int advanceValue = refDateType == RefDateType.NEXTDAY ? 1 : (refDateType == RefDateType.LASTDAY ? -1 : 0);
        return localDate.plusDays(advanceValue);
    }

    public static LocalDateTime advanceDateByRefDateType(LocalDateTime localDateTime, RefDateType refDateType) {
        if (localDateTime == null) {
            return null;
        }
        int advanceValue = refDateType == RefDateType.NEXTDAY ? 1 : (refDateType == RefDateType.LASTDAY ? -1 : 0);
        return localDateTime.plusDays(advanceValue);
    }

    public static int durationBetweenRefTimePoints(LocalTime time1, RefDateType ref1, LocalTime time2, RefDateType ref2) {
        Assert.nonNull((Object)time1, (String)"time1");
        Assert.nonNull((Object)ref1, (String)"RefDateType could not be null");
        Assert.nonNull((Object)time2, (String)"time2");
        Assert.nonNull((Object)ref2, (String)"RefDateType could not be null");
        if (ref1 == ref2) {
            return time2.toSecondOfDay() - time1.toSecondOfDay();
        }
        return time2.toSecondOfDay() - time1.toSecondOfDay() + 86400 * (ref2.refIndex - ref1.refIndex);
    }
}

