/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.common.util;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import kd.bos.entity.plugin.support.util.StringUtils;
import kd.wtc.wtes.common.util.Strings;

public final class Assert {
    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void state(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalStateException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNull(Object object, Supplier<String> messageSupplier) {
        if (object != null) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void nonNull(Object arg, String message) {
        if (arg == null) {
            throw new NullPointerException(message);
        }
    }

    public static void nonNull(Object object, Supplier<String> messageSupplier) {
        if (object == null) {
            throw new NullPointerException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void hasLength(String text, String message) {
        if (!StringUtils.hasLength((String)text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasLength(String text, Supplier<String> messageSupplier) {
        if (!StringUtils.hasLength((String)text)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void hasText(String text, String message) {
        if (!StringUtils.hasText((String)text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasText(String text, Supplier<String> messageSupplier) {
        if (!StringUtils.hasText((String)text)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    private static String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }

    public static void notBlank(String arg, String message) {
        if (Strings.isBlank(arg)) {
            throw new IllegalArgumentException(message);
        }
    }

    private Assert() {
    }

    public static void nonNullElements(Collection<?> cls, String argName) {
        if (cls.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("Could not contain null element in " + argName);
        }
    }
}

