/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.common.util;

import java.io.Serializable;
import java.util.Objects;
import kd.wtc.wtes.common.util.ILabel;

public class Label
implements ILabel,
Serializable {
    private static final long serialVersionUID = 4544987993193873214L;
    private final String key;
    private final String value;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Label label = (Label)obj;
        return this.key.equals(label.key) && Objects.equals(this.value, label.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    protected Label(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public static Label of(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key could not be null");
        }
        return new Label(key, value == null ? "" : value);
    }

    public static Label of(String key) {
        return Label.of(key, null);
    }

    @Override
    public boolean keyEqual(String key) {
        return this.key.equals(key);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "{key=" + this.key + ", value=" + this.value + '}';
    }
}

