/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.common.util;

import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.wtc.wtes.common.util.ErrorCodeUtils;
import kd.wtc.wtes.common.util.Strings;

public interface LogUtils {
    public static final String LOG_MSG_PATTERN = "[{}] {}";

    public static void warning(Log log, Exception ex, String defaultErrorNumber) {
        String errorNumber = LogUtils.getErrorNumber(ex, defaultErrorNumber);
        log.warn(LOG_MSG_PATTERN, new Object[]{errorNumber, ex.getMessage(), ex});
    }

    public static void error(Log log, Exception ex, String defaultErrorNumber) {
        String errorNumber = LogUtils.getErrorNumber(ex, defaultErrorNumber);
        log.warn(LOG_MSG_PATTERN, new Object[]{errorNumber, ex.getMessage(), ex});
    }

    public static void info(Log log, Exception ex, String defaultErrorNumber) {
        String errorNumber = LogUtils.getErrorNumber(ex, defaultErrorNumber);
        log.info(LOG_MSG_PATTERN, new Object[]{errorNumber, ex.getMessage(), ex});
    }

    public static void debug(Log log, Exception ex, String defaultErrorNumber) {
        String errorNumber = LogUtils.getErrorNumber(ex, defaultErrorNumber);
        log.info(LOG_MSG_PATTERN, new Object[]{errorNumber, ex.getMessage(), ex});
    }

    public static String getErrorNumber(Exception ex, String defaultErrorNumber) {
        String errorNumber = defaultErrorNumber;
        if (ex instanceof KDException) {
            KDException kde = (KDException)ex;
            ErrorCode errorCode = kde.getErrorCode();
            errorNumber = Strings.toStr(errorCode.getCode(), defaultErrorNumber);
        }
        if (null == errorNumber || "".equals(errorNumber)) {
            errorNumber = defaultErrorNumber;
        }
        return errorNumber;
    }

    public static void warning(Log log, ErrorCode errorCode, Object ... args) {
        log.info(LOG_MSG_PATTERN, (Object)errorCode.getCode(), (Object)ErrorCodeUtils.getMessage(errorCode, args));
    }
}

