/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.common.util;

import java.util.Locale;
import java.util.stream.Stream;

public final class Strings {
    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !Strings.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotBlank(String str) {
        return !Strings.isBlank(str);
    }

    public static String toStr(Object obj) {
        return Strings.toStr(obj, "");
    }

    public static String toStr(Object obj, String defaultValue) {
        return obj == null ? defaultValue : obj.toString();
    }

    public static String format(String format, Object ... args) {
        return String.format(Locale.ROOT, format, args);
    }

    public static boolean isAnyEmpty(String ... args) {
        if (args == null) {
            return true;
        }
        return Stream.of(args).anyMatch(Strings::isEmpty);
    }

    public static boolean isAllEmpty(String ... args) {
        if (args == null) {
            return true;
        }
        return Stream.of(args).allMatch(Strings::isEmpty);
    }

    public static boolean isAnyMatch(String key, String ... matchValues) {
        if (key == null || matchValues == null) {
            return false;
        }
        return Stream.of(matchValues).filter(Strings::isNotBlank).anyMatch(arg -> arg.equals(key));
    }

    private Strings() {
    }
}

