/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.opplugin.web.suppleapply.batchbill;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.wtc.wtpm.business.signcard.SignCardBatchService;

public class SupSignBatchSaveOp
extends HRCoreBaseBillOp {
    protected static final Log LOG = LogFactory.getLog(SupSignBatchSaveOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(args);
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            boolean billIsMulPri = SignCardBatchService.billIsMulPri((DynamicObject)dataEntity);
            if (billIsMulPri) {
                this.copyPriSupSignInfo(dataEntity);
                continue;
            }
            if (dataEntity.containsProperty("entryentitymultipri")) {
                dataEntity.set("entryentitymultipri", null);
            }
            boolean withOrg = dataEntity.getBoolean("withorg");
            boolean withPerson = dataEntity.getBoolean("withperson");
            if (!withOrg) {
                dataEntity.set("entryentityorg", null);
            }
            if (withPerson) continue;
            dataEntity.set("entryentityperson", null);
        }
    }

    private void copyPriSupSignInfo(DynamicObject dataEntity) {
        dataEntity.set("entryentityorg", null);
        dataEntity.set("entryentityperson", null);
        DynamicObjectCollection supSignInfoPriColl = dataEntity.getDynamicObjectCollection("entryentitymultipri");
        DynamicObjectCollection supSignInfoColl = dataEntity.getDynamicObjectCollection("entryentitysupinfo");
        supSignInfoColl.clear();
        long[] pkIds = ID.genLongIds((int)supSignInfoPriColl.size());
        int index = 0;
        for (DynamicObject supSignInfoPri : supSignInfoPriColl) {
            Object pkId = supSignInfoPri.get("id");
            if (pkId == null || Objects.equals(pkId, 0L)) {
                pkId = pkIds[index];
                supSignInfoPri.set("id", pkId);
                ++index;
            }
            DynamicObject supSignInfo = supSignInfoColl.addNew();
            supSignInfo.set("id", pkId);
            supSignInfo.set("signdate", supSignInfoPri.get("prisigndate"));
            supSignInfo.set("suppleworktime", supSignInfoPri.get("prisuppleworktime"));
            supSignInfo.set("applyreason", supSignInfoPri.get("priapplyreason"));
            supSignInfo.set("timezone", supSignInfoPri.get("pritimezone"));
            supSignInfo.set("accesstag", supSignInfoPri.get("priaccesstag"));
            supSignInfo.set("pointtag", supSignInfoPri.get("pripointtag"));
            supSignInfo.set("source", supSignInfoPri.get("prisource"));
            supSignInfo.set("equipment", supSignInfoPri.get("priequipment"));
            supSignInfo.set("remark", supSignInfoPri.get("priremark"));
        }
        dataEntity.set("entryentitysupinfo", (Object)supSignInfoColl);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        SignCardBatchService.batchRemoveEntryCache((DynamicObject[])e.getDataEntities(), (String)"entryentitysupinfo", (String)"wtpm_supsignbatchinfo");
    }
}

