/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.opplugin.web.suppleapply.bill;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRCoreBaseBillOp;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;

public class ApplyMustInputCheckOp
extends HRCoreBaseBillOp {
    private static final String ERROR_MSG = SupSignKDString.mustInputAccessTag();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("iscancel");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (dataEntities == null || dataEntities.length <= 0) {
                    return;
                }
                String entityName = dataEntities[0].getDataEntity().getDataEntityType().getName();
                String entryKey = entityName.equals("wtpm_supsignpc") || entityName.equals("wtpm_supsignself") ? "entryentity" : "entryentitysupinfo";
                this.doValidate(entryKey);
            }

            private void doValidate(String entryKey) {
                BillSystemParam billSystemParam = SystemParamQueryUtil.getBillSystemParam();
                boolean mustInputAccessTag = billSystemParam.isAccessTag();
                if (!mustInputAccessTag) {
                    return;
                }
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    if (dataEntity.getDataEntity().containsProperty("iscancel") && dataEntity.getDataEntity().getBoolean("iscancel")) continue;
                    DynamicObjectCollection entryColl = dataEntity.getDataEntity().getDynamicObjectCollection(entryKey);
                    for (int index = 0; index < entryColl.size(); ++index) {
                        DynamicObject dy = (DynamicObject)entryColl.get(index);
                        String accessTag = dy.getString("accesstag");
                        if (!HRStringUtils.isEmpty((String)accessTag)) continue;
                        this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ERROR_MSG, index + 1));
                    }
                }
            }
        });
    }
}

