/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.opplugin.web.suppleapply.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRCoreBaseBillValidator;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtpm.business.signcard.AdCheckService;
import kd.wtc.wtpm.business.signcard.validator.SupSignCheckServiceHandler;
import kd.wtc.wtpm.constants.suppleapply.SupSignKDString;
import kd.wtc.wtpm.constants.suppleapply.SuppleApplyConstants;
import kd.wtc.wtpm.enums.SignCardBillTypeEnum;
import kd.wtc.wtpm.opplugin.web.suppleapply.bill.SupSignSaveOp;
import kd.wtc.wtpm.vo.suppleapply.AdCheckVo;

public class SupSignValidator
extends HRCoreBaseBillValidator {
    private static final Log LOG = LogFactory.getLog(SupSignSaveOp.class);
    private boolean fromImportData = false;

    public void validate() {
        LOG.info("SupSignValidator.validate begin");
        super.validate();
        ArrayList allEntity = Lists.newArrayList((Object[])this.getDataEntities());
        ArrayList<ExtendedDataEntity> successDataEntities = new ArrayList<ExtendedDataEntity>(10);
        for (ExtendedDataEntity extendedDataEntity : allEntity) {
            if (extendedDataEntity.getDataEntity().containsProperty("iscancel") && extendedDataEntity.getDataEntity().getBoolean("iscancel")) continue;
            successDataEntities.add(extendedDataEntity);
        }
        if (CollectionUtils.isEmpty(successDataEntities)) {
            return;
        }
        this.fromImportData = this.isImportData();
        this.doValidateSupSignBill(successDataEntities);
    }

    private void doValidateSupSignBill(List<ExtendedDataEntity> dataEntities) {
        LOG.info("SupSignValidator.doValidateSupSignBill begin");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            ExtendedDataEntity[] supSignBillDy = dataEntity.getDataEntity();
            Long personId = supSignBillDy.getLong(SuppleApplyConstants.PERSONID_ID);
            if (personId == null || personId == 0L) {
                this.addErrorMessage(dataEntity, SupSignKDString.selectPerson());
                return;
            }
            DynamicObjectCollection supSignInfoColl = supSignBillDy.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)supSignInfoColl)) continue;
            this.addErrorMessage(dataEntity, SupSignKDString.mustOne());
            return;
        }
        ArrayList billDataEntityList = Lists.newArrayListWithExpectedSize((int)this.getDataEntities().length);
        Map discardAttFileBoIdMap = BillCommonService.getInstance().getDiscardAttFileBoId(this.getDataEntities());
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject formEntity = dataEntity.getDataEntity();
            DynamicObject attFile = formEntity.getDynamicObject("attfile");
            String attFileNumber = (String)discardAttFileBoIdMap.get(attFile.getLong("id"));
            if (HRStringUtils.isNotEmpty((String)attFileNumber)) {
                this.addErrorMessage(dataEntity, BillUnifyKDStringHelper.notEffAttFile((String)BillTypeEnum.SUPPLEMENTBILL.getBillName(), (String)attFileNumber));
                continue;
            }
            billDataEntityList.add(formEntity);
        }
        if (billDataEntityList.isEmpty()) {
            return;
        }
        List adCheckVoList = AdCheckService.genAdCheckVoListForSingleBill((List)billDataEntityList);
        String applyType = dataEntities.get(0).getDataEntity().getString("applytyperadio");
        SignCardBillTypeEnum billTypeEnum = "1".equals(applyType) ? SignCardBillTypeEnum.OTHER_BILL : SignCardBillTypeEnum.SELF_BILL;
        OperateOption option = this.getOption();
        String appId = BillCommonService.getInstance().getAppIdFromOp(option);
        SupSignCheckServiceHandler serviceHandler = new SupSignCheckServiceHandler(adCheckVoList, billTypeEnum, appId);
        boolean checkResult = serviceHandler.supSignCheck();
        if (!checkResult) {
            LOG.info("SupSignValidator.doValidateSupSignBill not check pass");
            this.addErrorMessage(dataEntities, adCheckVoList);
        }
        LOG.info("SupSignValidator.doValidateSupSignBill all check pass");
    }

    private void addErrorMessage(List<ExtendedDataEntity> dataEntities, List<AdCheckVo> adCheckVoList) {
        if (this.fromImportData) {
            this.setImportErrorMsg(dataEntities, adCheckVoList);
        } else {
            this.setFormErrorMsg(dataEntities, adCheckVoList);
        }
    }

    private void setImportErrorMsg(List<ExtendedDataEntity> dataEntities, List<AdCheckVo> adCheckVoList) {
        Map<Long, List<AdCheckVo>> adCheckVoMap = adCheckVoList.stream().collect(Collectors.groupingBy(AdCheckVo::getId));
        String errMsgEntryIndex = SupSignKDString.entryIndex();
        String errMsgFailByOther = SupSignKDString.failByOther();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject billDy = dataEntity.getDataEntity();
            long billId = billDy.getLong("id");
            List<AdCheckVo> billCheckList = adCheckVoMap.get(billId);
            StringBuilder sb = new StringBuilder();
            boolean allSuccess = true;
            int billEntrySize = billCheckList.size();
            for (int index = 0; index < billEntrySize; ++index) {
                AdCheckVo adCheckVo = billCheckList.get(index);
                if (billEntrySize > 1) {
                    sb.append(String.format(errMsgEntryIndex, index + 1));
                }
                if (adCheckVo.isCheckPass()) {
                    sb.append(errMsgFailByOther);
                    continue;
                }
                sb.append(adCheckVo.getErrorMsg());
                allSuccess = false;
            }
            if (allSuccess) continue;
            this.addErrorMessage(dataEntity, sb.toString());
        }
    }

    private void setFormErrorMsg(List<ExtendedDataEntity> dataEntities, List<AdCheckVo> adCheckVoList) {
        Map<Long, List<AdCheckVo>> notPassCheckMap = adCheckVoList.stream().filter(item -> !item.isCheckPass()).collect(Collectors.groupingBy(AdCheckVo::getId));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject billDy = dataEntity.getDataEntity();
            long billId = billDy.getLong("id");
            List<AdCheckVo> notPassCheckList = notPassCheckMap.get(billId);
            if (CollectionUtils.isEmpty(notPassCheckList)) continue;
            this.addErrorMessage(dataEntity, notPassCheckList.get(0).getErrorMsg());
        }
    }

    private boolean isImportData() {
        OperateOption option = this.getOption();
        if (!option.containsVariable("importtag_of_datasource")) {
            return false;
        }
        String importTag = option.getVariableValue("importtag_of_datasource");
        return Boolean.parseBoolean(importTag);
    }
}

