/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpm.mservice;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.upgrade.WTCUpgradeService;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class WTPMDataUpgrade
extends WTCUpgradeService {
    private static final Log LOG = LogFactory.getLog(WTCUpgradeService.class);
    private static final String T_WTPM_SUPSIGN_UPDATE = "update T_WTPM_SUPSIGN set FATTFILEBASEID = ? where fid = ?;";
    private static final String T_WTPM_SUPSIGN_QUERY = "select fid,fattfileid from t_wtpm_supsign where fattfilebaseid =0;";
    private static final String T_WTPM_SIGNCARDLIST_UPDATE = "update T_WTPM_SIGNCARDLIST set FATTFILEVID = ? where fid = ?;";
    private static final String T_WTPM_SIGNCARDLIST_QUERY = "select fid,fattfileid from  T_WTPM_SIGNCARDLIST where FATTFILEVID = 0;";
    private static final String T_WTPM_SUPSIGNLIST_UPDATE = "update T_WTPM_SUPSIGNLIST set FATTFILEVID = ? where fid = ?;";
    private static final String T_WTPM_SUPSIGNLIST_QUERY = "select fid,fattfileid from  T_WTPM_SUPSIGNLIST where FATTFILEVID = 0;";
    private static final String T_WTP_ATTFILEBASE_QUERY = "select fid,fsourcevid from t_wtp_attfilebase where";

    public void upgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        String errorMsg;
        boolean isDeploy = true;
        try (TXHandle tx = TX.requiresNew();){
            try {
                isDeploy = this.isDeploy(sqlFileName);
            }
            catch (Exception throwable) {
                isDeploy = false;
                tx.markRollback();
                errorMsg = throwable.getMessage();
                LOG.warn("WTPMDataUpgrade.upgradeAction.Exception:{}", (Object)errorMsg);
            }
        }
        if (!isDeploy) {
            this.executeSqlByText(dbKey);
            this.executeSqlByFile(dbKey, sqlFileName);
            tx = TX.requiresNew();
            var7_7 = null;
            try {
                try {
                    this.addDeploy(sqlFileName);
                }
                catch (Exception throwable) {
                    tx.markRollback();
                    errorMsg = throwable.getMessage();
                    LOG.warn("WTPMDataUpgrade.upgradeAction.Exception:{}", (Object)errorMsg);
                }
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var7_7 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
    }

    private void executeSqlByText(String dbKey) {
        this.executeUpdate(dbKey, T_WTPM_SUPSIGN_QUERY, T_WTPM_SUPSIGN_UPDATE);
        this.executeUpdate(dbKey, T_WTPM_SIGNCARDLIST_QUERY, T_WTPM_SIGNCARDLIST_UPDATE);
        this.executeUpdate(dbKey, T_WTPM_SUPSIGNLIST_QUERY, T_WTPM_SUPSIGNLIST_UPDATE);
    }

    private void executeUpdate(String dbKey, String selectQuery, String updateQuery) {
        HashMap<Long, Long> supSignIdMap = new HashMap<Long, Long>(16);
        HRDBUtil.query((DBRoute)DBRoute.of((String)dbKey), (String)selectQuery, (Object[])new Object[0], resultSet -> {
            while (resultSet.next()) {
                supSignIdMap.put(resultSet.getLong("fid"), resultSet.getLong("fattfileid"));
            }
            return null;
        });
        if (CollectionUtils.isEmpty(supSignIdMap)) {
            return;
        }
        HashMap attFileIdMap = new HashMap(16);
        Collection attFileIds = supSignIdMap.values();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(T_WTP_ATTFILEBASE_QUERY, new Object[0]);
        sqlBuilder.appendIn("fid", (List)Lists.newArrayList((Iterable)Sets.newHashSet(attFileIds)));
        DB.query((DBRoute)DBRoute.of((String)"wtc"), (SqlBuilder)sqlBuilder, resultSet -> {
            while (resultSet.next()) {
                attFileIdMap.put(resultSet.getLong("fid"), resultSet.getLong("fsourcevid"));
            }
            return null;
        });
        ArrayList paramsList = new ArrayList(supSignIdMap.size());
        supSignIdMap.forEach((key, value) -> {
            Long sourceVid = (Long)attFileIdMap.get(value);
            if (sourceVid != null) {
                paramsList.add(new Object[]{attFileIdMap.get(value), key});
            }
        });
        if (!CollectionUtils.isEmpty(paramsList)) {
            HRDBUtil.executeBatch((DBRoute)DBRoute.of((String)dbKey), (String)updateQuery, paramsList);
        }
    }

    private void executeSqlByFile(String dbKey, String sqlFileName) {
        try (BufferedReader bd = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/upgrade/" + sqlFileName)));){
            String line = "";
            DBRoute dbRoute = new DBRoute(dbKey);
            while ((line = bd.readLine()) != null) {
                if (HRStringUtils.isEmpty((String)line)) continue;
                HRDBUtil.execute((DBRoute)dbRoute, (String)line, null);
            }
        }
        catch (IOException io) {
            String msg = "WTPMDataUpgrade exception";
            LOG.error(msg, (Throwable)io);
            throw new KDBizException((Throwable)io, new ErrorCode("WTPMDataUpgrade", msg), new Object[0]);
        }
    }
}

